/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.JoinType;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.runtime.SortedMultiMap;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class EnumUtils {
    static final boolean BRIDGE_METHODS = true;
    static final List<ParameterExpression> NO_PARAMS = ImmutableList.of();
    static final List<Expression> NO_EXPRS = ImmutableList.of();
    public static final List<String> LEFT_RIGHT = ImmutableList.of("left", "right");

    private EnumUtils() {
    }

    public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
        return Expressions.methodDecl(method.getModifiers() & 0xFFFFFBFF, method.getReturnType(), method.getName(), parameters, body);
    }

    static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz = typeFactory.getJavaClass(type);
        return clazz instanceof Class ? clazz : Object[].class;
    }

    static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
        return new AbstractList<Type>(){

            @Override
            public Type get(int index) {
                return EnumUtils.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
            }

            @Override
            public int size() {
                return inputTypes.size();
            }
        };
    }

    static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final List<? extends RexNode> extraInputs, final List<Integer> argList) {
        final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int arg = (Integer)argList.get(index);
                return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)extraInputs.get(arg - inputFields.size())).getType();
            }

            @Override
            public int size() {
                return argList.size();
            }
        };
    }

    static Expression joinSelector(JoinRelType joinType, PhysType physType, List<PhysType> inputPhysTypes) {
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int outputFieldCount = physType.getRowType().getFieldCount();
        for (Ord<PhysType> ord : Ord.zip(inputPhysTypes)) {
            PhysType inputPhysType = ((PhysType)ord.e).makeNullable(joinType.generatesNullsOn(ord.i));
            ParameterExpression parameter = Expressions.parameter(Primitive.box(inputPhysType.getJavaRowType()), LEFT_RIGHT.get(ord.i));
            parameters.add(parameter);
            if (expressions.size() == outputFieldCount) break;
            int fieldCount = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Expression expression2 = inputPhysType.fieldReference(parameter, i, physType.getJavaFieldType(expressions.size()));
                if (joinType.generatesNullsOn(ord.i)) {
                    expression2 = Expressions.condition(Expressions.equal(parameter, Expressions.constant(null)), Expressions.constant(null), expression2);
                }
                expressions.add(expression2);
            }
        }
        return Expressions.lambda(Function2.class, physType.record(expressions), parameters);
    }

    static Expression toInternal(Expression operand, Type targetType) {
        return EnumUtils.toInternal(operand, operand.getType(), targetType);
    }

    private static Expression toInternal(Expression operand, Type fromType, Type targetType) {
        if (fromType == Date.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call(BuiltInMethod.DATE_TO_INT.method, operand);
            }
            if (targetType == Integer.class) {
                return Expressions.call(BuiltInMethod.DATE_TO_INT_OPTIONAL.method, operand);
            }
        } else if (fromType == Time.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call(BuiltInMethod.TIME_TO_INT.method, operand);
            }
            if (targetType == Integer.class) {
                return Expressions.call(BuiltInMethod.TIME_TO_INT_OPTIONAL.method, operand);
            }
        } else if (fromType == Timestamp.class) {
            if (targetType == Long.TYPE) {
                return Expressions.call(BuiltInMethod.TIMESTAMP_TO_LONG.method, operand);
            }
            if (targetType == Long.class) {
                return Expressions.call(BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, operand);
            }
        }
        return operand;
    }

    private static Expression fromInternal(Expression operand, Type targetType) {
        return EnumUtils.fromInternal(operand, operand.getType(), targetType);
    }

    private static Expression fromInternal(Expression operand, Type fromType, Type targetType) {
        if (operand == ConstantUntypedNull.INSTANCE) {
            return operand;
        }
        if (!(operand.getType() instanceof Class)) {
            return operand;
        }
        if (Types.isAssignableFrom(targetType, fromType)) {
            return operand;
        }
        if (targetType == Date.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call(BuiltInMethod.INTERNAL_TO_DATE.method, operand);
            }
        } else if (targetType == Time.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call(BuiltInMethod.INTERNAL_TO_TIME.method, operand);
            }
        } else if (targetType == Timestamp.class && EnumUtils.isA(fromType, Primitive.LONG)) {
            return Expressions.call(BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, operand);
        }
        if (Primitive.is(operand.type) && Primitive.isBox(targetType)) {
            return Expressions.convert_(operand, Primitive.ofBox((Type)targetType).primitiveClass);
        }
        return operand;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == expressions.size()) {
            for (int i = 0; i < expressions.size(); ++i) {
                list.add(EnumUtils.fromInternal(expressions.get(i), targetTypes[i]));
            }
        } else {
            int j2 = 0;
            for (int i = 0; i < expressions.size(); ++i) {
                Class<?> type;
                if (!targetTypes[j2].isArray()) {
                    type = targetTypes[j2];
                    ++j2;
                } else {
                    type = targetTypes[j2].getComponentType();
                }
                list.add(EnumUtils.fromInternal(expressions.get(i), type));
            }
        }
        return list;
    }

    static Type fromInternal(Type type) {
        if (type == Date.class || type == Time.class) {
            return Integer.TYPE;
        }
        if (type == Timestamp.class) {
            return Long.TYPE;
        }
        return type;
    }

    private static Type toInternal(RelDataType type) {
        return EnumUtils.toInternal(type, false);
    }

    static Type toInternal(RelDataType type, boolean forceNotNull) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() && !forceNotNull ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() && !forceNotNull ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    static List<Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> EnumUtils.toInternal(node.getType()));
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        return EnumUtils.convert(operand, fromType, toType);
    }

    public static Expression convert(Expression operand, Type fromType, Type toType) {
        Expression originTypedOperand;
        Expression internalTypedOperand;
        boolean fromNumber;
        if (!Types.needTypeCast(fromType, toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of(toType);
        Primitive toBox = Primitive.ofBox(toType);
        Primitive fromBox = Primitive.ofBox(fromType);
        Primitive fromPrimitive = Primitive.of(fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, "parse" + SqlFunctions.initcap(toPrimitive.primitiveName), operand);
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, "valueOf", operand);
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_(operand, toPrimitive.primitiveClass);
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox(operand, toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.box(Expressions.unbox(operand, toBox), toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                Primitive origin;
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert && Primitive.of(una.getType()) == toBox && (origin = Primitive.of(una.expression.type)) != null && toBox.assignableFrom(origin)) {
                    return Expressions.box(una.expression, toBox);
                }
            }
            if (fromType == toBox.primitiveClass) {
                return Expressions.box(operand, toBox);
            }
            return Expressions.box(Expressions.convert_(operand, toBox.primitiveClass), toBox);
        }
        if (EnumUtils.representAsInternalType(fromType) && operand != (internalTypedOperand = EnumUtils.toInternal(operand, fromType, toType))) {
            return internalTypedOperand;
        }
        if (EnumUtils.representAsInternalType(toType) && operand != (originTypedOperand = EnumUtils.fromInternal(operand, fromType, toType))) {
            return originTypedOperand;
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.new_(BigDecimal.class, new Expression[]{Expressions.unbox(operand, fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, new Expression[]{operand});
            }
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toBigDecimal", new Expression[]{operand}));
        }
        if (toType == String.class) {
            Expression result;
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, "toString", operand);
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand}));
            }
            try {
                if (operand instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)operand;
                    if (ce.value == null) {
                        return Expressions.convert_(operand, toType);
                    }
                }
                result = Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(operand, "toString", new Expression[0]));
            }
            catch (RuntimeException e) {
                return Expressions.convert_(operand, toType);
            }
            return result;
        }
        return Expressions.convert_(operand, toType);
    }

    public static <T> T evaluate(Object o, Class<T> clazz) {
        clazz = Primitive.box(clazz);
        BlockBuilder bb = new BlockBuilder();
        Expression expr = EnumUtils.convert(Expressions.constant(o), clazz);
        bb.add(Expressions.return_(null, expr));
        FunctionExpression convert2 = Expressions.lambda(bb.toBlock(), ImmutableList.of());
        return clazz.cast(convert2.compile().dynamicInvoke(new Object[0]));
    }

    private static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of(fromType) == primitive || Primitive.ofBox(fromType) == primitive;
    }

    private static boolean representAsInternalType(Type type) {
        return type == Date.class || type == Time.class || type == Timestamp.class;
    }

    static List<Expression> convertAssignableTypes(Class<?>[] targetTypes, List<Expression> arguments) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == arguments.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                list.add(EnumUtils.convertAssignableType(arguments.get(i), targetTypes[i]));
            }
        } else {
            int j2 = 0;
            for (Expression argument : arguments) {
                Class<?> type;
                if (!targetTypes[j2].isArray()) {
                    type = targetTypes[j2];
                    ++j2;
                } else {
                    type = targetTypes[j2].getComponentType();
                }
                list.add(EnumUtils.convertAssignableType(argument, type));
            }
        }
        return list;
    }

    private static Expression convertAssignableType(Expression argument, Type targetType) {
        if (targetType != BigDecimal.class) {
            return argument;
        }
        return EnumUtils.convert(argument, targetType);
    }

    public static MethodCallExpression call(Class clazz, String methodName, List<? extends Expression> arguments) {
        return EnumUtils.call(clazz, methodName, arguments, null);
    }

    public static MethodCallExpression call(Class clazz, String methodName, List<? extends Expression> arguments, Expression targetExpression) {
        Object[] argumentTypes = Types.toClassArray(arguments);
        try {
            Method candidate = clazz.getMethod(methodName, (Class<?>[])argumentTypes);
            return Expressions.call(targetExpression, candidate, arguments);
        }
        catch (NoSuchMethodException e) {
            for (Method method : clazz.getMethods()) {
                Class[] parameterTypes;
                if (!method.getName().equals(methodName)) continue;
                boolean varArgs = method.isVarArgs();
                if (Types.allAssignable(varArgs, parameterTypes = method.getParameterTypes(), (Class[])argumentTypes)) {
                    return Expressions.call(targetExpression, method, arguments);
                }
                List<? extends Expression> typeMatchedArguments = EnumUtils.matchMethodParameterTypes(varArgs, parameterTypes, arguments);
                if (typeMatchedArguments == null) continue;
                return Expressions.call(targetExpression, method, typeMatchedArguments);
            }
            throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
        }
    }

    private static List<? extends Expression> matchMethodParameterTypes(boolean varArgs, Class[] parameterTypes, List<? extends Expression> arguments) {
        if (varArgs && arguments.size() < parameterTypes.length - 1 || !varArgs && arguments.size() != parameterTypes.length) {
            return null;
        }
        ArrayList<Expression> typeMatchedArguments = new ArrayList<Expression>();
        for (int i = 0; i < arguments.size(); ++i) {
            Class<Object> parameterType = !varArgs || i < parameterTypes.length - 1 ? parameterTypes[i] : Object.class;
            Expression typeMatchedArgument = EnumUtils.matchMethodParameterType(arguments.get(i), parameterType);
            if (typeMatchedArgument == null) {
                return null;
            }
            typeMatchedArguments.add(typeMatchedArgument);
        }
        return typeMatchedArguments;
    }

    private static Expression matchMethodParameterType(Expression argument, Class parameter) {
        Type argumentType = argument.getType();
        if (Types.isAssignableFrom(parameter, argumentType)) {
            return argument;
        }
        if (parameter == Object.class && Primitive.of(argumentType) != null) {
            return argument;
        }
        if (argumentType == Object.class && Primitive.of(argumentType) == null) {
            return EnumUtils.convert(argument, parameter);
        }
        if (parameter == BigDecimal.class && Primitive.ofBoxOr(argumentType) != null) {
            return EnumUtils.convert(argument, parameter);
        }
        return null;
    }

    static JoinType toLinq4jJoinType(JoinRelType joinRelType) {
        switch (joinRelType) {
            case INNER: {
                return JoinType.INNER;
            }
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case FULL: {
                return JoinType.FULL;
            }
            case SEMI: {
                return JoinType.SEMI;
            }
            case ANTI: {
                return JoinType.ANTI;
            }
        }
        throw new IllegalStateException("Unable to convert " + (Object)((Object)joinRelType) + " to Linq4j JoinType");
    }

    static Expression generatePredicate(EnumerableRelImplementor implementor, RexBuilder rexBuilder, RelNode left, RelNode right, PhysType leftPhysType, PhysType rightPhysType, RexNode condition) {
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression left_ = Expressions.parameter(leftPhysType.getJavaRowType(), "left");
        ParameterExpression right_ = Expressions.parameter(rightPhysType.getJavaRowType(), "right");
        RexProgramBuilder program = new RexProgramBuilder(((RelDataTypeFactory.FieldInfoBuilder)implementor.getTypeFactory().builder().addAll(left.getRowType().getFieldList())).addAll(right.getRowType().getFieldList()).build(), rexBuilder);
        program.addCondition(condition);
        builder.add(Expressions.return_(null, RexToLixTranslator.translateCondition(program.getProgram(), implementor.getTypeFactory(), builder, new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(left_, leftPhysType), Pair.of(right_, rightPhysType))), implementor.allCorrelateVariables, implementor.getConformance())));
        return Expressions.lambda(Predicate2.class, builder.toBlock(), left_, right_);
    }

    static Expression tumblingWindowSelector(PhysType inputPhysType, PhysType outputPhysType, Expression wmColExpr, Expression windowSizeExpr, Expression offsetExpr) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ParameterExpression parameter = Expressions.parameter(Primitive.box(inputPhysType.getJavaRowType()), "_input");
        int fieldCount = inputPhysType.getRowType().getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Expression expression2 = inputPhysType.fieldReference(parameter, i, outputPhysType.getJavaFieldType(expressions.size()));
            expressions.add(expression2);
        }
        Expression wmColExprToLong = EnumUtils.convert(wmColExpr, Long.TYPE);
        BinaryExpression windowStartExpr = Expressions.subtract(wmColExprToLong, Expressions.modulo(Expressions.add(wmColExprToLong, Expressions.subtract(windowSizeExpr, offsetExpr)), windowSizeExpr));
        expressions.add(windowStartExpr);
        BinaryExpression windowEndExpr = Expressions.add(windowStartExpr, windowSizeExpr);
        expressions.add(windowEndExpr);
        return Expressions.lambda(Function1.class, outputPhysType.record(expressions), parameter);
    }

    public static Enumerable<Object[]> sessionize(final Enumerator<Object[]> inputEnumerator, final int indexOfWatermarkedColumn, final int indexOfKeyColumn, final long gap) {
        return new AbstractEnumerable<Object[]>(){

            @Override
            public Enumerator<Object[]> enumerator() {
                return new SessionizationEnumerator(inputEnumerator, indexOfWatermarkedColumn, indexOfKeyColumn, gap);
            }
        };
    }

    public static Enumerable<Object[]> hopping(final Enumerator<Object[]> inputEnumerator, final int indexOfWatermarkedColumn, final long emitFrequency, final long windowSize, final long offset) {
        return new AbstractEnumerable<Object[]>(){

            @Override
            public Enumerator<Object[]> enumerator() {
                return new HopEnumerator(inputEnumerator, indexOfWatermarkedColumn, emitFrequency, windowSize, offset);
            }
        };
    }

    private static List<Pair> hopWindows(long tsMillis, long periodMillis, long sizeMillis, long offsetMillis) {
        long lastStart;
        ArrayList<Pair> ret = new ArrayList<Pair>(Math.toIntExact(sizeMillis / periodMillis));
        for (long start = lastStart = tsMillis - (tsMillis + periodMillis - offsetMillis) % periodMillis; start > tsMillis - sizeMillis; start -= periodMillis) {
            ret.add(new Pair<Long, Long>(start, start + sizeMillis));
        }
        return ret;
    }

    public static <TSource, TResult> Enumerable<TResult> tumbling(final Enumerable<TSource> inputEnumerable, final Function1<TSource, TResult> outSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> inputs;
                    {
                        this.inputs = inputEnumerable.enumerator();
                    }

                    @Override
                    public TResult current() {
                        return outSelector.apply(this.inputs.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.inputs.moveNext();
                    }

                    @Override
                    public void reset() {
                        this.inputs.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public static Expression generateCollatorExpression(SqlCollation collation) {
        if (collation == null || collation.getCollator() == null) {
            return null;
        }
        Locale locale = collation.getLocale();
        int strength = collation.getCollator().getStrength();
        return Expressions.call(Utilities.class, "generateCollator", new Expression[]{Expressions.new_(Locale.class, new Expression[]{Expressions.constant(locale.getLanguage()), Expressions.constant(locale.getCountry()), Expressions.constant(locale.getVariant())}), Expressions.constant(strength)});
    }

    private static class HopEnumerator
    implements Enumerator<Object[]> {
        private final Enumerator<Object[]> inputEnumerator;
        private final int indexOfWatermarkedColumn;
        private final long emitFrequency;
        private final long windowSize;
        private final long offset;
        private final Deque<Object[]> list;

        HopEnumerator(Enumerator<Object[]> inputEnumerator, int indexOfWatermarkedColumn, long slide, long windowSize, long offset) {
            this.inputEnumerator = inputEnumerator;
            this.indexOfWatermarkedColumn = indexOfWatermarkedColumn;
            this.emitFrequency = slide;
            this.windowSize = windowSize;
            this.offset = offset;
            this.list = new ArrayDeque<Object[]>();
        }

        @Override
        public Object[] current() {
            if (this.list.size() > 0) {
                return this.takeOne();
            }
            Object[] current = this.inputEnumerator.current();
            List windows = EnumUtils.hopWindows(SqlFunctions.toLong(current[this.indexOfWatermarkedColumn]), this.emitFrequency, this.windowSize, this.offset);
            for (Pair window : windows) {
                Object[] curWithWindow = new Object[current.length + 2];
                System.arraycopy(current, 0, curWithWindow, 0, current.length);
                curWithWindow[current.length] = window.left;
                curWithWindow[current.length + 1] = window.right;
                this.list.offer(curWithWindow);
            }
            return this.takeOne();
        }

        @Override
        public boolean moveNext() {
            return this.list.size() > 0 || this.inputEnumerator.moveNext();
        }

        @Override
        public void reset() {
            this.inputEnumerator.reset();
            this.list.clear();
        }

        @Override
        public void close() {
        }

        private Object[] takeOne() {
            return this.list.pollFirst();
        }
    }

    private static class SessionizationEnumerator
    implements Enumerator<Object[]> {
        private final Enumerator<Object[]> inputEnumerator;
        private final int indexOfWatermarkedColumn;
        private final int indexOfKeyColumn;
        private final long gap;
        private final Deque<Object[]> list;
        private boolean initialized;

        SessionizationEnumerator(Enumerator<Object[]> inputEnumerator, int indexOfWatermarkedColumn, int indexOfKeyColumn, long gap) {
            this.inputEnumerator = inputEnumerator;
            this.indexOfWatermarkedColumn = indexOfWatermarkedColumn;
            this.indexOfKeyColumn = indexOfKeyColumn;
            this.gap = gap;
            this.list = new ArrayDeque<Object[]>();
            this.initialized = false;
        }

        @Override
        public Object[] current() {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            return this.list.pollFirst();
        }

        @Override
        public boolean moveNext() {
            return this.initialized ? this.list.size() > 0 : this.inputEnumerator.moveNext();
        }

        @Override
        public void reset() {
            this.list.clear();
            this.inputEnumerator.reset();
            this.initialized = false;
        }

        @Override
        public void close() {
            this.list.clear();
            this.inputEnumerator.close();
            this.initialized = false;
        }

        private void initialize() {
            ArrayList<Object[]> elements = new ArrayList<Object[]>();
            elements.add(this.inputEnumerator.current());
            while (this.inputEnumerator.moveNext()) {
                elements.add(this.inputEnumerator.current());
            }
            HashMap sessionKeyMap = new HashMap();
            for (Object[] objectArray : elements) {
                sessionKeyMap.putIfAbsent(objectArray[this.indexOfKeyColumn], new SortedMultiMap());
                Pair<Long, Long> initWindow = this.computeInitWindow(SqlFunctions.toLong(objectArray[this.indexOfWatermarkedColumn]), this.gap);
                ((SortedMultiMap)sessionKeyMap.get(objectArray[this.indexOfKeyColumn])).putMulti(initWindow, objectArray);
            }
            for (Map.Entry entry : sessionKeyMap.entrySet()) {
                HashMap finalWindowElementsMap = new HashMap();
                Pair<Long, Long> currentWindow = null;
                ArrayList tempElementList = new ArrayList();
                for (Map.Entry sessionEntry : ((SortedMultiMap)entry.getValue()).entrySet()) {
                    if (currentWindow == null || !this.isOverlapped(currentWindow, (Pair)sessionEntry.getKey())) {
                        if (currentWindow != null) {
                            finalWindowElementsMap.put(currentWindow, new ArrayList(tempElementList));
                        }
                        currentWindow = (Pair<Long, Long>)sessionEntry.getKey();
                        tempElementList.clear();
                        tempElementList.addAll((Collection)sessionEntry.getValue());
                        continue;
                    }
                    currentWindow = this.mergeWindows(currentWindow, (Pair)sessionEntry.getKey());
                    tempElementList.addAll((Collection)sessionEntry.getValue());
                }
                if (!tempElementList.isEmpty()) {
                    finalWindowElementsMap.put(currentWindow, new ArrayList(tempElementList));
                }
                for (Map.Entry finalWindowElementsEntry : finalWindowElementsMap.entrySet()) {
                    for (Object[] element : (List)finalWindowElementsEntry.getValue()) {
                        Object[] curWithWindow = new Object[element.length + 2];
                        System.arraycopy(element, 0, curWithWindow, 0, element.length);
                        curWithWindow[element.length] = ((Pair)finalWindowElementsEntry.getKey()).left;
                        curWithWindow[element.length + 1] = ((Pair)finalWindowElementsEntry.getKey()).right;
                        this.list.offer(curWithWindow);
                    }
                }
            }
        }

        private boolean isOverlapped(Pair<Long, Long> a, Pair<Long, Long> b) {
            return (Long)b.left < (Long)a.right;
        }

        private Pair<Long, Long> mergeWindows(Pair<Long, Long> a, Pair<Long, Long> b) {
            return new Pair<Long, Long>((Long)a.left <= (Long)b.left ? (Long)a.left : (Long)b.left, (Long)a.right >= (Long)b.right ? (Long)a.right : (Long)b.right);
        }

        private Pair<Long, Long> computeInitWindow(long ts, long gap) {
            return new Pair<Long, Long>(ts, ts + gap);
        }
    }
}

