/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u001f\t\u0019B+Z:uS:<7\u000b^1uK6,g\u000e^*fi*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0002\u0004\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tIB$D\u0001\u001b\u0015\tYb!A\u0002ba&L!!\b\u000e\u0003\u0019M#\u0018\r^3nK:$8+\u001a;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA\u0001^#omB\u0011\u0011EI\u0007\u0002\u0005%\u00111E\u0001\u0002\u0018)\u0016\u001cH/\u001b8h)\u0006\u0014G.Z#om&\u0014xN\\7f]RDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDCA\u0014)!\t\t\u0003\u0001C\u0003 I\u0001\u0007\u0001\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\u0015=\u0004XM]1uS>t7/F\u0001-!\ri\u0003GM\u0007\u0002])\u0011q\u0006F\u0001\u0005kRLG.\u0003\u00022]\t!A*[:u!\t\u0019T'D\u00015\u0015\tQc!\u0003\u00027i\tyQj\u001c3jMf|\u0005/\u001a:bi&|g\u000e\u0003\u00049\u0001\u0001\u0006I\u0001L\u0001\f_B,'/\u0019;j_:\u001c\b\u0005C\u0003;\u0001\u0011\u00051&A\u0007hKR|\u0005/\u001a:bi&|gn\u001d\u0005\u0006y\u0001!\t%P\u0001\rC\u0012$\u0017J\\:feR\u001c\u0016\u000f\u001c\u000b\u00031yBQaP\u001eA\u0002\u0001\u000b\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0005\u0005;eB\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\"\t\u000b-\u0003A\u0011\t'\u0002\u0013\u0005$G-\u00138tKJ$Hc\u0001\rN\u001f\")aJ\u0013a\u0001\u0001\u0006QA/\u0019:hKR\u0004\u0016\r\u001e5\t\u000b\u001dQ\u0005\u0019\u0001)\u0011\u0005e\t\u0016B\u0001*\u001b\u0005\u0015!\u0016M\u00197f\u0011\u0015Y\u0005\u0001\"\u0011U)\u0011ARKV,\t\u000b9\u001b\u0006\u0019\u0001!\t\u000b\u001d\u0019\u0006\u0019\u0001)\t\u000ba\u001b\u0006\u0019A-\u0002\u0013=4XM]<sSR,\u0007C\u0001\"[\u0013\tY6IA\u0004C_>dW-\u00198\t\u000bu\u0003A\u0011\t0\u0002\u000f\u0015D\b\u000f\\1j]R\u0011\u0001i\u0018\u0005\u0006Ar\u0003\r!Y\u0001\rKb$(/\u0019#fi\u0006LGn\u001d\t\u0004\u0005\n$\u0017BA2D\u0005)a$/\u001a9fCR,GM\u0010\t\u00033\u0015L!A\u001a\u000e\u0003\u001b\u0015C\b\u000f\\1j]\u0012+G/Y5m\u0011\u0015A\u0007\u0001\"\u0011j\u0003\u001d)\u00070Z2vi\u0016$\u0012A\u001b\t\u00033-L!\u0001\u001c\u000e\u0003\u0017Q\u000b'\r\\3SKN,H\u000e\u001e")
public class TestingStatementSet
implements StatementSet {
    private final TestingTableEnvironment tEnv;
    private final List<ModifyOperation> operations;

    private List<ModifyOperation> operations() {
        return this.operations;
    }

    public List<ModifyOperation> getOperations() {
        return this.operations();
    }

    public StatementSet addInsertSql(String statement) {
        List operations = this.tEnv.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Only single statement is supported.");
        }
        Operation operation = (Operation)operations.get(0);
        if (operation instanceof ModifyOperation) {
            ModifyOperation modifyOperation = (ModifyOperation)operation;
            boolean bl = this.operations().add(modifyOperation);
            return this;
        }
        throw new TableException("Only insert statement is supported now.");
    }

    public StatementSet addInsert(String targetPath, Table table) {
        return this.addInsert(targetPath, table, false);
    }

    public StatementSet addInsert(String targetPath, Table table, boolean overwrite) {
        UnresolvedIdentifier unresolvedIdentifier = this.tEnv.getParser().parseIdentifier(targetPath);
        ObjectIdentifier objectIdentifier = this.tEnv.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        this.operations().add((ModifyOperation)new CatalogSinkModifyOperation(objectIdentifier, table.getQueryOperation(), Collections.emptyMap(), overwrite, Collections.emptyMap()));
        return this;
    }

    public String explain(Seq<ExplainDetail> extraDetails) {
        return this.tEnv.explainInternal(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.operations()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Operation apply(ModifyOperation o) {
                return o;
            }
        }, Buffer$.MODULE$.canBuildFrom())), (ExplainDetail[])extraDetails.toArray(ClassTag$.MODULE$.apply(ExplainDetail.class)));
    }

    public TableResult execute() {
        try {
            return this.tEnv.executeInternal(this.operations());
        }
        finally {
            this.operations().clear();
        }
    }

    public String explain(ExplainDetail[] extraDetails) {
        return this.explain((Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public TestingStatementSet(TestingTableEnvironment tEnv) {
        this.tEnv = tEnv;
        this.operations = new ArrayList<ModifyOperation>();
    }
}

