/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.descriptors.DescriptorProperties;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TestPartitionableSourceFactory$ {
    public static final TestPartitionableSourceFactory$ MODULE$;
    private final TableSchema tableSchema;

    static {
        new TestPartitionableSourceFactory$();
    }

    private TableSchema tableSchema() {
        return this.tableSchema;
    }

    public void createTemporaryTable(TableEnvironment tEnv, String tableName, boolean isBounded) {
        this.createTemporaryTable(tEnv, tableName, isBounded, this.tableSchema(), this.createTemporaryTable$default$5(), this.createTemporaryTable$default$6());
    }

    public void createTemporaryTable(TableEnvironment tEnv, String tableName, boolean isBounded, TableSchema tableSchema, java.util.List<java.util.Map<String, String>> remainingPartitions, boolean sourceFetchPartitions) {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("is-bounded", ((Object)BoxesRunTime.boxToBoolean((boolean)isBounded)).toString());
        properties.putBoolean("source-fetch-partitions", sourceFetchPartitions);
        properties.putString("connector.type", "TestPartitionableSource");
        if (remainingPartitions != null) {
            ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(remainingPartitions).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final DescriptorProperties properties$1;

                public final void apply(Tuple2<java.util.Map<String, String>, Object> x0$4) {
                    Tuple2<java.util.Map<String, String>, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        java.util.Map part = (java.util.Map)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        this.properties$1.putString(new StringBuilder().append((Object)"remaining-partition.").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (String)((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(part).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Tuple2<String, String> x0$5) {
                                Tuple2<String, String> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                                    return string;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String kv1, String kv2) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kv1, kv2}));
                            }
                        }));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.properties$1 = properties$1;
                }
            });
        }
        CatalogTableImpl table = new CatalogTableImpl(tableSchema, Arrays.asList((Object[])new String[]{"part1", "part2"}), properties.asMap(), "");
        Catalog catalog = (Catalog)tEnv.getCatalog(tEnv.getCurrentCatalog()).get();
        ObjectPath path = new ObjectPath(tEnv.getCurrentDatabase(), tableName);
        catalog.createTable(path, (CatalogBaseTable)table, false);
        List partitions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.Map[]{(java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))).asJava()}));
        partitions.foreach((Function1)new Serializable(catalog, path){
            public static final long serialVersionUID = 0L;
            private final Catalog catalog$1;
            private final ObjectPath path$1;

            public final void apply(java.util.Map<String, String> spec) {
                this.catalog$1.createPartition(this.path$1, new CatalogPartitionSpec(new LinkedHashMap<String, String>(spec)), (CatalogPartition)new CatalogPartitionImpl(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), ""), true);
            }
            {
                this.catalog$1 = catalog$1;
                this.path$1 = path$1;
            }
        });
    }

    public TableSchema createTemporaryTable$default$4() {
        return this.tableSchema();
    }

    public java.util.List<java.util.Map<String, String>> createTemporaryTable$default$5() {
        return null;
    }

    public boolean createTemporaryTable$default$6() {
        return false;
    }

    private TestPartitionableSourceFactory$() {
        MODULE$ = this;
        this.tableSchema = TableSchema.builder().field("id", DataTypes.INT()).field("name", DataTypes.STRING()).field("part1", DataTypes.STRING()).field("part2", DataTypes.INT()).build();
    }
}

