/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.operations.DataStreamQueryOperation;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;

public final class TableTestUtil$ {
    public static final TableTestUtil$ MODULE$;
    private final EnvironmentSettings STREAM_SETTING;
    private final EnvironmentSettings BATCH_SETTING;

    static {
        new TableTestUtil$();
    }

    public EnvironmentSettings STREAM_SETTING() {
        return this.STREAM_SETTING;
    }

    public EnvironmentSettings BATCH_SETTING() {
        return this.BATCH_SETTING;
    }

    public RelNode toRelNode(Table table) {
        return ((PlannerBase)((TableEnvironmentImpl)((TableImpl)table).getTableEnvironment()).getPlanner()).getRelBuilder().queryOperation(table.getQueryOperation()).build();
    }

    public <T> void createTemporaryView(TableEnvironment tEnv, String name, DataStream<T> dataStream, Option<Expression[]> fields, Option<boolean[]> fieldNullables, Option<FlinkStatistic> statistic) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        StreamExecutionEnvironment execEnv = planner.getExecEnv();
        TypeInformation streamType = dataStream.getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1)new Serializable(execEnv, streamType){
            public static final long serialVersionUID = 0L;
            private final StreamExecutionEnvironment execEnv$1;
            private final TypeInformation streamType$1;

            /*
             * WARNING - void declaration
             */
            public final FieldInfoUtils.TypeInfoSchema apply(Expression[] f) {
                void var2_2;
                FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo((TypeInformation)this.streamType$1, (Expression[])f);
                if (fieldsInfo.isRowtimeDefined() && this.execEnv$1.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                    throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", this.execEnv$1.getStreamTimeCharacteristic()));
                }
                return var2_2;
            }
            {
                this.execEnv$1 = execEnv$1;
                this.streamType$1 = streamType$1;
            }
        }).getOrElse((Function0)new Serializable(streamType){
            public static final long serialVersionUID = 0L;
            private final TypeInformation streamType$1;

            public final FieldInfoUtils.TypeInfoSchema apply() {
                return FieldInfoUtils.getFieldsInfo((TypeInformation)this.streamType$1);
            }
            {
                this.streamType$1 = streamType$1;
            }
        });
        int fieldCnt = typeInfoSchema.getFieldTypes().length;
        DataStreamQueryOperation dataStreamQueryOperation = new DataStreamQueryOperation(ObjectIdentifier.of((String)tEnv.getCurrentCatalog(), (String)tEnv.getCurrentDatabase(), (String)name), dataStream, typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema(), (boolean[])fieldNullables.getOrElse((Function0)new Serializable(fieldCnt){
            public static final long serialVersionUID = 0L;
            private final int fieldCnt$1;

            public final boolean[] apply() {
                return (boolean[])Array$.MODULE$.fill(this.fieldCnt$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }, ClassTag$.MODULE$.Boolean());
            }
            {
                this.fieldCnt$1 = fieldCnt$1;
            }
        }), (FlinkStatistic)statistic.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FlinkStatistic apply() {
                return FlinkStatistic$.MODULE$.UNKNOWN();
            }
        }));
        Table table = this.createTable(tEnv, (QueryOperation)dataStreamQueryOperation);
        tEnv.registerTable(name, table);
    }

    public <T> Option<Expression[]> createTemporaryView$default$4() {
        return None$.MODULE$;
    }

    public <T> Option<boolean[]> createTemporaryView$default$5() {
        return None$.MODULE$;
    }

    public <T> Option<FlinkStatistic> createTemporaryView$default$6() {
        return None$.MODULE$;
    }

    public Table createTable(TableEnvironment tEnv, QueryOperation queryOperation) {
        block4: {
            Method method;
            block3: {
                TableEnvironment tableEnvironment;
                block2: {
                    tableEnvironment = tEnv;
                    boolean bl = tableEnvironment instanceof StreamTableEnvironmentImpl ? true : tableEnvironment instanceof org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
                    if (!bl) break block2;
                    method = tEnv.getClass().getSuperclass().getDeclaredMethod("createTable", QueryOperation.class);
                    break block3;
                }
                if (!(tableEnvironment instanceof TableEnvironmentImpl)) break block4;
                TableEnvironmentImpl tableEnvironmentImpl = (TableEnvironmentImpl)tableEnvironment;
                method = tableEnvironmentImpl.getClass().getDeclaredMethod("createTable", QueryOperation.class);
            }
            Method createTableMethod = method;
            createTableMethod.setAccessible(true);
            return (Table)createTableMethod.invoke((Object)tEnv, queryOperation);
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported class: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tEnv.getClass().getCanonicalName()})));
    }

    public String readFromResource(String path) {
        String basePath = this.getClass().getResource("/").getFile();
        String fullPath = path.startsWith("/") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath, path.substring(1)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath, path}));
        BufferedSource source = Source$.MODULE$.fromFile(fullPath, Codec$.MODULE$.fallbackSystemCodec());
        String str = source.mkString();
        source.close();
        return str;
    }

    public Seq<String> readFromFile(String path) {
        File file = new File(path);
        return file.isDirectory() ? (Seq)Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foldLeft((Object)Seq$.MODULE$.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Seq<String> lines, File p) {
                return (Seq)lines.$plus$plus(TableTestUtil$.MODULE$.readFromFile(p.getAbsolutePath()), Seq$.MODULE$.canBuildFrom());
            }
        }) : (file.isHidden() ? (Seq)Seq$.MODULE$.empty() : JavaConversions$.MODULE$.asScalaBuffer(Files.readAllLines(Paths.get(file.toURI()))).toSeq());
    }

    public String getFormattedJson(String json) throws IOException {
        JsonParser parser = new ObjectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toString();
    }

    public String getPrettyJson(String json) throws IOException {
        JsonParser parser = new ObjectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toPrettyString();
    }

    public String replaceStageId(String s) {
        return s.replaceAll("\\r\\n", "\n").replaceAll("Stage \\d+", "");
    }

    public String replaceStreamNodeId(String s) {
        return s.replaceAll("\"id\" : \\d+", "\"id\" : ").trim();
    }

    public String replaceExecNodeId(String s) {
        return s.replaceAll("\"id\"\\s*:\\s*\\d+", "\"id\": 0").replaceAll("\"source\"\\s*:\\s*\\d+", "\"source\": 0").replaceAll("\"target\"\\s*:\\s*\\d+", "\"target\": 0");
    }

    public String replaceFlinkVersion(String s) {
        return s.replaceAll("\"flinkVersion\":\"[\\w.-]*\"", "\"flinkVersion\":\"\"");
    }

    public Option<CatalogManager> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private TableTestUtil$() {
        MODULE$ = this;
        this.STREAM_SETTING = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.BATCH_SETTING = EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

