/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.graph.GlobalDataExchangeMode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.utils.ShuffleModeUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ShuffleModeUtilsTest
extends TestLogger {
    @Test
    public void testGetValidShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalDataExchangeMode.ALL_EDGES_BLOCKING.toString());
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_BLOCKING, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalDataExchangeMode.FORWARD_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalDataExchangeMode.FORWARD_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalDataExchangeMode.POINTWISE_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalDataExchangeMode.POINTWISE_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, GlobalDataExchangeMode.ALL_EDGES_PIPELINED.toString());
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
    }

    @Test
    public void testGetLegacyShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "batch");
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_BLOCKING, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "pipelined");
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
    }

    @Test
    public void testGetShuffleModeIgnoreCases() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "Forward_edges_PIPELINED");
        Assert.assertEquals((Object)GlobalDataExchangeMode.FORWARD_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "Pipelined");
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_PIPELINED, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
    }

    @Test
    public void testGetDefaultShuffleMode() {
        Configuration configuration = new Configuration();
        Assert.assertEquals((Object)GlobalDataExchangeMode.ALL_EDGES_BLOCKING, (Object)ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInvalidShuffleMode() {
        Configuration configuration = new Configuration();
        configuration.setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, "invalid-value");
        ShuffleModeUtils.getShuffleModeAsGlobalDataExchangeMode((Configuration)configuration);
    }
}

