/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.table.planner.utils.XmlOutput;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DiffRepository {
    private static final String ROOT_TAG = "Root";
    private static final String TEST_CASE_TAG = "TestCase";
    private static final String TEST_CASE_NAME_ATTR = "name";
    private static final String TEST_CASE_OVERRIDES_ATTR = "overrides";
    private static final String RESOURCE_TAG = "Resource";
    private static final String RESOURCE_NAME_ATTR = "name";
    private static final String LICENSE = "\nLicensed to the Apache Software Foundation (ASF) under one or more\ncontributor license agreements.  See the NOTICE file distributed with\nthis work for additional information regarding copyright ownership.\nThe ASF licenses this file to you under the Apache License, Version 2.0\n(the \"License\"); you may not use this file except in compliance with\nthe License.  You may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n";
    private static final Map<Class, DiffRepository> MAP_CLASS_TO_REPOSITORY = new HashMap<Class, DiffRepository>();
    private final DiffRepository baseRepository;
    private final int indent;
    private Document doc;
    private final Element root;
    private final File logFile;
    private final Filter filter;

    private DiffRepository(URL refFile, File logFile, DiffRepository baseRepository, Filter filter) {
        this.baseRepository = baseRepository;
        this.filter = filter;
        if (refFile == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.logFile = logFile;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = fac.newDocumentBuilder();
            try {
                this.doc = docBuilder.parse(refFile.openStream());
            }
            catch (IOException | SAXParseException e) {
                this.doc = docBuilder.newDocument();
                this.doc.appendChild(this.doc.createComment(LICENSE));
                this.doc.appendChild(this.doc.createElement(ROOT_TAG));
                this.flushDoc();
            }
            this.root = this.doc.getDocumentElement();
            if (!this.root.getNodeName().equals(ROOT_TAG)) {
                throw new RuntimeException("expected root element of type 'Root', but found '" + this.root.getNodeName() + "'");
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("error while creating xml parser", e);
        }
        this.indent = logFile.getPath().contains("RelOptRulesTest") || logFile.getPath().contains("SqlToRelConverterTest") || logFile.getPath().contains("SqlLimitsTest") ? 4 : 2;
    }

    private static URL findFile(Class clazz, String suffix) {
        String rest = "/" + clazz.getName().replace('.', File.separatorChar) + suffix;
        URL url = clazz.getResource(rest);
        if (url == null) {
            File path = new File("./src/test/resources", rest);
            try {
                path.getParentFile().mkdirs();
                path.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Can not create file " + path.getAbsolutePath(), e);
            }
            try {
                url = path.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Can not get URL of file path " + path.getAbsolutePath(), e);
            }
        }
        return url;
    }

    public synchronized String expand(String testCaseName, String tag, String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("${") && text.endsWith("}")) {
            String token = text.substring(2, text.length() - 1);
            if (tag == null) {
                tag = token;
            }
            assert (token.startsWith(tag)) : "token '" + token + "' does not match tag '" + tag + "'";
            String expanded = this.get(testCaseName, token);
            if (expanded == null) {
                return text;
            }
            if (this.filter != null) {
                expanded = this.filter.filter(this, testCaseName, tag, text, expanded);
            }
            return expanded;
        }
        if (this.baseRepository == null || this.baseRepository.get(testCaseName, tag) == null) {
            this.set(testCaseName, tag, text);
        }
        return text;
    }

    public synchronized void set(String testCaseName, String resourceName, String value) {
        assert (resourceName != null);
        this.update(testCaseName, resourceName, value);
    }

    public void amend(String testCaseName, String expected, String actual) {
        if (expected.startsWith("${") && expected.endsWith("}")) {
            String token = expected.substring(2, expected.length() - 1);
            this.set(testCaseName, token, actual);
        }
    }

    private synchronized String get(String testCaseName, String resourceName) {
        Element testCaseElement = this.getTestCaseElement(testCaseName, true, null);
        if (testCaseElement == null) {
            if (this.baseRepository != null) {
                return this.baseRepository.get(testCaseName, resourceName);
            }
            return null;
        }
        Element resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName);
        if (resourceElement != null) {
            return DiffRepository.getText(resourceElement);
        }
        return null;
    }

    private static String getText(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof CDATASection)) continue;
            return node.getNodeValue();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Text)) continue;
            buf.append(((Text)node).getWholeText());
        }
        return buf.toString();
    }

    private synchronized Element getTestCaseElement(String testCaseName, boolean checkOverride, List<Pair<String, Element>> elements) {
        NodeList childNodes = this.root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(TEST_CASE_TAG)) continue;
            Element testCase = (Element)child;
            String name = testCase.getAttribute("name");
            if (testCaseName.equals(name)) {
                if (checkOverride && this.baseRepository != null && this.baseRepository.getTestCaseElement(testCaseName, false, null) != null && !"true".equals(testCase.getAttribute(TEST_CASE_OVERRIDES_ATTR))) {
                    throw new RuntimeException("TestCase  '" + testCaseName + "' overrides a test case in the base repository, but does not specify 'overrides=true'");
                }
                return testCase;
            }
            if (elements == null) continue;
            elements.add((Pair<String, Element>)Pair.of((Object)name, (Object)testCase));
        }
        return null;
    }

    public void assertEquals(String testCaseName, String tag, String expected, String actual) {
        String expected2 = this.expand(testCaseName, tag, expected);
        if (expected2 == null) {
            this.update(testCaseName, expected, actual);
            throw new AssertionError((Object)("reference file does not contain resource '" + expected + "' for test case '" + testCaseName + "'"));
        }
        try {
            String expected2Canonical = expected2.replace(Util.LINE_SEPARATOR, "\n");
            String actualCanonical = actual.replace(Util.LINE_SEPARATOR, "\n");
            Assert.assertEquals((String)tag, (Object)expected2Canonical, (Object)actualCanonical);
        }
        catch (ComparisonFailure e) {
            this.amend(testCaseName, expected, actual);
            throw e;
        }
    }

    private synchronized void update(String testCaseName, String resourceName, String value) {
        Element resourceElement;
        ArrayList<Pair<String, Element>> map2 = new ArrayList<Pair<String, Element>>();
        Element testCaseElement = this.getTestCaseElement(testCaseName, true, map2);
        if (testCaseElement == null) {
            testCaseElement = this.doc.createElement(TEST_CASE_TAG);
            testCaseElement.setAttribute("name", testCaseName);
            Node refElement = this.ref(testCaseName, map2);
            this.root.insertBefore(testCaseElement, refElement);
        }
        if ((resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName, true)) == null) {
            resourceElement = this.doc.createElement(RESOURCE_TAG);
            resourceElement.setAttribute("name", resourceName);
            testCaseElement.appendChild(resourceElement);
        } else {
            DiffRepository.removeAllChildren(resourceElement);
        }
        if (!value.equals("")) {
            resourceElement.appendChild(this.doc.createCDATASection(value));
        }
        this.flushDoc();
    }

    private Node ref(String testCaseName, List<Pair<String, Element>> map2) {
        if (map2.isEmpty()) {
            return null;
        }
        int i = 0;
        List names = Pair.left(map2);
        for (String s : names) {
            if (s.compareToIgnoreCase(testCaseName) > 0) continue;
            ++i;
        }
        while (i < map2.size() && ((String)names.get(i)).compareToIgnoreCase(testCaseName) < 0) {
            ++i;
        }
        if (i >= map2.size() - 1) {
            return null;
        }
        while (i >= 0 && ((String)names.get(i)).compareToIgnoreCase(testCaseName) > 0) {
            --i;
        }
        return (Node)map2.get((int)(i + 1)).right;
    }

    private void flushDoc() {
        try {
            boolean b = this.logFile.getParentFile().mkdirs();
            Util.discard((boolean)b);
            try (PrintWriter w = Util.printWriter((File)this.logFile);){
                DiffRepository.write(this.doc, w, this.indent);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error while writing test reference log '" + this.logFile + "'", e);
        }
    }

    private static Element getResourceElement(Element testCaseElement, String resourceName) {
        return DiffRepository.getResourceElement(testCaseElement, resourceName, false);
    }

    private static Element getResourceElement(Element testCaseElement, String resourceName, boolean killYoungerSiblings) {
        NodeList childNodes = testCaseElement.getChildNodes();
        Element found = null;
        ArrayList<Node> kills = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(RESOURCE_TAG) || !resourceName.equals(((Element)child).getAttribute("name"))) continue;
            if (found == null) {
                found = (Element)child;
                continue;
            }
            if (!killYoungerSiblings) continue;
            kills.add(child);
        }
        for (Node kill : kills) {
            testCaseElement.removeChild(kill);
        }
        return found;
    }

    private static void removeAllChildren(Element element) {
        NodeList childNodes = element.getChildNodes();
        while (childNodes.getLength() > 0) {
            element.removeChild(childNodes.item(0));
        }
    }

    private static void write(Document doc, Writer w, int indent) {
        XmlOutput out = new XmlOutput(w);
        out.setGlob(true);
        out.setIndentString(Spaces.of((int)indent));
        DiffRepository.writeNode(doc, out);
    }

    private static void writeNode(Node node, XmlOutput out) {
        switch (node.getNodeType()) {
            case 9: {
                out.print("<?xml version=\"1.0\" ?>\n");
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    DiffRepository.writeNode(child, out);
                }
                break;
            }
            case 1: {
                int i;
                Element element = (Element)node;
                String tagName = element.getTagName();
                out.beginBeginTag(tagName);
                NamedNodeMap attributeMap = element.getAttributes();
                for (i = 0; i < attributeMap.getLength(); ++i) {
                    Node att = attributeMap.item(i);
                    out.attribute(att.getNodeName(), att.getNodeValue());
                }
                out.endBeginTag(tagName);
                NodeList childNodes = node.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() == 2) continue;
                    DiffRepository.writeNode(child, out);
                }
                out.endTag(tagName);
                break;
            }
            case 2: {
                out.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                CDATASection cdata = (CDATASection)node;
                out.cdata(cdata.getNodeValue(), true);
                break;
            }
            case 3: {
                Text text = (Text)node;
                String wholeText = text.getNodeValue();
                if (DiffRepository.isWhitespace(wholeText)) break;
                out.cdata(wholeText, false);
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                out.print("<!--" + comment.getNodeValue() + "-->\n");
                break;
            }
            default: {
                throw new RuntimeException("unexpected node type: " + node.getNodeType() + " (" + node + ")");
            }
        }
    }

    private static boolean isWhitespace(String text) {
        int count = text.length();
        block3: for (int i = 0; i < count; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static DiffRepository lookup(Class clazz) {
        return DiffRepository.lookup(clazz, null);
    }

    public static DiffRepository lookup(Class clazz, DiffRepository baseRepository) {
        return DiffRepository.lookup(clazz, baseRepository, null);
    }

    public static synchronized DiffRepository lookup(Class clazz, DiffRepository baseRepository, Filter filter) {
        DiffRepository diffRepository = MAP_CLASS_TO_REPOSITORY.get(clazz);
        if (diffRepository == null) {
            URL refFile = DiffRepository.findFile(clazz, ".xml");
            File logFile = new File(refFile.getFile().replace("test-classes", "surefire"));
            diffRepository = new DiffRepository(refFile, logFile, baseRepository, filter);
            MAP_CLASS_TO_REPOSITORY.put(clazz, diffRepository);
        }
        return diffRepository;
    }

    public static interface Filter {
        public String filter(DiffRepository var1, String var2, String var3, String var4, String var5);
    }
}

