/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Random;
import java.util.TimeZone;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.types.Row;
import org.junit.Assert;

public class JavaUserDefinedScalarFunctions {

    public static class RowPandasScalarFunction
    extends RowPythonScalarFunction {
        public RowPandasScalarFunction(String name) {
            super(name);
        }

        public PythonFunctionKind getPythonFunctionKind() {
            return PythonFunctionKind.PANDAS;
        }
    }

    public static class BooleanPandasScalarFunction
    extends BooleanPythonScalarFunction {
        public BooleanPandasScalarFunction(String name) {
            super(name);
        }

        public PythonFunctionKind getPythonFunctionKind() {
            return PythonFunctionKind.PANDAS;
        }
    }

    public static class PandasScalarFunction
    extends PythonScalarFunction {
        public PandasScalarFunction(String name) {
            super(name);
        }

        public PythonFunctionKind getPythonFunctionKind() {
            return PythonFunctionKind.PANDAS;
        }
    }

    public static class RowJavaScalarFunction
    extends ScalarFunction {
        private final String name;

        public RowJavaScalarFunction(String name) {
            this.name = name;
        }

        public Row eval(Object ... a) {
            return Row.of((Object[])new Object[]{1, 2});
        }

        public TypeInformation<?> getResultType(Class<?>[] signature) {
            return Types.ROW((TypeInformation[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        }

        public String toString() {
            return this.name;
        }
    }

    public static class RowPythonScalarFunction
    extends ScalarFunction
    implements PythonFunction {
        private final String name;

        public RowPythonScalarFunction(String name) {
            this.name = name;
        }

        public Row eval(int a) {
            return Row.of((Object[])new Object[]{a + 1, Row.of((Object[])new Object[]{a * a})});
        }

        public Row eval(Object ... args) {
            return Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{2})});
        }

        public TypeInformation<?> getResultType(Class<?>[] signature) {
            return Types.ROW((TypeInformation[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, Types.ROW((TypeInformation[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO})});
        }

        public boolean takesRowAsInput() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        public byte[] getSerializedPythonFunction() {
            return new byte[0];
        }

        public PythonEnv getPythonEnv() {
            return null;
        }
    }

    public static class BooleanPythonScalarFunction
    extends ScalarFunction
    implements PythonFunction {
        private final String name;

        public BooleanPythonScalarFunction(String name) {
            this.name = name;
        }

        public boolean eval(int i, int j) {
            return i + j > 1;
        }

        public TypeInformation<?> getResultType(Class<?>[] signature) {
            return BasicTypeInfo.BOOLEAN_TYPE_INFO;
        }

        public String toString() {
            return this.name;
        }

        public byte[] getSerializedPythonFunction() {
            return new byte[0];
        }

        public PythonEnv getPythonEnv() {
            return null;
        }
    }

    public static class PythonScalarFunction
    extends ScalarFunction
    implements PythonFunction {
        private final String name;

        public PythonScalarFunction(String name) {
            this.name = name;
        }

        public int eval(int i, int j) {
            return i + j;
        }

        public String eval(String a) {
            return a;
        }

        public String toString() {
            return this.name;
        }

        public byte[] getSerializedPythonFunction() {
            return new byte[0];
        }

        public PythonEnv getPythonEnv() {
            return new PythonEnv(PythonEnv.ExecType.PROCESS);
        }
    }

    public static class NonDeterministicUdf
    extends ScalarFunction {
        Random random = new Random();

        public int eval() {
            return this.random.nextInt();
        }

        public int eval(int v) {
            return v + this.random.nextInt();
        }

        public boolean isDeterministic() {
            return false;
        }
    }

    public static class UdfWithOpen
    extends ScalarFunction {
        private boolean isOpened = false;

        public void open(FunctionContext context) throws Exception {
            super.open(context);
            this.isOpened = true;
        }

        public String eval(String c) {
            if (!this.isOpened) {
                throw new IllegalStateException("Open method is not called!");
            }
            return "$" + c;
        }
    }

    public static class JavaFunc5
    extends ScalarFunction {
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        public void open(FunctionContext context) {
            openCalled = true;
        }

        @DataTypeHint(value="TIMESTAMP(3)")
        public Timestamp eval(@DataTypeHint(value="TIMESTAMP(3)") TimestampData timestampData, Integer offset) {
            if (!openCalled) {
                Assert.fail((String)"Open was not called before run.");
            }
            if (timestampData == null || offset == null) {
                return null;
            }
            long ts = timestampData.getMillisecond() - (long)offset.intValue();
            int tzOffset = TimeZone.getDefault().getOffset(ts);
            return new Timestamp(ts - (long)tzOffset);
        }

        public void close() {
            closeCalled = true;
        }
    }

    public static class JavaFunc4
    extends ScalarFunction {
        public String eval(Integer[] a, String[] b) {
            return Arrays.toString((Object[])a) + " and " + Arrays.toString(b);
        }
    }

    public static class JavaFunc3
    extends ScalarFunction {
        public int eval(String a, int ... b) {
            return b.length;
        }

        public String eval(String c) {
            return c;
        }
    }

    public static class JavaFunc2
    extends ScalarFunction {
        public String eval(String s, Integer ... a) {
            int m = 1;
            Integer[] integerArray = a;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                m *= n2;
            }
            return s + m;
        }
    }

    public static class JavaFunc1
    extends ScalarFunction {
        public String eval(Integer a, int b, @DataTypeHint(value="TIMESTAMP(3)") TimestampData c) {
            Long ts = c == null ? null : Long.valueOf(c.getMillisecond());
            return a + " and " + b + " and " + ts;
        }
    }

    public static class JavaFunc0
    extends ScalarFunction {
        public long eval(Long l) {
            return l + 1L;
        }
    }
}

