/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.stream.sql.TemporalTableFunctionJoinITCase$;
import org.apache.flink.table.planner.runtime.stream.sql.TimestampExtractor;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001'\tyB+Z7q_J\fG\u000eV1cY\u00164UO\\2uS>t'j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbC\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015\u0019H/\u0019;f!\ti\u0012G\u0004\u0002\u001f_9\u0011qD\f\b\u0003A5r!!\t\u0017\u000f\u0005\tZcBA\u0012+\u001d\t!\u0013F\u0004\u0002&Q5\taE\u0003\u0002(%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011\u0001GF\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0005\u0003eM\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u0005A2\u0002\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\b\u0006\u00028sA\u0011\u0001\bA\u0007\u0002\u0005!)1\u0004\u000ea\u00019!)1\b\u0001C\u0001y\u0005AB/Z:u!J|7-Z:t)&lW-\u00138oKJTu.\u001b8\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\u0012!\b\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fB\tQA[;oSRL!!\u0013$\u0003\tQ+7\u000f\u001e\u0005\u0006\u0017\u0002!\t\u0001P\u0001\u0017i\u0016\u001cH/\u0012<f]R$\u0016.\\3J]:,'OS8j]\"\u0012!\n\u0012\u0005\u0006\u001d\u0002!\t\u0001P\u0001\u0017i\u0016\u001cHOT3ti\u0016$G+Z7q_J\fGNS8j]\"\u0012Q\n\u0012\u0015\u0005\u0001E;\u0006\f\u0005\u0002S+6\t1K\u0003\u0002U\r\u00061!/\u001e8oKJL!AV*\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\n\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]\r\u00069!/\u001e8oKJ\u001c\u0018B\u00010\\\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0002")
public class TemporalTableFunctionJoinITCase
extends StreamingWithStateTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("amount");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("currency");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("rate");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("orderId");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("productId");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("price");

    @Test
    public void testProcessTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.proctime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro"));
        ordersData.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)"US Dollar"));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L)));
        ratesHistoryData.$plus$eq((Object)new Tuple2((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L)));
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ordersData, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).proctime()}));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ratesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$4), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).proctime()}));
        tEnv.registerTable("Orders", orders);
        tEnv.registerTable("RatesHistory", ratesHistory);
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        result.addSink((SinkFunction)new TestingAppendSink());
        env.execute();
    }

    @Test
    public void testEventTimeInnerJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setParallelism(1);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.amount * r.rate AS amount\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Rates(o.rowtime)) AS r\n        |WHERE r.currency = o.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"Euro", (Object)new Timestamp(2L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"US Dollar", (Object)new Timestamp(3L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)50L), (Object)"Yen", (Object)new Timestamp(4L)));
        ordersData.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)"Euro", (Object)new Timestamp(5L)));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L), (Object)new Timestamp(5L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L), (Object)new Timestamp(7L)));
        HashSet expectedOutput = new HashSet();
        expectedOutput.$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)228)).toString());
        expectedOutput.$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)348)).toString());
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ordersData, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ratesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$4), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}));
        tEnv.registerTable("Orders", orders);
        tEnv.registerTable("RatesHistory", ratesHistory);
        tEnv.registerTable("FilteredRatesHistory", tEnv.sqlQuery("SELECT * FROM RatesHistory WHERE rate > 110"));
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)tEnv.from("FilteredRatesHistory").createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        tEnv.registerTable("TemporalJoinResult", tEnv.sqlQuery(sqlQuery));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.from("TemporalJoinResult")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        env.execute();
        Assert.assertEquals((Object)expectedOutput, (Object)sink.getAppendResults().toSet());
    }

    @Test
    public void testNestedTemporalJoin() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  o.orderId,\n        |  (o.amount * p.price * r.rate) as total_price\n        |FROM\n        |  Orders AS o,\n        |  LATERAL TABLE (Prices(o.rowtime)) AS p,\n        |  LATERAL TABLE (Rates(o.rowtime)) AS r\n        |WHERE\n        |  o.productId = p.productId AND\n        |  r.currency = p.currency\n        |")).stripMargin();
        MutableList ordersData = new MutableList();
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)1L), (Object)"A1", (Object)BoxesRunTime.boxToLong((long)2L), (Object)new Timestamp(2L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)2L), (Object)"A2", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(3L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)3L), (Object)"A4", (Object)BoxesRunTime.boxToLong((long)50L), (Object)new Timestamp(4L)));
        ordersData.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)4L), (Object)"A1", (Object)BoxesRunTime.boxToLong((long)3L), (Object)new Timestamp(5L)));
        Table orders = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ordersData, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$1), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}));
        MutableList ratesHistoryData = new MutableList();
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"US Dollar", (Object)BoxesRunTime.boxToLong((long)102L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)114L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Yen", (Object)BoxesRunTime.boxToLong((long)1L), (Object)new Timestamp(1L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)116L), (Object)new Timestamp(5L)));
        ratesHistoryData.$plus$eq((Object)new Tuple3((Object)"Euro", (Object)BoxesRunTime.boxToLong((long)119L), (Object)new Timestamp(7L)));
        Table ratesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)ratesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$13 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$4), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}));
        MutableList pricesHistoryData = new MutableList();
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A2", (Object)"US Dollar", (Object)BoxesRunTime.boxToDouble((double)10.2), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.4), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A4", (Object)"Yen", (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)new Timestamp(1L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.6), (Object)new Timestamp(5L)));
        pricesHistoryData.$plus$eq((Object)new Tuple4((Object)"A1", (Object)"Euro", (Object)BoxesRunTime.boxToDouble((double)11.9), (Object)new Timestamp(7L)));
        Table pricesHistory = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromCollection((Seq)pricesHistoryData, (TypeInformation)new CaseClassTypeInfo<Tuple4<String, String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<String, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<String, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<String, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).assignTimestampsAndWatermarks(new TimestampExtractor())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$8), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}));
        tEnv.createTemporaryView("Orders", orders);
        tEnv.createTemporaryView("RatesHistory", ratesHistory);
        tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)ratesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporarySystemFunction("Prices", (UserDefinedFunction)pricesHistory.createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"productId"}))).$((Seq)Nil$.MODULE$)));
        tEnv.createTemporaryView("TemporalJoinResult", tEnv.sqlQuery(sqlQuery));
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.from("TemporalJoinResult")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        env.execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2599.2000000000003)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1040.3999999999999)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)50.0)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4,", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)4036.7999999999997)}))}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TemporalTableFunctionJoinITCase(StreamingWithStateTestBase.StateBackendMode state) {
        super(state);
    }
}

