/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001'\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005[>$W\r\u0005\u0002\u001ec9\u0011ad\f\b\u0003?9r!\u0001I\u0017\u000f\u0005\u0005bcB\u0001\u0012,\u001d\t\u0019#F\u0004\u0002%S9\u0011Q\u0005K\u0007\u0002M)\u0011qEE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003aY\t!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!AM\u001a\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'B\u0001\u0019\u0017\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0011q'\u000f\t\u0003q\u0001i\u0011A\u0001\u0005\u00067Q\u0002\r\u0001\b\u0005\u0006w\u0001!\t\u0005P\u0001\u0007E\u00164wN]3\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\")A\t\u0001C\u0001y\u0005IB/Z:u\u0015>Lg\u000eR5t_J$WM]\"iC:<W\rT8hQ\t\u0019e\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J!\u0005)!.\u001e8ji&\u00111\n\u0013\u0002\u0005)\u0016\u001cH\u000fC\u0003N\u0001\u0011\u0005A(A\ruKN$8+\u001b8l\t&\u001cxN\u001d3fe\u000eC\u0017M\\4f\u0019><\u0007F\u0001'G\u0011\u0015\u0001\u0006\u0001\"\u0001=\u0003\u0005\"Xm\u001d;TS:\\G)[:pe\u0012,'o\u00115b]\u001e,Gj\\4XSRD'+\u00198lQ\tye\t\u000b\u0003\u0001'fS\u0006C\u0001+X\u001b\u0005)&B\u0001,I\u0003\u0019\u0011XO\u001c8fe&\u0011\u0001,\u0016\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010I\u0003\u001d\u0011XO\u001c8feNL!\u0001Y/\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class TableSinkITCase
extends StreamingWithStateTestBase {
    @Override
    public void before() {
        super.before();
        String srcDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE src (person String, votes BIGINT) WITH(\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcDataId})))).stripMargin());
        String awardDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)12.1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)18.3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)22.5)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{awardDataId})))).stripMargin());
        String peopleDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToInteger((int)22)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values',\n        |  'data-id' = '", "'\n        |)\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{peopleDataId})))).stripMargin());
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE JoinDisorderChangeLog (\n        |  person STRING, votes BIGINT, prize DOUBLE, age INT,\n        |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values',\n        |  'sink-insert-only' = 'false'\n        |)\n        |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO JoinDisorderChangeLog\n        |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n        | (SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n        |   award\n        |   WHERE T.sum_votes = award.votes) T1, people T2\n        | WHERE T1.person = T2.person\n        |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("JoinDisorderChangeLog");
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I[jason, 4, 22.5, 22]"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkDisorderChangeLog() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE SinkDisorderChangeLog (\n        |  person STRING, votes BIGINT, prize DOUBLE,\n        |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values',\n        |  'sink-insert-only' = 'false'\n        |)\n        |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkDisorderChangeLog\n        |SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T, award\n        |   WHERE T.sum_votes = award.votes\n        |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("SinkDisorderChangeLog");
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I[jason, 4, 22.5]"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkDisorderChangeLogWithRank() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE SinkRankChangeLog (\n        |  person STRING, votes BIGINT,\n        |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values',\n        |  'sink-insert-only' = 'false'\n        |)\n        |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkRankChangeLog\n        |SELECT person, sum_votes FROM\n        | (SELECT person, sum_votes,\n        |   ROW_NUMBER() OVER (PARTITION BY vote_section ORDER BY sum_votes DESC) AS rank_number\n        |   FROM (SELECT person, SUM(votes) AS sum_votes, SUM(votes) / 2 AS vote_section FROM src\n        |      GROUP BY person))\n        |   WHERE rank_number < 10\n        |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("SinkRankChangeLog");
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I[jason, 4]"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TableSinkITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

