/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecSort;
import org.apache.flink.table.planner.runtime.stream.sql.SortITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001'\tQ1k\u001c:u\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbC\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0011iw\u000eZ3\u0011\u0005u\tdB\u0001\u00100\u001d\tybF\u0004\u0002![9\u0011\u0011\u0005\f\b\u0003E-r!a\t\u0016\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\f\u0007\u0013\t\u0001d#\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0003\u00023g\t\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0003aYAQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtDCA\u001c:!\tA\u0004!D\u0001\u0003\u0011\u0015YB\u00071\u0001\u001d\u0011\u0015Y\u0004\u0001\"\u0001=\u0003}!Xm\u001d;ESN\f'\r\\3T_J$hj\u001c8UK6\u0004xN]1m\r&,G\u000e\u001a\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t!QK\\5uQ\tQD\t\u0005\u0002F\u00116\taI\u0003\u0002H!\u0005)!.\u001e8ji&\u0011\u0011J\u0012\u0002\u0005)\u0016\u001cH\u000fC\u0003L\u0001\u0011\u0005A(\u0001\u0005uKN$8k\u001c:uQ\tQE\tC\u0003O\u0001\u0011\u0005A(A\nuKN$8k\u001c:u\u001fJ$WM\u001d\"z\t\u0016\u001c8\r\u000b\u0002N\t\")\u0011\u000b\u0001C\u0001y\u0005iB/Z:u'>\u0014Ho\u0014:eKJ\u0014\u00150T;mi&\u0004H.\u001a$jK2$7\u000f\u000b\u0002Q\t\")A\u000b\u0001C\u0001y\u0005iB/Z:u'>\u0014Ho\u0014:eKJ\u0014\u0015PU3qK\u0006$X\r\u001a$jK2$7\u000f\u000b\u0002T\t\")q\u000b\u0001C\u0001y\u0005QB/Z:u'>\u0014Ho\u0014:eKJ\u0014\u0015pV5uQJ+GO]1di\"\u0012a\u000b\u0012\u0005\u00065\u0002!\t\u0001P\u0001\u0012i\u0016\u001cHoU8si^KG\u000f[,iKJ,\u0007FA-EQ\u0011\u0001Ql\u00193\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0015A\u0002:v]:,'/\u0003\u0002c?\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%A3\u0011\u0005\u0019LW\"A4\u000b\u0005!4\u0015a\u0002:v]:,'o]\u0005\u0003U\u001e\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class SortITCase
extends StreamingWithStateTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a1");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("a2");

    @Test
    public void testDisableSortNonTemporalField() {
        String sqlQuery = "SELECT * FROM a ORDER BY a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = package$.MODULE$.dataStreamConversions(this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Sort on a non-time-attribute field is not supported.");
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testSort() {
        String sqlQuery = "SELECT * FROM a ORDER BY a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,1", "1,2", "3,3", "0,4"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    @Test
    public void testSortOrderByDesc() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1 DESC";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5,1", "3,3", "1,2", "0,4"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    @Test
    public void testSortOrderByMultipleFields() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1, a2";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"7"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,4", "1,2", "1,7", "5,1"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    @Test
    public void testSortOrderByRepeatedFields() {
        String sqlQuery = "SELECT * FROM a ORDER BY a1, a1";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"5", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"0", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"7"));
        data.$plus$eq((Object)new Tuple2((Object)"2", (Object)"2"));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,4", "1,7", "2,2", "5,1"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    @Test
    public void testSortOrderByWithRetract() {
        String sqlQuery = "SELECT a1, count(*) as c FROM a GROUP BY a1 ORDER BY c";
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"2", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"4"));
        data.$plus$eq((Object)new Tuple2((Object)"6", (Object)"1"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"1", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"2"));
        data.$plus$eq((Object)new Tuple2((Object)"3", (Object)"3"));
        data.$plus$eq((Object)new Tuple2((Object)"6", (Object)"2"));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$13 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, String>> unused = new ScalaCaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                    public Tuple2<String, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,1", "6,2", "1,3", "3,4"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    @Test
    public void testSortWithWhere() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |select * from a where a1 < all (select a1 * 2 from a) order by a1 desc\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2.mcII.sp(8, 1));
        data.$plus$eq((Object)new Tuple2.mcII.sp(7, 2));
        data.$plus$eq((Object)new Tuple2.mcII.sp(6, 3));
        data.$plus$eq((Object)new Tuple2.mcII.sp(5, 4));
        data.$plus$eq((Object)new Tuple2.mcII.sp(4, 5));
        Table da = package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1)}));
        this.tEnv().registerTable("a", da);
        TestingRetractSink sink = new TestingRetractSink();
        this.tEnv().getConfig().getConfiguration().setBoolean(StreamExecSort.TABLE_EXEC_NON_TEMPORAL_SORT_ENABLED, true);
        DataStream results = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
        results.addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"7", "6", "5", "4"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    public SortITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

