/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.runtime.stream.sql.AggregateRemoveITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithAggTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001M\u0011Q#Q4he\u0016<\u0017\r^3SK6|g/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011\u0001d\u0015;sK\u0006l\u0017N\\4XSRD\u0017iZ4UKN$()Y:f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aB1hO6{G-\u001a\t\u0003;Er!AH\u0018\u000f\u0005}qcB\u0001\u0011.\u001d\t\tCF\u0004\u0002#W9\u00111E\u000b\b\u0003I%r!!\n\u0015\u000e\u0003\u0019R!a\n\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!a\u0006\u0004\n\u0005A2\u0012\u0001G*ue\u0016\fW.\u001b8h/&$\b.Q4h)\u0016\u001cHOQ1tK&\u0011!g\r\u0002\b\u0003\u001e<Wj\u001c3f\u0015\t\u0001d\u0003\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003%i\u0017N\\5cCR\u001c\u0007\u000e\u0005\u00028u9\u0011a\u0004O\u0005\u0003sY\tad\u0015;sK\u0006l\u0017N\\4XSRDW*\u001b8j\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\n\u0005mb$!D'j]&\u0014\u0015\r^2i\u001b>$WM\u0003\u0002:-!Aa\b\u0001B\u0001B\u0003%q(A\u0004cC\u000e\\WM\u001c3\u0011\u0005\u0001\u001beB\u0001\u0010B\u0013\t\u0011e#\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0003\u0002E\u000b\n\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0003\u0005ZAQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD\u0003B%L\u00196\u0003\"A\u0013\u0001\u000e\u0003\tAQa\u0007$A\u0002qAQ!\u000e$A\u0002YBQA\u0010$A\u0002}BQa\u0014\u0001\u0005\u0002A\u000ba\"^:fg2+w-Y2z%><8/F\u0001R!\t\u0011F+D\u0001T\u0015\t9\"\"\u0003\u0002V'\n\tB*Z4bGf\u0014vn\u001e*fg>,(oY3)\u00059;\u0006C\u0001-\\\u001b\u0005I&B\u0001.\u0011\u0003\u0015QWO\\5u\u0013\ta\u0016L\u0001\u0003Sk2,\u0007\"\u00020\u0001\t\u0003y\u0016A\u0003;fgR\u001c\u0016.\u001c9mKR\t\u0001\r\u0005\u0002bI6\t!MC\u0001d\u0003\u0015\u00198-\u00197b\u0013\t)'M\u0001\u0003V]&$\bFA/h!\tA\u0006.\u0003\u0002j3\n!A+Z:u\u0011\u0015Y\u0007\u0001\"\u0001`\u0003Q!Xm\u001d;XSRDwI]8va&twmU3ug\"\u0012!n\u001a\u0005\u0006]\u0002!\taX\u0001\u000fi\u0016\u001cHoV5uQJ{G\u000e\\;qQ\tiw\rC\u0003r\u0001\u0011\u0005q,\u0001\u0007uKN$x+\u001b;i\u0007V\u0014W\r\u000b\u0002qO\")A\u000f\u0001C\u0001?\u0006)B/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<\u0007FA:h\u0011\u00159\b\u0001\"\u0001`\u0003!\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hQ\t1x\rC\u0003{\u0001\u0011\u0005q,A\u000buKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ:)\u0005e<\u0007\"B?\u0001\t\u0003y\u0016a\u0005;fgR\fum\u001a:fO\u0006$XMU3n_Z,\u0007F\u0001?h\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\t1b\u00195fG.\u0014Vm];miR)\u0001-!\u0002\u0002\u0018!9\u0011qA@A\u0002\u0005%\u0011aA:ueB!\u00111BA\t\u001d\r\t\u0017QB\u0005\u0004\u0003\u001f\u0011\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010\tDq!!\u0007\u0000\u0001\u0004\tY\"\u0001\u0003s_^\u001c\bCBA\u000f\u0003G\t9#\u0004\u0002\u0002 )\u0019\u0011\u0011\u00052\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0005}!aA*fcB!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.1\tQ\u0001^=qKNLA!!\r\u0002,\t\u0019!k\\<)\u000f\u0001\t)$!\u0011\u0002DA!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<e\u000baA];o]\u0016\u0014\u0018\u0002BA \u0003s\u0011qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002Le\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002P\u0005%#!\u0004)be\u0006lW\r^3sSj,G\r")
public class AggregateRemoveITCase
extends StreamingWithAggTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testSimple() {
        this.checkResult("SELECT a, b FROM T GROUP BY a, b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, b + 1, c, s FROM (SELECT a, MIN(b) AS b, SUM(b) AS s, MAX(c) AS c FROM MyTable2 GROUP BY a)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5)}))}))));
        this.checkResult("SELECT a, SUM(b) AS s FROM MyTable2 GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5)}))}))));
        this.checkResult("SELECT a, b + 1, c, s FROM (SELECT a, MIN(b) AS b, SUM(b) AS s, MAX(c) AS c FROM MyTable GROUP BY a)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "Hi", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), "Hello", BoxesRunTime.boxToLong((long)2L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)3L), "Hello world", BoxesRunTime.boxToLong((long)2L)}))}))));
    }

    @Test
    public void testWithGroupingSets() {
        this.checkResult("SELECT a, b, c, COUNT(d) FROM T GROUP BY GROUPING SETS ((a, b), (a, c))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, "C", BoxesRunTime.boxToInteger((int)1)}))}))));
        this.checkResult("SELECT a, c, COUNT(d) FROM T GROUP BY GROUPING SETS ((a, c), (a), ())", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, b, c, COUNT(d) FROM T GROUP BY GROUPING SETS ((a, b, c), (a, b, d))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)}))}))));
    }

    @Test
    public void testWithRollup() {
        this.checkResult("SELECT a, b, c, COUNT(d) FROM T GROUP BY ROLLUP (a, b, c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)3)}))}))));
    }

    @Test
    public void testWithCube() {
        this.checkResult("SELECT a, b, c, COUNT(d) FROM T GROUP BY CUBE (a, b, c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "B", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "C", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT b, c, e, SUM(a), MAX(d) FROM MyTable2 GROUP BY CUBE (b, c, e)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, null, BoxesRunTime.boxToInteger((int)5), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)0), null, BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, null, BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0), null, BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "Hallo Welt wie"}))}))));
    }

    @Test
    public void testSingleDistinctAgg() {
        this.checkResult("SELECT a, COUNT(DISTINCT c) FROM T GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1)}))}))));
        this.checkResult("SELECT a, b, COUNT(DISTINCT c) FROM T GROUP BY a, b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)}))}))));
        this.checkResult("SELECT a, b, COUNT(DISTINCT c), COUNT(DISTINCT d) FROM T GROUP BY a, b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}))));
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg() {
        this.checkResult("SELECT a, COUNT(DISTINCT c), SUM(b) FROM T GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, c, COUNT(DISTINCT c), SUM(b) FROM T GROUP BY a, c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "B", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "C", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, COUNT(DISTINCT c), SUM(b) FROM T GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, d, COUNT(DISTINCT c), SUM(b) FROM T GROUP BY a, d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Hello", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Hello world", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
    }

    @Test
    public void testMultiDistinctAggs() {
        this.checkResult("SELECT a, COUNT(DISTINCT b), SUM(DISTINCT b) FROM T GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, d, COUNT(DISTINCT c), SUM(DISTINCT b) FROM T GROUP BY a, d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Hello", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Hello world", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)}))}))));
        this.checkResult("SELECT a, SUM(DISTINCT b), MAX(DISTINCT b), MIN(DISTINCT c) FROM T GROUP BY a", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "A"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "A"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "B"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), "C"}))}))));
        this.checkResult("SELECT a, d, COUNT(DISTINCT c), MAX(DISTINCT b), SUM(b) FROM T GROUP BY a, d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Hello", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "Hello world", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)}))}))));
    }

    @Test
    public void testAggregateRemove() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2.mcII.sp(1, 1));
        data.$plus$eq((Object)new Tuple2.mcII.sp(2, 2));
        data.$plus$eq((Object)new Tuple2.mcII.sp(3, 3));
        data.$plus$eq((Object)new Tuple2.mcII.sp(4, 2));
        data.$plus$eq((Object)new Tuple2.mcII.sp(4, 4));
        data.$plus$eq((Object)new Tuple2.mcII.sp(6, 2));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2)}));
        this.tEnv().registerTable("T1", t);
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |select sum(b) from\n        | (select b from\n        |   (select b, sum(a) from\n        |     (select b, sum(a) as a from T1 group by b) t1\n        |   group by b) t2\n        | ) t3\n      ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10"}));
        Assert.assertEquals((Object)expected, sink.getRetractResults());
    }

    private void checkResult(String str, Seq<Row> rows) {
        super.before();
        DataStream ds1 = this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"A", null), new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"A", (Object)"Hi"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"B", (Object)"Hello"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"C", (Object)"Hello world")})), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, String>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        StreamTableEnvUtil$.MODULE$.createTemporaryViewInternal(this.tEnv(), "T", ds1.javaStream(), (Option<String[]>)new Some((Object)new String[]{"a", "b", "c", "d"}), (Option<boolean[]>)new Some((Object)new boolean[]{true, true, true, true}), (Option<FlinkStatistic>)new Some((Object)FlinkStatistic$.MODULE$.builder().uniqueKeys((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.Set[]{(java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).asJava()}))).asJava()).build()));
        StreamTableEnvUtil$.MODULE$.createTemporaryViewInternal(this.tEnv(), "MyTable", this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).javaStream(), (Option<String[]>)new Some((Object)new String[]{"a", "b", "c"}), (Option<boolean[]>)new Some((Object)new boolean[]{true, true, true}), (Option<FlinkStatistic>)new Some((Object)FlinkStatistic$.MODULE$.builder().uniqueKeys((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.Set[]{(java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).asJava()}))).asJava()).build()));
        StreamTableEnvUtil$.MODULE$.createTemporaryViewInternal(this.tEnv(), "MyTable2", this.env().fromCollection(TestData$.MODULE$.smallTupleData5(), (TypeInformation)new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }).javaStream(), (Option<String[]>)new Some((Object)new String[]{"a", "b", "c", "d", "e"}), (Option<boolean[]>)new Some((Object)new boolean[]{true, true, true, true, true}), (Option<FlinkStatistic>)new Some((Object)FlinkStatistic$.MODULE$.builder().uniqueKeys((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.Set[]{(java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).asJava()}))).asJava()).build()));
        Table t = this.tEnv().sqlQuery(str);
        TestingRetractSink sink = new TestingRetractSink();
        this.env().setMaxParallelism(1);
        this.env().setParallelism(1);
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)rows.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public AggregateRemoveITCase(StreamingWithAggTestBase.AggMode aggMode, StreamingWithMiniBatchTestBase.MiniBatchMode minibatch, StreamingWithStateTestBase.StateBackendMode backend) {
        super(aggMode, minibatch, backend);
    }
}

