/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class RankJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testRank() throws ExecutionException, InterruptedException, IOException {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data1()), "a int", "b varchar", "c int");
        this.createTestNonInsertOnlyValuesSinkTable("`result`", "a int", "b varchar", "c bigint");
        String sql = "insert into `result` select * from (select a, b, row_number() over(partition by b order by c) as c from MyTable) where c = 1";
        this.executeSqlWithJsonPlanVerified(sql).await();
        List<String> expected = Arrays.asList("+I[1, a, 1]", "+I[3, b, 1]", "+I[5, c, 1]");
        this.assertResult(expected, TestValuesTableFactory.getResults("result"));
    }
}

