/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class MatchRecognizeJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testSimpleMatch() throws Exception {
        List<Row> data = Arrays.asList(Row.of((Object[])new Object[]{1L, "a"}), Row.of((Object[])new Object[]{2L, "z"}), Row.of((Object[])new Object[]{3L, "b"}), Row.of((Object[])new Object[]{4L, "c"}), Row.of((Object[])new Object[]{5L, "d"}), Row.of((Object[])new Object[]{6L, "a"}), Row.of((Object[])new Object[]{7L, "b"}), Row.of((Object[])new Object[]{8L, "c"}), Row.of((Object[])new Object[]{9L, "h"}));
        this.createTestValuesSourceTable("MyTable", data, "id bigint", "name varchar", "proctime as PROCTIME()");
        this.createTestValuesSinkTable("MySink", "a bigint", "b bigint", "c bigint");
        String sql = "insert into MySink SELECT T.aid, T.bid, T.cid\n     FROM MyTable MATCH_RECOGNIZE (\n             ORDER BY proctime\n             MEASURES\n             `A\"`.id AS aid,\n             l.id AS bid,\n             C.id AS cid\n             PATTERN (`A\"` l C)\n             DEFINE\n                 `A\"` AS name = 'a',\n                 l AS name = 'b',\n                 C AS name = 'c'\n     ) AS T";
        this.executeSqlWithJsonPlanVerified(sql).await();
        List<String> expected = Collections.singletonList("+I[6, 7, 8]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testComplexMatch() throws Exception {
        List<Row> data = Arrays.asList(Row.of((Object[])new Object[]{"ACME", 1L, 19, 1}), Row.of((Object[])new Object[]{"ACME", 2L, 17, 2}), Row.of((Object[])new Object[]{"ACME", 3L, 13, 3}), Row.of((Object[])new Object[]{"ACME", 4L, 20, 4}));
        this.createTestValuesSourceTable("MyTable", data, "symbol string", "tstamp bigint", "price int", "tax int", "proctime as PROCTIME()");
        this.createTestValuesSinkTable("MySink", "a bigint", "b bigint", "c bigint");
        String sql = "insert into MySink SELECT * FROM MyTable MATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    FIRST(DOWN.price) as first,\n    LAST(DOWN.price) as last,\n    FIRST(DOWN.price, 5) as nullPrice\n  ONE ROW PER MATCH\n  AFTER MATCH SKIP PAST LAST ROW\n  PATTERN (DOWN{2,} UP)\n  DEFINE\n    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n    UP AS price > LAST(DOWN.price)\n) AS T";
        this.executeSqlWithJsonPlanVerified(sql).await();
        List<String> expected = Collections.singletonList("+I[19, 13, null]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

