/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowAggregateHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001E\u0011!dV5oI><\u0018iZ4sK\u001e\fG/\u001a%be:,7o\u001d+fgRT!a\u0001\u0003\u0002\u000f!\f'O\\3tg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011q\u0002S1s]\u0016\u001c8\u000fV3ti\n\u000b7/\u001a\u0005\t/\u0001\u0011\t\u0011)A\u00051\u00059!-Y2lK:$\u0007CA\r0\u001d\tQBF\u0004\u0002\u001cU9\u0011A$\u000b\b\u0003;!r!AH\u0014\u000f\u0005}1cB\u0001\u0011&\u001d\t\tC%D\u0001#\u0015\t\u0019\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYC!A\u0003vi&d7/\u0003\u0002.]\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK*\u00111\u0006B\u0005\u0003aE\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u00055r\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u001bMD\u0017N\u001a;US6,'l\u001c8f!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003uS6,'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aAW8oK&#\u0007\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\bF\u0002@\u0001\u0006\u0003\"a\u0005\u0001\t\u000b]a\u0004\u0019\u0001\r\t\u000bMb\u0004\u0019\u0001\u001b\t\u000f\r\u0003!\u0019!C\u0005\t\u0006YQ\u000bV\"`5>sUiX%E+\u0005!\u0004B\u0002$\u0001A\u0003%A'\u0001\u0007V)\u000e{&l\u0014(F?&#\u0005\u0005C\u0003I\u0001\u0011\u0005\u0013*\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n!QK\\5uQ\t9\u0015\u000b\u0005\u0002S+6\t1K\u0003\u0002U\u001d\u0005)!.\u001e8ji&\u0011ak\u0015\u0002\u0007\u0005\u00164wN]3\t\u000ba\u0003A\u0011A%\u0002=Q,7\u000f\u001e)s_\u000e,7o]5oORKW.\u001a+v[\ndWmV5oI><\bFA,[!\t\u00116,\u0003\u0002]'\n!A+Z:u\u0011\u0015q\u0006\u0001\"\u0001J\u0003m!Xm\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3I_B<\u0016N\u001c3po\"\u0012QL\u0017\u0005\u0006C\u0002!\t!S\u0001!i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8/\u001b8h)&lWmQ;nk2\fG/Z,j]\u0012|w\u000f\u000b\u0002a5\")A\r\u0001C\u0005K\u0006Q\u0011N\\4fgR$\u0015\r^1\u0015\u0005)3\u0007\"B4d\u0001\u0004A\u0017a\u0003;fgRD\u0015M\u001d8fgN\u0004R!\u001b8qaBl\u0011A\u001b\u0006\u0003W2\fA!\u001e;jY*\u0011QNC\u0001\ngR\u0014X-Y7j]\u001eL!a\u001c6\u0003M-+\u00170\u001a3P]\u0016Le\u000e];u'R\u0014X-Y7Pa\u0016\u0014\u0018\r^8s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002ri6\t!O\u0003\u0002t\u0011\u0005!A-\u0019;b\u0013\t)(OA\u0004S_^$\u0015\r^1\t\u000b]\u0004A\u0011\u0002=\u0002\rI,7m\u001c:e)\rI\u0018\u0011\u0001\t\u0004uz\u0004X\"A>\u000b\u0005ql\u0018\u0001D:ue\u0016\fWN]3d_J$'BA\u0003m\u0013\ty8P\u0001\u0007TiJ,\u0017-\u001c*fG>\u0014H\rC\u0004\u0002\u0004Y\u0004\r!!\u0002\u0002\t\u0005\u0014xm\u001d\t\u0006\u0017\u0006\u001d\u00111B\u0005\u0004\u0003\u0013a%A\u0003\u001fsKB,\u0017\r^3e}A\u00191*!\u0004\n\u0007\u0005=AJA\u0002B]fDq!a\u0005\u0001\t\u0013\t)\"\u0001\u0006m_\u000e\fG.T5mYN$B!a\u0006\u0002\u001eA\u0019\u0011/!\u0007\n\u0007\u0005m!OA\u0007US6,7\u000f^1na\u0012\u000bG/\u0019\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u0005AA-\u0019;f)&lW\r\u0005\u0003\u0002$\u0005%bbA&\u0002&%\u0019\u0011q\u0005'\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9\u0003\u0014\u0015\b\u0001\u0005E\u0012QHA !\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c'\u00061!/\u001e8oKJLA!a\u000f\u00026\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$'\u00069!/\u001e8oKJ\u001c\u0018\u0002BA&\u0003\u000b\u0012Q\u0002U1sC6,G/\u001a:ju\u0016$waBA(\u0005!\u0005\u0011\u0011K\u0001\u001b/&tGm\\<BO\u001e\u0014XmZ1uK\"\u000b'O\\3tgR+7\u000f\u001e\t\u0004'\u0005McAB\u0001\u0003\u0011\u0003\t)f\u0005\u0003\u0002T\u0005]\u0003cA&\u0002Z%\u0019\u00111\f'\u0003\r\u0005s\u0017PU3g\u0011\u001di\u00141\u000bC\u0001\u0003?\"\"!!\u0015\t\u0011\u0005\r\u00141\u000bC\u0001\u0003K\n!\u0002]1sC6,G/\u001a:t)\t\t9\u0007\u0005\u0004\u0002j\u00055\u0014\u0011O\u0007\u0003\u0003WR!a\u001b\u001d\n\t\u0005=\u00141\u000e\u0002\u000b\u0007>dG.Z2uS>t\u0007#B&\u0002t\u0005]\u0014bAA;\u0019\n)\u0011I\u001d:bsB!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~a\nA\u0001\\1oO&!\u0011\u0011QA>\u0005\u0019y%M[3di\"B\u0011\u0011MAC\u0003'\u000b)\n\u0005\u0003\u0002\b\u00065e\u0002BA\"\u0003\u0013KA!a#\u0002F\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a$\u0002\u0012\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005-\u0015QI\u0001\u0005]\u0006lW-\t\u0002\u0002\u0018\u0006q2\u000b^1uK\n\u000b7m[3oIvZ\b' \u0017!)&lWMW8oKvZ\u0018' ")
public class WindowAggregateHarnessTest
extends HarnessTestBase {
    private final ZoneId shiftTimeZone;
    private final ZoneId UTC_ZONE_ID;

    @Parameterized.Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowAggregateHarnessTest$.MODULE$.parameters();
    }

    private ZoneId UTC_ZONE_ID() {
        return this.UTC_ZONE_ID;
    }

    @Override
    @Before
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.shiftTimeZone);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE T1 (\n         | `ts` STRING,\n         | `int` INT,\n         | `double` DOUBLE,\n         | `float` FLOAT,\n         | `bigdec` DECIMAL(10, 2),\n         | `string` STRING,\n         | `name` STRING,\n         | proctime AS PROCTIME()\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '", "'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataId})))).stripMargin());
    }

    @Test
    public void testProcessingTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testProcessingTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testProcessingTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  MAX(`double`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(proctime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness = this.createHarnessTester(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowAggregate");
        RowDataHarnessAssertor assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToDouble((double)5.0), BoxesRunTime.boxToLong((long)3L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)6.0), BoxesRunTime.boxToLong((long)2L), this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)4.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)3.0), BoxesRunTime.boxToLong((long)1L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)7.0), BoxesRunTime.boxToLong((long)0L), this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45")})));
        assertor.assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(KeyedOneInputStreamOperatorTestHarness<RowData, RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(2000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(3000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(4000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.setProcessingTime(6000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
        testHarness.setProcessingTime(7000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
        testHarness.setProcessingTime(8000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
        testHarness.setProcessingTime(16000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
        testHarness.setProcessingTime(32000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null})));
        testHarness.setProcessingTime(34000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(50000L);
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x0$1) {
                Object object;
                Object object2 = x0$1;
                if (object2 instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object2);
                    object = BoxesRunTime.boxToLong((long)l);
                } else if (object2 instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object2);
                    object = BoxesRunTime.boxToDouble((double)d);
                } else {
                    object = object2;
                }
                return object;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    private TimestampData localMills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)TimeWindowUtil.toUtcTimestampMills((long)windowDateTime.toInstant().toEpochMilli(), (ZoneId)this.shiftTimeZone));
    }

    public WindowAggregateHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        super(backend);
        this.UTC_ZONE_ID = ZoneId.of("UTC");
    }
}

