/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase$;
import org.apache.flink.table.runtime.operators.join.temporal.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.hamcrest.Description;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001E\u0011\u0011&\u00112tiJ\f7\r\u001e+x_&s\u0007/\u001e;TiJ,\u0017-\\(qKJ\fGo\u001c:XSRDG\u000b\u0016'UKN$(BA\u0002\u0005\u0003\u001dA\u0017M\u001d8fgNT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!a\u0004%be:,7o\u001d+fgR\u0014\u0015m]3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\n\u0001\u0011%Y\u0002\u00011AA\u0002\u0013%A$\u0001\nsK\u000e|'\u000fZ!G_J4\u0015N]:u\u0017\u0016LX#A\u000f\u0011\u0007y!c%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tiJ,\u0017-\u001c:fG>\u0014HM\u0003\u0002\u0006E)\u00111EC\u0001\ngR\u0014X-Y7j]\u001eL!!J\u0010\u0003\u0019M#(/Z1n%\u0016\u001cwN\u001d3\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%B\u0011\u0001\u00023bi\u0006L!a\u000b\u0015\u0003\u000fI{w\u000fR1uC\"IQ\u0006\u0001a\u0001\u0002\u0004%IAL\u0001\u0017e\u0016\u001cwN\u001d3B\r>\u0014h)\u001b:ti.+\u0017p\u0018\u0013fcR\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005+:LG\u000fC\u00047Y\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013\u0007\u0003\u00049\u0001\u0001\u0006K!H\u0001\u0014e\u0016\u001cwN\u001d3B\r>\u0014h)\u001b:ti.+\u0017\u0010\t\u0015\u0003oi\u0002\"\u0001M\u001e\n\u0005q\n$!\u0003;sC:\u001c\u0018.\u001a8u\u0011%q\u0004\u00011AA\u0002\u0013%A$\u0001\nsK\u000e|'\u000f\u001a\"G_J4\u0015N]:u\u0017\u0016L\b\"\u0003!\u0001\u0001\u0004\u0005\r\u0011\"\u0003B\u0003Y\u0011XmY8sI\n3uN\u001d$jeN$8*Z=`I\u0015\fHCA\u0018C\u0011\u001d1t(!AA\u0002uAa\u0001\u0012\u0001!B\u0013i\u0012a\u0005:fG>\u0014HM\u0011$pe\u001aK'o\u001d;LKf\u0004\u0003FA\";\u0011\u001d9\u0005A1A\u0005\n!\u000b\u0001#\\5o%\u0016$XM\u001c;j_:$\u0016.\\3\u0016\u0003%\u0003\"AS)\u000e\u0003-S!\u0001T'\u0002\tQLW.\u001a\u0006\u0003\u001d>\u000baaY8n[>t'B\u0001)\u000b\u0003\r\t\u0007/[\u0005\u0003%.\u0013A\u0001V5nK\"1A\u000b\u0001Q\u0001\n%\u000b\u0011#\\5o%\u0016$XM\u001c;j_:$\u0016.\\3!\u0011\u001d1\u0006A1A\u0005\n!\u000b\u0001#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3\t\ra\u0003\u0001\u0015!\u0003J\u0003Ei\u0017\r\u001f*fi\u0016tG/[8o)&lW\r\t\u0005\n5\u0002\u0001\r\u00111A\u0005\nm\u000b\u0011c\u001c9fe\u0006$xN]+oI\u0016\u0014H+Z:u+\u0005a\u0006CA/_\u001b\u0005\u0001a\u0001B0\u0001\u0001\u0001\u0014\u0001d\u0015;vE>\u0003XM]1u_J<\u0016\u000e\u001e5Ti\u0006$X\r\u0016+M'\tq\u0016\r\u0005\u0002cU6\t1M\u0003\u0002eK\u0006AA/Z7q_J\fGN\u0003\u0002gO\u0006!!n\\5o\u0015\tA\u0017.A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011Q\u0001C\u0005\u0003W\u000e\u0014AFQ1tKR;x.\u00138qkR\u001cFO]3b[>\u0003XM]1u_J<\u0016\u000e\u001e5Ti\u0006$XMU3uK:$\u0018n\u001c8\t\u0011\u001ds&\u0011!Q\u0001\n%C\u0001B\u00160\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006/y#\ta\u001c\u000b\u00049B\f\b\"B$o\u0001\u0004I\u0005\"\u0002,o\u0001\u0004I\u0005bB:_\u0005\u0004%\t\u0001^\u0001\u0013M&\u0014X\rZ\"mK\u0006tW\u000b\u001d+j[\u0016\u00148/F\u0001v!\r180`\u0007\u0002o*\u0011\u00010_\u0001\b[V$\u0018M\u00197f\u0015\tQ\u0018'\u0001\u0006d_2dWm\u0019;j_:L!\u0001`<\u0003\r\t+hMZ3s!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0011auN\\4\t\u000f\u00055a\f)A\u0005k\u0006\u0019b-\u001b:fI\u000ecW-\u00198VaRKW.\u001a:tA!9\u0011\u0011\u00030\u0005B\u0005M\u0011\u0001D2mK\u0006tW\u000f]*uCR,GcA\u0018\u0002\u0016!9A*a\u0004A\u0002\u0005]\u0001c\u0001\u0019\u0002\u001a%\u0019\u0011\u0011B\u0019\t\u000f\u0005ua\f\"\u0011\u0002 \u0005y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007F\u00020\u0003CAq!a\t\u0002\u001c\u0001\u0007Q$A\u0004fY\u0016lWM\u001c;\t\u000f\u0005\u001db\f\"\u0011\u0002*\u0005y\u0001O]8dKN\u001cX\t\\3nK:$(\u0007F\u00020\u0003WAq!a\t\u0002&\u0001\u0007Q\u0004C\u0004\u00020y#\t%!\r\u0002\u0017=tWI^3oiRKW.\u001a\u000b\u0004_\u0005M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u000bQLW.\u001a:\u0011\u0011\u0005e\u0012qHA\"\u0003\u0013j!!a\u000f\u000b\u0007!\fiD\u0003\u0002QE%!\u0011\u0011IA\u001e\u00055Ie\u000e^3s]\u0006dG+[7feB\u0019a0!\u0012\n\u0007\u0005\u001dsP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u0017\n\u0019&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0015\u0019H/\u0019;f\u0015\t)!\"\u0003\u0003\u0002V\u00055#!\u0004,pS\u0012t\u0015-\\3ta\u0006\u001cW\rC\u0006\u0002Z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0013!F8qKJ\fGo\u001c:V]\u0012,'\u000fV3ti~#S-\u001d\u000b\u0004_\u0005u\u0003\u0002\u0003\u001c\u0002X\u0005\u0005\t\u0019\u0001/\t\u000f\u0005\u0005\u0004\u0001)Q\u00059\u0006\u0011r\u000e]3sCR|'/\u00168eKJ$Vm\u001d;!\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%I!a\u001a\u0002\u0017Q,7\u000f\u001e%be:,7o]\u000b\u0003\u0003S\u0002\u0002\"a\u001b\u0002ru4cEJ\u0007\u0003\u0003[R1!a\u001c#\u0003\u0011)H/\u001b7\n\t\u0005M\u0014Q\u000e\u0002'\u0017\u0016LX\r\u001a+x_&s\u0007/\u001e;TiJ,\u0017-\\(qKJ\fGo\u001c:UKN$\b*\u0019:oKN\u001c\bbCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003s\nq\u0002^3ti\"\u000b'O\\3tg~#S-\u001d\u000b\u0004_\u0005m\u0004\"\u0003\u001c\u0002v\u0005\u0005\t\u0019AA5\u0011!\ty\b\u0001Q!\n\u0005%\u0014\u0001\u0004;fgRD\u0015M\u001d8fgN\u0004\u0003bBAB\u0001\u0011\u0005\u0011QQ\u0001\u0012GJ,\u0017\r^3UKN$\b*\u0019:oKN\u001cH#A\u0018)\t\u0005\u0005\u0015\u0011\u0012\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\b\u0002\u000b),h.\u001b;\n\t\u0005M\u0015Q\u0012\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0006\u0006\u00012\r\\8tKR+7\u000f\u001e%be:,7o\u001d\u0015\u0005\u0003+\u000bY\n\u0005\u0003\u0002\f\u0006u\u0015\u0002BAP\u0003\u001b\u0013Q!\u00114uKJDq!a)\u0001\t\u0003\t))A\no_Jl\u0017\r\\*dK:\f'/[8X_J\\7\u000f\u000b\u0003\u0002\"\u0006\u001d\u0006\u0003BAF\u0003SKA!a+\u0002\u000e\n!A+Z:u\u0011\u001d\ty\u000b\u0001C\u0001\u0003\u000b\u000b\u0001k\u001e5f]\u000e+(O]3oiRKW.\u001a)mkNl\u0015N\u001c*fi\u0016tG/[8o'6\fG\u000e\\3s)\"\fgnQ;se\u0016tGo\u00117fC:,\b\u000fV5nK:{g*Z<US6,'OU3hSN$XM]3eQ\u0011\ti+a*\t\u000f\u0005U\u0006\u0001\"\u0001\u0002\u0006\u0006Iu\u000f[3o\u0007V\u0014(/\u001a8u)&lW\r\u00157vg6KgNU3uK:$\u0018n\u001c8MCJ<WM\u001d+iC:\u001cUO\u001d:f]R\u001cE.Z1okB$\u0016.\\3US6,'/S:Va\u0012\fG/\u001a3)\t\u0005M\u0016q\u0015\u0005\b\u0003w\u0003A\u0011AAC\u00039zG\u000f[3s'&$W\rV8TC6,7*Z=Ti\u0006$X-\u00117t_V\u0003H-\u0019;fg\u000ecW-\u00198vaRKW.\u001a:)\t\u0005e\u0016q\u0015\u0005\b\u0003\u0007\u0003A\u0011BAa)\u0011\tI'a1\t\u000f\u0005\u0015\u0017q\u0018a\u0001C\u0006Aq\u000e]3sCR|'\u000fC\u0004\u0002J\u0002!I!a3\u0002E!\f7OR5sK\u0012\u001cE.Z1o+B$\u0016.\\3sg\u001a{'\u000fV5nKN$\u0018-\u001c9t)\u0011\ti-!7\u0011\u000b\u0005=\u0017Q\u001b/\u000e\u0005\u0005E'bAAj\u001d\u0005A\u0001.Y7de\u0016\u001cH/\u0003\u0003\u0002X\u0006E'a\u0004+za\u0016\u001c\u0016MZ3NCR\u001c\u0007.\u001a:\t\u0011\u0005m\u0017q\u0019a\u0001\u0003;\fa\u0001^5nKJ\u001c\b\u0003\u0002\u0019\u0002`vL1!!92\u0005)a$/\u001a9fCR,GM\u0010")
public class AbstractTwoInputStreamOperatorWithTTLTest
extends HarnessTestBase {
    private transient StreamRecord<RowData> recordAForFirstKey;
    private transient StreamRecord<RowData> recordBForFirstKey;
    private final Time minRetentionTime = Time.milliseconds((long)2L);
    private final Time maxRetentionTime = Time.milliseconds((long)4L);
    private StubOperatorWithStateTTL operatorUnderTest;
    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> testHarness;

    private StreamRecord<RowData> recordAForFirstKey() {
        return this.recordAForFirstKey;
    }

    private void recordAForFirstKey_$eq(StreamRecord<RowData> x$1) {
        this.recordAForFirstKey = x$1;
    }

    private StreamRecord<RowData> recordBForFirstKey() {
        return this.recordBForFirstKey;
    }

    private void recordBForFirstKey_$eq(StreamRecord<RowData> x$1) {
        this.recordBForFirstKey = x$1;
    }

    private Time minRetentionTime() {
        return this.minRetentionTime;
    }

    private Time maxRetentionTime() {
        return this.maxRetentionTime;
    }

    private StubOperatorWithStateTTL operatorUnderTest() {
        return this.operatorUnderTest;
    }

    private void operatorUnderTest_$eq(StubOperatorWithStateTTL x$1) {
        this.operatorUnderTest = x$1;
    }

    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> testHarness() {
        return this.testHarness;
    }

    private void testHarness_$eq(KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> x$1) {
        this.testHarness = x$1;
    }

    @Before
    public void createTestHarness() {
        this.operatorUnderTest_$eq(new StubOperatorWithStateTTL(this.minRetentionTime(), this.maxRetentionTime()));
        this.testHarness_$eq(this.createTestHarness(this.operatorUnderTest()));
        this.testHarness().open();
        this.recordAForFirstKey_$eq((StreamRecord<RowData>)StreamRecordUtils.insertRecord((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "hello"}));
        this.recordBForFirstKey_$eq((StreamRecord<RowData>)StreamRecordUtils.insertRecord((Object[])new Object[]{Predef$.MODULE$.long2Long(1L), "world"}));
    }

    @After
    public void closeTestHarness() {
        this.testHarness().close();
    }

    @Test
    public void normalScenarioWorks() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(10L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(5L)})));
    }

    @Test
    public void whenCurrentTimePlusMinRetentionSmallerThanCurrentCleanupTimeNoNewTimerRegistered() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(2L);
        this.testHarness().processElement1(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(5L)})));
    }

    @Test
    public void whenCurrentTimePlusMinRetentionLargerThanCurrentCleanupTimeTimerIsUpdated() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(4L);
        this.testHarness().processElement1(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(8L)})));
    }

    @Test
    public void otherSideToSameKeyStateAlsoUpdatesCleanupTimer() {
        this.testHarness().setProcessingTime(1L);
        this.testHarness().processElement1(this.recordAForFirstKey());
        this.testHarness().setProcessingTime(4L);
        this.testHarness().processElement2(this.recordBForFirstKey());
        this.testHarness().setProcessingTime(20L);
        MatcherAssert.assertThat((Object)((Object)this.operatorUnderTest()), this.hasFiredCleanUpTimersForTimestamps((Seq<Long>)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(8L)})));
    }

    private KeyedTwoInputStreamOperatorTestHarness<Long, RowData, RowData, RowData> createTestHarness(BaseTwoInputStreamOperatorWithStateRetention operator) {
        return new KeyedTwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator, (KeySelector)new HarnessTestBase.TestingRowDataKeySelector(0), (KeySelector)new HarnessTestBase.TestingRowDataKeySelector(0), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, 1, 1, 0);
    }

    private TypeSafeMatcher<StubOperatorWithStateTTL> hasFiredCleanUpTimersForTimestamps(Seq<Long> timers) {
        return new TypeSafeMatcher<StubOperatorWithStateTTL>(this, timers){
            private final Seq timers$1;

            public boolean matchesSafely(StubOperatorWithStateTTL operator) {
                IndexedSeq indexedSeq = Predef$.MODULE$.refArrayOps((Object[])operator.firedCleanUpTimers().toArray(ClassTag$.MODULE$.apply(Long.class))).deep();
                IndexedSeq indexedSeq2 = Predef$.MODULE$.refArrayOps((Object[])this.timers$1.toArray(ClassTag$.MODULE$.apply(Long.class))).deep();
                return !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
            }

            public void describeTo(Description description) {
                description.appendText("a list of timers with timestamps=").appendValue((Object)this.timers$1.mkString(","));
            }
            {
                this.timers$1 = timers$1;
            }
        };
    }

    public AbstractTwoInputStreamOperatorWithTTLTest() {
        super(StreamingWithStateTestBase$.MODULE$.HEAP_BACKEND());
    }

    public class StubOperatorWithStateTTL
    extends BaseTwoInputStreamOperatorWithStateRetention {
        private final Buffer<Long> firedCleanUpTimers;

        public Buffer<Long> firedCleanUpTimers() {
            return this.firedCleanUpTimers;
        }

        public void cleanupState(long time) {
            this.firedCleanUpTimers().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Long[]{Predef$.MODULE$.long2Long(time)}));
        }

        public void processElement1(StreamRecord<RowData> element) {
            this.registerProcessingCleanupTimer();
        }

        public void processElement2(StreamRecord<RowData> element) {
            this.registerProcessingCleanupTimer();
        }

        public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        }

        public /* synthetic */ AbstractTwoInputStreamOperatorWithTTLTest org$apache$flink$table$planner$runtime$harness$AbstractTwoInputStreamOperatorWithTTLTest$StubOperatorWithStateTTL$$$outer() {
            return AbstractTwoInputStreamOperatorWithTTLTest.this;
        }

        public StubOperatorWithStateTTL(Time minRetentionTime, Time maxRetentionTime) {
            if (AbstractTwoInputStreamOperatorWithTTLTest.this == null) {
                throw null;
            }
            super(minRetentionTime.toMilliseconds(), maxRetentionTime.toMilliseconds());
            this.firedCleanUpTimers = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
    }
}

