/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.runtime.batch.sql.join.GenericTypeInfoWithoutComparator;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.sinks.CollectRowTableSink;
import org.apache.flink.table.planner.utils.TestingStatementSet;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u0001\u0003\u0001U\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!\u0001\u0003k_&t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQAY1uG\"T!!\u0003\u0006\u0002\u000fI,h\u000e^5nK*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\tfqB,7\r^3e\u0015>Lg\u000eV=qKB\u0011qd\u000e\b\u0003AUr!!\t\u001b\u000f\u0005\t\u001adBA\u00123\u001d\t!\u0013G\u0004\u0002&a9\u0011ae\f\b\u0003O9r!\u0001K\u0017\u000f\u0005%bS\"\u0001\u0016\u000b\u0005-\"\u0012A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t\t\"#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u00027\u0005\u0005A!j\\5o)f\u0004X-\u0003\u00029s\tA!j\\5o)f\u0004XM\u0003\u00027\u0005!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"\"!P \u0011\u0005y\u0002Q\"\u0001\u0002\t\u000buQ\u0004\u0019\u0001\u0010\t\u000b\u0005\u0003A\u0011\t\"\u0002\r\t,gm\u001c:f)\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRD#\u0001\u0011&\u0011\u0005-sU\"\u0001'\u000b\u00055\u0013\u0012!\u00026v]&$\u0018BA(M\u0005\u0019\u0011UMZ8sK\")\u0011\u000b\u0001C\u0001\u0005\u0006AA/Z:u\u0015>Lg\u000e\u000b\u0002Q'B\u00111\nV\u0005\u0003+2\u0013A\u0001V3ti\")q\u000b\u0001C\u0001\u0005\u0006AB/Z:u\u0019>twMS8j]^KG\u000f\u001b\"jOJ\u000bgnZ3)\u0005Y\u001b\u0006\"\u0002.\u0001\t\u0003\u0011\u0015!\u0007;fgRduN\\4ICND'j\\5o\u000f\u0016tWM]1u_JD#!W*\t\u000bu\u0003A\u0011\u0001\"\u00021Q,7\u000f^(oKNKG-Z*nU\u001aKW\r\u001c3FeJ|'\u000f\u000b\u0002]'\")\u0001\r\u0001C\u0001\u0005\u00061B/Z:u\u0015>LgnU1nK\u001aKW\r\u001c3FcV\fG\u000e\u000b\u0002`'\")1\r\u0001C\u0001\u0005\u0006QA/Z:u\u0015>Lgn\u00148)\u0005\t\u001c\u0006\"\u00024\u0001\t\u0003\u0011\u0015!\u0005;fgRTu.\u001b8O_6\u000bGo\u00195fg\"\u0012Qm\u0015\u0005\u0006S\u0002!\tAQ\u0001\u001ei\u0016\u001cHOS8j]:{W*\u0019;dQ\u0016\u001cx+\u001b;i'V\u0014\u0017/^3ss\"\u0012\u0001n\u0015\u0005\u0006Y\u0002!\tAQ\u0001\u0013i\u0016\u001cHOS8j]^KG\u000f\u001b$jYR,'\u000f\u000b\u0002l'\")q\u000e\u0001C\u0001\u0005\u00061B/Z:u\u0015>LgnV5uQ*{\u0017N\u001c$jYR,'\u000f\u000b\u0002o'\")!\u000f\u0001C\u0001\u0005\u0006)C/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5K_&t\u0007K]3eS\u000e\fG/\u001a\u0015\u0003cNCQ!\u001e\u0001\u0005\u0002\t\u000b\u0001\u0004^3ti*{\u0017N\\,ji\"lU\u000f\u001c;ja2,7*Z=tQ\t!8\u000bC\u0003y\u0001\u0011\u0005!)A\tuKN$(j\\5o/&$\b.\u00117jCND#a^*\t\u000bm\u0004A\u0011\u0001\"\u00029Q,7\u000f\u001e'fMRTu.\u001b8XSRDW*\u001e7uSBdWmS3zg\"\u0012!p\u0015\u0005\u0006}\u0002!\tAQ\u0001 i\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"tuN\\#rk&Tu.\u001b8Qe\u0016$\u0007FA?T\u0011\u0019\t\u0019\u0001\u0001C\u0001\u0005\u0006iB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b'fMRdunY1m!J,G\rK\u0002\u0002\u0002MCa!!\u0003\u0001\t\u0003\u0011\u0015!\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ6+H\u000e^5qY\u0016\\U-_:)\u0007\u0005\u001d1\u000b\u0003\u0004\u0002\u0010\u0001!\tAQ\u0001!i\u0016\u001cHOU5hQRTu.\u001b8XSRDgj\u001c8FcVL'j\\5o!J,G\rK\u0002\u0002\u000eMCa!!\u0006\u0001\t\u0003\u0011\u0015A\b;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ2+g\r\u001e'pG\u0006d\u0007K]3eQ\r\t\u0019b\u0015\u0005\u0007\u00037\u0001A\u0011\u0001\"\u0002CQ,7\u000f\u001e$vY2|U\u000f^3s\u0015>LgnV5uQ6+H\u000e^5qY\u0016\\U-_:)\u0007\u0005e1\u000b\u0003\u0004\u0002\"\u0001!\tAQ\u0001 i\u0016\u001cHOR;mY*{\u0017N\\,ji\"tuN\\#rk&Tu.\u001b8Qe\u0016$\u0007fAA\u0010'\"1\u0011q\u0005\u0001\u0005\u0002\t\u000bQ\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5MK\u001a$Hj\\2bYB\u0013X\r\u001a\u0015\u0004\u0003K\u0019\u0006BBA\u0017\u0001\u0011\u0005!)A\tuKN$h)\u001e7m\u001fV$XM\u001d&pS:D3!a\u000bT\u0011\u0019\t\u0019\u0004\u0001C\u0001\u0005\u0006\tC/Z:u\rVdGnT;uKJTu.\u001b8XSRDw.\u001e;FcV\fGnQ8oI\"\u001a\u0011\u0011G*\t\r\u0005e\u0002\u0001\"\u0001C\u0003)\"Xm\u001d;TS:<G.\u001a*po\u001a+H\u000e\\(vi\u0016\u0014(j\\5o/&$\bn\\;u\u000bF,\u0018\r\\\"p]\u0012D3!a\u000eT\u0011\u0019\ty\u0004\u0001C\u0001\u0005\u0006\tD/Z:u'&tw\r\\3S_^4U\u000f\u001c7PkR,'OS8j]^KG\u000f[8vi\u0016\u000bX/\u00197D_:$gj\\'bi\u000eD\u0007fAA\u001f'\"1\u0011Q\t\u0001\u0005\u0002\t\u000b\u0011\u0003^3ti2+g\r^(vi\u0016\u0014(j\\5oQ\r\t\u0019e\u0015\u0005\u0007\u0003\u0017\u0002A\u0011\u0001\"\u0002%Q,7\u000f\u001e*jO\"$x*\u001e;fe*{\u0017N\u001c\u0015\u0004\u0003\u0013\u001a\u0006BBA)\u0001\u0011\u0005!)A\fuKN$(j\\5o/&$\b.Q4he\u0016<\u0017\r^5p]\"\u001a\u0011qJ*\t\r\u0005]\u0003\u0001\"\u0001C\u0003u!Xm\u001d;K_&t7i\u001c8eSRLwN\u001c(fK\u0012\u001c\u0016.\u001c9mS\u001aL\bfAA+'\"1\u0011Q\f\u0001\u0005\u0002\t\u000b!\b^3ti*{\u0017N\\\"p]\u0012LG/[8o\t\u0016\u0014\u0018N^3e\rJ|WnQ8se\u0016d\u0017\r^3e'V\u0014\u0017+^3ss:+W\rZ*j[Bd\u0017NZ=)\u0007\u0005m3\u000b\u0003\u0004\u0002d\u0001!\tAQ\u0001\u000bi\u0016\u001cHoU5na2,\u0007fAA1'\"1\u0011\u0011\u000e\u0001\u0005\u0002\t\u000b!\u0002^3tiN+G.Z2uQ\r\t9g\u0015\u0005\u0007\u0003_\u0002A\u0011\u0001\"\u0002\u001dQ,7\u000f^\"peJ,G.\u0019;fI\"\u001a\u0011QN*\t\r\u0005U\u0004\u0001\"\u0001C\u0003M!Xm\u001d;D_J\u0014X\r\\1uK\u0012,\u00050[:uQ\r\t\u0019h\u0015\u0005\u0007\u0003w\u0002A\u0011\u0001\"\u0002)Q,7\u000f^\"peJ,G.\u0019;fI\u0016C\u0018n\u001d;3Q\r\tIh\u0015\u0005\u0007\u0003\u0003\u0003A\u0011\u0001\"\u0002-Q,7\u000f^\"peJ,G.\u0019;fI:{G/\u0012=jgRD3!a T\u0011\u0019\t9\t\u0001C\u0001\u0005\u00061B/Z:u+:\u001cwN\u001d:fY\u0006$X\rZ*dC2\f'\u000fK\u0002\u0002\u0006NCa!!$\u0001\t\u0003\u0011\u0015A\u0006;fgR,\u0015/^1m/&$\b.Q4h'\u000e\fG.\u0019:)\u0007\u0005-5\u000b\u0003\u0004\u0002\u0014\u0002!\tAQ\u0001\u0016i\u0016\u001cHoQ8na\u0006\u0014\u0018n]8ogN\u001b\u0017\r\\1sQ\r\t\tj\u0015\u0005\u0007\u00033\u0003A\u0011\u0001\"\u0002!Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Ok2d\u0007fAAL'\"1\u0011q\u0014\u0001\u0005\u0002\t\u000b\u0011\u0003^3tiNKgn\u001a7f%><(j\\5oQ\r\tij\u0015\u0005\u0007\u0003K\u0003A\u0011\u0001\"\u0002?Q,7\u000f\u001e(p]\u0016k\u0007\u000f^=UC\ndWMS8j]\u0016k\u0007\u000f^=UC\ndW\rK\u0002\u0002$NCa!a+\u0001\t\u0003\u0011\u0015\u0001\b;fgR,U\u000e\u001d;z)\u0006\u0014G.\u001a&pS:,U\u000e\u001d;z)\u0006\u0014G.\u001a\u0015\u0004\u0003S\u001b\u0006BBAY\u0001\u0011\u0005!)A\tuKN$(j\\5o\u0007>dG.\u0019;j_:D3!a,T\u0011\u0019\t9\f\u0001C\u0001\u0005\u0006)B/Z:u\u0015>LgnV5uQV#eIR5mi\u0016\u0014\bfAA['\":\u0001!!0\u0002J\u0006-\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rG*\u0001\u0004sk:tWM]\u0005\u0005\u0003\u000f\f\tMA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u00055\u0007\u0003BAh\u0003+l!!!5\u000b\u0007\u0005MG*A\u0004sk:tWM]:\n\t\u0005]\u0017\u0011\u001b\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005m'\u0001#\u0001\u0002^\u0006Q!j\\5o\u0013R\u001b\u0015m]3\u0011\u0007y\nyN\u0002\u0004\u0002\u0005!\u0005\u0011\u0011]\n\u0005\u0003?\f\u0019\u000fE\u0002E\u0003KL1!a:F\u0005\u0019\te.\u001f*fM\"91(a8\u0005\u0002\u0005-HCAAo\u0011!\ty/a8\u0005\u0002\u0005E\u0018A\u00039be\u0006lW\r^3sgR\u0011\u00111\u001f\t\u0007\u0003k\fyPa\u0001\u000e\u0005\u0005](\u0002BA}\u0003w\fA!\u001e;jY*\u0011\u0011Q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0002\u0005](AC\"pY2,7\r^5p]B\u0019AI!\u0002\n\u0007\t\u001dQIA\u0002B]fD\u0003\"!<\u0003\f\te!1\u0004\t\u0005\u0005\u001b\u0011\u0019B\u0004\u0003\u0002P\n=\u0011\u0002\u0002B\t\u0003#\fQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002\u0002B\u000b\u0005/\u0011!\u0002U1sC6,G/\u001a:t\u0015\u0011\u0011\t\"!5\u0002\t9\fW.Z\u0011\u0003\u0005;\t1a\u001f\u0019~\u0001")
public class JoinITCase
extends BatchTestBase {
    private final Enumeration.Value expectedJoinType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return JoinITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("SmallTable3", TestData$.MODULE$.smallData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        this.registerCollection("Table5", TestData$.MODULE$.data5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
        this.registerCollection("NullTable3", TestData$.MODULE$.nullData3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfNullData3());
        this.registerCollection("NullTable5", TestData$.MODULE$.nullData5(), TestData$.MODULE$.type5(), "d, e, f, g, h", TestData$.MODULE$.nullablesOfNullData5());
        this.registerCollection("l", (Iterable<Row>)TestData$.MODULE$.data2_1(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "a, b");
        this.registerCollection("r", (Iterable<Row>)TestData$.MODULE$.data2_2(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        this.registerCollection("t", TestData$.MODULE$.data2_3(), TestData$.MODULE$.INT_DOUBLE(), "c, d", TestData$.MODULE$.nullablesOfData2_3());
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType);
    }

    @Test
    public void testJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLongJoinWithBigRange() {
        this.registerCollection("inputT1", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO}), "a, b");
        this.registerCollection("inputT2", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO}), "c, d");
        this.checkResult("SELECT a, b, c, d FROM inputT1, inputT2 WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLongHashJoinGenerator() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.HashJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            TableSink sink = new CollectRowTableSink().configure((String[])((Object[])new String[]{"c"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING}));
            ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("outputTable", sink);
            StatementSet stmtSet = this.tEnv().createStatementSet();
            Table table = this.tEnv().sqlQuery("SELECT c FROM SmallTable3, Table5 WHERE b = e");
            stmtSet.addInsert("outputTable", table);
            TestingTableEnvironment testingTEnv = (TestingTableEnvironment)this.tEnv();
            TestingStatementSet testingStmtSet = (TestingStatementSet)stmtSet;
            List transforms = ((PlannerBase)testingTEnv.getPlanner()).translate(testingStmtSet.getOperations());
            BooleanRef haveTwoOp = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(transforms).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JoinITCase $outer;

                public final TwoInputTransformation<?, ?, ?> apply(Transformation<?> t) {
                    return this.$outer.org$apache$flink$table$planner$runtime$batch$sql$join$JoinITCase$$findTwoInputTransform$1(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, haveTwoOp){
                public static final long serialVersionUID = 0L;
                private final BooleanRef haveTwoOp$1;

                public final void apply(TwoInputTransformation<?, ?, ?> transform) {
                    StreamOperatorFactory streamOperatorFactory = transform.getOperatorFactory();
                    if (streamOperatorFactory instanceof CodeGenOperatorFactory) {
                        BoxedUnit boxedUnit;
                        CodeGenOperatorFactory codeGenOperatorFactory = (CodeGenOperatorFactory)streamOperatorFactory;
                        if (codeGenOperatorFactory.getGeneratedClass().getCode().contains("LongHashJoinOperator")) {
                            this.haveTwoOp$1.elem = true;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    this.haveTwoOp$1 = haveTwoOp$1;
                }
            });
            Assert.assertTrue((boolean)haveTwoOp.elem);
        }
    }

    @Test
    public void testOneSideSmjFieldError() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.registerCollection("PojoSmallTable3", TestData$.MODULE$.smallData3(), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, new GenericTypeInfoWithoutComparator<String>(String.class)}), "a, b, c", TestData$.MODULE$.nullablesOfSmallData3());
            this.registerCollection("PojoTable5", TestData$.MODULE$.data5(), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, new GenericTypeInfoWithoutComparator<String>(String.class), BasicTypeInfo.LONG_TYPE_INFO}), "d, e, f, g, h", TestData$.MODULE$.nullablesOfData5());
            this.checkResult("SELECT c, g FROM (SELECT h, g, f, e, d FROM PojoSmallTable3, PojoTable5 WHERE b = e), PojoSmallTable3 WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testJoinSameFieldEqual() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinOn() {
        this.checkResult("SELECT c, g FROM SmallTable3 JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinNoMatches() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 where c = g", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJoinNoMatchesWithSubquery() {
        this.checkResult("SELECT c, g FROM (SELECT * FROM SmallTable3 WHERE b>2), (SELECT * FROM Table5 WHERE e>2) WHERE b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithFilter() {
        this.checkResult("SELECT c, g FROM SmallTable3, Table5 WHERE b = e AND b < 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithJoinFilter() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        this.checkResult("SELECT c, g FROM Table3, Table5 WHERE b = e AND a < 6 AND h < b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "Hallo Welt wie"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE a = d AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithAlias() {
        this.registerCollection("AliasTable5", (Iterable<Row>)TestData$.MODULE$.data5(), (TypeInformation<Row>)TestData$.MODULE$.type5(), "d, e, f, g, c");
        this.checkResult("SELECT AliasTable5.c, T.`1-_./\u00dc` FROM (SELECT a, b, c AS `1-_./\u00dc` FROM Table3) AS T, AliasTable5 WHERE a = d AND a < 4", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable3 LEFT JOIN NullTable5 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithMultipleKeys() {
        this.checkResult("SELECT c, g FROM NullTable3 RIGHT JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithNonEquiJoinPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightJoinWithLeftLocalPred() {
        this.checkResult("SELECT c, g FROM NullTable5 RIGHT JOIN NullTable3 ON a = d and b = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testFullOuterJoinWithMultipleKeys() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullJoinWithNonEquiJoinPred() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b <= h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullJoinWithLeftLocalPred() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM NullTable3 FULL JOIN NullTable5 ON a = d and b >= 2 and h = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world, how are you?", "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#1", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#2", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#3", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#5", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#6", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#7", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#8", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#10", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#11", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#12", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#13", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#14", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "NullTuple"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullOuterJoin() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.BroadcastHashJoin();
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = this.expectedJoinType;
            Enumeration.Value value4 = JoinType$.MODULE$.NestedLoopJoin();
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                this.checkResult("SELECT c, g FROM SmallTable3 FULL OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
            }
        }
    }

    @Test
    public void testFullOuterJoinWithoutEqualCond() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT t1.c, t2.c FROM SmallTable3 t1 FULL OUTER JOIN SmallTable3 t2 ON t1.b > t2.b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowFullOuterJoinWithoutEqualCond() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT min(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowFullOuterJoinWithoutEqualCondNoMatch() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, mc FROM SmallTable3 t1 FULL OUTER JOIN (SELECT max(b) AS mb, max(c) AS mc FROM SmallTable3) t2 ON b > mb", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hi"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testLeftOuterJoin() {
        this.checkResult("SELECT c, g FROM Table5 LEFT OUTER JOIN SmallTable3 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRightOuterJoin() {
        this.checkResult("SELECT c, g FROM SmallTable3 RIGHT OUTER JOIN Table5 ON b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "Hallo Welt wie"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "BCD"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "CDE"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "DEF"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "EFG"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "FGH"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "GHI"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "JKL"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "KLM"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithAggregation() {
        this.checkResult("SELECT COUNT(g), COUNT(b) FROM SmallTable3, Table5 WHERE a = d", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)6L), BoxesRunTime.boxToLong((long)6L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinConditionNeedSimplify() {
        this.checkResult("SELECT A.d FROM Table5 A JOIN SmallTable3 B ON (A.d=B.a and B.a>2) or (A.d=B.a and B.b=1)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinConditionDerivedFromCorrelatedSubQueryNeedSimplify() {
        this.checkResult("SELECT B.a FROM SmallTable3 B WHERE b = (select count(*) from Table5 A where (A.d=B.a and A.d<3) or (A.d=B.a and B.b=5))", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSimple() {
        this.checkResult("select a, b from l where a in (select c from r where c > 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testSelect() {
        this.checkResult("select t.a from (select 1 as a)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCorrelated() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("select t.a from (select l.a from l, r where l.a = r.c and l.a = 6)t", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testCorrelatedExist() {
        this.checkResult("select * from l where exists (select * from r where l.a = r.c)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}))}))), this.checkResult$default$3());
        this.checkResult("select * from l where exists (select * from r where l.a = r.c) and l.a <= 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testCorrelatedExist2() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-123456L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-2147483647L)}))}));
        this.registerCollection("t1", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO}), "f1");
        this.checkResult("select * from t1 o where exists (select 1 from t1 i where i.f1=o.f1 limit 0)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testCorrelatedNotExist() {
        this.checkResult("select * from l where not exists (select * from r where l.a = r.c and l.b <> r.d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUncorrelatedScalar() {
        this.checkResult("select (select 1) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as b)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
        this.checkResult("select (select 1 as a) as b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testEqualWithAggScalar() {
        this.checkResult("select a, b from l where a = (select distinct (c) from r where c = 2)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testComparisonsScalar() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkEmptyResult("select a, b from l where a = (select c from r where 1 = 2)");
            Row row2 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row3 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
            Row row4 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)}));
            Row row5 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null}));
            this.checkResult("select a, b from l where a >= 1.0 * (select avg(d) from r where c > 2)", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2), this.checkResult$default$3());
        }
        Row row6 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        Row row7 = BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)}));
        this.checkResult("select a, b from l where a * b < 2.0 * (select avg(d) from r where l.a = r.c and c < 6 )", (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row7).$colon$colon((Object)row6), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithNull() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) AND b = h", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt wie gehts?"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "ABC"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "HIJ"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"I am fine.", "IJK"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT c, g FROM NullTable3, NullTable5 WHERE (a = d OR (a IS NULL AND d IS NULL)) and c = 'NullTuple'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"NullTuple", "NullTuple"}))}))), this.checkResult$default$3());
            this.registerCollection("NullT", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, "c"}))})), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.allNullablesOfNullData3());
            this.checkResult("SELECT T1.a, T1.b, T1.c FROM NullT T1, NullT T2 WHERE (T1.a = T2.a OR (T1.a IS NULL AND T2.a IS NULL)) AND (T1.b = T2.b OR (T1.b IS NULL AND T2.b IS NULL)) AND T1.c = T2.c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null", "null", "c"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testSingleRowJoin() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3) ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3) JOIN SmallTable3 ON s <> b", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testNonEmptyTableJoinEmptyTable() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM SmallTable3 FULL JOIN (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
            this.checkResult("SELECT s, a, b, c FROM (SELECT SUM(b) AS s FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN SmallTable3 ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "Hello world"}))}))), this.checkResult$default$3());
        }
    }

    @Test
    public void testEmptyTableJoinEmptyTable() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
            this.checkResult("SELECT sa, sb FROM (SELECT SUM(b) AS sb FROM SmallTable3 HAVING COUNT(*) < 0) FULL JOIN (SELECT SUM(a) AS sa FROM SmallTable3 HAVING COUNT(*) < 0) ON true", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
        }
    }

    @Test
    public void testJoinCollation() {
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.a AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        |  SELECT t1.a AS a, (t1.b + t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.a = t2.a\n        |),\n        |\n        |v2 AS (\n        |  SELECT t1.b AS a, (t1.b * t2.b) AS b\n        |    FROM SmallTable3 AS t1, SmallTable3 AS t2 WHERE t1.b = t2.b\n        |)\n        |\n        |SELECT v1.a, v2.a, v1.b, v2.b FROM v1, v2 WHERE v1.a = v2.a\n      ")).stripMargin(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testJoinWithUDFFilter() {
        this.registerFunction("funcWithOpen", new FuncWithOpen());
        this.checkResult("SELECT c, g FROM SmallTable3 join Table5 on funcWithOpen(a + d) where b = e", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi", "Hallo"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", "Hallo Welt"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world", "Hallo Welt"}))}))), this.checkResult$default$3());
    }

    public final TwoInputTransformation org$apache$flink$table$planner$runtime$batch$sql$join$JoinITCase$$findTwoInputTransform$1(Transformation t) {
        Transformation transformation;
        while (true) {
            if ((transformation = t) instanceof LegacySinkTransformation) {
                LegacySinkTransformation legacySinkTransformation = (LegacySinkTransformation)transformation;
                t = (Transformation)legacySinkTransformation.getInputs().get(0);
                continue;
            }
            if (!(transformation instanceof OneInputTransformation)) break;
            OneInputTransformation oneInputTransformation = (OneInputTransformation)transformation;
            t = (Transformation)oneInputTransformation.getInputs().get(0);
        }
        if (transformation instanceof TwoInputTransformation) {
            TwoInputTransformation twoInputTransformation;
            TwoInputTransformation twoInputTransformation2 = twoInputTransformation = (TwoInputTransformation)transformation;
            return twoInputTransformation2;
        }
        throw new MatchError((Object)transformation);
    }

    public JoinITCase(Enumeration.Value expectedJoinType) {
        this.expectedJoinType = expectedJoinType;
    }
}

