/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.join.InnerJoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001U\u0011q\"\u00138oKJTu.\u001b8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"A\u0004sk:$\u0018.\\3\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005)Q\u000f^5mg&\u00111\u0004\u0007\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001#\u001a=qK\u000e$X\r\u001a&pS:$\u0016\u0010]3\u0011\u0005}9dB\u0001\u00116\u001d\t\tCG\u0004\u0002#g9\u00111E\r\b\u0003IEr!!\n\u0019\u000f\u0005\u0019zcBA\u0014/\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!A\u000e\u0002\u0002\u0011){\u0017N\u001c+za\u0016L!\u0001O\u001d\u0003\u0011){\u0017N\u001c+za\u0016T!A\u000e\u0002\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\tit\b\u0005\u0002?\u00015\t!\u0001C\u0003\u001eu\u0001\u0007a\u0004\u0003\u0005B\u0001!\u0015\r\u0011\"\u0003C\u0003=i\u00170\u00169qKJ\u001c\u0015m]3ECR\fW#A\"\u0011\u0007\u0011K5*D\u0001F\u0015\t1u)\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u0016\u00131aU3r!\tau*D\u0001N\u0015\tqe\"A\u0003usB,7/\u0003\u0002Q\u001b\n\u0019!k\\<\t\u0011I\u0003\u0001\u0012!Q!\n\r\u000b\u0001#\\=VaB,'oQ1tK\u0012\u000bG/\u0019\u0011\t\u0011Q\u0003\u0001R1A\u0005\n\t\u000bq\"\\=M_^,'oQ1tK\u0012\u000bG/\u0019\u0005\t-\u0002A\t\u0011)Q\u0005\u0007\u0006\u0001R.\u001f'po\u0016\u00148)Y:f\t\u0006$\u0018\r\t\u0005\t1\u0002A)\u0019!C\u0005\u0005\u0006YQ.\u001f+fgR$\u0015\r^12\u0011!Q\u0006\u0001#A!B\u0013\u0019\u0015\u0001D7z)\u0016\u001cH\u000fR1uCF\u0002\u0003\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011\u0002\"\u0002\u00175LH+Z:u\t\u0006$\u0018M\r\u0005\t=\u0002A\t\u0011)Q\u0005\u0007\u0006aQ.\u001f+fgR$\u0015\r^13A!)\u0001\r\u0001C!C\u00061!-\u001a4pe\u0016$\u0012A\u0019\t\u0003G\u0012l\u0011aR\u0005\u0003K\u001e\u0013A!\u00168ji\"\u0012ql\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003UJ\tQA[;oSRL!\u0001\\5\u0003\r\t+gm\u001c:f\u0011\u0015q\u0007\u0001\"\u0001b\u0003I!Xm\u001d;P]\u0016l\u0015\r^2i!\u0016\u0014(k\\<)\u00055\u0004\bC\u00015r\u0013\t\u0011\u0018N\u0001\u0003UKN$\b\"\u0002;\u0001\t\u0003\t\u0017a\u0005;fgRlU\u000f\u001c;ja2,W*\u0019;dQ\u0016\u001c\bFA:q\u0011\u00159\b\u0001\"\u0001b\u00035!Xm\u001d;O_6\u000bGo\u00195fg\"\u0012a\u000f\u001d\u0005\u0006u\u0002!\t!Y\u0001\u0011i\u0016\u001cH\u000fR3dS6\fG.Q:LKfD#!\u001f9\t\u000bu\u0004A\u0011A1\u0002\u001fQ,7\u000f\u001e\"jO\u001a{'o\u00159jY2D#\u0001 9\t\r\u0005\u0005\u0001\u0001\"\u0001b\u0003q!Xm\u001d;T_J$X*\u001a:hK*{\u0017N\\(viB,Ho\u0014:eKJD#a 9)\u000f\u0001\t9!a\u0005\u0002\u0016A!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e%\faA];o]\u0016\u0014\u0018\u0002BA\t\u0003\u0017\u0011qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e%\fqA];o]\u0016\u00148/\u0003\u0003\u0002\"\u0005m!!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002&\tA\t!a\n\u0002\u001f%sg.\u001a:K_&t\u0017\nV\"bg\u0016\u00042APA\u0015\r\u0019\t!\u0001#\u0001\u0002,M!\u0011\u0011FA\u0017!\r\u0019\u0017qF\u0005\u0004\u0003c9%AB!osJ+g\rC\u0004<\u0003S!\t!!\u000e\u0015\u0005\u0005\u001d\u0002\u0002CA\u001d\u0003S!\t!a\u000f\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002>A1\u0011qHA%\u0003\u001bj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005kRLGN\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\u0011\tY%!\u0011\u0003\u0015\r{G\u000e\\3di&|g\u000e\r\u0003\u0002P\u0005e\u0003#B2\u0002R\u0005U\u0013bAA*\u000f\n)\u0011I\u001d:bsB!\u0011qKA-\u0019\u0001!A\"a\u0017\u00028\u0005\u0005\t\u0011!B\u0001\u0003;\u00121a\u0018\u00132#\u0011\ty&!\u001a\u0011\u0007\r\f\t'C\u0002\u0002d\u001d\u0013qAT8uQ&tw\rE\u0002d\u0003OJ1!!\u001bH\u0005\r\te.\u001f\u0015\t\u0003o\ti'a\u001f\u0002~A!\u0011qNA;\u001d\u0011\tI\"!\u001d\n\t\u0005M\u00141D\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005]\u0014\u0011\u0010\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002BA:\u00037\tAA\\1nK\u0006\u0012\u0011qP\u0001\u0004wBj\b")
public class InnerJoinITCase
extends BatchTestBase {
    private final Enumeration.Value expectedJoinType;
    private Seq<Row> myUpperCaseData;
    private Seq<Row> myLowerCaseData;
    private Seq<Row> myTestData1;
    private Seq<Row> myTestData2;
    private volatile byte bitmap$0;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return InnerJoinITCase$.MODULE$.parameters();
    }

    private Seq myUpperCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.myUpperCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "E"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "F"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "G"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.myUpperCaseData;
        }
    }

    private Seq myLowerCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.myLowerCaseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "e"}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.myLowerCaseData;
        }
    }

    private Seq myTestData1$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.myTestData1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.myTestData1;
        }
    }

    private Seq myTestData2$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.myTestData2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.myTestData2;
        }
    }

    private Seq<Row> myUpperCaseData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.myUpperCaseData$lzycompute() : this.myUpperCaseData;
    }

    private Seq<Row> myLowerCaseData() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.myLowerCaseData$lzycompute() : this.myLowerCaseData;
    }

    private Seq<Row> myTestData1() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.myTestData1$lzycompute() : this.myTestData1;
    }

    private Seq<Row> myTestData2() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.myTestData2$lzycompute() : this.myTestData2;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("myUpperCaseData", this.myUpperCaseData(), TestData$.MODULE$.INT_STRING(), "N, L", new boolean[]{true, true});
        this.registerCollection("myLowerCaseData", this.myLowerCaseData(), TestData$.MODULE$.INT_STRING(), "n, l", new boolean[]{true, true});
        this.registerCollection("myTestData1", this.myTestData1(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        this.registerCollection("myTestData2", this.myTestData2(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType);
    }

    @Test
    public void testOneMatchPerRow() {
        this.checkResult("SELECT * FROM myUpperCaseData u, myLowerCaseData l WHERE u.N = l.n", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)1), "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)2), "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)3), "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D", BoxesRunTime.boxToInteger((int)4), "d"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMultipleMatches() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testNoMatches() {
        this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1 and B.a = 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testDecimalAsKey() {
        RowTypeInfo DEC_INT = new RowTypeInfo(new TypeInformation[]{BigDecimalTypeInfo.of((int)9, (int)0), BasicTypeInfo.INT_TYPE_INFO});
        this.registerCollection("leftTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(2), BoxesRunTime.boxToInteger((int)2)}))}))), (TypeInformation<Row>)DEC_INT, "a, b");
        this.registerCollection("rightTable", (Iterable<Row>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)}))}))), (TypeInformation<Row>)DEC_INT, "c, d");
        this.checkResult("SELECT * FROM leftTable, rightTable WHERE a = c", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testBigForSpill() {
        this.conf().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
        Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
        this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
        this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Row> apply(Row row2) {
                return (Seq)Seq$.MODULE$.fill(16, (Function0)new Serializable(this, row2){
                    public static final long serialVersionUID = 0L;
                    private final Row row$1;

                    public final Row apply() {
                        return this.row$1;
                    }
                    {
                        this.row$1 = row$1;
                    }
                });
            }
        }, Seq$.MODULE$.canBuildFrom())), this.checkResult$default$3());
    }

    @Test
    public void testSortMergeJoinOutputOrder() {
        Enumeration.Value value = this.expectedJoinType;
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.conf().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 1);
            this.env().getConfig().setParallelism(1);
            Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
            this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
            this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Row> apply(Row row2) {
                    return (Seq)Seq$.MODULE$.fill(16, (Function0)new Serializable(this, row2){
                        public static final long serialVersionUID = 0L;
                        private final Row row$2;

                        public final Row apply() {
                            return this.row$2;
                        }
                        {
                            this.row$2 = row$2;
                        }
                    });
                }
            }, Seq$.MODULE$.canBuildFrom())), true);
        }
    }

    public InnerJoinITCase(Enumeration.Value expectedJoinType) {
        this.expectedJoinType = expectedJoinType;
    }
}

