/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.planner.runtime.batch.sql.SetOperatorsITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001M\u0011!cU3u\u001fB,'/\u0019;peNLEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011m\u0001!\u0011!Q\u0001\nq\t\u0001B[8j]RK\b/\u001a\t\u0003;]r!A\b\u001b\u000f\u0005}\u0011dB\u0001\u00112\u001d\t\t\u0003G\u0004\u0002#_9\u00111E\f\b\u0003I5r!!\n\u0017\u000f\u0005\u0019ZcBA\u0014+\u001b\u0005A#BA\u0015\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u00024\u0005\u0005!!n\\5o\u0013\t)d'\u0001\u0005K_&tG+\u001f9f\u0015\t\u0019$!\u0003\u00029s\tA!j\\5o)f\u0004XM\u0003\u00026m!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"\"!P \u0011\u0005y\u0002Q\"\u0001\u0002\t\u000bmQ\u0004\u0019\u0001\u000f\t\u000b\u0005\u0003A\u0011\t\"\u0002\r\t,gm\u001c:f)\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRD#\u0001\u0011&\u0011\u0005-sU\"\u0001'\u000b\u00055\u0003\u0012!\u00026v]&$\u0018BA(M\u0005\u0019\u0011UMZ8sK\")\u0011\u000b\u0001C\u0001\u0005\u0006iA/Z:u\u0013:$XM]:fGRD#\u0001U*\u0011\u0005-#\u0016BA+M\u0005\u0011!Vm\u001d;\t\u000b]\u0003A\u0011\u0001\"\u0002/Q,7\u000f^%oi\u0016\u00148/Z2u/&$\bNR5mi\u0016\u0014\bF\u0001,T\u0011\u0015Q\u0006\u0001\"\u0001C\u0003)!Xm\u001d;Fq\u000e,\u0007\u000f\u001e\u0015\u00033NCQ!\u0018\u0001\u0005\u0002\t\u000bA\u0003^3ti\u0016C8-\u001a9u/&$\bNR5mi\u0016\u0014\bF\u0001/T\u0011\u0015\u0001\u0007\u0001\"\u0001C\u0003Y!Xm\u001d;J]R,'o]3di^KG\u000f\u001b(vY2\u001c\bFA0T\u0011\u0015\u0019\u0007\u0001\"\u0001C\u0003M!Xm\u001d;Fq\u000e,\u0007\u000f^,ji\"tU\u000f\u001c7tQ\t\u00117\u000bC\u0003g\u0001\u0011\u0005!)\u0001\tuKN$\u0018J\u001c;feN,7\r^!mY\"\u0012Qm\u0015\u0005\u0006S\u0002!\tAQ\u0001\ri\u0016\u001cH/T5okN\fE\u000e\u001c\u0015\u0003QNCC\u0001\u00017sgB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eT\u0001\u0007eVtg.\u001a:\n\u0005Et'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fT\u0001\beVtg.\u001a:t\u0013\tIhOA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\u0006w\nA\t\u0001`\u0001\u0013'\u0016$x\n]3sCR|'o]%U\u0007\u0006\u001cX\r\u0005\u0002?{\u001a)\u0011A\u0001E\u0001}N\u0011Qp \t\u0004\t\u0006\u0005\u0011bAA\u0002\u000b\n1\u0011I\\=SK\u001aDaaO?\u0005\u0002\u0005\u001dA#\u0001?\t\u000f\u0005-Q\u0010\"\u0001\u0002\u000e\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005=\u0001CBA\t\u00037\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\tQ1i\u001c7mK\u000e$\u0018n\u001c81\t\u0005\u0005\u00121\u0006\t\u0006\t\u0006\r\u0012qE\u0005\u0004\u0003K)%!B!se\u0006L\b\u0003BA\u0015\u0003Wa\u0001\u0001\u0002\u0007\u0002.\u0005%\u0011\u0011!A\u0001\u0006\u0003\tyCA\u0002`IE\nB!!\r\u00028A\u0019A)a\r\n\u0007\u0005URIA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\u000bI$C\u0002\u0002<\u0015\u00131!\u00118zQ!\tI!a\u0010\u0002N\u0005=\u0003\u0003BA!\u0003\u000fr1!^A\"\u0013\r\t)E^\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005%\u00131\n\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA#m\u0006!a.Y7fC\t\t\t&A\u0002|au\u0004")
public class SetOperatorsITCase
extends BatchTestBase {
    private final Enumeration.Value joinType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return SetOperatorsITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("AllNullTable3", (Iterable<Row>)TestData$.MODULE$.allNullData3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("SmallTable3", (Iterable<Row>)TestData$.MODULE$.smallData3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("Table3", (Iterable<Row>)TestData$.MODULE$.data3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("Table5", (Iterable<Row>)TestData$.MODULE$.data5(), (TypeInformation<Row>)TestData$.MODULE$.type5(), "a, b, c, d, e");
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.joinType);
    }

    @Test
    public void testIntersect() {
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)2L), "Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)2L), "Hello world!"}))}));
        List shuffleData = (List)Random$.MODULE$.shuffle((TraversableOnce)data, List$.MODULE$.canBuildFrom());
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), "T", shuffleData, new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "a, b, c");
        this.checkResult("SELECT c FROM SmallTable3 INTERSECT SELECT c FROM T", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testIntersectWithFilter() {
        this.checkResult("SELECT c FROM ((SELECT * FROM SmallTable3) INTERSECT (SELECT * FROM Table3)) WHERE a > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testExcept() {
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "Hi"}))}));
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), "T", data, new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "a, b, c");
        this.checkResult("SELECT c FROM SmallTable3 EXCEPT (SELECT c FROM T)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testExceptWithFilter() {
        this.checkResult("SELECT c FROM (SELECT * FROM SmallTable3 EXCEPT (SELECT a, b, d FROM Table5))WHERE b < 2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testIntersectWithNulls() {
        this.checkResult("SELECT c FROM AllNullTable3 INTERSECT SELECT c FROM AllNullTable3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}))}))), this.checkResult$default$3());
    }

    @Test
    public void testExceptWithNulls() {
        this.checkResult("SELECT c FROM AllNullTable3 EXCEPT SELECT c FROM AllNullTable3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testIntersectAll() {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), "T1", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1, 2, 2})), "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), "T2", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2, 2, 3})), "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.checkResult("SELECT c FROM T1 INTERSECT ALL SELECT c FROM T2", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testMinusAll() {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), "T2", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")})), "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String t1 = "SELECT * FROM SmallTable3";
        String t2 = "SELECT * FROM T2";
        this.checkResult(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT c FROM ((", " UNION ALL ", " UNION ALL ", ") EXCEPT ALL (", " UNION ALL ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t1, t1, t1, t2, t2})), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"}))}))), this.checkResult$default$3());
    }

    public SetOperatorsITCase(Enumeration.Value joinType) {
        this.joinType = joinType;
    }
}

