/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001M\u00111#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aC:ik\u001a4G.Z'pI\u0016\u0004\"!H\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003E}AQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015Yb\u00051\u0001\u001d\u0011\u0015i\u0003\u0001\"\u0011/\u0003\u0019\u0011WMZ8sKR\tq\u0006\u0005\u0002\u001fa%\u0011\u0011g\b\u0002\u0005+:LG\u000f\u000b\u0002-gA\u0011AgN\u0007\u0002k)\u0011a\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003qU\u0012aAQ3g_J,\u0007\"\u0002\u001e\u0001\t\u0003q\u0013A\u0006;fgR\u0014\u0015m]5d\u001bVdG/\u001b9mK&s\u0007/\u001e;)\u0005eb\u0004C\u0001\u001b>\u0013\tqTG\u0001\u0003UKN$\b\"\u0002!\u0001\t\u0003q\u0013A\u0006;fgRl\u0015M\\=Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f^:)\u0005}b\u0004\"B\"\u0001\t\u0003q\u0013A\u0006;fgRTu.\u001b8XSRD\u0017iZ4BgB\u0013xNY3)\u0005\tc\u0004\"\u0002$\u0001\t\u0003q\u0013\u0001\u0007;fgRtu\u000e\u0015:j_JLG/_\"p]N$(/Y5oi\"\u0012Q\t\u0010\u0005\u0006\u0013\u0002!\tAL\u0001\u0012i\u0016\u001cHOU3mCR,G-\u00138qkR\u001c\bF\u0001%=\u0011\u0015a\u0005\u0001\"\u0001/\u0003a!Xm\u001d;SK2\fG/\u001a3J]B,Ho],ji\"\fum\u001a\u0015\u0003\u0017rBQa\u0014\u0001\u0005\u00029\na\u0005^3ti\u0012+\u0017\r\u001a7pG.\u001c\u0015-^:fI\nKX\t_2iC:<W-\u00138B]\u000e,7\u000f^8sQ\tqE\bC\u0003S\u0001\u0011\u0005a&\u0001\fuKN$X*\u0019=TkB\u0004xN\u001d;fI&s\u0007/\u001e;tQ\t\tF\bC\u0003V\u0001\u0011\u0005a+\u0001\rdQ\u0016\u001c7.T;mi&\u0004H.Z%oaV$(+Z:vYR$\"aL,\t\u000b\r!\u0006\u0019\u0001\u000f)\t\u0001Iv\f\u0019\t\u00035vk\u0011a\u0017\u0006\u00039V\naA];o]\u0016\u0014\u0018B\u00010\\\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IV\nqA];o]\u0016\u00148/\u0003\u0002gG\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<Q\u0001\u001b\u0002\t\u0002%\f1#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016\u0004\"A\u000b6\u0007\u000b\u0005\u0011\u0001\u0012A6\u0014\u0005)d\u0007C\u0001\u0010n\u0013\tqwD\u0001\u0004B]f\u0014VM\u001a\u0005\u0006O)$\t\u0001\u001d\u000b\u0002S\")!O\u001bC\u0001g\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0003Q\u00042AH;\u001d\u0013\t1xDA\u0003BeJ\f\u0017\u0010\u000b\u0004rq\u0006E\u00111\u0003\t\u0004s\u0006-ab\u0001>\u0002\b9\u001910!\u0002\u000f\u0007q\f\u0019AD\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fJ\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005Y\u0002\u0012B\u000136\u0013\r\tIaY\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u00055\u0011q\u0002\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\u0005G\u0006!a.Y7fC\t\t)\"\u0001\ttQV4g\r\\3N_\u0012,'\bI>1{\"9\u0011\u0011\u00046\u0005\u0002\u0005m\u0011AE4f]\u0016\u0014\u0018\r^3SC:$w.\u001c#bi\u0006$\"!!\b\u0011\r\u0005}\u0011\u0011FA\u0018\u001d\u0011\t\t#!\n\u000f\u0007u\f\u0019#C\u0001!\u0013\r\t9cH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY#!\f\u0003\u0007M+\u0017OC\u0002\u0002(}\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ka\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u001d\u0003g\u00111AU8x\u0011)\tiD\u001bEC\u0002\u0013\u0005\u0011qH\u0001\be><H+\u001f9f+\t\t\t\u0005\u0005\u0003\u0002D\u0005ESBAA#\u0015\u0011\t9%!\u0013\u0002\u0013QL\b/Z;uS2\u001c(\u0002BA&\u0003\u001b\nAA[1wC*\u0019\u0011q\n\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002T\u0005\u0015#a\u0003*poRK\b/Z%oM>D!\"a\u0016k\u0011\u0003\u0005\u000b\u0015BA!\u0003!\u0011xn\u001e+za\u0016\u0004\u0003BCA.U\"\u0015\r\u0011\"\u0001\u0002^\u0005Ia.\u001e7mC\ndWm]\u000b\u0003\u0003?\u0002BAH;\u0002bA\u0019a$a\u0019\n\u0007\u0005\u0015tDA\u0004C_>dW-\u00198\t\u0015\u0005%$\u000e#A!B\u0013\ty&\u0001\u0006ok2d\u0017M\u00197fg\u0002B!\"!\u001ck\u0011\u000b\u0007I\u0011AA8\u0003\u0015!\u0017\r^1Y+\t\ti\u0002\u0003\u0006\u0002t)D\t\u0011)Q\u0005\u0003;\ta\u0001Z1uCb\u0003\u0003BCA<U\"\u0015\r\u0011\"\u0001\u0002p\u0005)A-\u0019;b3\"Q\u00111\u00106\t\u0002\u0003\u0006K!!\b\u0002\r\u0011\fG/Y-!\u0011)\tyH\u001bEC\u0002\u0013\u0005\u0011qN\u0001\u0006I\u0006$\u0018M\u0017\u0005\u000b\u0003\u0007S\u0007\u0012!Q!\n\u0005u\u0011A\u00023bi\u0006T\u0006\u0005\u0003\u0006\u0002\b*D)\u0019!C\u0001\u0003_\nQ\u0001Z1uCRC!\"a#k\u0011\u0003\u0005\u000b\u0015BA\u000f\u0003\u0019!\u0017\r^1UA\u0001")
public class MultipleInputITCase
extends BatchTestBase {
    private final String shuffleMode;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameterized.Parameters(name="shuffleMode: {0}")
    public static String[] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().getConfiguration().setString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE, this.shuffleMode);
    }

    @Test
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @Test
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"}))}));
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        StringBuilder sql = new StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;

            public final StringBuilder apply(int i) {
                return this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", t", ".c, t", ".d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.sql$1 = sql$1;
            }
        });
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;

            public final StringBuilder apply(int i) {
                return this.sql$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" left join right_table as t", " on t0.a = t", ".c and t", ".c = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.sql$1 = sql$1;
            }
        });
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, false);
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, true);
        this.checkResult(sql, expected, this.checkResult$default$3());
    }

    public MultipleInputITCase(String shuffleMode) {
        this.shuffleMode = shuffleMode;
    }
}

