/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Over;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'>,(oY3UKN$(BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\t\u00191B\u0003\u0002\r\u001b\u0005)a\r\\5oW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005YA\u0011!B;uS2\u001c\u0018B\u0001\r\u0016\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006?\u0001!\t\u0001I\u0001$i\u0016\u001cH\u000fV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b'p]\u001e\u0014vn\u001e+j[\u00164\u0015.\u001a7e)\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSRD#A\b\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-z\u0011!\u00026v]&$\u0018BA\u0017+\u0005\u0011!Vm\u001d;\t\u000b=\u0002A\u0011\u0001\u0011\u0002QQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5US6,7\u000f^1naJ{w\u000fV5nK\u001aKW\r\u001c3)\u00059B\u0003\"\u0002\u001a\u0001\t\u0003\u0001\u0013!\t;fgR\u0014vn\u001e+j[\u0016$\u0016M\u00197f'>,(oY3He>,\boV5oI><\bFA\u0019)\u0011\u0015)\u0004\u0001\"\u0001!\u0003u!Xm\u001d;Qe>\u001cG+[7f)\u0006\u0014G.Z*pkJ\u001cWmU5na2,\u0007F\u0001\u001b)\u0011\u0015A\u0004\u0001\"\u0001!\u0003\u0005\"Xm\u001d;Qe>\u001cG+[7f)\u0006\u0014G.Z*pkJ\u001cWm\u0014<fe^Kg\u000eZ8xQ\t9\u0004\u0006C\u0003<\u0001\u0011\u0005\u0001%\u0001\u0010uKN$\bK]8kK\u000e$x+\u001b;i%><H/[7f!J|7\r^5nK\"\u0012!\b\u000b\u0005\u0006}\u0001!\t\u0001I\u0001\u001ai\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,HOU8xi&lW\r\u000b\u0002>Q!)\u0011\t\u0001C\u0001A\u0005QB/Z:u!J|'.Z2u/&$\bn\\;u!J|7\r^5nK\"\u0012\u0001\t\u000b\u0005\u0006\t\u0002!\t\u0001I\u0001\u0018i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGo\u00148msB\u0013xn\u0019;j[\u0016D#a\u0011\u0015\t\u000b\u001d\u0003A\u0011\u0001\u0011\u0002-Q,7\u000f\u001e)s_*,7\r^(oYf\u0014vn\u001e;j[\u0016D#A\u0012\u0015\t\u000b)\u0003A\u0011\u0001\u0011\u0002-Q,7\u000f\u001e)s_*,7\r^,ji\"l\u0015\r\u001d9j]\u001eD#!\u0013\u0015\t\u000b5\u0003A\u0011\u0001\u0011\u0002#Q,7\u000f\u001e(fgR,G\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002MQ\u0001")
public class LegacyTableSourceTest
extends TableTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("w");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("name");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("val");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("valSum");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("ptime");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("rtime");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("deepNested");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("nestedName");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("nested");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("nestedValue");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("nestedFlag");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("nestedNum");

    @Test
    public void testTableSourceWithLongRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        Table t = util.tableEnv().from("rowTimeT").where(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).window((GroupWindow)Tumble.over((Expression)((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).on(package$.MODULE$.symbol2FieldExpression(symbol$1)).as(package$.MODULE$.symbol2FieldExpression(symbol$2))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$2)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$2).end(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).avg()});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProcTimeTableSourceSimple() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        boolean x$1 = false;
        TableSchema x$2 = tableSchema;
        RowTypeInfo x$3 = returnType;
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$5 = "proctime";
        String x$6 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        Map<String, String> x$7 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7();
        String x$8 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8();
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("procTimeT", new TestTableSourceWithTime(x$1, x$2, x$3, x$4, x$6, x$5, x$7, x$8));
        Table t = util.tableEnv().from("procTimeT").select(new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProcTimeTableSourceOverWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        boolean x$9 = false;
        TableSchema x$10 = tableSchema;
        RowTypeInfo x$11 = returnType;
        Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$13 = "proctime";
        String x$14 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        Map<String, String> x$15 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7();
        String x$16 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8();
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("procTimeT", new TestTableSourceWithTime(x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16));
        Table t = util.tableEnv().from("procTimeT").window(new OverWindow[]{Over.partitionBy((Expression[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5)}).orderBy(package$.MODULE$.symbol2FieldExpression(symbol$6)).preceding((Expression)package$.MODULE$.LiteralIntExpression(2).hours()).as(package$.MODULE$.symbol2FieldExpression(symbol$2))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).sum()).over((Object)package$.MODULE$.symbol2FieldExpression(symbol$2))).as(symbol$7, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).filter(package$.MODULE$.UnresolvedFieldExpression(symbol$7).$greater(package$.MODULE$.int2Literal(100)));
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithRowtimeProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithoutProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$9), package$.MODULE$.symbol2FieldExpression(symbol$5)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectOnlyProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$8)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectOnlyRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$9)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testProjectWithMapping() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.SQL_TIMESTAMP(), Types.LONG(), Types.SQL_TIMESTAMP(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", (Map<String, String>)mapping));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$9), package$.MODULE$.symbol2FieldExpression(symbol$4)});
        util.verifyExecPlan(t);
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().from("T").select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$10).get("nested1")).get("name")).as(symbol$11, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$12).get("value")).as(symbol$13, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$10).get("nested2")).get("flag")).as(symbol$14, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$10).get("nested2")).get("num")).as(symbol$15, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
        util.verifyExecPlan(t);
    }
}

