/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001U\u0011abV5oI><(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u0002;Q,7\u000f^\"b]RlUM]4f/&tGm\\<U-\u001a{F+^7cY\u0016$\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000f\u000b\u0002*gA\u0011AgN\u0007\u0002k)\u0011aGE\u0001\u0006UVt\u0017\u000e^\u0005\u0003qU\u0012A\u0001V3ti\")!\b\u0001C\u0001W\u00059C/Z:u\u0007\u0006tG/T3sO\u0016<\u0016N\u001c3poR3fi\u0018+v[\ndWm\u00148Qe>\u001cG/[7fQ\tI4\u0007C\u0003>\u0001\u0011\u00051&\u0001\u000euKN$8)\u00198u\u001b\u0016\u0014x-Z,j]\u0012|w\u000f\u0016,G?\"{\u0007\u000f\u000b\u0002=g!)\u0001\t\u0001C\u0001W\u0005!C/Z:u\u0007\u0006tG/T3sO\u0016<\u0016N\u001c3poR3fi\u0018%pa>s\u0007K]8di&lW\r\u000b\u0002@g!)1\t\u0001C\u0001W\u0005yB/Z:u\u0007\u0006tG/T3sO\u0016<\u0016N\u001c3poR3fiX\"v[Vd\u0017\r^3)\u0005\t\u001b\u0004\"\u0002$\u0001\t\u0003Y\u0013!\u000b;fgR\u001c\u0015M\u001c;NKJ<WmV5oI><HK\u0016$`\u0007VlW\u000f\\1uK>s\u0007K]8di&lW\r\u000b\u0002Fg!)\u0011\n\u0001C\u0001W\u0005)B/Z:u\u001d>$8+Y7f/&tGm\\<UsB,\u0007F\u0001%4\u0011\u0015a\u0005\u0001\"\u0001,\u0003U!Xm\u001d;O_R\u001c\u0016-\\3XS:$wn^*qK\u000eD#aS\u001a\t\u000b=\u0003A\u0011A\u0016\u00029Q,7\u000f\u001e(piN\u000bW.\u001a+j[\u0016\fE\u000f\u001e:jEV$X\rV=qK\"\u0012aj\r\u0005\u0006%\u0002!\taK\u0001,i\u0016\u001cH/T5tg^Kg\u000eZ8x\u000b:$\u0017J\\\"p]\u0012LG/[8o\r>\u0014H+^7cY\u0016<\u0016N\u001c3po\"\u0012\u0011k\r\u0005\u0006+\u0002!\taK\u0001.i\u0016\u001cH/T5tg^Kg\u000eZ8x'R\f'\u000f^%o\u0007>tG-\u001b;j_:4uN\u001d+v[\ndWmV5oI><\bF\u0001+4\u0011\u0015A\u0006\u0001\"\u0001,\u0003!\"Xm\u001d;NSN\u001cx+\u001b8e_^,e\u000eZ%o\u0007>tG-\u001b;j_:4uN\u001d%pa^Kg\u000eZ8xQ\t96\u0007C\u0003\\\u0001\u0011\u00051&\u0001\u0016uKN$X*[:t/&tGm\\<Ti\u0006\u0014H/\u00138D_:$\u0017\u000e^5p]\u001a{'\u000fS8q/&tGm\\<)\u0005i\u001b\u0004\"\u00020\u0001\t\u0003Y\u0013!\f;fgRl\u0015n]:XS:$wn^#oI&s7i\u001c8eSRLwN\u001c$pe\u000e+X.\u001e7bi\u0016<\u0016N\u001c3po\"\u0012Ql\r\u0005\u0006C\u0002!\taK\u00010i\u0016\u001cH/T5tg^Kg\u000eZ8x'R\f'\u000f^%o\u0007>tG-\u001b;j_:4uN]\"v[Vd\u0017\r^3XS:$wn\u001e\u0015\u0003ANBQ\u0001\u001a\u0001\u0005\u0002-\n1\u0004^3ti>sG+^7cY\u0016<\u0016N\u001c3po\u0006;wM]3hCR,\u0007FA24\u0011\u00159\u0007\u0001\"\u0001,\u0003\u0015\"Xm\u001d;P]R+XN\u00197f/&tGm\\<BO\u001e\u0014XmZ1uK>s\u0007K]8di&lW\r\u000b\u0002gg!)!\u000e\u0001C\u0001W\u0005AB/Z:u\u001f:Du\u000e],j]\u0012|w/Q4he\u0016<\u0017\r^3)\u0005%\u001c\u0004\"B7\u0001\t\u0003Y\u0013A\t;fgR|e\u000eS8q/&tGm\\<BO\u001e\u0014XmZ1uK>s\u0007K]8di&lW\r\u000b\u0002mg!)\u0001\u000f\u0001C\u0001W\u0005iB/Z:u\u001f:\u001cU/\\;mCR,w+\u001b8e_^\fum\u001a:fO\u0006$X\r\u000b\u0002pg!)1\u000f\u0001C\u0001W\u00059C/Z:u\u001f:\u001cU/\\;mCR,w+\u001b8e_^\fum\u001a:fO\u0006$Xm\u00148Qe>\u001cG/[7fQ\t\u00118\u0007C\u0003w\u0001\u0011\u00051&A\ruKN$x+\u001b8e_^Tu.\u001b8XSRDgj\u001c8FcVL\u0007FA;4\u0011\u0015I\b\u0001\"\u0001,\u0003\u001d\"Xm\u001d;US6,\u0017\t\u001e;sS\n,H/\u001a)s_B\fw-\u0019;f\r>\u0014x+\u001b8e_^Tu.\u001b8)\u0005a\u001c\u0004\"\u0002?\u0001\t\u0003Y\u0013\u0001\u000b;fgR$\u0016.\\3BiR\u0014\u0018NY;uKB\u0013x\u000e]1hCR,gi\u001c:XS:$wn\u001e&pS:\f\u0004FA>4\u0011\u0015y\b\u0001\"\u0001,\u0003!\"Xm\u001d;XS:$wn\u001e)s_B,'\u000f^=Qe>\u0004\u0018mZ1uK\u001a{'oV5oI><(j\\5oQ\tq8\u0007\u0003\u0004\u0002\u0006\u0001!\taK\u0001\u000fi\u0016\u001cHoU3nS*{\u0017N\\%OQ\r\t\u0019a\r\u0005\u0007\u0003\u0017\u0001A\u0011A\u0016\u0002\u001bQ,7\u000f^*f[&,\u00050[:uQ\r\tIa\r\u0005\u0007\u0003#\u0001A\u0011A\u0016\u0002#Q,7\u000f^!oi&Tu.\u001b8O_RLe\nK\u0002\u0002\u0010MBa!a\u0006\u0001\t\u0003Y\u0013\u0001\u0006;fgR\fe\u000e^5K_&tgj\u001c;Fq&\u001cH\u000fK\u0002\u0002\u0016MBa!!\b\u0001\t\u0003Y\u0013!\b;fgRTu.\u001b8XSRD\u0017j\u001d(pi\u0012K7\u000f^5oGR4%o\\7)\u0007\u0005m1\u0007")
public class WindowJoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testCantMergeWindowTVF_Tumble() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_TumbleOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_Hop() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_HopOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_Cumulate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_CumulateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotSameWindowType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join doesn't support different window table function of left and right inputs.\nThe left window table function is HOP(size=[10 min], slide=[5 min]).\nThe right window table function is CUMULATE(max_size=[1 h], step=[10 min]).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotSameWindowSpec() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '2' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join doesn't support different window table function of left and right inputs.\nThe left window table function is CUMULATE(max_size=[2 h], step=[10 min]).\nThe right window table function is CUMULATE(max_size=[1 h], step=[10 min]).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotSameTimeAttributeType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join doesn't support different time attribute type of left and right inputs.\nThe left time attribute type is TIMESTAMP_LTZ(3) NOT NULL *PROCTIME*.\nThe right time attribute type is TIMESTAMP(3) *ROWTIME*.");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_start = window_start) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_end = window_end) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_start = window_start) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_end = window_end) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_start = window_start) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\nBut the current JOIN ON condition is ((window_end = window_end) AND (a = a)).");
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowJoinWithNonEqui() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a AND\n        | CAST(L.window_start AS BIGINT) > R.uv\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable3 (\n         |  a INT,\n         |  b STRING NOT NULL,\n         |  c BIGINT,\n         |  rowtime TIMESTAMP(3),\n         |  proctime as PROCTIME(),\n         |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n         |) with (\n         |  'connector' = 'values'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp AS\n        |SELECT\n        |  L.window_time as rowtime,\n        |  L.a as a,\n        |  L.b as l_b,\n        |  L.c as l_c,\n        |  R.b as r_b,\n        |  R.c as r_c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT tmp.*, MyTable3.* FROM tmp JOIN MyTable3 ON\n        | tmp.a = MyTable3.a AND\n        | tmp.rowtime BETWEEN\n        |   MyTable3.rowtime - INTERVAL '10' SECOND AND\n        |   MyTable3.rowtime + INTERVAL '1' HOUR\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowJoin1() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable4 (\n         |  a INT,\n         |  b STRING NOT NULL,\n         |  c BIGINT,\n         |  rowtime TIMESTAMP(3),\n         |  proctime as PROCTIME(),\n         |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n         |) with (\n         |  'connector' = 'values'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp1 AS\n        |SELECT\n        |  L.window_time as rowtime,\n        |  L.a,\n        |  L.cnt as l_cnt,\n        |  L.uv as l_uv,\n        |  R.cnt as r_cnt,\n        |  R.uv as r_uv\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT tmp1.*, MyTable4.* FROM tmp1 JOIN MyTable4 ON\n        | tmp1.a = MyTable4.a AND\n        | tmp1.rowtime BETWEEN\n        |   MyTable4.rowtime - INTERVAL '10' SECOND AND\n        |   MyTable4.rowtime + INTERVAL '1' HOUR\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowPropertyPropagateForWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp2 AS\n        |SELECT\n        |  L.window_start as window_start,\n        |  L.window_end as window_end,\n        |  L.a,\n        |  L.cnt as l_cnt,\n        |  L.uv as l_uv,\n        |  R.cnt as r_cnt,\n        |  R.uv as r_uv\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |(\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(\n        |      PARTITION BY window_start, window_end ORDER BY l_cnt DESC) as rownum\n        |  FROM tmp2\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSemiJoinIN() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE L.a IN (\n        |SELECT a FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSemiExist() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE EXISTS (\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAntiJoinNotIN() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE L.a NOT IN (\n        |SELECT a FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAntiJoinNotExist() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE NOT EXISTS (\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testJoinWithIsNotDistinctFrom() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND\n        |L.a IS NOT DISTINCT FROM R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowJoinTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREATE TABLE MyTable (\n       |  a INT,\n       |  b STRING NOT NULL,\n       |  c BIGINT,\n       |  rowtime TIMESTAMP(3),\n       |  proctime as PROCTIME(),\n       |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n       |) with (\n       |  'connector' = 'values'\n       |)\n       |"})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREATE TABLE MyTable2 (\n       |  a INT,\n       |  b STRING NOT NULL,\n       |  c BIGINT,\n       |  rowtime TIMESTAMP(3),\n       |  proctime as PROCTIME(),\n       |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n       |) with (\n       |  'connector' = 'values'\n       |)\n       |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }
}

