/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.TemporalFunctionJoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.hamcrest.Matchers;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001+\tAB+Z7q_J\fGNR;oGRLwN\u001c&pS:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"BA\r\u000b\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0003vi&dW#\u0001\u0013\u0011\u0005])\u0013B\u0001\u0014\u0019\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019A\u0003\u0001)A\u0005I\u0005)Q\u000f^5mA!9!\u0006\u0001b\u0001\n\u0013Y\u0013\u0001\u0004:bi\u0016\u001c\b*[:u_JLX#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=b\u0011aA1qS&\u0011\u0011G\f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u001bI\fG/Z:ISN$xN]=!\u0011\u001d)\u0004A1A\u0005\n-\nA\u0003\u001d:pGRLW.\u001a*bi\u0016\u001c\b*[:u_JL\bBB\u001c\u0001A\u0003%A&A\u000bqe>\u001cG/[7f%\u0006$Xm\u001d%jgR|'/\u001f\u0011\t\u000be\u0002A\u0011\u0001\u001e\u0002\u001dQ,7\u000f^*j[BdWMS8j]R\t1\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\bF\u0001\u001dC!\t\u0019e)D\u0001E\u0015\t)%#A\u0003kk:LG/\u0003\u0002H\t\n!A+Z:u\u0011\u0015I\u0005\u0001\"\u0001;\u0003Y!Xm\u001d;TS6\u0004H.\u001a)s_\u000e$\u0018.\\3K_&t\u0007F\u0001%C\u0011\u0015a\u0005\u0001\"\u0001;\u0003M!Xm\u001d;K_&twJ\\)vKJLH*\u001a4uQ\tY%\tC\u0003P\u0001\u0011\u0005!(A\buKN$8i\\7qY\u0016D(j\\5oQ\tq%\tC\u0003S\u0001\u0011\u0005!(\u0001\u000buKN$XK\\2peJ,G.\u0019;fI*{\u0017N\u001c\u0015\u0003#\nCQ!\u0016\u0001\u0005\u0002i\nQ\u0004^3tiR+W\u000e]8sC2$\u0016M\u00197f\rVt7\r^5p]N\u001b\u0017M\u001c\u0015\u0003)\n\u0003")
public class TemporalFunctionJoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final Table ratesHistory;
    private final Table proctimeRatesHistory;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("t3_comment");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("t3_secondary_key");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("o_rowtime");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("o_comment");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("o_amount");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("o_currency");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("o_secondary_key");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("comment");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("currency");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("rate");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("secondary_key");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("o_proctime");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("proctime");

    public StreamTableTestUtil util() {
        return this.util;
    }

    private Table ratesHistory() {
        return this.ratesHistory;
    }

    private Table proctimeRatesHistory() {
        return this.proctimeRatesHistory;
    }

    @Test
    public void testSimpleJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(o.o_rowtime)) AS r WHERE currency = o_currency";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleProctimeJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM ProctimeOrders AS o, LATERAL TABLE (ProctimeRates(o.o_proctime)) AS r WHERE currency = o_currency";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testJoinOnQueryLeft() {
        Table orders = this.util().tableEnv().sqlQuery("SELECT * FROM Orders WHERE o_amount > 1000");
        this.util().tableEnv().createTemporaryView("Orders2", orders);
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders2 AS o, LATERAL TABLE (Rates(o.o_rowtime)) AS r WHERE currency = o_currency";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testComplexJoin() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        util.addDataStream("Table3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2)}), new CaseClassTypeInfo<Tuple2<String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        util.addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).rowtime(), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7)}), new CaseClassTypeInfo<Tuple5<Timestamp, String, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$13 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        util.addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime(), package$.MODULE$.symbol2FieldExpression(symbol$9), package$.MODULE$.symbol2FieldExpression(symbol$10), package$.MODULE$.symbol2FieldExpression(symbol$11), package$.MODULE$.symbol2FieldExpression(symbol$12)}), new CaseClassTypeInfo<Tuple5<Timestamp, String, String, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        TemporalTableFunction rates = util.tableEnv().sqlQuery("SELECT * FROM RatesHistory WHERE rate > 110").createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$));
        util.addTemporarySystemFunction("Rates", (UserDefinedFunction)rates);
        String sqlQuery = "SELECT * FROM (SELECT o_amount * rate as rate, secondary_key as secondary_key FROM Orders AS o, LATERAL TABLE (Rates(o_rowtime)) AS r WHERE currency = o_currency AND (rate > 120 OR secondary_key = o_secondary_key)), Table3 WHERE t3_secondary_key = secondary_key";
        util.verifyExecPlan(sqlQuery);
    }

    @Test
    public void testUncorrelatedJoin() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage(Matchers.containsString((String)"Cannot generate a valid execution plan"));
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123')) AS r WHERE currency = o_currency";
        this.util().verifyExplain(sqlQuery);
    }

    @Test
    public void testTemporalTableFunctionScan() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage(Matchers.containsString((String)"Cannot generate a valid execution plan"));
        String sqlQuery = "SELECT * FROM LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123'))";
        this.util().verifyExplain(sqlQuery);
    }

    public TemporalFunctionJoinTest() {
        this.util().addDataStream("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).rowtime()}), new CaseClassTypeInfo<Tuple2<Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.ratesHistory = this.util().addDataStream("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$10), package$.MODULE$.symbol2FieldExpression(symbol$11), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$8).rowtime()}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTemporarySystemFunction("Rates", (UserDefinedFunction)this.ratesHistory().createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowtime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
        this.util().addDataStream("ProctimeOrders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$13).proctime()}), new CaseClassTypeInfo<Tuple2<Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.proctimeRatesHistory = this.util().addDataStream("ProctimeRatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$10), package$.MODULE$.symbol2FieldExpression(symbol$11), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$14).proctime()}), new CaseClassTypeInfo<Tuple2<String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTemporarySystemFunction("ProctimeRates", (UserDefinedFunction)this.proctimeRatesHistory().createTemporalTableFunction(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proctime"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currency"}))).$((Seq)Nil$.MODULE$)));
    }
}

