/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestInvalidTemporalTable$;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.AsyncTableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2;
import org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature;
import org.apache.flink.table.planner.plan.utils.InvalidTableFunctionResultType;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRow;
import org.apache.flink.table.planner.plan.utils.TableFunctionWithRowDataVarArg;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003EaWmZ1dsR\u000b'\r\\3T_V\u00148-\u001a\t\u0003;\u0015J!A\n\u0010\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b\r:\u0003\u0019\u0001\u0013\t\u000f9\u0002!\u0019!C\u0005_\u0005!Q\u000f^5m+\u0005\u0001\u0004CA\f2\u0013\t\u0011\u0004DA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u00045\u0001\u0001\u0006I\u0001M\u0001\u0006kRLG\u000e\t\u0005\u0006m\u0001!\taN\u0001\u0007E\u00164wN]3\u0015\u0003a\u0002\"!H\u001d\n\u0005ir\"\u0001B+oSRD#!\u000e\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0012!\u00026v]&$\u0018BA!?\u0005\u0019\u0011UMZ8sK\")1\t\u0001C\u0001o\u0005\u0001C/Z:u\u0015>Lg.\u00138wC2LGMS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\t\u0011U\t\u0005\u0002>\r&\u0011qI\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003J\u0001\u0011\u0005q'\u0001\u0012uKN$hj\u001c;ESN$\u0018N\\2u\rJ|W.\u00138K_&t7i\u001c8eSRLwN\u001c\u0015\u0003\u0011\u0016CQ\u0001\u0014\u0001\u0005\u0002]\na\u0004^3ti&sg/\u00197jI2{wn[;q)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8)\u0005-+\u0005\"B(\u0001\t\u00039\u0014a\u0007;fgRTu.\u001b8P]\u0012KgMZ3sK:$8*Z=UsB,7\u000f\u000b\u0002O\u000b\")!\u000b\u0001C\u0001o\u0005)B/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,\u0007FA)F\u0011\u0015)\u0006\u0001\"\u00018\u0003e!Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\u0005Q+\u0005\"\u0002-\u0001\t\u00039\u0014\u0001\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"tUm\u001d;fIF+XM]=)\u0005]+\u0005\"B.\u0001\t\u00039\u0014a\u000b;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u0004&o\u001c6fGRLwN\u001c)vg\"$un\u001e8)\u0005i+\u0005\"\u00020\u0001\t\u00039\u0014a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"4\u0015\u000e\u001c;feB+8\u000f\u001b#po:D#!X#\t\u000b\u0005\u0004A\u0011A\u001c\u0002KQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f[\"bY\u000e\u0004Vo\u001d5E_^t\u0007F\u00011F\u0011\u0015!\u0007\u0001\"\u00018\u0003%\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018.\u00138eKb\u001cu\u000e\\;n]\"\u00121-\u0012\u0005\u0006O\u0002!\taN\u0001\u001bi\u0016\u001cH/\u0011<pS\u0012\fum\u001a:fO\u0006$X\rU;tQ\u0012{wO\u001c\u0015\u0003M\u0016CQA\u001b\u0001\u0005\u0002]\na\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQR\u0013X/Z\"p]\u0012LG/[8oQ\tIW\tC\u0003n\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDg)\u001e8di&|g.\u00118e\u0007>t7\u000f^1oi\u000e{g\u000eZ5uS>t\u0007F\u00017F\u0011\u0015\u0001\b\u0001\"\u00018\u0003i\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5Nk2$\u0018NR;oGRLwN\\!oI\u000e{gn\u001d;b]R\u001cuN\u001c3ji&|g\u000e\u000b\u0002p\u000b\")1\u000f\u0001C\u0001o\u00051D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\rVt7\r^5p]\u0006sGMU3gKJ,gnY3D_:$\u0017\u000e^5p]\"\u0012!/\u0012\u0005\u0006m\u0002!\taN\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b.\u00163g\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0002v\u000b\")\u0011\u0010\u0001C\u0001o\u00059C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i\u0007>l\u0007/\u001e;fI\u000e{G.^7oQ\tAX\tC\u0003}\u0001\u0011\u0005q'\u0001\u001auKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6t\u0017I\u001c3QkNDGi\\<oQ\tYX\tC\u0003\u0000\u0001\u0011\u0005q'A\u001buKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDW*\u001e7uS\u000e{g\u000eZ5uS>twJ\\*b[\u0016$\u0015.\u001c$jK2$\u0007F\u0001@F\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\t\u0011c\u0019:fCR,Gj\\8lkB$\u0016M\u00197f)\u0015A\u0014\u0011BA\u000e\u0011!\tY!a\u0001A\u0002\u00055\u0011!\u0003;bE2,g*Y7f!\u0011\ty!!\u0006\u000f\u0007u\t\t\"C\u0002\u0002\u0014y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\n=!A\u0011QDA\u0002\u0001\u0004\ty\"\u0001\bm_>\\W\u000f\u001d$v]\u000e$\u0018n\u001c8\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n\r\u0003%1WO\\2uS>t7/\u0003\u0003\u0002*\u0005\r\"aE+tKJ$UMZ5oK\u00124UO\\2uS>t\u0007bBA\u0017\u0001\u0011%\u0011qF\u0001\u0016Kb\u0004Xm\u0019;Fq\u000e,\u0007\u000f^5p]RC'o\\<o)\u001dA\u0014\u0011GA\u001a\u0003oAq!BA\u0016\u0001\u0004\ti\u0001\u0003\u0005\u00026\u0005-\u0002\u0019AA\u0007\u0003\u001diWm]:bO\u0016D!\"!\u000f\u0002,A\u0005\t\u0019AA\u001e\u0003\u0015\u0019G.\u0019>{a\u0011\ti$a\u0012\u0011\r\u0005=\u0011qHA\"\u0013\u0011\t\t%!\u0007\u0003\u000b\rc\u0017m]:\u0011\t\u0005\u0015\u0013q\t\u0007\u0001\t1\tI%a\u000e\u0002\u0002\u0003\u0005)\u0011AA&\u0005\ryF%M\t\u0005\u0003\u001b\n\u0019\u0006E\u0002\u001e\u0003\u001fJ1!!\u0015\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0016\u0002f9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/)\u00051AH]8pizJ\u0011aH\u0005\u0004\u0003Gr\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003O\nIGA\u0005UQJ|w/\u00192mK*\u0019\u00111\r\u0010\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005Ab/\u001a:jMf$&/\u00198tY\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0015\u0007a\n\t\bC\u0004\u0006\u0003W\u0002\r!!\u0004\t\u0013\u0005U\u0004!%A\u0005\n\u0005]\u0014aH3ya\u0016\u001cG/\u0012=dKB$\u0018n\u001c8UQJ|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0010\u0019\u0005\u0003w\ny\b\u0005\u0004\u0002\u0010\u0005}\u0012Q\u0010\t\u0005\u0003\u000b\ny\b\u0002\u0007\u0002J\u0005M\u0014\u0011!A\u0001\u0006\u0003\tY\u0005K\u0004\u0001\u0003\u0007\u000by)!%\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#?\u0003\u0019\u0011XO\u001c8fe&!\u0011QRAD\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!a%\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'?\u0003\u001d\u0011XO\u001c8feNLA!!(\u0002\u0018\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!!)\u0003\u0011\u0003\t\u0019+\u0001\bM_>\\W\u000f\u001d&pS:$Vm\u001d;\u0011\u0007-\n)K\u0002\u0004\u0002\u0005!\u0005\u0011qU\n\u0006\u0003K\u000bI\u000b\b\t\u0004;\u0005-\u0016bAAW=\t1\u0011I\\=SK\u001aDq\u0001KAS\t\u0003\t\t\f\u0006\u0002\u0002$\"A\u0011QWAS\t\u0003\t9,\u0001\u0006qCJ\fW.\u001a;feN$\"!!/\u0011\r\u0005m\u00161YAd\u001b\t\tiLC\u0002/\u0003\u007fS!!!1\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\fiL\u0001\u0006D_2dWm\u0019;j_:\u0004R!HAe\u0003\u001bL1!a3\u001f\u0005\u0015\t%O]1z!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u0003\u007f\u000bA\u0001\\1oO&!\u0011q[Ai\u0005\u0019y%M[3di\"B\u00111WAn\u0003S\fY\u000f\u0005\u0003\u0002^\u0006\rh\u0002BAK\u0003?LA!!9\u0002\u0018\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!:\u0002h\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005\u0005\u0018qS\u0001\u0005]\u0006lW-\t\u0002\u0002n\u0006)B*Z4bGf$\u0016M\u00197f'>,(oY3>wBj\bBCAy\u0003K\u000b\t\u0011\"\u0003\u0002t\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\r")
public class LookupJoinTest
extends TableTestBase
implements Serializable {
    private final boolean legacyTableSource;
    private final StreamTableTestUtil util;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("proctime");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("rowtime");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("name");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("age");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("ts");

    @Parameterized.Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$6)}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$6 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$7 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), "LookupTable", TestTemporalTable$.MODULE$.createTemporaryTable$default$3());
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTable (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT\n          |) WITH (\n          |  'connector' = 'values'\n          |)\n          |")).stripMargin());
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE LookupTableWithComputedColumn (\n          |  `id` INT,\n          |  `name` STRING,\n          |  `age` INT,\n          |  `nominal_age` as age + 1\n          |) WITH (\n          |  'connector' = 'values',\n          |  'bounded' = 'true'\n          |)\n          |")).stripMargin());
        }
    }

    @Test
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proctime AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM LookupTable FOR SYSTEM_TIME AS OF TIMESTAMP '2017-08-09 14:36:11'", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with a constant timestamp '2017-08-09 14:36:11' is not supported yet", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", "Correlate has invalid join type RIGHT", AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 2", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF PROCTIME() AS D ON T.a = D.id", "Temporal table can only be used in temporal join and only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.\nQuerying a temporal table using 'FOR SYSTEM TIME AS OF' syntax with an expression call 'PROCTIME()' is not supported yet.", AssertionError.class);
    }

    @Test
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @Test
    public void testInvalidLookupTableFunction() {
        if (this.legacyTableSource) {
            return;
        }
        this.util().addDataStream("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$10), (Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).proctime()}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.createLookupTable("LookupTable1", (UserDefinedFunction)new InvalidTableFunctionResultType());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable1 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output class can simply be a Row or RowData class"})).s((Seq)Nil$.MODULE$), ValidationException.class);
        this.createLookupTable("LookupTable2", (UserDefinedFunction)new InvalidTableFunctionEvalSignature());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable2 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidTableFunctionEvalSignature' for function 'default_catalog.default_database.LookupTable2' that matches the following signature:\nvoid eval(java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable3", (UserDefinedFunction)new TableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable3 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable4", (UserDefinedFunction)new TableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable4 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable5", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable5 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable6", (UserDefinedFunction)new AsyncTableFunctionWithRow());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable6 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable7", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature1());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable7 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature1' for function 'default_catalog.default_database.LookupTable7' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
        this.createLookupTable("LookupTable8", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature2());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable8 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature2' for function 'default_catalog.default_database.LookupTable8' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, java.lang.String, java.time.LocalDateTime)", ValidationException.class);
        this.createLookupTable("LookupTable9", (UserDefinedFunction)new AsyncTableFunctionWithRowDataVarArg());
        this.verifyTranslationSuccess("SELECT * FROM T JOIN LookupTable9 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts");
        this.createLookupTable("LookupTable10", (UserDefinedFunction)new InvalidAsyncTableFunctionEvalSignature3());
        this.expectExceptionThrown("SELECT * FROM T JOIN LookupTable10 FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id AND T.b = D.name AND T.ts = D.ts", "Could not find an implementation method 'eval' in class 'org.apache.flink.table.planner.plan.utils.InvalidAsyncTableFunctionEvalSignature3' for function 'default_catalog.default_database.LookupTable10' that matches the following signature:\nvoid eval(java.util.concurrent.CompletableFuture, java.lang.Integer, org.apache.flink.table.data.StringData, org.apache.flink.table.data.TimestampData)", ValidationException.class);
    }

    @Test
    public void testJoinOnDifferentKeyTypes() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("VARCHAR(2147483647) and INTEGER does not have common type now");
        this.util().verifyExecPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id");
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithCalcPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE cast(D.name as bigint) > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiIndexColumn() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND D.name = 'AAA'\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proc\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT T.* FROM (", ") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proc AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql1})))).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (", ") AS T\n         |GROUP BY b\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql2})))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithTrueCondition() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.util().verifyExplain(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiFunctionAndConstantCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id + 1 AND T.b = concat(D.name, '!') AND D.age = 11\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithFunctionAndReferenceCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND T.b = concat(D.name, '!')\n        |WHERE D.name LIKE 'Jack%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name\n        |FROM\n        |  MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinTemporalTableWithMultiConditionOnSameDimField() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id and CAST(T.c as INT) = D.id";
        this.util().verifyExecPlan(sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLookupTable(String tableName, UserDefinedFunction lookupFunction) {
        if (this.legacyTableSource) {
            UserDefinedFunction userDefinedFunction = lookupFunction;
            if (userDefinedFunction instanceof TableFunction) {
                TableFunction tableFunction = (TableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, tableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(userDefinedFunction instanceof AsyncTableFunction)) throw new MatchError((Object)userDefinedFunction);
                AsyncTableFunction asyncTableFunction = (AsyncTableFunction)userDefinedFunction;
                TestInvalidTemporalTable$.MODULE$.createTemporaryTable(this.util().tableEnv(), tableName, asyncTableFunction);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", " (\n           |  `id` INT,\n           |  `name` STRING,\n           |  `age` INT,\n           |  `ts` TIMESTAMP(3)\n           |) WITH (\n           |  'connector' = 'values',\n           |  'lookup-function-class' = '", "'\n           |)\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, lookupFunction.getClass().getName()})))).stripMargin());
        }
    }

    private void expectExceptionThrown(String sql, String message, Class<? extends Throwable> clazz) {
        try {
            this.verifyTranslationSuccess(sql);
            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a ", ", but no exception is thrown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz})));
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)clazz.isAssignableFrom(throwable.getClass()));
            Assert.assertThat((Object)throwable, (Matcher)FlinkMatchers.containsMessage((String)message));
        }
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    private void verifyTranslationSuccess(String sql) {
        this.util().tableEnv().sqlQuery(sql).explain(new ExplainDetail[0]);
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

