/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001U\u0011\u0001BS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0003\u0001\"\u0001,\u00035!Xm\u001d;J]:,'OS8j]R\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!t'D\u00016\u0015\t1$#A\u0003kk:LG/\u0003\u00029k\t!A+Z:u\u0011\u0015Q\u0004\u0001\"\u0001,\u0003a!Xm\u001d;J]:,'OS8j]^KG\u000f[#rk\u0006d\u0007k\u001b\u0015\u0003sMBQ!\u0010\u0001\u0005\u0002-\n1\u0003^3ti&sg.\u001a:K_&tw+\u001b;i!.D#\u0001P\u001a\t\u000b\u0001\u0003A\u0011A\u0016\u0002'Q,7\u000f\u001e'fMRTu.\u001b8O_:,\u0015/^5)\u0005}\u001a\u0004\"B\"\u0001\t\u0003Y\u0013A\b;fgRdUM\u001a;K_&tw+\u001b;i\u000bF,\u0018\r\u001c)l\u001d>tW)];jQ\t\u00115\u0007C\u0003G\u0001\u0011\u00051&A\u0011uKN$H*\u001a4u\u0015>LgnV5uQJKw\r\u001b;O_R\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002Fg!)\u0011\n\u0001C\u0001W\u0005IB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b)l\u001d>tW)];jQ\tA5\u0007C\u0003M\u0001\u0011\u00051&\u0001\u0007uKN$H*\u001a4u\u0015>Lg\u000e\u000b\u0002Lg!)q\n\u0001C\u0001W\u00059B/Z:u\u0019\u00164GOS8j]^KG\u000f[#rk\u0006d\u0007k\u001b\u0015\u0003\u001dNBQA\u0015\u0001\u0005\u0002-\n!\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5SS\u001eDGOT8u!.D#!U\u001a\t\u000bU\u0003A\u0011A\u0016\u0002%Q,7\u000f\u001e'fMRTu.\u001b8XSRD\u0007k\u001b\u0015\u0003)NBQ\u0001\u0017\u0001\u0005\u0002-\nA\u0003^3tiJKw\r\u001b;K_&tgj\u001c8FcVL\u0007FA,4\u0011\u0015Y\u0006\u0001\"\u0001,\u0003}!Xm\u001d;SS\u001eDGOS8j]^KG\u000f[#rk\u0006d\u0007k\u001b(p]\u0016\u000bX/\u001b\u0015\u00035NBQA\u0018\u0001\u0005\u0002-\n!\u0005^3tiJKw\r\u001b;K_&tw+\u001b;i%&<\u0007\u000e\u001e(piB[gj\u001c8FcVL\u0007FA/4\u0011\u0015\t\u0007\u0001\"\u0001,\u0003i!Xm\u001d;SS\u001eDGOS8j]^KG\u000f\u001b)l\u001d>tW)];jQ\t\u00017\u0007C\u0003e\u0001\u0011\u00051&A\u0007uKN$(+[4ii*{\u0017N\u001c\u0015\u0003GNBQa\u001a\u0001\u0005\u0002-\n\u0001\u0004^3tiJKw\r\u001b;K_&tw+\u001b;i\u000bF,\u0018\r\u001c)lQ\t17\u0007C\u0003k\u0001\u0011\u00051&A\u000euKN$(+[4ii*{\u0017N\\,ji\"\u0014\u0016n\u001a5u\u001d>$\bk\u001b\u0015\u0003SNBQ!\u001c\u0001\u0005\u0002-\n1\u0003^3tiJKw\r\u001b;K_&tw+\u001b;i!.D#\u0001\\\u001a\t\u000bA\u0004A\u0011A\u0016\u0002'Q,7\u000f\u001e$vY2Tu.\u001b8O_:,\u0015/^5)\u0005=\u001c\u0004\"B:\u0001\t\u0003Y\u0013A\b;fgR4U\u000f\u001c7K_&tw+\u001b;i\u000bF,\u0018\r\u001c)l\u001d>tW)];jQ\t\u00118\u0007C\u0003w\u0001\u0011\u00051&\u0001\u0011uKN$h)\u001e7m\u0015>LgnV5uQ\u001a+H\u000e\u001c(piB[gj\u001c8FcVL\u0007FA;4\u0011\u0015I\b\u0001\"\u0001,\u0003e!Xm\u001d;Gk2d'j\\5o/&$\b\u000eU6O_:,\u0015/^5)\u0005a\u001c\u0004\"\u0002?\u0001\t\u0003Y\u0013\u0001\u0004;fgR4U\u000f\u001c7K_&t\u0007FA>4\u0011\u0015y\b\u0001\"\u0001,\u0003]!Xm\u001d;Gk2d'j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002\u007fg!1\u0011Q\u0001\u0001\u0005\u0002-\n\u0011\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5Gk2dgj\u001c;QW\"\u001a\u00111A\u001a\t\r\u0005-\u0001\u0001\"\u0001,\u0003I!Xm\u001d;Gk2d'j\\5o/&$\b\u000eU6)\u0007\u0005%1\u0007\u0003\u0004\u0002\u0012\u0001!\taK\u0001\u0011i\u0016\u001cHoU3mM*{\u0017N\u001c)mC:D3!a\u00044\u0011\u0019\t9\u0002\u0001C\u0001W\u0005\u0001B/Z:u\u0015>LgnV5uQN{'\u000f\u001e\u0015\u0004\u0003+\u0019\u0004BBA\u000f\u0001\u0011\u00051&A\ruKN$H*\u001a4u\u001fV$XM\u001d&pS:,\u0015/^5Qe\u0016$\u0007fAA\u000eg!1\u00111\u0005\u0001\u0005\u0002-\n\u0011\u0005^3ti2+g\r^(vi\u0016\u0014(j\\5o\u000bF,\u0018.\u00118e\u0019>\u001c\u0017\r\u001c)sK\u0012D3!!\t4\u0011\u0019\tI\u0003\u0001C\u0001W\u0005\u0019C/Z:u\u0019\u00164GoT;uKJTu.\u001b8FcVL\u0017I\u001c3O_:,\u0015/^5Qe\u0016$\u0007fAA\u0014g!1\u0011q\u0006\u0001\u0005\u0002-\n!\u0004^3tiJKw\r\u001b;PkR,'OS8j]\u0016\u000bX/\u001b)sK\u0012D3!!\f4\u0011\u0019\t)\u0004\u0001C\u0001W\u0005\u0011C/Z:u%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u000bF,\u0018.\u00118e\u0019>\u001c\u0017\r\u001c)sK\u0012D3!a\r4\u0011\u0019\tY\u0004\u0001C\u0001W\u0005!C/Z:u%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u000bF,\u0018.\u00118e\u001d>tW)];j!J,G\rK\u0002\u0002:MBa!!\u0011\u0001\t\u0003Y\u0013!\f;fgRTu.\u001b8B]\u0012\u001cV\r\\3di>s\u0007+\u0019:uS\u0006d7i\\7q_NLG/\u001a)sS6\f'/_&fs\"\u001a\u0011qH\u001a\t\r\u0005\u001d\u0003\u0001\"\u0001,\u0003e!Xm\u001d;K_&tG)[:pe\u0012,'o\u00115b]\u001e,Gj\\4)\u0007\u0005\u00153\u0007")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("key");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("v");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("i");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("j");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("t");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("k");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("a1");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("a2");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("a3");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("b1");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("b2");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("b3");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$16 = Symbol$.MODULE$.apply("x");
    private static Symbol symbol$17 = Symbol$.MODULE$.apply("y");
    private static Symbol symbol$18 = Symbol$.MODULE$.apply("z");

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON a1 = b1");
    }

    @Test
    public void testInnerJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") JOIN (", ") ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") JOIN (", ") ON a2 = b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") LEFT JOIN (", ") ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") LEFT JOIN B ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") LEFT JOIN (", ") ON a2 = b2 AND a1 > b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") LEFT JOIN (", ") ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") LEFT JOIN B ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") LEFT JOIN (", ") ON a2 = b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") RIGHT JOIN (", ") ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") RIGHT JOIN B ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") RIGHT JOIN (", ") ON a2 = b2 AND a1 > b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") RIGHT JOIN (", ") ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") RIGHT JOIN B ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B group by b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") RIGHT JOIN (", ") ON a2 = b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") FULL JOIN (", ") ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") FULL JOIN B ON a1 = b1 AND a2 > b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") FULL JOIN (", ") ON a2 = b2 AND a1 > b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoin() {
        String query = "SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") FULL JOIN (", ") ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, b1 FROM (", ") FULL JOIN B ON a1 = b1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a1, a2, b1, b2 FROM (", ") FULL JOIN (", ") ON a2 = b2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query1, query2}));
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSelfJoinPlan() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2)}), new CaseClassTypeInfo<Tuple2<Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM (\n         |  SELECT * FROM src WHERE key = 0) src1\n         |LEFT OUTER JOIN (\n         |  SELECT * FROM src WHERE key = 0) src2\n         |ON (src1.key = src2.key AND src2.key > 10)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinWithSort() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$13 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$6)}), new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$14 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  MyTable3 FULL JOIN\n        |  (SELECT * FROM MyTable4 ORDER BY MyTable4.i DESC, MyTable4.k ASC) MyTable4\n        |  ON MyTable3.i = MyTable4.i and MyTable3.i = MyTable4.k\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z");
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2");
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z");
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2");
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testJoinAndSelectOnPartialCompositePrimaryKey() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE tableWithCompositePk (\n        |  pk1 INT,\n        |  pk2 BIGINT,\n        |  PRIMARY KEY (pk1, pk2) NOT ENFORCED\n        |) WITH (\n        |  'connector'='values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan("SELECT A.a1 FROM A LEFT JOIN tableWithCompositePk T ON A.a1 = T.pk1");
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE src (person String, votes BIGINT) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n        | (SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n        |   award\n        |   WHERE T.sum_votes = award.votes) T1, people T2\n        | WHERE T1.person = T2.person\n        |")).stripMargin());
    }

    public JoinTest() {
        this.util().addTableSource("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$10), package$.MODULE$.symbol2FieldExpression(symbol$11), package$.MODULE$.symbol2FieldExpression(symbol$12)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$13), package$.MODULE$.symbol2FieldExpression(symbol$14), package$.MODULE$.symbol2FieldExpression(symbol$15)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$16), package$.MODULE$.symbol2FieldExpression(symbol$17), package$.MODULE$.symbol2FieldExpression(symbol$18)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }
}

