/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001'\tqq+\u001b8e_^\u0014\u0016M\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQ\u0004^3ti\u000e\u000bg\u000e^'fe\u001e,w+\u001b8e_^$fKR0Uk6\u0014G.\u001a\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005)!.\u001e8ji&\u0011ag\r\u0002\u0005)\u0016\u001cH\u000fC\u00039\u0001\u0011\u0005\u0011&A\u0014uKN$8)\u00198u\u001b\u0016\u0014x-Z,j]\u0012|w\u000f\u0016,G?R+XN\u00197f\u001f:\u0004&o\\2uS6,\u0007FA\u001c2\u0011\u0015Y\u0004\u0001\"\u0001*\u0003i!Xm\u001d;DC:$X*\u001a:hK^Kg\u000eZ8x)Z3u\fS8qQ\tQ\u0014\u0007C\u0003?\u0001\u0011\u0005\u0011&\u0001\u0013uKN$8)\u00198u\u001b\u0016\u0014x-Z,j]\u0012|w\u000f\u0016,G?\"{\u0007o\u00148Qe>\u001cG/[7fQ\ti\u0014\u0007C\u0003B\u0001\u0011\u0005\u0011&A\u0010uKN$8)\u00198u\u001b\u0016\u0014x-Z,j]\u0012|w\u000f\u0016,G?\u000e+X.\u001e7bi\u0016D#\u0001Q\u0019\t\u000b\u0011\u0003A\u0011A\u0015\u0002SQ,7\u000f^\"b]RlUM]4f/&tGm\\<U-\u001a{6)^7vY\u0006$Xm\u00148Qe>\u001cG/[7fQ\t\u0019\u0015\u0007C\u0003H\u0001\u0011\u0005\u0011&A\u000euKN$xJ\u001c+v[\ndWmV5oI><\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003\rFBQA\u0013\u0001\u0005\u0002%\nQ\u0005^3ti>sG+^7cY\u0016<\u0016N\u001c3po\u0006;wM]3hCR,wJ\u001c)s_\u000e$\u0018.\\3)\u0005%\u000b\u0004\"B'\u0001\t\u0003I\u0013\u0001\u0007;fgR|e\u000eS8q/&tGm\\<BO\u001e\u0014XmZ1uK\"\u0012A*\r\u0005\u0006!\u0002!\t!K\u0001#i\u0016\u001cHo\u00148I_B<\u0016N\u001c3po\u0006;wM]3hCR,wJ\u001c)s_\u000e$\u0018.\\3)\u0005=\u000b\u0004\"B*\u0001\t\u0003I\u0013!\b;fgR|enQ;nk2\fG/Z,j]\u0012|w/Q4he\u0016<\u0017\r^3)\u0005I\u000b\u0004\"\u0002,\u0001\t\u0003I\u0013a\n;fgR|enQ;nk2\fG/Z,j]\u0012|w/Q4he\u0016<\u0017\r^3P]B\u0013xn\u0019;j[\u0016D#!V\u0019\t\u000be\u0003A\u0011A\u0015\u0002OQ,7\u000f\u001e+j[\u0016\fE\u000f\u001e:jEV$X\r\u0015:pa\u0006<\u0017\r^3G_J<\u0016N\u001c3poJ\u000bgn\u001b\u0015\u00031FBQ\u0001\u0018\u0001\u0005\u0002%\n\u0001\u0006^3tiRKW.Z!uiJL'-\u001e;f!J|\u0007/Y4bi\u00164uN],j]\u0012|wOU1oWFB#aW\u0019\t\u000b}\u0003A\u0011A\u0015\u0002!Q,7\u000f\u001e*b].4UO\\2uS>t\u0007F\u000102\u0011\u0015\u0011\u0007\u0001\"\u0001*\u0003U!Xm\u001d;EK:\u001cXMU1oW\u001a+hn\u0019;j_:D#!Y\u0019\t\u000b\u0015\u0004A\u0011A\u0015\u0002+Q,7\u000f\u001e,be&\f'\r\\3SC:\\'+\u00198hK\"\u0012A-\r")
public class WindowRankTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testCantMergeWindowTVF_Tumble() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_TumbleOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_Hop() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_HopOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_Cumulate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCantMergeWindowTVF_CumulateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Processing time Window TopN is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testOnHopWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Processing time Window TopN is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testOnCumulateWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(\n        |     PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(\n        |     PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Processing time Window TopN is not supported yet.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowRank() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp AS\n        |SELECT window_time as rowtime, a, b, c, d, e\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   weightedAvg(b, e) AS wAvg,\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE tmp, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowRank1() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp1 AS\n        |SELECT window_time as rowtime, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY cnt DESC) as rownum\n        |  FROM (\n        |    SELECT\n        |      a,\n        |      window_start,\n        |      window_end,\n        |      window_time,\n        |      count(*) as cnt,\n        |      sum(d) as sum_d,\n        |      max(d) filter (where b > 1000) as max_d,\n        |      weightedAvg(b, e) AS wAvg,\n        |      count(distinct c) AS uv\n        |    FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |    GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   sum(cnt),\n        |   sum(sum_d),\n        |   max(max_d)\n        |FROM TABLE(TUMBLE(TABLE tmp1, DESCRIPTOR(rowtime), INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testRankFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   RANK() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testDenseRankFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   DENSE_RANK() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("DENSE_RANK() function is not supported on Window TopN currently, only ROW_NUMBER() is supported.");
        this.util().verifyExplain(sql);
    }

    @Test
    public void testVariableRankRange() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT window_start, window_end, window_time, a, cnt, sum_d, max_d, wAvg, uv\n        |FROM (\n        |SELECT *,\n        |   ROW_NUMBER() OVER(PARTITION BY window_start, window_end ORDER BY cnt DESC) as rownum\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    sum(d) as sum_d,\n        |    max(d) filter (where b > 1000) as max_d,\n        |    max(b) as max_b,\n        |    weightedAvg(b, e) AS wAvg,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |  )\n        |)\n        |WHERE rownum <= max_b\n      ")).stripMargin();
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Rank strategy rankEnd=max_b is not supported on window rank currently.");
        this.util().verifyExplain(sql);
    }

    public WindowRankTest() {
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |CREATE TABLE MyTable (\n       |  a INT,\n       |  b BIGINT,\n       |  c STRING NOT NULL,\n       |  d DECIMAL(10, 3),\n       |  e BIGINT,\n       |  rowtime TIMESTAMP(3),\n       |  proctime as PROCTIME(),\n       |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n       |) with (\n       |  'connector' = 'values'\n       |)\n       |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }
}

