/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.utils.JavaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;

public class NullTypeTest
extends TableTestBase {
    private final JavaStreamTableTestUtil util = this.javaStreamTestUtil();

    @Test
    public void testValues() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Illegal use of 'NULL'");
        this.util.verifyExecPlan("SELECT * FROM (VALUES (1, NULL), (2, NULL)) AS T(a, b)");
    }

    @Test
    public void testValuesWithoutTypeCoercion() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Illegal use of 'NULL'");
        this.util.verifyExecPlan("SELECT * FROM (VALUES (1, NULL), (2, 1)) AS T(a, b)");
    }

    @Test
    public void testSetOperationWithoutTypeCoercion() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Parameters must be of the same type");
        this.util.verifyExecPlan("SELECT ARRAY[1,2] IN (ARRAY[1], ARRAY[1,2], ARRAY[NULL, NULL, NULL])");
    }

    @Test
    public void testBuiltInFunction() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Illegal use of 'NULL'");
        this.util.verifyExecPlan("SELECT ABS(NULL)");
    }

    @Test
    public void testArrayConstructor() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Parameters must be of the same type");
        this.util.verifyExecPlan("SELECT ARRAY[NULL]");
    }

    @Test
    public void testMapConstructor() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Parameters must be of the same type");
        this.util.verifyExecPlan("SELECT MAP[NULL, NULL]");
    }

    @Test
    public void testFunctionReturningNull() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("SQL validation failed. Invalid function call");
        this.util.addTemporarySystemFunction("NullTypeFunction", NullTypeFunction.class);
        this.util.verifyExecPlan("SELECT NullTypeFunction(12)");
    }

    @Test
    public void testNestedNull() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("SQL validation failed. Invalid function call");
        this.util.addTemporarySystemFunction("NestedNullTypeFunction", NestedNullTypeFunction.class);
        this.util.verifyExecPlan("SELECT NestedNullTypeFunction(12)");
    }

    public static class NestedNullTypeFunction
    extends ScalarFunction {
        @DataTypeHint(value="ARRAY<NULL>")
        public Object eval(Integer i) {
            return null;
        }
    }

    public static class NullTypeFunction
    extends ScalarFunction {
        @DataTypeHint(value="NULL")
        public Object eval(Integer i) {
            return null;
        }
    }
}

