/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.CustomConnectorDescriptor;
import org.apache.flink.table.descriptors.Rowtime;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource$;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource;
import org.apache.flink.table.planner.utils.TestLegacyProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.planner.utils.TestTableSource$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001M\u0011Q\u0003T3hC\u000eLH+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003b\u0002\u0015\u0001\u0005\u0004%I!K\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017-F\u0001+!\tYc&D\u0001-\u0015\ti#\"A\u0002ba&L!a\f\u0017\u0003\u0017Q\u000b'\r\\3TG\",W.\u0019\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0019Q\f'\r\\3TG\",W.\u0019\u0011\t\u000bM\u0002A\u0011\u0001\u001b\u0002\u000bM,G/\u001e9\u0015\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012A!\u00168ji\"\u0012!\u0007\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fA\tQA[;oSRL!!\u0011 \u0003\r\t+gm\u001c:f\u0011\u0015\u0019\u0005\u0001\"\u00015\u0003q!Xm\u001d;C_VtG-\u001a3TiJ,\u0017-\u001c+bE2,7k\\;sG\u0016D#AQ#\u0011\u0005u2\u0015BA$?\u0005\u0011!Vm\u001d;\t\u000b%\u0003A\u0011\u0001\u001b\u0002=Q,7\u000f^+oE>,h\u000eZ3e'R\u0014X-Y7UC\ndWmU8ve\u000e,\u0007F\u0001%F\u0011\u0015a\u0005\u0001\"\u00015\u0003\r\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i\u0019>twMU8x)&lWMR5fY\u0012D#aS#\t\u000b=\u0003A\u0011\u0001\u001b\u0002QQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5US6,7\u000f^1naJ{w\u000fV5nK\u001aKW\r\u001c3)\u00059+\u0005\"\u0002*\u0001\t\u0003!\u0014!\t;fgR\u0014vn\u001e+j[\u0016$\u0016M\u00197f'>,(oY3He>,\boV5oI><\bFA)F\u0011\u0015)\u0006\u0001\"\u00015\u0003\u0005\"Xm\u001d;MK\u001e\f7-\u001f*poRKW.\u001a+bE2,wI]8va^Kg\u000eZ8xQ\t!V\tC\u0003Y\u0001\u0011\u0005A'\u0001\u0012uKN$H*Z4bGf\u0004&o\\2US6,G+\u00192mK\u001e\u0013x.\u001e9XS:$wn\u001e\u0015\u0003/\u0016CQa\u0017\u0001\u0005\u0002Q\nQ\u0004^3tiB\u0013xn\u0019+j[\u0016$\u0016M\u00197f'>,(oY3TS6\u0004H.\u001a\u0015\u00035\u0016CQA\u0018\u0001\u0005\u0002Q\na\u0004^3tiB\u0013xN[3di^KG\u000f\u001b*poRLW.\u001a)s_\u000e$\u0018.\\3)\u0005u+\u0005\"B1\u0001\t\u0003!\u0014!\u0007;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5pkR\u0014vn\u001e;j[\u0016D#\u0001Y#\t\u000b\u0011\u0004A\u0011\u0001\u001b\u00025Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f\u001e)s_\u000e$\u0018.\\3\t\u000b\u0019\u0004A\u0011\u0001\u001b\u0002/Q,7\u000f\u001e)s_*,7\r^(oYf\u0004&o\\2uS6,\u0007\"\u00025\u0001\t\u0003!\u0014A\u0006;fgR\u0004&o\u001c6fGR|e\u000e\\=S_^$\u0018.\\3\t\u000b)\u0004A\u0011\u0001\u001b\u0002-Q,7\u000f\u001e)s_*,7\r^,ji\"l\u0015\r\u001d9j]\u001eD#![#\t\u000b5\u0004A\u0011\u0001\u001b\u0002#Q,7\u000f\u001e(fgR,G\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002m\u000b\")\u0001\u000f\u0001C\u0001i\u0005QB/Z:u!J|'.Z2u/&$\bn\\;u\u0013:\u0004X\u000f\u001e*fM\"\u0012q.\u0012\u0005\u0006g\u0002!\t\u0001N\u0001\u0016i\u0016\u001cHOR5mi\u0016\u00148)\u00198QkNDGi\\<oQ\t\u0011X\tC\u0003w\u0001\u0011\u0005A'\u0001\ruKN$h)\u001b7uKJ\u001c\u0015M\u001c8piB+8\u000f\u001b#po:D#!^#\t\u000be\u0004A\u0011\u0001\u001b\u00023Q,7\u000f\u001e$jYR,'\u000fU1si&\fG\u000eU;tQ\u0012{wO\u001c\u0015\u0003q\u0016CQ\u0001 \u0001\u0005\u0002Q\nq\u0003^3ti\u001aKG\u000e^3s\rVdG.\u001f)vg\"$un\u001e8)\u0005m,\u0005\"B@\u0001\t\u0003!\u0014!\u0007;fgR4\u0015\u000e\u001c;fe\u000e\u000bgN\\8u!V\u001c\b\u000eR8x]JB#A`#\t\r\u0005\u0015\u0001\u0001\"\u00015\u0003e!Xm\u001d;GS2$XM]\"b]:|G\u000fU;tQ\u0012{wO\\\u001a)\u0007\u0005\rQ\t\u0003\u0004\u0002\f\u0001!\t\u0001N\u0001(i\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h.\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000eK\u0002\u0002\n\u0015Ca!!\u0005\u0001\t\u0003!\u0014!\u0007;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b#po:<\u0016\u000e\u001e5VI\u001aD3!a\u0004F\u0011\u0019\t9\u0002\u0001C\u0001i\u0005AB/Z:u!\u0006\u0014H/\u001b;j_:$\u0016M\u00197f'>,(oY3)\u0007\u0005UQ\t\u0003\u0004\u0002\u001e\u0001!\t\u0001N\u0001 i\u0016\u001cH\u000fU1si&$\u0018n\u001c8UC\ndWmU8ve\u000e,w+\u001b;i+\u00124\u0007fAA\u000e\u000b\"1\u00111\u0005\u0001\u0005\u0002Q\n\u0011\u0005^3tiRKW.\u001a'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]B+8\u000f\u001b#po:D3!!\tF\u0001")
public class LegacyTableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()})).build();

    private StreamTableTestUtil util() {
        return this.util;
    }

    private TableSchema tableSchema() {
        return this.tableSchema;
    }

    @Before
    public void setup() {
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), TestLegacyFilterableTableSource$.MODULE$.defaultSchema(), "FilterableTable", TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$4(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$5(), TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable$default$6());
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(this.util().tableEnv(), "PartitionableTable", false);
    }

    @Test
    public void testBoundedStreamTableSource() {
        TestTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), true, this.tableSchema(), "MyTable");
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testUnboundedStreamTableSource() {
        TestTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), false, this.tableSchema(), "MyTable");
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testTableSourceWithLongRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("rowTimeT", new TestTableSourceWithTime(false, tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(rowtime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM rowTimeT WHERE val > 100\n        |   GROUP BY name, TUMBLE(rowtime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLegacyRowTimeTableGroupWindow() {
        this.util().tableEnv().connect((ConnectorDescriptor)new CustomConnectorDescriptor("TestTableSourceWithTime", 1, false)).withSchema(new Schema().field("id", DataTypes.INT()).field("val", DataTypes.BIGINT()).field("name", DataTypes.STRING()).field("rowtime", DataTypes.TIMESTAMP((int)3)).rowtime(new Rowtime().timestampsFromField("rowtime").watermarksPeriodicBounded(1000L))).createTemporaryTable("rowTimeT");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(rowtime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM rowTimeT WHERE val > 100\n        |    GROUP BY name, TUMBLE(rowtime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLegacyProcTimeTableGroupWindow() {
        this.util().tableEnv().connect((ConnectorDescriptor)new CustomConnectorDescriptor("TestTableSourceWithTime", 1, false)).withSchema(new Schema().field("id", DataTypes.INT()).field("val", DataTypes.BIGINT()).field("name", DataTypes.STRING()).field("proctime", DataTypes.TIMESTAMP_LTZ((int)3)).proctime()).createTemporaryTable("procTimeT");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(proctime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM procTimeT WHERE val > 100\n        |    GROUP BY name, TUMBLE(proctime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testProcTimeTableSourceSimple() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "pTime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        boolean x$1 = false;
        TableSchema x$2 = tableSchema;
        RowTypeInfo x$3 = returnType;
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$5 = "pTime";
        String x$6 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        Map<String, String> x$7 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7();
        String x$8 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8();
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("procTimeT", new TestTableSourceWithTime(x$1, x$2, x$3, x$4, x$6, x$5, x$7, x$8));
        this.util().verifyExecPlan("SELECT pTime, id, name, val FROM procTimeT");
    }

    @Test
    public void testProjectWithRowtimeProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        this.util().verifyExecPlan("SELECT name, val, id FROM T");
    }

    @Test
    public void testProjectWithoutRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING(), Types.LONG(), Types.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        this.util().verifyExecPlan("SELECT ptime, name, val, id FROM T");
    }

    public void testProjectWithoutProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        ((TableEnvironmentInternal)util.tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        util.verifyExecPlan("select name, val, rtime, id from T");
    }

    public void testProjectOnlyProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        this.util().verifyExecPlan("SELECT ptime FROM T");
    }

    public void testProjectOnlyRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        this.util().verifyExecPlan("SELECT rtime FROM T");
    }

    @Test
    public void testProjectWithMapping() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LONG(), Types.LOCAL_DATE_TIME(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.LONG(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", (Map<String, String>)mapping));
        this.util().verifyExecPlan("SELECT name, rtime, val FROM T");
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProjectWithoutInputRef() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"id", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestLegacyProjectableTableSource(false, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), null, null, TestLegacyProjectableTableSource$.MODULE$.$lessinit$greater$default$7()));
        this.util().verifyExecPlan("SELECT COUNT(1) FROM T");
    }

    @Test
    public void testFilterCanPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2");
    }

    @Test
    public void testFilterCannotPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE price > 10");
    }

    @Test
    public void testFilterPartialPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND price > 10");
    }

    @Test
    public void testFilterFullyPushDown() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    public void testFilterCannotPushDown2() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 OR price > 10");
    }

    @Test
    public void testFilterCannotPushDown3() {
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    public void testFilterPushDownUnconvertedExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM FilterableTable WHERE\n        |    amount > 2 AND id < 100 AND CAST(amount AS BIGINT) > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownWithUdf() {
        this.util().addFunction("myUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM FilterableTable WHERE amount > 2 AND myUdf(amount) < 32");
    }

    @Test
    public void testPartitionTableSource() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 > 1 and id > 2 AND part1 = 'A' ");
    }

    @Test
    public void testPartitionTableSourceWithUdf() {
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @Test
    public void testTimeLiteralExpressionPushDown() {
        TableSchema schema = TableSchema.builder().field("id", DataTypes.INT()).field("dv", DataTypes.DATE()).field("tv", DataTypes.TIME()).field("tsv", DataTypes.TIMESTAMP((int)3)).build();
        Row row2 = new Row(4);
        row2.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        row2.setField(1, (Object)DateTimeTestUtil$.MODULE$.localDate("2017-01-23"));
        row2.setField(2, (Object)DateTimeTestUtil$.MODULE$.localTime("14:23:02"));
        row2.setField(3, (Object)DateTimeTestUtil$.MODULE$.localDateTime("2017-01-24 12:45:01.234"));
        TestLegacyFilterableTableSource$.MODULE$.createTemporaryTable(this.util().tableEnv(), schema, "FilterableTable1", false, (List<Row>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row2})), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dv", "tv", "tsv"})));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT id FROM FilterableTable1 WHERE\n         |  tv > TIME '14:25:02' AND\n         |  dv > DATE '2017-02-03' AND\n         |  tsv > TIMESTAMP '2017-02-03 14:25:02.000'\n      "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

