/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001M\u0011\u0001bQ1mGR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\buKN$xJ\u001c7z!J|'.Z2u)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0011!Vm\u001d;\t\u000ba\u0002A\u0011A\u0015\u0002+Q,7\u000f\u001e)s_*,7\r^,ji\"t\u0015-\\5oO\"\u0012q'\r\u0005\u0006w\u0001!\t!K\u0001\u0012i\u0016\u001cH/T;mi&\u0004&o\u001c6fGR\u001c\bF\u0001\u001e2\u0011\u0015q\u0004\u0001\"\u0001*\u00039!Xm\u001d;P]2Lh)\u001b7uKJD#!P\u0019\t\u000b\u0005\u0003A\u0011A\u0015\u0002+Q,7\u000f\u001e#jg*,hn\u0019;jm\u00164\u0015\u000e\u001c;fe\"\u0012\u0001)\r\u0005\u0006\t\u0002!\t!K\u0001\u0016i\u0016\u001cHoQ8oUVt7\r^5wK\u001aKG\u000e^3sQ\t\u0019\u0015\u0007C\u0003H\u0001\u0011\u0005\u0011&\u0001\tuKN$X*\u001e7uS\u001aKG\u000e^3sg\"\u0012a)\r\u0005\u0006\u0015\u0002!\t!K\u0001\u0015i\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/\u00118e\r&dG/\u001a:)\u0005%\u000b\u0004\"B'\u0001\t\u0003I\u0013A\u0002;fgRLe\u000e\u000b\u0002Mc!)\u0001\u000b\u0001C\u0001S\u0005YB/Z:u\r&dG/\u001a:P]:{g.Q:dS&d\u0015\u000e^3sC2D#aT\u0019\t\u000bM\u0003A\u0011A\u0015\u0002\u0013Q,7\u000f\u001e(pi&s\u0007F\u0001*2\u0011\u00151\u0006\u0001\"\u0001*\u0003Y!Xm\u001d;Nk2$\u0018\u000e\u001d7f\r2\fG\u000f^3oS:<\u0007FA+2\u0011\u0015I\u0006\u0001\"\u0001*\u0003E!Xm\u001d;J]Z\fG.\u001b3GS\u0016dGm\u001d\u0015\u00051FZF,\u0001\u0005fqB,7\r^3eG\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011\u000b\u0003\r\t\u0007/[\u0005\u0003E~\u00131CV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001\u001a\u0001\u0005\u0002%\nA\u0003^3tiB\u0013\u0018.\\5uSZ,W*\u00199UsB,\u0007FA22\u0011\u00159\u0007\u0001\"\u0001*\u0003]!Xm\u001d;O_:\u0004&/[7ji&4X-T1q)f\u0004X\r\u000b\u0002gc!)!\u000e\u0001C\u0001S\u0005YA/Z:u%><H+\u001f9fQ\tI\u0017\u0007C\u0003n\u0001\u0011\u0005\u0011&A\u0007uKN$\u0018I\u001d:bsRK\b/\u001a\u0015\u0003YFBQ\u0001\u001d\u0001\u0005\u0002%\nq\u0003^3tiB\u0013xN[3di^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005=\f\u0004\"B:\u0001\t\u0003I\u0013A\u0006;fgR4\u0015\u000e\u001c;fe^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005I\f\u0004\"\u0002<\u0001\t\u0003I\u0013\u0001\u0004;fgR\u0004vN[8UsB,\u0007FA;2\u0011\u0015I\b\u0001\"\u0001*\u00035!Xm\u001d;NSb,G\rV=qK\"\u0012\u00010\r\u0005\u0006y\u0002!\t!K\u0001\u001ai\u0016\u001cHo\u0014:XSRD\u0017j\u001d(vY2\u0004&/\u001a3jG\u0006$X\r\u000b\u0002|c!)q\u0010\u0001C\u0001S\u0005!B/Z:u\u001fJ<\u0016\u000e\u001e5Jg:+H\u000e\\%o\u0013\u001aD#A`\u0019")
public class CalcTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'"})).s((Seq)Nil$.MODULE$);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterOnNonAsciiLiteral() {
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT a, b, c, c || TRIM(' \u4e16\u754c ') FROM MyTable WHERE c = '\u4f60\u597d'"})).s((Seq)Nil$.MODULE$);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'"})).s((Seq)Nil$.MODULE$);
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFields() {
        this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable");
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$15 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (TypeInformation[])((Object[])new TypeInformation[]{TypeExtractor.createTypeInfo(MyPojo.class)}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$16 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    public CalcTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }
}

