/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.FlinkBatchRuleSets$;
import org.apache.flink.table.planner.plan.rules.FlinkStreamRuleSets$;
import org.apache.flink.table.planner.plan.rules.logical.PythonCalcSplitRuleTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001M\u0011q\u0003U=uQ>t7)\u00197d'Bd\u0017\u000e\u001e*vY\u0016$Vm\u001d;\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0015\u0019X\r^;q)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u00059C/Z:u!f$\bn\u001c8Gk:\u001cG/[8o\u0003NLe\u000e];u\u001f\u001aT\u0015M^1Gk:\u001cG/[8oQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&A\u0014uKN$\b+\u001f;i_:4UO\\2uS>tW*\u001b=fI^KG\u000f\u001b&bm\u00064UO\\2uS>t\u0007FA\u001f;\u0011\u0015\t\u0005\u0001\"\u0001*\u0003Q\"Xm\u001d;QsRDwN\u001c$v]\u000e$\u0018n\u001c8NSb,GmV5uQ*\u000bg/\u0019$v]\u000e$\u0018n\u001c8J]^CWM]3DY\u0006,8/\u001a\u0015\u0003\u0001jBQ\u0001\u0012\u0001\u0005\u0002%\nq\u0004^3tiBKH\u000f[8o\rVt7\r^5p]&sw\u000b[3sK\u000ec\u0017-^:fQ\t\u0019%\bC\u0003H\u0001\u0011\u0005\u0011&\u0001\u000euKN$8\t[1j]&tw\rU=uQ>tg)\u001e8di&|g\u000e\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005IB/Z:u\u001f:d\u0017p\u00148f!f$\bn\u001c8Gk:\u001cG/[8oQ\tI%\bC\u0003N\u0001\u0011\u0005\u0011&\u0001\u0014uKN$xJ\u001c7z\u001f:,\u0007+\u001f;i_:4UO\\2uS>t\u0017J\\,iKJ,7\t\\1vg\u0016D#\u0001\u0014\u001e\t\u000bA\u0003A\u0011A\u0015\u0002+Q,7\u000f\u001e$jK2$g*Y7f+:L\u0017/^5gs\"\u0012qJ\u000f\u0005\u0006'\u0002!\t!K\u0001\fi\u0016\u001cH\u000fT5uKJ\fG\u000e\u000b\u0002Su!)a\u000b\u0001C\u0001S\u0005)B/Z:u%\u0016|'\u000fZ3s!f$\bn\u001c8DC2\u001c\u0007FA+;\u0011\u0015I\u0006\u0001\"\u0001*\u0003\u001d\"Xm\u001d;QC:$\u0017m\u001d$v]\u000e$\u0018n\u001c8Bg&s\u0007/\u001e;PM*\u000bg/\u0019$v]\u000e$\u0018n\u001c8)\u0005aS\u0004\"\u0002/\u0001\t\u0003I\u0013a\n;fgR\u0004\u0016M\u001c3bg\u001a+hn\u0019;j_:l\u0015\u000e_3e/&$\bNS1wC\u001a+hn\u0019;j_:D#a\u0017\u001e\t\u000b}\u0003A\u0011A\u0015\u0002iQ,7\u000f\u001e)b]\u0012\f7OR;oGRLwN\\'jq\u0016$w+\u001b;i\u0015\u00064\u0018MR;oGRLwN\\%o/\",'/Z\"mCV\u001cX\r\u000b\u0002_u!)!\r\u0001C\u0001S\u0005yB/Z:u!\u0006tG-Y:Gk:\u001cG/[8o\u0013:<\u0006.\u001a:f\u00072\fWo]3)\u0005\u0005T\u0004\"B3\u0001\t\u0003I\u0013A\u0007;fgR\u001c\u0005.Y5oS:<\u0007+\u00198eCN4UO\\2uS>t\u0007F\u00013;\u0011\u0015A\u0007\u0001\"\u0001*\u0003e!Xm\u001d;P]2LxJ\\3QC:$\u0017m\u001d$v]\u000e$\u0018n\u001c8)\u0005\u001dT\u0004\"B6\u0001\t\u0003I\u0013A\n;fgR|e\u000e\\=P]\u0016\u0004\u0016M\u001c3bg\u001a+hn\u0019;j_:Len\u00165fe\u0016\u001cE.Y;tK\"\u0012!N\u000f\u0005\u0006]\u0002!\t!K\u00011i\u0016\u001cH\u000fU1oI\u0006\u001ch)\u001e8di&|g.T5yK\u0012<\u0016\u000e\u001e5HK:,'/\u00197QsRDwN\u001c$v]\u000e$\u0018n\u001c8)\u00055T\u0004\"B9\u0001\t\u0003I\u0013A\u000e;fgR\u0004\u0016M\u001c3bg\u001a+hn\u0019;j_:tu\u000e^\"iC&t\u0017N\\4XSRDw)\u001a8fe\u0006d\u0007+\u001f;i_:4UO\\2uS>t\u0007F\u00019;\u0011\u0015!\b\u0001\"\u0001*\u0003\u0015\"Xm\u001d;QsRDwN\u001c$v]\u000e$\u0018n\u001c8XSRD7i\\7q_NLG/Z%oaV$8\u000f\u000b\u0002tu!)q\u000f\u0001C\u0001S\u0005\u0019D/Z:u!f$\bn\u001c8Gk:\u001cG/[8o/&$\bnQ8na>\u001c\u0018\u000e^3J]B,Ho]!oI^CWM]3DY\u0006,8/\u001a\u0015\u0003mjBQA\u001f\u0001\u0005\u0002%\nQ\u0006^3ti\u000eC\u0017-\u001b8j]\u001e\u0004\u0016\u0010\u001e5p]\u001a+hn\u0019;j_:<\u0016\u000e\u001e5D_6\u0004xn]5uK&s\u0007/\u001e;tQ\tI(\bC\u0003~\u0001\u0011\u0005\u0011&A\u0013uKN$\b+\u00198eCN4UO\\2uS>tw+\u001b;i\u0007>l\u0007o\\:ji\u0016Le\u000e];ug\"\u0012AP\u000f\u0005\u0007\u0003\u0003\u0001A\u0011A\u0015\u0002MQ,7\u000f\u001e)zi\"|gNR;oGRLwN\\,ji\"\u001cu.\u001c9pg&$XmT;uaV$8\u000f\u000b\u0002\u0000u!1\u0011q\u0001\u0001\u0005\u0002%\na\u0006^3tiBKH\u000f[8o\rVt7\r^5p]^KG\u000f['vYRL\u0007\u000f\\3D_6\u0004xn]5uK>+H\u000f];ug\"\u001a\u0011Q\u0001\u001e\t\r\u00055\u0001\u0001\"\u0001*\u0003=\"Xm\u001d;QsRDwN\u001c$v]\u000e$\u0018n\u001c8XSRD7i\\7q_NLG/Z%oaV$8/\u00118e\u001fV$\b/\u001e;tQ\r\tYA\u000f\u0005\u0007\u0003'\u0001A\u0011A\u0015\u0002UQ,7\u000f\u001e)zi\"|gNR;oGRLwN\\,ji\"\u001cu.\u001c9pg&$Xm\u00165fe\u0016\u001cE.Y;tK\"\u001a\u0011\u0011\u0003\u001e")
public class PythonCalcSplitRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f2");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("logical", (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(FlinkBatchRuleSets$.MODULE$.LOGICAL_OPT_RULES()).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.LOGICAL()})).build());
        programs.addLast("logical_rewrite", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(FlinkStreamRuleSets$.MODULE$.LOGICAL_REWRITE()).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}), new CaseClassTypeInfo<Tuple4<Object, Object, Object, Tuple2<Object, Object>>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$5 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, Object, Tuple2<Object, Object>>>(this, fieldSerializers){

                    public Tuple4<Object, Object, Object, Tuple2<Object, Object>> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((Tuple2)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addFunction("pyFunc1", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc1"));
        this.util().addFunction("pyFunc2", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc2"));
        this.util().addFunction("pyFunc3", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc3"));
        this.util().addFunction("pyFunc4", new JavaUserDefinedScalarFunctions.BooleanPythonScalarFunction("pyFunc4"));
        this.util().addFunction("pyFunc5", new JavaUserDefinedScalarFunctions.RowPythonScalarFunction("pyFunc5"));
        this.util().addFunction("RowJavaFunc", new JavaUserDefinedScalarFunctions.RowJavaScalarFunction("RowJavaFunc"));
        this.util().addFunction("pandasFunc1", new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc1"));
        this.util().addFunction("pandasFunc2", new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc2"));
        this.util().addFunction("pandasFunc3", new JavaUserDefinedScalarFunctions.PandasScalarFunction("pandasFunc3"));
        this.util().addFunction("pandasFunc4", new JavaUserDefinedScalarFunctions.BooleanPandasScalarFunction("pandasFunc4"));
    }

    @Test
    public void testPythonFunctionAsInputOfJavaFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionMixedWithJavaFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b), c + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionMixedWithJavaFunctionInWhereClause() {
        String sqlQuery = "SELECT pyFunc1(a, b), c + 1 FROM MyTable WHERE pyFunc2(a, c) > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionInWhereClause() {
        String sqlQuery = "SELECT pyFunc1(a, b) FROM MyTable WHERE pyFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPythonFunction() {
        String sqlQuery = "SELECT pyFunc3(pyFunc2(a + pyFunc1(a, c), b), c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePythonFunction() {
        String sqlQuery = "SELECT pyFunc1(a, b) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePythonFunctionInWhereClause() {
        String sqlQuery = "SELECT a, b FROM MyTable WHERE pyFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFieldNameUniquify() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$5), package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        String sqlQuery = "SELECT pyFunc1(f1, f2), f0 + 1 FROM MyTable2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testLiteral() {
        String sqlQuery = "SELECT a, b, pyFunc1(a, c), 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testReorderPythonCalc() {
        String sqlQuery = "SELECT a, pyFunc1(a, c), b FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionAsInputOfJavaFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithJavaFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b), c + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithJavaFunctionInWhereClause() {
        String sqlQuery = "SELECT pandasFunc1(a, b), c + 1 FROM MyTable WHERE pandasFunc2(a, c) > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionInWhereClause() {
        String sqlQuery = "SELECT pandasFunc1(a, b) FROM MyTable WHERE pandasFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPandasFunction() {
        String sqlQuery = "SELECT pandasFunc3(pandasFunc2(a + pandasFunc1(a, c), b), c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePandasFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testOnlyOnePandasFunctionInWhereClause() {
        String sqlQuery = "SELECT a, b FROM MyTable WHERE pandasFunc4(a, c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionMixedWithGeneralPythonFunction() {
        String sqlQuery = "SELECT pandasFunc1(a, b), pyFunc1(a, c) + 1, a + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionNotChainingWithGeneralPythonFunction() {
        String sqlQuery = "SELECT pyFunc1(a, pandasFunc1(a, b)) + 1 FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pyFunc1(b, d._1) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputsAndWhereClause() {
        String sqlQuery = "SELECT a, pyFunc1(b, d._1) FROM MyTable WHERE a + 1 > 0";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testChainingPythonFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pyFunc1(b, pyFunc1(c, d._1)) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPandasFunctionWithCompositeInputs() {
        String sqlQuery = "SELECT a, pandasFunc1(b, d._1) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeOutputs() {
        String sqlQuery = "SELECT e.* FROM (SELECT pyFunc5(a) as e FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithMultipleCompositeOutputs() {
        String sqlQuery = "SELECT e.*, f.* FROM (SELECT pyFunc5(a) as e, pyFunc5(b) as f FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeInputsAndOutputs() {
        String sqlQuery = "SELECT e.* FROM (SELECT pyFunc5(d._1) as e FROM MyTable) AS T";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testPythonFunctionWithCompositeWhereClause() {
        String sqlQuery = "SELECT a + 1 FROM MyTable where RowJavaFunc(pyFunc5(a).f0).f0 is NULL and b > 0";
        this.util().verifyRelPlan(sqlQuery);
    }
}

