/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Test;

public abstract class PushFilterIntoTableSourceScanRuleTestBase
extends TableTestBase {
    protected TableTestUtil util;

    @Test
    public void testCanPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2");
    }

    @Test
    public void testCanPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2");
    }

    @Test
    public void testCannotPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE price > 10");
    }

    @Test
    public void testCannotPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE price > 10");
    }

    @Test
    public void testPartialPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND price > 10");
    }

    @Test
    public void testPartialPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 AND price > 10");
    }

    @Test
    public void testFullyPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    public void testFullyPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    public void testPartialPushDown2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 OR price > 10");
    }

    @Test
    public void testPartialPushDown2WithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 OR price > 10");
    }

    @Test
    public void testCannotPushDown3() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    public void testCannotPushDown3WithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    public void testUnconvertedExpression() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE\n    amount > 2 AND id < 100 AND CAST(amount AS BIGINT) > 10");
    }

    @Test
    public void testWithUdf() {
        this.util.addFunction("myUdf", Func1$.MODULE$);
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND myUdf(amount) < 32");
    }

    @Test
    public void testLowerUpperPushdown() {
        this.util.verifyRelPlan("SELECT * FROM MTable WHERE LOWER(a) = 'foo' AND UPPER(b) = 'bar'");
    }

    @Test
    public void testWithInterval() {
        this.util.verifyRelPlan("SELECT * FROM MTable\nWHERE TIMESTAMPADD(HOUR, 5, a) >= b\nOR\nTIMESTAMPADD(YEAR, 2, b) >= a");
    }

    @Test
    public void testCannotPushDownIn() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE name IN ('Alice', 'Bob', 'Dave')");
    }

    @Test
    public void testWithNullLiteral() {
        this.util.verifyRelPlan("WITH MyView AS (SELECT CASE\n  WHEN amount > 0 THEN name\n  ELSE CAST(NULL AS STRING)\n  END AS a\n  FROM MyTable)\nSELECT a FROM MyView WHERE a IS NOT NULL\n");
    }
}

