/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.rules.logical.PruneAggregateCallRuleTestBase$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0001\u0002\u0002\u0002M\u0011a\u0004\u0015:v]\u0016\fum\u001a:fO\u0006$XmQ1mYJ+H.\u001a+fgR\u0014\u0015m]3\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013E\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0015\u0019X\r^;q)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012!\u00026v]&$\u0018B\u0001\u001c4\u0005\u0019\u0011UMZ8sK\")\u0001\b\u0001C\u0001S\u00051C/Z:u!J,h.\u001a*fOVd\u0017M]!hO\u000e\u000bG\u000e\\0XSRDw.\u001e;GS2$XM]\u0019)\u0005]R\u0004C\u0001\u001a<\u0013\ta4G\u0001\u0003UKN$\b\"\u0002 \u0001\t\u0003I\u0013A\n;fgR\u0004&/\u001e8f%\u0016<W\u000f\\1s\u0003\u001e<7)\u00197m?^KG\u000f[8vi\u001aKG\u000e^3se!\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001'i\u0016\u001cH\u000f\u0015:v]\u0016\u0014VmZ;mCJ\fumZ\"bY2|v+\u001b;i_V$h)\u001b7uKJ\u001c\u0004F\u0001!;\u0011\u0015!\u0005\u0001\"\u0001*\u0003\r\"Xm\u001d;QeVtWMU3hk2\f'/Q4h\u0007\u0006dGnX,ji\"4\u0015\u000e\u001c;feFB#a\u0011\u001e\t\u000b\u001d\u0003A\u0011A\u0015\u0002GQ,7\u000f\u001e)sk:,'+Z4vY\u0006\u0014\u0018iZ4DC2dwlV5uQ\u001aKG\u000e^3se!\u0012aI\u000f\u0005\u0006\u0015\u0002!\t!K\u0001(i\u0016\u001cH\u000f\u0015:v]\u0016\fU\u000f_$s_V\u0004\u0018iZ4DC2dwlV5uQ>,HOR5mi\u0016\u0014\u0018\u0007\u000b\u0002Ju!)Q\n\u0001C\u0001S\u00059C/Z:u!J,h.Z!vq\u001e\u0013x.\u001e9BO\u001e\u001c\u0015\r\u001c7`/&$\bn\\;u\r&dG/\u001a:3Q\ta%\bC\u0003Q\u0001\u0011\u0005\u0011&\u0001\u0013uKN$\bK];oK\u0006+\bp\u0012:pkB\fumZ\"bY2|v+\u001b;i\r&dG/\u001a:2Q\ty%\bC\u0003T\u0001\u0011\u0005\u0011&\u0001\u0013uKN$\bK];oK\u0006+\bp\u0012:pkB\fumZ\"bY2|v+\u001b;i\r&dG/\u001a:3Q\t\u0011&\bC\u0003W\u0001\u0011\u0005\u0011&A\u0011uKN$X)\u001c9us\u001e\u0013x.\u001e9LKf|v+\u001b;i\u001f:,\u0017iZ4DC2d\u0017\u0007\u000b\u0002Vu!)\u0011\f\u0001C\u0001S\u0005\tC/Z:u\u000b6\u0004H/_$s_V\u00048*Z=`/&$\bn\u00148f\u0003\u001e<7)\u00197me!\u0012\u0001L\u000f\u0005\u00069\u0002!\t!K\u0001\"i\u0016\u001cH/R7qif<%o\\;q\u0017\u0016LxlV5uQ>sW-Q4h\u0007\u0006dGn\r\u0015\u00037jBQa\u0018\u0001\u0005\u0002%\n!\u0006^3ti\u0016k\u0007\u000f^=He>,\boS3z?^KG\u000f['pe\u0016$\u0006.\u00198P]\u0016\fumZ\"bY2\u001c\u0018\u0007\u000b\u0002_u!)!\r\u0001C\u0001S\u0005QC/Z:u\u000b6\u0004H/_$s_V\u00048*Z=`/&$\b.T8sKRC\u0017M\\(oK\u0006;wmQ1mYN\u0014\u0004FA1;\u0011\u0015)\u0007\u0001\"\u0001*\u0003)\"Xm\u001d;F[B$\u0018p\u0012:pkB\\U-_0XSRDWj\u001c:f)\"\fgn\u00148f\u0003\u001e<7)\u00197mgNB#\u0001\u001a\u001e")
public abstract class PruneAggregateCallRuleTestBase
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a2");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b2");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c2");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d2");

    public BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    @Test
    public void testPruneRegularAggCall_WithoutFilter1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, d2 FROM\n        | (SELECT a2, b2, COUNT(c2) as c2, SUM(d2) as d2 FROM T2 GROUP BY a2, b2) t\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRegularAggCall_WithoutFilter2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b2, a2, d2 FROM\n        | (SELECT a2, b2, COUNT(c2) as c2, SUM(d2) as d2 FROM T2 GROUP BY a2, b2) t\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRegularAggCall_WithoutFilter3() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2 as a, b2, d2 FROM\n        | (SELECT a2, b2, COUNT(c2) as c2, SUM(d2) as d2 FROM T2 GROUP BY a2, b2) t\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRegularAggCall_WithFilter1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, d2 FROM\n        | (SELECT a2, b2, COUNT(c2) as c2, SUM(d2) as d2 FROM T2 GROUP BY a2, b2) t\n        |WHERE d2 > 0\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRegularAggCall_WithFilter2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b2, a2, d2 FROM\n        | (SELECT a2, b2, COUNT(c2) as c2, SUM(d2) as d2 FROM T2 GROUP BY a2, b2) t\n        |WHERE d2 > 0\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneAuxGroupAggCall_WithoutFilter1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a1, c1 FROM\n        | (SELECT a1, b1, COUNT(c1) as c1, SUM(d1) as d1 FROM T1 GROUP BY a1, b1) t\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneAuxGroupAggCall_WithoutFilter2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c1, a1 FROM\n        | (SELECT a1, b1, COUNT(c1) as c1, SUM(d1) as d1 FROM T1 GROUP BY a1, b1) t\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneAuxGroupAggCall_WithFilter1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a1, c1 FROM\n        | (SELECT a1, b1, COUNT(c1) as c1, SUM(d1) as d1 FROM T1 GROUP BY a1, b1) t\n        |WHERE c1 > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneAuxGroupAggCall_WithFilter2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c1, a1 FROM\n        | (SELECT a1, b1, COUNT(c1) as c1, SUM(d1) as d1 FROM T1 GROUP BY a1, b1) t\n        |WHERE c1 > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithOneAggCall1() {
        String sql = "SELECT 1 FROM (SELECT SUM(a1) FROM T1) t";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithOneAggCall2() {
        String sql = "SELECT * FROM T2 WHERE EXISTS (SELECT COUNT(*) FROM T1)";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithOneAggCall3() {
        String sql = "SELECT * FROM T2 WHERE EXISTS (SELECT COUNT(*) FROM T1 WHERE 1=2)";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithMoreThanOneAggCalls1() {
        String sql = "SELECT 1 FROM (SELECT SUM(a1), COUNT(*) FROM T1) t";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithMoreThanOneAggCalls2() {
        String sql = "SELECT * FROM T2 WHERE EXISTS (SELECT SUM(a1), COUNT(*) FROM T1)";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testEmptyGroupKey_WithMoreThanOneAggCalls3() {
        String sql = "SELECT * FROM T2 WHERE EXISTS (SELECT SUM(a1), COUNT(*) FROM T1 WHERE 1=2)";
        this.util().verifyRelPlan(sql);
    }
}

