/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForRangeEndTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001'\t\u0019c\t\\5oW2{w-[2bYJ\u000bgn\u001b*vY\u00164uN\u001d*b]\u001e,WI\u001c3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0012i\u0016\u001cHOU8x\u001dVl'-\u001a:Gk:\u001cG#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$\u0001\u0002+fgRDQ\u0001\u000f\u0001\u0005\u0002%\n\u0011\u0003^3ti^KG\u000f[8vi\u001aKG\u000e^3sQ\t9\u0014\u0007C\u0003<\u0001\u0011\u0005\u0011&A\u0011uKN$(+\u00198l-\u0006dW/\u001a$jYR,'oV5uQV\u0003\b/\u001a:WC2,X\r\u000b\u0002;c!)a\b\u0001C\u0001S\u0005aB/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f\u001b*b]\u001e,\u0007FA\u001f2\u0011\u0015\t\u0005\u0001\"\u0001*\u0003\u0005\"Xm\u001d;SC:\\g+\u00197vK\u001aKG\u000e^3s/&$\b\u000eT8xKJ4\u0016\r\\;fQ\t\u0001\u0015\u0007C\u0003E\u0001\u0011\u0005\u0011&A\u000fuKN$(+\u00198l-\u0006dW/\u001a$jYR,'oV5uQ\u0016\u000bX/\u00197tQ\t\u0019\u0015\u0007C\u0003H\u0001\u0011\u0005\u0011&A\u0013uKN$(+\u00198l-\u0006dW/\u001a$jYR,'oV5uQZ\u000b'/[1cY\u00164\u0015.\u001a7ec!\u0012a)\r\u0005\u0006\u0015\u0002!\t!K\u0001&i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\"4\u0016M]5bE2,g)[3mIJB#!S\u0019\t\u000b5\u0003A\u0011A\u0015\u0002KQ,7\u000f\u001e*b].4\u0016\r\\;f\r&dG/\u001a:XSRDg+\u0019:jC\ndWMR5fY\u0012\u001c\u0004F\u0001'2\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003\u0015\"Xm\u001d;SC:\\g+\u00197vK\u001aKG\u000e^3s/&$\bNV1sS\u0006\u0014G.\u001a$jK2$G\u0007\u000b\u0002Pc!)1\u000b\u0001C\u0001S\u00051B/Z:u/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010\u000b\u0002Sc!)a\u000b\u0001C\u0001S\u00059C/Z:u\u001bVdG/[*b[\u0016\u0014\u0016M\\6Gk:\u001cG/[8og^KG\u000f[*b[\u0016<%o\\;qQ\t)\u0016\u0007C\u0003Z\u0001\u0011\u0005\u0011&A\u0014uKN$X*\u001e7uSN\u000bW.\u001a*b].4UO\\2uS>t7oV5uQ\u0012KgMZ$s_V\u0004\bF\u0001-2\u0011\u0015a\u0006\u0001\"\u0001*\u0003i!Xm\u001d;Nk2$\u0018\u000eR5gMJ\u000bgn\u001b$v]\u000e$\u0018n\u001c8tQ\tY\u0016\u0007")
public class FlinkLogicalRankRuleForRangeEndTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testRowNumberFunc() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rn <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutFilter() {
        this.util().verifyRelPlan("SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable");
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithLowerValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk > 2\n      ")).stripMargin();
        this.thrown().expectMessage("Rank end is not specified.");
        this.thrown().expect(TableException.class);
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk > a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a and b > 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField4() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY a ORDER BY c) rk FROM MyTable) t\n        |WHERE rk = b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithDiffGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY c ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiDiffRankFunctions() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk,\n        |        ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public FlinkLogicalRankRuleForRangeEndTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
    }
}

