/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkGroupProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.AggregateReduceGroupingRule$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRule;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateJoinTransposeRuleTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001'\t\u0019c\t\\5oW\u0006;wM]3hCR,'j\\5o)J\fgn\u001d9pg\u0016\u0014V\u000f\\3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001,i\u0016\u001cH\u000fU;tQ\u000e{WO\u001c;BO\u001e$\u0006N]8vO\"Tu.\u001b8Pm\u0016\u0014XK\\5rk\u0016\u001cu\u000e\\;n]\"\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001*i\u0016\u001cH\u000fU;tQN+X.Q4h)\"\u0014x.^4i\u0015>Lgn\u0014<feVs\u0017.];f\u0007>dW/\u001c8)\u0005uR\u0004\"B!\u0001\t\u0003I\u0013a\n;fgR\u0004Vo\u001d5BO\u001e$\u0006N]8vO\"Tu.\u001b8XSRDWK\\5rk\u0016Tu.\u001b8LKfD#\u0001\u0011\u001e\t\u000b\u0011\u0003A\u0011A\u0015\u0002gQ,7\u000f^*p[\u0016\fumZ\"bY2\u001cu\u000e\\;n]N\fe\u000e\u001a&pS:\u001cuN\u001c3ji&|gnQ8mk6t7/S:TC6,\u0007FA\";\u0011\u00159\u0005\u0001\"\u0001*\u0003)\"Xm\u001d;BO\u001e\u0014XmZ1uK^KG\u000f[!vq\u001e\u0013x.\u001e9`\u0015>LgnS3z\u0013N,f.[9vKFB#A\u0012\u001e\t\u000b)\u0003A\u0011A\u0015\u0002UQ,7\u000f^!hOJ,w-\u0019;f/&$\b.Q;y\u000fJ|W\u000f]0K_&t7*Z=JgVs\u0017.];fe!\u0012\u0011J\u000f\u0005\u0006\u001b\u0002!\t!K\u0001.i\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRD\u0017)\u001e=He>,\bo\u0018&pS:\\U-_%t\u001d>$XK\\5rk\u0016\f\u0004F\u0001';\u0011\u0015\u0001\u0006\u0001\"\u0001*\u00035\"Xm\u001d;BO\u001e\u0014XmZ1uK^KG\u000f[!vq\u001e\u0013x.\u001e9`\u0015>LgnS3z\u0013Ntu\u000e^+oSF,XM\r\u0015\u0003\u001fj\u0002")
public class FlinkAggregateJoinTransposeRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        FlinkChainedProgram program = new FlinkChainedProgram();
        program.addLast("rules", (FlinkOptimizeProgram)FlinkGroupProgramBuilder$.MODULE$.newBuilder().addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule$.MODULE$.INSTANCE()})).build(), "reduce useless grouping").addProgram((FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{AggregateReduceGroupingRule$.MODULE$.INSTANCE(), CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH, CoreRules.FILTER_AGGREGATE_TRANSPOSE, CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.FILTER_MERGE, CoreRules.AGGREGATE_PROJECT_MERGE, FlinkAggregateJoinTransposeRule.EXTENDED})).build(), "aggregate join transpose").build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)program);
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"))).build());
    }

    @Test
    public void testPushCountAggThroughJoinOverUniqueColumn() {
        this.util().verifyRelPlan("SELECT COUNT(A.a) FROM (SELECT DISTINCT a FROM T) AS A JOIN T AS B ON A.a=B.a");
    }

    @Test
    public void testPushSumAggThroughJoinOverUniqueColumn() {
        this.util().verifyRelPlan("SELECT SUM(A.a) FROM (SELECT DISTINCT a FROM T) AS A JOIN T AS B ON A.a=B.a");
    }

    @Test
    public void testPushAggThroughJoinWithUniqueJoinKey() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (SELECT a AS a1, COUNT(b) AS b1 FROM T GROUP BY a),\n        |     T2 AS (SELECT COUNT(a) AS a2, b AS b2 FROM T GROUP BY b)\n        |SELECT MIN(a1), MIN(b1), MIN(a2), MIN(b2), a, b, COUNT(c) FROM\n        |  (SELECT * FROM T1, T2, T WHERE a1 = b2 AND a1 = a) t GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSomeAggCallColumnsAndJoinConditionColumnsIsSame() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MIN(a2), MIN(b2), a, b, COUNT(c2) FROM\n        |    (SELECT * FROM T2, T WHERE b2 = a) t GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c2, SUM(a) FROM (SELECT * FROM T2, T WHERE b2 = b) GROUP BY a2, b2, c2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsUnique2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c, SUM(a) FROM (SELECT * FROM T2, T WHERE b2 = b) GROUP BY a2, b2, c\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c2, SUM(a) FROM (SELECT * FROM T2, T WHERE a2 = a) GROUP BY a2, b2, c2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggregateWithAuxGroup_JoinKeyIsNotUnique2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a2, b2, c, SUM(a) FROM (SELECT * FROM T2, T WHERE a2 = a) GROUP BY a2, b2, c\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

