/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.util.Collections;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\t9b\t\\5oW\u000eC\u0017-\u001b8fIB\u0013xn\u001a:b[R+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\u001d:pOJ\fWN\u0003\u0002\u0006\r\u0005Aq\u000e\u001d;j[&TXM\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013\u0001\u0007;fgR\fE\rZ$fiJ+Wn\u001c<f!J|wM]1ngR\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0005+:LG\u000f\u000b\u0002 MA\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006E\u0001\u0006UVt\u0017\u000e^\u0005\u0003W!\u0012A\u0001V3ti\")Q\u0006\u0001C\u0001C\u0005QB/Z:u\u000f\u0016$h\t\\5oWJ+H.Z*fiB\u0013xn\u001a:b[\"\u0012AF\n\u0005\u0006a\u0001!\t!I\u0001\u0013i\u0016\u001cH/\u00113e\u001dVdG\u000e\u0015:pOJ\fW\u000e\u000b\u00030MI\u001a\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003Q\u0002\"!N\u001f\u000f\u0005YZdBA\u001c;\u001b\u0005A$BA\u001d\u0013\u0003\u0019a$o\\8u}%\tq#\u0003\u0002=-\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005QqU\u000f\u001c7Q_&tG/\u001a:Fq\u000e,\u0007\u000f^5p]*\u0011AH\u0006")
public class FlinkChainedProgramTest {
    @Test
    public void testAddGetRemovePrograms() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        Assert.assertTrue((boolean)programs.getProgramNames().isEmpty());
        Assert.assertTrue((boolean)programs.get("o1").isEmpty());
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addMatchLimit(10).addMatchOrder(HepMatchOrder.ARBITRARY).addRuleInstance((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE).addMatchLimit(100).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleCollection(Collections.singletonList(CoreRules.FILTER_VALUES_MERGE));
        FlinkHepProgram program1 = FlinkHepProgram$.MODULE$.apply(builder.build(), FlinkHepProgram$.MODULE$.apply$default$2());
        Assert.assertTrue((boolean)programs.addFirst("o2", (FlinkOptimizeProgram)program1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o2"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertTrue((boolean)programs.get("o2").isDefined());
        Assert.assertTrue((program1 == programs.get("o2").get() ? 1 : 0) != 0);
        FlinkHepRuleSetProgram program2 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).build();
        Assert.assertTrue((boolean)programs.addFirst("o1", (FlinkOptimizeProgram)program2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o2"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertTrue((boolean)programs.get("o1").isDefined());
        Assert.assertTrue((program2 == programs.get("o1").get() ? 1 : 0) != 0);
        FlinkHepRuleSetProgram program3 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_CALC_MERGE, CoreRules.PROJECT_CALC_MERGE, CoreRules.FILTER_TO_CALC, CoreRules.PROJECT_TO_CALC, CoreRules.CALC_MERGE})).setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setMatchLimit(10000).setHepMatchOrder(HepMatchOrder.ARBITRARY).build();
        Assert.assertTrue((boolean)programs.addLast("o4", (FlinkOptimizeProgram)program3));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o2", "o4"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertTrue((boolean)programs.get("o4").isDefined());
        Assert.assertTrue((program3 == programs.get("o4").get() ? 1 : 0) != 0);
        Convention.Impl TEST = new Convention.Impl("TEST", RelNode.class);
        FlinkVolcanoProgram program4 = FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{TEST})).build();
        Assert.assertTrue((boolean)programs.addBefore("o4", "o3", (FlinkOptimizeProgram)program4));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o2", "o3", "o4"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertTrue((boolean)programs.get("o3").isDefined());
        Assert.assertTrue((program4 == programs.get("o3").get() ? 1 : 0) != 0);
        Option p2 = programs.remove("o2");
        Assert.assertTrue((boolean)p2.isDefined());
        Assert.assertTrue((p2.get() == program1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o3", "o4"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertTrue((boolean)programs.remove("o0").isEmpty());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o3", "o4"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
        Assert.assertFalse((boolean)programs.addFirst("o3", (FlinkOptimizeProgram)program1));
        Assert.assertFalse((boolean)programs.addLast("o4", (FlinkOptimizeProgram)program1));
        Assert.assertFalse((boolean)programs.addBefore("o0", "o4", (FlinkOptimizeProgram)program1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o1", "o3", "o4"})), (Object)JavaConversions$.MODULE$.asScalaBuffer(programs.getProgramNames()).toList());
    }

    @Test
    public void testGetFlinkRuleSetProgram() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        Assert.assertTrue((boolean)programs.getProgramNames().isEmpty());
        FlinkHepRuleSetProgram program1 = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS})).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).build();
        programs.addFirst("o1", (FlinkOptimizeProgram)program1);
        Assert.assertTrue((boolean)programs.get("o1").isDefined());
        Assert.assertTrue((program1 == programs.get("o1").get() ? 1 : 0) != 0);
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addMatchLimit(10).addRuleInstance((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE).addRuleInstance((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE).addMatchOrder(HepMatchOrder.BOTTOM_UP);
        FlinkHepProgram program2 = FlinkHepProgram$.MODULE$.apply(builder.build(), FlinkHepProgram$.MODULE$.apply$default$2());
        programs.addLast("o2", (FlinkOptimizeProgram)program2);
        Assert.assertTrue((boolean)programs.get("o2").isDefined());
        Assert.assertTrue((program2 == programs.get("o2").get() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)programs.getFlinkRuleSetProgram("o2").isEmpty());
        Assert.assertTrue((boolean)programs.getFlinkRuleSetProgram("o3").isEmpty());
        Option p1 = programs.getFlinkRuleSetProgram("o1");
        Assert.assertTrue((boolean)p1.isDefined());
        ((FlinkRuleSetProgram)p1.get()).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE}));
        Assert.assertTrue((p1.get() == programs.getFlinkRuleSetProgram("o1").get() ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullProgram() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("o1", null);
    }
}

