/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSourceJsonPlanTest
extends TableTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
    }

    @Test
    public void testProjectPushDown() {
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint,\n  b int\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into sink select a, b from MyTable");
    }

    @Test
    public void testReadingMetadata() {
        String srcTableDdl = "CREATE TABLE MyTable2 (\n  a bigint,\n  b int,\n  c varchar,\n  m varchar metadata\n) with (\n  'connector' = 'values',\n  'readable-metadata' = 'm:STRING',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint,\n  b int,\n  m varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into sink select a, b, m from MyTable2");
    }

    @Test
    public void testFilterPushDown() {
        String srcTableDdl = "CREATE TABLE src (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false',  'filterable-fields' = 'a')";
        this.tEnv.executeSql(srcTableDdl);
        this.util.verifyJsonPlan("insert into MySink select * from src where a > 0");
    }

    @Test
    public void testLimitPushDown() {
        this.util.verifyJsonPlan("insert into MySink select * from MyTable limit 3");
    }

    @Test
    public void testPartitionPushDown() {
        String srcTableDdl = "CREATE TABLE PartitionTable (\n  a bigint,\n  b int,\n  p varchar)\npartitioned by (p)\nwith (\n  'connector' = 'values',\n  'bounded' = 'false',  'partition-list' = 'p:A')";
        this.tEnv.executeSql(srcTableDdl);
        this.util.verifyJsonPlan("insert into MySink select * from PartitionTable where p = 'A'");
    }

    @Test
    public void testWatermarkPushDown() {
        String srcTableDdl = "CREATE TABLE WatermarkTable (\n  a bigint,\n  b int,\n  c timestamp(3),\n  watermark for c as c - interval '5' second\n) with (\n  'connector' = 'values',\n  'bounded' = 'false',  'enable-watermark-push-down' = 'true',  'disable-lookup' = 'true')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint,\n  b int,\n  c timestamp(3)\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into sink select * from WatermarkTable");
    }
}

