/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSinkJsonPlanTest
extends TableTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
    }

    @Test
    public void testOverwrite() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'filesystem',\n  'format' = 'testcsv',\n  'path' = '/tmp')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert overwrite MySink select * from MyTable");
    }

    @Test
    public void testPartitioning() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) partitioned by (c) with (\n  'connector' = 'filesystem',\n  'format' = 'testcsv',\n  'path' = '/tmp')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink partition (c='A') select a, b from MyTable");
    }

    @Test
    public void testWritingMetadata() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  m varchar METADATA\n) with (\n  'connector' = 'values',\n  'writable-metadata' = 'm:STRING')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select * from MyTable");
    }
}

