/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.utils.EncodingUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RexNodeSerdeTest {
    private static final FlinkTypeFactory FACTORY = FlinkTypeFactory.INSTANCE();
    @Parameterized.Parameter
    public RexNode rexNode;
    @Parameterized.Parameter(value=1)
    public FlinkContext flinkContext;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        TableConfig tableConfig = TableConfig.getDefault();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog("default_catalog", (Catalog)new GenericInMemoryCatalog("default_db")).build();
        FlinkContextImpl flinkContext = new FlinkContextImpl(tableConfig, new FunctionCatalog(tableConfig, catalogManager, new ModuleManager()), catalogManager, null);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)FACTORY);
        RelDataType inputType = FACTORY.createStructType(StructKind.PEEK_FIELDS, Arrays.asList(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.BIGINT), FACTORY.createStructType(StructKind.PEEK_FIELDS, Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createSqlType(SqlTypeName.VARCHAR)), Arrays.asList("n1", "n2"))), Arrays.asList("f1", "f2", "f3"));
        Random random = new Random();
        List<RexNode> rexNodes = Arrays.asList(rexBuilder.makeNullLiteral(FACTORY.createSqlType(SqlTypeName.VARCHAR)), rexBuilder.makeLiteral(random.nextBoolean()), rexBuilder.makeExactLiteral(new BigDecimal((byte)random.nextInt()), FACTORY.createSqlType(SqlTypeName.TINYINT)), rexBuilder.makeExactLiteral(new BigDecimal((short)random.nextInt()), FACTORY.createSqlType(SqlTypeName.SMALLINT)), rexBuilder.makeExactLiteral(new BigDecimal(random.nextInt()), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeExactLiteral(new BigDecimal(random.nextLong()), FACTORY.createSqlType(SqlTypeName.BIGINT)), rexBuilder.makeExactLiteral(BigDecimal.valueOf(random.nextDouble()), FACTORY.createSqlType(SqlTypeName.DOUBLE)), rexBuilder.makeApproxLiteral(BigDecimal.valueOf(random.nextFloat()), FACTORY.createSqlType(SqlTypeName.FLOAT)), rexBuilder.makeExactLiteral(BigDecimal.valueOf(random.nextDouble())), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.YEAR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(100L), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.YEAR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.MONTH, TimeUnit.MONTH, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.MONTH, TimeUnit.MONTH, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.HOUR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.HOUR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.HOUR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.HOUR, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.MINUTE, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO)), rexBuilder.makeDateLiteral(DateString.fromDaysSinceEpoch((int)10)), rexBuilder.makeDateLiteral(new DateString("2000-12-12")), rexBuilder.makeTimeLiteral(TimeString.fromMillisOfDay((int)1234), 3), rexBuilder.makeTimeLiteral(TimeString.fromMillisOfDay((int)123456), 6), rexBuilder.makeTimeLiteral(new TimeString("01:01:01.000000001"), 9), rexBuilder.makeTimeWithLocalTimeZoneLiteral(TimeString.fromMillisOfDay((int)1234), 3), rexBuilder.makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)1234L), 3), rexBuilder.makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)123456789L), 9), rexBuilder.makeTimestampLiteral(new TimestampString("0001-01-01 01:01:01.000000001"), 9), rexBuilder.makeTimestampLiteral(new TimestampString("2000-12-12 12:30:57.1234"), 4), rexBuilder.makeBinaryLiteral(ByteString.EMPTY), rexBuilder.makeBinaryLiteral(ByteString.ofBase64((String)EncodingUtils.encodeObjectToString((Serializable)((Object)"abc")))), rexBuilder.makeLiteral(""), rexBuilder.makeLiteral("abc"), rexBuilder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), rexBuilder.makeLiteral(Arrays.asList(1, 2L), FACTORY.createStructType(Arrays.asList(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.BIGINT)), Arrays.asList("f1", "f2")), false), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)ImmutableRangeSet.of((Range)Range.closed((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(10L)))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)ImmutableRangeSet.of((Range)Range.range((Comparable)BigDecimal.valueOf(1L), (BoundType)BoundType.OPEN, (Comparable)BigDecimal.valueOf(10L), (BoundType)BoundType.CLOSED))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)TreeRangeSet.create(Arrays.asList(Range.closed((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(1L)), Range.closed((Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(3L)), Range.closed((Comparable)BigDecimal.valueOf(6L), (Comparable)BigDecimal.valueOf(6L))))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.BIGINT), 0), rexBuilder.makeCorrel(inputType, new CorrelationId("$cor1")), rexBuilder.makeFieldAccess(rexBuilder.makeCorrel(inputType, new CorrelationId("$cor2")), "f2", true), rexBuilder.makeCast(FACTORY.createSqlType(SqlTypeName.SMALLINT), (RexNode)rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)), rexBuilder.makeIn((RexNode)rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1), Arrays.asList(rexBuilder.makeExactLiteral(new BigDecimal(1)), rexBuilder.makeExactLiteral(new BigDecimal(3)), rexBuilder.makeExactLiteral(new BigDecimal(5)))), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{rexBuilder.makeNullLiteral(FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)})}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1), rexBuilder.makeExactLiteral(new BigDecimal(10))}), rexBuilder.makeCall((SqlOperator)FlinkSqlOperatorTable.HASH_CODE, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)}), rexBuilder.makeCall((SqlOperator)new ScalarSqlFunction(FunctionIdentifier.of((String)"MyUdf"), "MyUdf", (ScalarFunction)new ScalarFunc1(), FACTORY, JavaScalaConversionUtil.toScala(Optional.empty())), new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 0)}), rexBuilder.makeCall((SqlOperator)BridgingSqlFunction.of((FlinkContext)flinkContext, (FlinkTypeFactory)FACTORY, null, (FunctionDefinition)new ScalarFunc1()), new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 0)}), rexBuilder.makeCall((SqlOperator)BridgingSqlFunction.of((FlinkContext)flinkContext, (FlinkTypeFactory)FACTORY, (FunctionIdentifier)FunctionIdentifier.of((String)BuiltInFunctionDefinitions.TYPE_OF.getName()), (FunctionDefinition)BuiltInFunctionDefinitions.TYPE_OF), new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 0)}), rexBuilder.makePatternFieldRef("test", FACTORY.createSqlType(SqlTypeName.INTEGER), 0));
        return (Object[][])rexNodes.stream().map(arg_0 -> RexNodeSerdeTest.lambda$parameters$0((FlinkContext)flinkContext, arg_0)).toArray(x$0 -> new Object[x$0][]);
    }

    @Test
    public void testRexNodeSerde() throws Exception {
        SerdeContext serdeCtx = new SerdeContext(this.flinkContext, Thread.currentThread().getContextClassLoader(), FACTORY, (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.rexNode);
        }
        String json = writer.toString();
        RexNode actual = (RexNode)mapper.readValue(json, RexNode.class);
        Assert.assertEquals((Object)this.rexNode, (Object)actual);
    }

    private static /* synthetic */ Object[] lambda$parameters$0(FlinkContext flinkContext, RexNode n) {
        return new Object[]{n, flinkContext};
    }

    public static class ScalarFunc1
    extends ScalarFunction {
        public int eval(int i) {
            return i + 1;
        }
    }
}

