/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeSerdeTest;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RelDataTypeSerdeTest {
    private static final FlinkTypeFactory FACTORY = FlinkTypeFactory.INSTANCE();
    @Parameterized.Parameter
    public RelDataType relDataType;

    @Parameterized.Parameters(name="type = {0}")
    public static Collection<RelDataType> parameters() {
        List<RelDataType> types = Arrays.asList(FACTORY.createSqlType(SqlTypeName.BOOLEAN), FACTORY.createSqlType(SqlTypeName.TINYINT), FACTORY.createSqlType(SqlTypeName.SMALLINT), FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.BIGINT), FACTORY.createSqlType(SqlTypeName.DECIMAL, 3, 10), FACTORY.createSqlType(SqlTypeName.DECIMAL, 0, 19), FACTORY.createSqlType(SqlTypeName.DECIMAL, -1, 19), FACTORY.createSqlType(SqlTypeName.FLOAT), FACTORY.createSqlType(SqlTypeName.REAL), FACTORY.createSqlType(SqlTypeName.DOUBLE), FACTORY.createSqlType(SqlTypeName.DATE), FACTORY.createSqlType(SqlTypeName.TIME), FACTORY.createSqlType(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE), FACTORY.createSqlType(SqlTypeName.TIMESTAMP), FACTORY.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.YEAR, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.MONTH, TimeUnit.MONTH, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.DAY, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.HOUR, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.HOUR, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.MINUTE, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.HOUR, TimeUnit.SECOND, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.MINUTE, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.MINUTE, TimeUnit.SECOND, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO)), FACTORY.createSqlType(SqlTypeName.CHAR), FACTORY.createSqlType(SqlTypeName.CHAR, 0), FACTORY.createSqlType(SqlTypeName.CHAR, 32), FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createSqlType(SqlTypeName.VARCHAR, 0), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10), FACTORY.createSqlType(SqlTypeName.BINARY), FACTORY.createSqlType(SqlTypeName.BINARY, 0), FACTORY.createSqlType(SqlTypeName.BINARY, 100), FACTORY.createSqlType(SqlTypeName.VARBINARY), FACTORY.createSqlType(SqlTypeName.VARBINARY, 0), FACTORY.createSqlType(SqlTypeName.VARBINARY, 1000), FACTORY.createSqlType(SqlTypeName.NULL), FACTORY.createSqlType(SqlTypeName.ANY), FACTORY.createSqlType(SqlTypeName.SYMBOL), FACTORY.createMultisetType(FACTORY.createSqlType(SqlTypeName.VARCHAR), -1L), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L), FACTORY.createArrayType(FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L), -1L), FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), FACTORY.createMapType(FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), FACTORY.createArrayType(FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), -1L)), FACTORY.createSqlType(SqlTypeName.DISTINCT), FACTORY.createSqlType(SqlTypeName.STRUCTURED), FACTORY.createStructType(StructKind.PEEK_FIELDS, Arrays.asList(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.DECIMAL, 3, 10)), Arrays.asList("f1", "f2")), FACTORY.createStructType(Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L)), Arrays.asList("f1", "f2")), FACTORY.createStructType(Arrays.asList(FACTORY.createStructType(Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR, 5), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), Arrays.asList("f1", "f2")), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L)), Arrays.asList("f3", "f4")), FACTORY.createSqlType(SqlTypeName.SARG), FACTORY.createRowtimeIndicatorType(true, false), FACTORY.createRowtimeIndicatorType(true, true), FACTORY.createProctimeIndicatorType(true), FACTORY.createFieldTypeFromLogicalType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.RAW, Types.STRING)), FACTORY.createFieldTypeFromLogicalType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType"), LogicalTypeSerdeTest.PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).comparision(StructuredType.StructuredComparision.FULL).setFinal(false).setInstantiable(false).description("description for StructuredType").build()));
        ArrayList<RelDataType> ret = new ArrayList<RelDataType>(types.size() * 2);
        for (RelDataType type : types) {
            ret.add(FACTORY.createTypeWithNullability(type, true));
            ret.add(FACTORY.createTypeWithNullability(type, false));
        }
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(true, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), true));
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(false, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), false));
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(true, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), false));
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(true, Types.STRING)), true));
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(false, Types.STRING)), false));
        ret.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(true, Types.STRING)), false));
        return ret;
    }

    @Test
    public void testTypeSerde() throws Exception {
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(TableConfig.getDefault(), null, null, null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new ObjectIdentifierJsonSerializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addDeserializer(ObjectIdentifier.class, (JsonDeserializer)new ObjectIdentifierJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.relDataType);
        }
        String json = writer.toString();
        RelDataType actual = (RelDataType)mapper.readValue(json, RelDataType.class);
        if (this.relDataType.toString().equals("DECIMAL")) {
            Assert.assertEquals((Object)SqlTypeName.DECIMAL, (Object)actual.getSqlTypeName());
            Assert.assertEquals((long)this.relDataType.getScale(), (long)actual.getScale());
            Assert.assertEquals((long)serdeCtx.getTypeFactory().getTypeSystem().getDefaultPrecision(SqlTypeName.DECIMAL), (long)actual.getPrecision());
        } else {
            Assert.assertSame((Object)this.relDataType, (Object)actual);
        }
    }
}

