/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.LimitPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.PartitionPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceWatermarkSpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DynamicTableSourceSpecSerdeTest {
    @Parameterized.Parameter
    public DynamicTableSourceSpec spec;

    @Test
    public void testDynamicTableSourceSpecSerde() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(TableConfig.getDefault(), null, CatalogManagerMocks.createEmptyCatalogManager(), null), classLoader, FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.spec);
        }
        String json = writer.toString();
        DynamicTableSourceSpec actual = (DynamicTableSourceSpec)mapper.readValue(json, DynamicTableSourceSpec.class);
        Assert.assertEquals((Object)this.spec, (Object)actual);
        Assert.assertNull((Object)actual.getClassLoader());
        actual.setClassLoader(classLoader);
        Assert.assertNull((Object)actual.getReadableConfig());
        actual.setReadableConfig((ReadableConfig)serdeCtx.getConfiguration());
        TableEnvironmentImpl tableEnv = (TableEnvironmentImpl)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().useBlinkPlanner().build());
        Assert.assertNotNull((Object)actual.getScanTableSource((PlannerBase)tableEnv.getPlanner()));
    }

    @Parameterized.Parameters(name="{0}")
    public static List<DynamicTableSourceSpec> testData() {
        HashMap<String, String> properties1 = new HashMap<String, String>();
        properties1.put("connector", "filesystem");
        properties1.put("format", "testcsv");
        properties1.put("path", "/tmp");
        properties1.put("schema.0.name", "a");
        properties1.put("schema.0.data-type", "BIGINT");
        CatalogTable catalogTable1 = CatalogTable.fromProperties(properties1);
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        DynamicTableSourceSpec spec1 = new DynamicTableSourceSpec(ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), new ResolvedCatalogTable(catalogTable1, resolvedSchema1), Collections.emptyList());
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("connector", "values");
        properties2.put("disable-lookup", "true");
        properties2.put("enable-watermark-push-down", "true");
        properties2.put("filterable-fields", "b");
        properties2.put("bounded", "false");
        properties2.put("schema.0.name", "a");
        properties2.put("schema.0.data-type", "BIGINT");
        properties2.put("schema.1.name", "b");
        properties2.put("schema.1.data-type", "INT");
        properties2.put("schema.2.name", "c");
        properties2.put("schema.2.data-type", "STRING");
        properties2.put("schema.3.name", "p");
        properties2.put("schema.3.data-type", "STRING");
        properties2.put("schema.4.name", "m1");
        properties2.put("schema.4.data-type", "INT");
        properties2.put("schema.5.name", "m2");
        properties2.put("schema.5.data-type", "STRING");
        properties2.put("schema.6.name", "ts");
        properties2.put("schema.6.data-type", "TIMESTAMP(3)");
        properties2.put("readable-metadata", "m1:INT, m2:STRING");
        CatalogTable catalogTable2 = CatalogTable.fromProperties(properties2);
        ResolvedSchema resolvedSchema2 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.STRING()), Column.physical((String)"p", (DataType)DataTypes.STRING()), Column.physical((String)"m1", (DataType)DataTypes.INT()), Column.physical((String)"m2", (DataType)DataTypes.STRING()), Column.physical((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3))), Collections.emptyList(), null);
        FlinkTypeFactory factory = FlinkTypeFactory.INSTANCE();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)factory);
        DynamicTableSourceSpec spec2 = new DynamicTableSourceSpec(ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), new ResolvedCatalogTable(catalogTable2, resolvedSchema2), Arrays.asList(new ProjectPushDownSpec((int[][])new int[][]{{0}, {1}, {4}, {6}}, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(3)}, (String[])new String[]{"a", "b", "m1", "ts"})), new ReadingMetadataSpec(Arrays.asList("m1", "m2"), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(3)}, (String[])new String[]{"a", "b", "m1", "ts"})), new FilterPushDownSpec(Collections.singletonList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeInputRef(factory.createSqlType(SqlTypeName.INTEGER), 1), rexBuilder.makeExactLiteral(new BigDecimal(10))}))), new WatermarkPushDownSpec(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{rexBuilder.makeInputRef(factory.createSqlType(SqlTypeName.TIMESTAMP, 3), 3), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(1000L), new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO))}), 5000L, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(false, TimestampKind.ROWTIME, 3)})), new SourceWatermarkSpec(true, RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType(), new TimestampType(false, TimestampKind.ROWTIME, 3)})), new LimitPushDownSpec(100L), new PartitionPushDownSpec(Arrays.asList(new HashMap<String, String>(){
            {
                this.put("p", "A");
            }
        }, new HashMap<String, String>(){
            {
                this.put("p", "B");
            }
        }))));
        return Arrays.asList(spec1, spec2);
    }
}

