/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.abilities.sink.OverwriteSpec;
import org.apache.flink.table.planner.plan.abilities.sink.PartitioningSpec;
import org.apache.flink.table.planner.plan.abilities.sink.WritingMetadataSpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DynamicTableSinkSpecSerdeTest {
    @Parameterized.Parameter
    public DynamicTableSinkSpec spec;

    @Test
    public void testDynamicTableSinkSpecSerde() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SerdeContext serdeCtx = new SerdeContext((FlinkContext)new FlinkContextImpl(TableConfig.getDefault(), null, CatalogManagerMocks.createEmptyCatalogManager(), null), classLoader, FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectMapper mapper = JsonSerdeUtil.createObjectMapper((SerdeContext)serdeCtx);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.spec);
        }
        String json = writer.toString();
        DynamicTableSinkSpec actual = (DynamicTableSinkSpec)mapper.readValue(json, DynamicTableSinkSpec.class);
        Assert.assertEquals((Object)this.spec, (Object)actual);
        Assert.assertNull((Object)actual.getClassLoader());
        actual.setClassLoader(classLoader);
        Assert.assertNull((Object)actual.getReadableConfig());
        actual.setReadableConfig((ReadableConfig)serdeCtx.getConfiguration());
        Assert.assertNotNull((Object)actual.getTableSink());
    }

    @Parameterized.Parameters(name="{0}")
    public static List<DynamicTableSinkSpec> testData() {
        HashMap<String, String> properties1 = new HashMap<String, String>();
        properties1.put("connector", "filesystem");
        properties1.put("format", "testcsv");
        properties1.put("path", "/tmp");
        properties1.put("schema.0.name", "a");
        properties1.put("schema.0.data-type", "BIGINT");
        CatalogTable catalogTable1 = CatalogTable.fromProperties(properties1);
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        DynamicTableSinkSpec spec1 = new DynamicTableSinkSpec(ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), new ResolvedCatalogTable(catalogTable1, resolvedSchema1), Collections.emptyList());
        spec1.setReadableConfig((ReadableConfig)new Configuration());
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("connector", "filesystem");
        properties2.put("format", "testcsv");
        properties2.put("path", "/tmp");
        properties2.put("schema.0.name", "a");
        properties2.put("schema.0.data-type", "BIGINT");
        properties2.put("schema.1.name", "b");
        properties2.put("schema.1.data-type", "INT");
        properties2.put("schema.2.name", "p");
        properties2.put("schema.2.data-type", "STRING");
        CatalogTable catalogTable2 = CatalogTable.fromProperties(properties2);
        ResolvedSchema resolvedSchema2 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"p", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
        DynamicTableSinkSpec spec2 = new DynamicTableSinkSpec(ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), new ResolvedCatalogTable(catalogTable2, resolvedSchema2), Arrays.asList(new OverwriteSpec(true), new PartitioningSpec((Map)new HashMap<String, String>(){
            {
                this.put("p", "A");
            }
        })));
        spec2.setReadableConfig((ReadableConfig)new Configuration());
        HashMap<String, String> properties3 = new HashMap<String, String>();
        properties3.put("connector", "values");
        properties3.put("schema.0.name", "a");
        properties3.put("schema.0.data-type", "BIGINT");
        properties3.put("schema.1.name", "b");
        properties3.put("schema.1.data-type", "INT");
        properties3.put("schema.2.name", "m");
        properties3.put("schema.2.data-type", "STRING");
        properties3.put("writable-metadata", "m:STRING");
        CatalogTable catalogTable3 = CatalogTable.fromProperties(properties3);
        ResolvedSchema resolvedSchema3 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"m", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
        DynamicTableSinkSpec spec3 = new DynamicTableSinkSpec(ObjectIdentifier.of((String)"default_catalog", (String)"default_db", (String)"MyTable"), new ResolvedCatalogTable(catalogTable3, resolvedSchema3), Collections.singletonList(new WritingMetadataSpec(Collections.singletonList("m"), (LogicalType)RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}))));
        spec3.setReadableConfig((ReadableConfig)new Configuration());
        return Arrays.asList(spec1, spec2, spec3);
    }
}

