/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DurationJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DurationJsonSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DurationJsonSerdeTest {
    @Parameterized.Parameter
    public Duration duration;

    @Test
    public void testDurationSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new DurationJsonSerializer());
        module.addDeserializer(Duration.class, (JsonDeserializer)new DurationJsonDeserializer());
        mapper.registerModule((Module)module);
        StringWriter writer = new StringWriter(100);
        try (JsonGenerator gen = mapper.getFactory().createGenerator((Writer)writer);){
            gen.writeObject((Object)this.duration);
        }
        String json = writer.toString();
        Duration actual = (Duration)mapper.readValue(json, Duration.class);
        Assert.assertEquals((Object)this.duration, (Object)actual);
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Duration> testData() {
        return Arrays.asList(Duration.ofNanos(1234567890L), Duration.ofMillis(123456789L), Duration.ofSeconds(12345L), Duration.ofMinutes(123L), Duration.ofHours(5L), Duration.ofDays(10L));
    }
}

