/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableAggregate;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001#\t\u0011c\t\\5oWJ+G.\u00143N_\u0012Lg-[3e\u001b>tw\u000e^8oS\u000eLG/\u001f+fgRT!a\u0001\u0003\u0002\u00115,G/\u00193bi\u0006T!!\u0002\u0004\u0002\tAd\u0017M\u001c\u0006\u0003\u000f!\tq\u0001\u001d7b]:,'O\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005e1E.\u001b8l%\u0016dW\n\u001a%b]\u0012dWM\u001d+fgR\u0014\u0015m]3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\n\u0001\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0005\"Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\u001c+bE2,7kY1o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRD#A\u0007\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dr\u0011!\u00026v]&$\u0018BA\u0015'\u0005\u0011!Vm\u001d;\t\u000b-\u0002A\u0011\u0001\u000f\u0002?Q,7\u000f^$fiJ+G.T8o_R|g.[2jif|e\u000e\u0015:pU\u0016\u001cG\u000f\u000b\u0002+I!)a\u0006\u0001C\u00019\u0005aB/Z:u\u000f\u0016$(+\u001a7N_:|Go\u001c8jG&$\u0018p\u00148SC:\\\u0007FA\u0017%\u0011\u0015\t\u0004\u0001\"\u0001\u001d\u0003=\"Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\u001c+bE2,\u0017iZ4sK\u001e\fG/Z!gi\u0016\u00148kY1oQ\t\u0001D\u0005C\u00035\u0001\u0011\u0005A$\u0001\u001buKN$x)\u001a;SK2luN\\8u_:L7-\u001b;z\u001f:$\u0016M\u00197f\u0003\u001e<'/Z4bi\u0016\fe\r^3s\u0003\u001e<'/Z4bi\u0016D#a\r\u0013\t\u000b]\u0002A\u0011\u0001\u000f\u0002YQ,7\u000f^$fiJ+G.T8o_R|g.[2jif|enV5oI><H+\u00192mK\u0006;wM]3hCR,\u0007F\u0001\u001c%\u0011\u0015Q\u0004\u0001\"\u0001\u001d\u0003\u0005\"Xm\u001d;HKR\u0014V\r\\'p]>$xN\\5dSRLxJ\\!hOJ,w-\u0019;fQ\tID\u0005C\u0003>\u0001\u0011\u0005A$\u0001\u000fuKN$x)\u001a;SK2luN\\8u_:L7-\u001b;z\u001f:Tu.\u001b8)\u0005q\"\u0003\"\u0002!\u0001\t\u0003a\u0012a\t;fgR<U\r\u001e*fY6{gn\u001c;p]&\u001c\u0017\u000e^=P]\u0012+G-\u001e9mS\u000e\fG/\u001a\u0015\u0003\u007f\u0011BQa\u0011\u0001\u0005\u0002q\t!\u0006^3ti\u001e+GOU3m\u001b>tw\u000e^8oS\u000eLG/_(o\u0007\"\fgnZ3m_\u001etuN]7bY&TX\r\u000b\u0002CI!)a\t\u0001C\u00019\u0005AC/Z:u\u000f\u0016$(+\u001a7N_:|Go\u001c8jG&$\u0018p\u00148Ee>\u0004X\u000b\u001d3bi\u0016\u0014UMZ8sK\"\u0012Q\t\n")
public class FlinkRelMdModifiedMonotonicityTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetRelMonotonicityOnTableScan() {
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(7, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SqlMonotonicity apply() {
                return SqlMonotonicity.CONSTANT;
            }
        }, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.studentLogicalScan()));
    }

    @Test
    public void testGetRelMonotonicityOnProject() {
        RelNode projectWithMaxAgg = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(projectWithMaxAgg));
        RelNode aggWithMaxMax = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxMax));
        RelNode aggWithMaxMin = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxMin));
    }

    @Test
    public void testGetRelMonotonicityOnRank() {
        FlinkLogicalRank rank = new FlinkLogicalRank(this.cluster(), this.logicalTraits(), (RelNode)this.testRel(), ImmutableBitSet.of(), RelCollations.of((int)1), RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 3L), (RelDataTypeField)new RelDataTypeFieldImpl("rk", 7, this.longType()), false);
        Assert.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity((RelNode)rank));
    }

    @Test
    public void testGetRelMonotonicityOnTableAggregateAfterScan() {
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.logicalTableAgg()));
    }

    @Test
    public void testGetRelMonotonicityOnTableAggregateAfterAggregate() {
        RelNode projectWithMaxAgg = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        FlinkLogicalTableAggregate tableAggregate = new FlinkLogicalTableAggregate(this.cluster(), this.logicalTraits(), projectWithMaxAgg, ImmutableBitSet.of((int[])new int[]{0}), null, JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregateCall[]{this.tableAggCall()}))));
        Assert.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity((RelNode)tableAggregate));
    }

    @Test
    public void testGetRelMonotonicityOnWindowTableAggregate() {
        Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowTableAgg(), this.flinkLogicalWindowTableAgg(), this.streamWindowTableAgg()}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkRelMdModifiedMonotonicityTest $outer;

            public final void apply(SingleRel agg) {
                Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(agg.getRowType().getFieldCount(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SqlMonotonicity apply() {
                        return SqlMonotonicity.CONSTANT;
                    }
                }, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)this.$outer.mq().getRelModifiedMonotonicity((RelNode)agg));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testGetRelMonotonicityOnAggregate() {
        RelNode aggWithSum = this.relBuilder().scan(new String[]{"MyTable3"}).project(new RexNode[]{this.relBuilder().alias(this.relBuilder().call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))}), "a"), this.relBuilder().field(1)}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().sum(false, "sum_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithSum));
        RelNode aggWithCount = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().count(false, "count_a", new RexNode[]{this.relBuilder().field("a")})}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithCount));
        RelNode aggWithMax = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMax));
        RelNode aggWithMin = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_a", (RexNode)this.relBuilder().field("a"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMin));
        RelNode aggWithAvg = this.relBuilder().scan(new String[]{"MyTable3"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a")}), new RelBuilder.AggCall[]{this.relBuilder().avg(false, "avg_b", (RexNode)this.relBuilder().field("b"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithAvg));
        RelNode aggWithMaxSum = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("max_c")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_sum_d", (RexNode)this.relBuilder().field("sum_d"))}).build();
        Assert.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSum));
        RelNode aggWithMaxSumMin = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSumMin));
        RelNode aggWithMaxSumMax = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "max_d", (RexNode)this.relBuilder().field("d"))}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_max_c", (RexNode)this.relBuilder().field("max_c"))}).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.INCREASING})), (Object)this.mq().getRelModifiedMonotonicity(aggWithMaxSumMax));
    }

    @Test
    public void testGetRelMonotonicityOnJoin() {
        RelNode left1 = this.relBuilder().scan(new String[]{"MyTable4"}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode right1 = this.relBuilder().scan(new String[]{"MyTable4"}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode join1 = this.relBuilder().push(left1).push(right1).join(JoinRelType.LEFT, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 1), this.relBuilder().field(2, 1, 1)})).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(join1));
        RelNode left = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().max("max_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode right = this.relBuilder().scan(new String[]{"MyTable4"}).aggregate(this.relBuilder().groupKey(new RexNode[]{this.relBuilder().field("a"), this.relBuilder().field("b")}), new RelBuilder.AggCall[]{this.relBuilder().min("min_c", (RexNode)this.relBuilder().field("c")), this.relBuilder().sum(false, "sum_d", (RexNode)this.relBuilder().field("d"))}).project(new RexNode[]{this.relBuilder().field(2), this.relBuilder().field(1)}).build();
        RelNode join2 = this.relBuilder().push(left).push(right).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 1), this.relBuilder().field(2, 1, 1)})).build();
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.INCREASING, SqlMonotonicity.CONSTANT, SqlMonotonicity.DECREASING, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(join2));
        RelNode join3 = this.relBuilder().push(left).push(right).join(JoinRelType.INNER, this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(2, 0, 0), this.relBuilder().field(2, 1, 1)})).build();
        Assert.assertEquals(null, (Object)this.mq().getRelModifiedMonotonicity(join3));
        Assert.assertNull((Object)this.mq().getRelModifiedMonotonicity(this.logicalAntiJoinNotOnUniqueKeys()));
        Assert.assertNull((Object)this.mq().getRelModifiedMonotonicity(this.logicalAntiJoinOnUniqueKeys()));
    }

    @Test
    public void testGetRelMonotonicityOnDeduplicate() {
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(this.streamProcTimeDeduplicateFirstRow()));
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(this.streamProcTimeDeduplicateLastRow()));
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity(this.streamRowTimeDeduplicateFirstRow()));
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT})), (Object)this.mq().getRelModifiedMonotonicity(this.streamRowTimeDeduplicateLastRow()));
    }

    @Test
    public void testGetRelMonotonicityOnChangelogNormalize() {
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])((Object[])new SqlMonotonicity[]{SqlMonotonicity.CONSTANT, SqlMonotonicity.CONSTANT, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC, SqlMonotonicity.NOT_MONOTONIC})), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.streamChangelogNormalize()));
    }

    @Test
    public void testGetRelMonotonicityOnDropUpdateBefore() {
        Assert.assertEquals((Object)new RelModifiedMonotonicity((SqlMonotonicity[])Array$.MODULE$.fill(7, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SqlMonotonicity apply() {
                return SqlMonotonicity.CONSTANT;
            }
        }, ClassTag$.MODULE$.apply(SqlMonotonicity.class))), (Object)this.mq().getRelModifiedMonotonicity((RelNode)this.streamDropUpdateBefore()));
    }
}

