/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.hint;

import java.util.HashMap;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.hint.OptionsHintTest$;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink;
import org.apache.flink.table.planner.utils.OptionsTableSink;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TestingStatementSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0001\u0003\u0001E\u0011qb\u00149uS>t7\u000fS5oiR+7\u000f\u001e\u0006\u0003\u0007\u0011\tA\u0001[5oi*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0015\u0001\u0018M]1n!\tY\u0012J\u0004\u0002\u001d[9\u0011Q\u0004\f\b\u0003=-r!a\b\u0016\u000f\u0005\u0001JcBA\u0011)\u001d\t\u0011sE\u0004\u0002$M5\tAE\u0003\u0002&!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)aF\u0001E\u0001_\u0005yq\n\u001d;j_:\u001c\b*\u001b8u)\u0016\u001cH\u000f\u0005\u00021c5\t!AB\u0003\u0002\u0005!\u0005!g\u0005\u00022gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001aDQAO\u0019\u0005\u0002m\na\u0001P5oSRtD#A\u0018\t\u000fu\n$\u0019!C\u0001}\u0005Q\u0011jU0C\u001fVsE)\u0012#\u0016\u0003}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\t1\fgn\u001a\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0004TiJLgn\u001a\u0005\u0007\u0011F\u0002\u000b\u0011B \u0002\u0017%\u001bvLQ(V\u001d\u0012+E\t\t\u0004\u0005\u0015F\u00025JA\u0003QCJ\fWn\u0005\u0003Jg1{\u0005C\u0001\u001bN\u0013\tqUGA\u0004Qe>$Wo\u0019;\u0011\u0005Q\u0002\u0016BA)6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0019\u0016J!f\u0001\n\u0003!\u0016\u0001D;uS2\u001cV\u000f\u001d9mS\u0016\u0014X#A+\u0011\tQ2&\u0003W\u0005\u0003/V\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005MI\u0016B\u0001.\u0015\u00055!\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"AA,\u0013B\tB\u0003%Q+A\u0007vi&d7+\u001e9qY&,'\u000f\t\u0005\t=&\u0013)\u001a!C\u0001?\u0006I\u0011n\u001d\"pk:$W\rZ\u000b\u0002AB\u0011A'Y\u0005\u0003EV\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005e\u0013\nE\t\u0015!\u0003a\u0003)I7OQ8v]\u0012,G\r\t\u0005\u0006u%#\tA\u001a\u000b\u0004O&T\u0007C\u00015J\u001b\u0005\t\u0004\"B*f\u0001\u0004)\u0006\"\u00020f\u0001\u0004\u0001\u0007\"\u00027J\t\u0003j\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00039\u0004\"a\u001c:\u000f\u0005Q\u0002\u0018BA96\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u001d\u0006\u0003cVBq!^%\u0002\u0002\u0013\u0005a/\u0001\u0003d_BLHcA4xq\"91\u000b\u001eI\u0001\u0002\u0004)\u0006b\u00020u!\u0003\u0005\r\u0001\u0019\u0005\bu&\u000b\n\u0011\"\u0001|\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001 \u0016\u0003+v\\\u0013A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0004k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0011\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\b\u0013F\u0005I\u0011AA\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0005+\u0005\u0001l\b\u0002CA\f\u0013\u0006\u0005I\u0011\t \u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011%\tY\"SA\u0001\n\u0003\ti\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002 A\u0019A'!\t\n\u0007\u0005\rRGA\u0002J]RD\u0011\"a\nJ\u0003\u0003%\t!!\u000b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111FA\u0019!\r!\u0014QF\u0005\u0004\u0003_)$aA!os\"Q\u00111GA\u0013\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013\u0007C\u0005\u00028%\u000b\t\u0011\"\u0011\u0002:\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002<A1\u0011QHA\"\u0003Wi!!a\u0010\u000b\u0007\u0005\u0005S'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0012\u0002@\tA\u0011\n^3sCR|'\u000fC\u0005\u0002J%\u000b\t\u0011\"\u0001\u0002L\u0005A1-\u00198FcV\fG\u000eF\u0002a\u0003\u001bB!\"a\r\u0002H\u0005\u0005\t\u0019AA\u0016\u0011%\t\t&SA\u0001\n\u0003\n\u0019&\u0001\u0005iCND7i\u001c3f)\t\ty\u0002C\u0005\u0002X%\u000b\t\u0011\"\u0011\u0002Z\u00051Q-];bYN$2\u0001YA.\u0011)\t\u0019$!\u0016\u0002\u0002\u0003\u0007\u00111F\u0004\n\u0003?\n\u0014\u0011!E\u0001\u0003C\nQ\u0001U1sC6\u00042\u0001[A2\r!Q\u0015'!A\t\u0002\u0005\u00154#BA2\u0003Oz\u0005cBA5\u0003_*\u0006mZ\u0007\u0003\u0003WR1!!\u001c6\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001d\u0002l\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fi\n\u0019\u0007\"\u0001\u0002vQ\u0011\u0011\u0011\r\u0005\nY\u0006\r\u0014\u0011!C#\u0003s\"\u0012a\u0010\u0005\u000b\u0003{\n\u0019'!A\u0005\u0002\u0006}\u0014!B1qa2LH#B4\u0002\u0002\u0006\r\u0005BB*\u0002|\u0001\u0007Q\u000b\u0003\u0004_\u0003w\u0002\r\u0001\u0019\u0005\u000b\u0003\u000f\u000b\u0019'!A\u0005\u0002\u0006%\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0017\u000b9\nE\u00035\u0003\u001b\u000b\t*C\u0002\u0002\u0010V\u0012aa\u00149uS>t\u0007#\u0002\u001b\u0002\u0014V\u0003\u0017bAAKk\t1A+\u001e9mKJB\u0011\"!'\u0002\u0006\u0006\u0005\t\u0019A4\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002\u001e\u0006\r\u0014\u0011!C\u0005\u0003?\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0015\t\u0004\u0001\u0006\r\u0016bAAS\u0003\n1qJ\u00196fGRDq!!+2\t\u0003\tY+\u0001\u0006qCJ\fW.\u001a;feN$\"!!,\u0011\tQ\nykZ\u0005\u0004\u0003c+$!B!se\u0006L\b\u0006CAT\u0003k\u000b\u0019.!6\u0011\t\u0005]\u0016Q\u001a\b\u0005\u0003s\u000b9M\u0004\u0003\u0002<\u0006\u0005gb\u0001\u0012\u0002>&\u0019\u0011q\u0018\b\u0002\u000b),h.\u001b;\n\t\u0005\r\u0017QY\u0001\beVtg.\u001a:t\u0015\r\tyLD\u0005\u0005\u0003\u0013\fY-A\u0007QCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003\u0007\f)-\u0003\u0003\u0002P\u0006E'A\u0003)be\u0006lW\r^3sg*!\u0011\u0011ZAf\u0003\u0011q\u0017-\\3\"\u0005\u0005]\u0017\u0001D>j]\u0012,\u00070 \u001e!wBj\bB\u0002\u001e\u0001\t\u0003\tY\u000e\u0006\u0003\u0002^\u0006}\u0007C\u0001\u0019\u0001\u0011\u0019I\u0012\u0011\u001ca\u00015!I\u00111\u001d\u0001C\u0002\u0013%\u0011Q]\u0001\u0005kRLG.F\u0001Y\u0011\u001d\tI\u000f\u0001Q\u0001\na\u000bQ!\u001e;jY\u0002B\u0001\"!<\u0001\u0005\u0004%IaX\u0001\u000bSN|&m\\;oI\u0016$\u0007bBAy\u0001\u0001\u0006I\u0001Y\u0001\fSN|&m\\;oI\u0016$\u0007\u0005C\u0004\u0002v\u0002!\t!a>\u0002\r\t,gm\u001c:f)\t\tI\u0010E\u00025\u0003wL1!!@6\u0005\u0011)f.\u001b;)\t\u0005M(\u0011\u0001\t\u0005\u0005\u0007\u0011)!\u0004\u0002\u0002F&!!qAAc\u0005\u0019\u0011UMZ8sK\"9!1\u0002\u0001\u0005\u0002\u0005]\u0018!\t;fgR|\u0005\u000f^5p]N<\u0016\u000e\u001e5HY>\u0014\u0017\r\\\"p]\u001a$\u0015n]1cY\u0016$\u0007\u0006\u0002B\u0005\u0005\u001f\u0001BAa\u0001\u0003\u0012%!!1CAc\u0005\u0011!Vm\u001d;\t\u000f\t]\u0001\u0001\"\u0001\u0002x\u0006aB/Z:u\u0013:\u001cXM\u001d;XSRDG)\u001f8b[&\u001cw\n\u001d;j_:\u001c\b\u0006\u0002B\u000b\u0005\u001fAqA!\b\u0001\t\u0003\t90A\tuKN$\u0018\t\u001d9f]\u0012|\u0005\u000f^5p]NDCAa\u0007\u0003\u0010!9!1\u0005\u0001\u0005\u0002\u0005]\u0018a\u0005;fgR|e/\u001a:sS\u0012,w\n\u001d;j_:\u001c\b\u0006\u0002B\u0011\u0005\u001fAqA!\u000b\u0001\t\u0003\t90A\u000euKN$(j\\5o/&$\b.\u00119qK:$W\rZ(qi&|gn\u001d\u0015\u0005\u0005O\u0011y\u0001C\u0004\u00030\u0001!\t!a>\u0002;Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Pm\u0016\u0014(/\u001b3eK:|\u0005\u000f^5p]NDCA!\f\u0003\u0010!9!Q\u0007\u0001\u0005\u0002\u0005]\u0018!\b;fgR|\u0005\u000f^5p]ND\u0015N\u001c;P]R\u000b'\r\\3Ba&4\u0016.Z<)\t\tM\"q\u0002\u0005\b\u0005w\u0001A\u0011AA|\u0003a!Xm\u001d;PaRLwN\\:IS:$xJ\\*R\u0019ZKWm\u001e\u0015\u0005\u0005s\u0011y\u0001K\u0004\u0001\u0005\u0003\u0012iEa\u0014\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bRAAa\u0012\u0002F\u00061!/\u001e8oKJLAAa\u0013\u0003F\t9!+\u001e8XSRD\u0017!\u0002<bYV,7E\u0001B)!\u0011\u0011\u0019F!\u0016\u000e\u0005\u0005-\u0017\u0002\u0002B,\u0003\u0017\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$\u0007")
public class OptionsHintTest
extends TableTestBase {
    private final TableTestUtil util;
    private final boolean is_bounded;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Param[] parameters() {
        return OptionsHintTest$.MODULE$.parameters();
    }

    public static String IS_BOUNDED() {
        return OptionsHintTest$.MODULE$.IS_BOUNDED();
    }

    private TableTestUtil util() {
        return this.util;
    }

    private boolean is_bounded() {
        return this.is_bounded;
    }

    @Before
    public void before() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, true);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c as a + 1\n         |) with (\n         |  'connector' = 'OPTIONS',\n         |  '", "' = '", "',\n         |  'k1' = 'v1',\n         |  'k2' = 'v2'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OptionsHintTest$.MODULE$.IS_BOUNDED(), BoxesRunTime.boxToBoolean((boolean)this.is_bounded())})))).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table t2(\n         |  d int,\n         |  e varchar,\n         |  f bigint\n         |) with (\n         |  'connector' = 'OPTIONS',\n         |  '", "' = '", "',\n         |  'k3' = 'v3',\n         |  'k4' = 'v4'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OptionsHintTest$.MODULE$.IS_BOUNDED(), BoxesRunTime.boxToBoolean((boolean)this.is_bounded())})))).stripMargin());
    }

    @Test
    public void testOptionsWithGlobalConfDisabled() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, false);
        this.expectedException().expect(Matchers.isA(ValidationException.class));
        this.expectedException().expectMessage(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OPTIONS hint is allowed only when "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is set to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()}))).toString());
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(connector='COLLECTION', k2='#v2') */");
    }

    @Test
    public void testInsertWithDynamicOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |insert into t1 /*+ OPTIONS(k1='#v1', k5='v5') */\n         |select d, e from t2\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        TestingStatementSet testStmtSet = (TestingStatementSet)stmtSet;
        PlannerBase plannerBase = this.util().getPlanner();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(testStmtSet.getOperations()).map((Function1)new Serializable(this, plannerBase){
            public static final long serialVersionUID = 0L;
            private final PlannerBase eta$0$1$1;

            public final RelNode apply(ModifyOperation modifyOperation) {
                return this.eta$0$1$1.translateToRel(modifyOperation);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Assert.assertThat((Object)BoxesRunTime.boxToInteger((int)relNodes.length()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)1)));
        Predef$.MODULE$.assert(relNodes.head() instanceof LogicalLegacySink);
        LogicalLegacySink sink = (LogicalLegacySink)relNodes.head();
        Assert.assertEquals((Object)"{k1=#v1, k2=v2, k5=v5}", (Object)((OptionsTableSink)sink.sink()).props().toString());
    }

    @Test
    public void testAppendOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */");
    }

    @Test
    public void testOverrideOptions() {
        this.util().verifyExecPlan("select * from t1/*+ OPTIONS(k1='#v1', k2='#v2') */");
    }

    @Test
    public void testJoinWithAppendedOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |select * from\n         |t1 /*+ OPTIONS(k5='v5', 'a.b.c'='fakeVal') */\n         |join\n         |t2 /*+ OPTIONS(k6='v6', 'd.e.f'='fakeVal') */\n         |on t1.a = t2.d\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithOverriddenOptions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |select * from\n         |t1 /*+ OPTIONS(k1='#v1', k2='#v2') */\n         |join\n         |t2 /*+ OPTIONS(k3='#v3', k4='#v4') */\n         |on t1.a = t2.d\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testOptionsHintOnTableApiView() {
        Table view1 = this.util().tableEnv().sqlQuery("select * from t1 join t2 on t1.a = t2.d");
        this.util().tableEnv().createTemporaryView("view1", view1);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testOptionsHintOnSQLView() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "v1");
        props.put("k2", "v2");
        props.put("k3", "v3");
        props.put("k4", "v4");
        CatalogViewImpl view1 = new CatalogViewImpl("select * from t1 join t2 on t1.a = t2.d", "select * from t1 join t2 on t1.a = t2.d", TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.STRING()).field("c", DataTypes.INT()).field("d", DataTypes.INT()).field("e", DataTypes.STRING()).field("f", DataTypes.BIGINT()).build(), props, "a view table");
        Catalog catalog = (Catalog)this.util().tableEnv().getCatalog(this.util().tableEnv().getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(this.util().tableEnv().getCurrentDatabase(), "view1"), (CatalogBaseTable)view1, false);
        String sql = "select * from view1/*+ OPTIONS(k1='#v1', k2='#v2', k3='#v3', k4='#v4') */";
        this.util().verifyExecPlan(sql);
    }

    public OptionsHintTest(Param param) {
        this.util = (TableTestUtil)param.utilSupplier().apply((Object)this);
        this.is_bounded = param.isBounded();
    }

    public static class Param
    implements Product,
    Serializable {
        private final Function1<TableTestBase, TableTestUtil> utilSupplier;
        private final boolean isBounded;

        public Function1<TableTestBase, TableTestUtil> utilSupplier() {
            return this.utilSupplier;
        }

        public boolean isBounded() {
            return this.isBounded;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OptionsHintTest$.MODULE$.IS_BOUNDED(), BoxesRunTime.boxToBoolean((boolean)this.isBounded())}));
        }

        public Param copy(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            return new Param(utilSupplier, isBounded);
        }

        public Function1<TableTestBase, TableTestUtil> copy$default$1() {
            return this.utilSupplier();
        }

        public boolean copy$default$2() {
            return this.isBounded();
        }

        public String productPrefix() {
            return "Param";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isBounded());
                    break;
                }
                case 0: {
                    object = this.utilSupplier();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Param;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.utilSupplier()));
            n = Statics.mix((int)n, (int)(this.isBounded() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Param)) return false;
            boolean bl = true;
            if (!bl) return false;
            Param param = (Param)x$1;
            Function1<TableTestBase, TableTestUtil> function1 = this.utilSupplier();
            Function1<TableTestBase, TableTestUtil> function12 = param.utilSupplier();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (this.isBounded() != param.isBounded()) return false;
            if (!param.canEqual(this)) return false;
            return true;
        }

        public Param(Function1<TableTestBase, TableTestUtil> utilSupplier, boolean isBounded) {
            this.utilSupplier = utilSupplier;
            this.isBounded = isBounded;
            Product.class.$init$((Product)this);
        }
    }
}

