/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.common.PartialInsertTest$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1si&\fG.\u00138tKJ$H+Z:u\u0015\t\u0019A!\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011!B;uS2\u001c\u0018BA\f\u0015\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0004jg\n\u000bGo\u00195\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005!Q\u000f^5m+\u0005I#\u0003\u0002\u0016-_I2Aa\u000b\u0001\u0001S\taAH]3gS:,W.\u001a8u}A\u00111#L\u0005\u0003]Q\u0011Q\u0002V1cY\u0016$Vm\u001d;Vi&d\u0007CA\u000e1\u0013\t\tDDA\u0004Qe>$Wo\u0019;\u0011\u0005m\u0019\u0014B\u0001\u001b\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u00191\u0004\u0001)A\u0005S\u0005)Q\u000f^5mA!)\u0001\b\u0001C\u0001s\u0005\u0019C/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD7i\\7qY\u0016D(+Z8sI\u0016\u0014H#\u0001\u001e\u0011\u0005mY\u0014B\u0001\u001f\u001d\u0005\u0011)f.\u001b;)\u0005]r\u0004CA C\u001b\u0005\u0001%BA!\u000f\u0003\u0015QWO\\5u\u0013\t\u0019\u0005I\u0001\u0003UKN$\b\"B#\u0001\t\u0003I\u0014\u0001\u000e;fgR\u0004\u0016M\u001d;jC2Len]3si^KG\u000f[\"p[BdW\r\u001f*f_J$WM]!oI\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012AI\u0010\u0005\u0006\u0011\u0002!\t!O\u0001\u001bi\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i+:LwN\u001c\u0015\u0003\u000fzBQa\u0013\u0001\u0005\u0002e\nQ\u0004^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\b.\u00168j_:\fE\u000e\u001c\u0015\u0003\u0015zBQA\u0014\u0001\u0005\u0002e\n\u0011\u0005^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\b.\u00138uKJ\u001cXm\u0019;BY2D#!\u0014 \t\u000bE\u0003A\u0011A\u001d\u0002=Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ\u0016C8-\u001a9u\u00032d\u0007F\u0001)?\u0011\u0015!\u0006\u0001\"\u0003V\u0003\u0001\"Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\"\u001cV\r^(qKJ\fGo\u001c:\u0015\u0005i2\u0006\"B,T\u0001\u0004A\u0016\u0001C8qKJ\fGo\u001c:\u0011\u0005ecfBA\u000e[\u0013\tYF$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.\u001d\u0011\u0015\u0001\u0007\u0001\"\u0001:\u0003\r\"Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\",f.[8o\u00032dg*Z:uK\u0012D#a\u0018 \t\u000b\r\u0004A\u0011A\u001d\u00029Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ>\u0013H-\u001a:Cs\"\u0012!M\u0010\u0015\u0005\u0001\u0019dW\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j\u0001\u00061!/\u001e8oKJL!a\u001b5\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\na\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r\u0001\u00069!/\u001e8oKJ\u001c\u0018BA:q\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e)QO\u0001E\u0001m\u0006\t\u0002+\u0019:uS\u0006d\u0017J\\:feR$Vm\u001d;\u0011\u0005\u0011:h!B\u0001\u0003\u0011\u0003A8CA<z!\tY\"0\u0003\u0002|9\t1\u0011I\\=SK\u001aDQ!I<\u0005\u0002u$\u0012A\u001e\u0005\u0007\u007f^$\t!!\u0001\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002\u0004A)\u0011QAA\u000755\u0011\u0011q\u0001\u0006\u0004O\u0005%!BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011q\u0001\u0002\u000b\u0007>dG.Z2uS>t\u0007f\u0002@\u0002\u0014\u0005\u0005\u00121\u0005\t\u0005\u0003+\tYBD\u0002p\u0003/I1!!\u0007q\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011QDA\u0010\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0004\u00033\u0001\u0018\u0001\u00028b[\u0016\f#!!\n\u0002\u0019%\u001c()\u0019;dQj\u00023\u0010M?")
public class PartialInsertTest
extends TableTestBase {
    private final TableTestUtil util;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("d");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("e");

    @Parameterized.Parameters(name="isBatch: {0}")
    public static Collection<Object> parameters() {
        return PartialInsertTest$.MODULE$.parameters();
    }

    private TableTestUtil util() {
        return this.util;
    }

    @Test
    public void testPartialInsertWithComplexReorder() {
        this.util().verifyRelPlanInsert("INSERT INTO sink (b,e,a,g,f,c,d) SELECT b,e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @Test
    public void testPartialInsertWithComplexReorderAndComputedColumn() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @Test
    public void testPartialInsertWithUnion() {
        this.testPartialInsertWithSetOperator("UNION");
    }

    @Test
    public void testPartialInsertWithUnionAll() {
        this.testPartialInsertWithSetOperator("UNION ALL");
    }

    @Test
    public void testPartialInsertWithIntersectAll() {
        this.testPartialInsertWithSetOperator("INTERSECT ALL");
    }

    @Test
    public void testPartialInsertWithExceptAll() {
        this.testPartialInsertWithSetOperator("EXCEPT ALL");
    }

    private void testPartialInsertWithSetOperator(String operator) {
        this.util().verifyRelPlanInsert(new StringBuilder().append((Object)"INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e ").append((Object)operator).append((Object)" ").append((Object)"SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e ").toString());
    }

    @Test
    public void testPartialInsertWithUnionAllNested() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,123,456,c,d FROM MyTable GROUP BY a,b,c,d,e ");
    }

    @Test
    public void testPartialInsertWithOrderBy() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable ORDER BY a,e,c,d");
    }

    public PartialInsertTest(boolean isBatch) {
        this.util = isBatch ? this.batchTestUtil(this.batchTestUtil$default$1()) : this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5)}), new CaseClassTypeInfo<Tuple5<Object, String, String, String, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, String, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |create table sink (\n       |  `a` INT,\n       |  `b` STRING,\n       |  `c` STRING,\n       |  `d` STRING,\n       |  `e` DOUBLE,\n       |  `f` BIGINT,\n       |  `g` INT\n       |) with (\n       |  'connector' = 'values',\n       |  'sink-insert-only' = 'false'\n       |)\n       |"})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |create table partitioned_sink (\n       |  `a` INT,\n       |  `b` AS `a` + 1,\n       |  `c` STRING,\n       |  `d` STRING,\n       |  `e` DOUBLE,\n       |  `f` BIGINT,\n       |  `g` INT\n       |) PARTITIONED BY (`c`, `d`) with (\n       |  'connector' = 'values',\n       |  'sink-insert-only' = 'false'\n       |)\n       |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }
}

