/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0001\u0002\u0002\u0002E\u00111CS8j]J+wN\u001d3feR+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011QCB\u0001\u0006kRLGn]\u0005\u0003/Q\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0012}\tA!\u001e;jYV\t\u0001\u0005\u0005\u0002\u0014C%\u0011!\u0005\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003\u0015)H/\u001b7!\u0011\u00151\u0003A\"\u0005 \u0003A9W\r\u001e+bE2,G+Z:u+RLG\u000eC\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u000f\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001\u0017i\u0016\u001cHo\u0015;be*{\u0017N\\\"p]\u0012LG/[8oc!\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001\u0017i\u0016\u001cHo\u0015;be*{\u0017N\\\"p]\u0012LG/[8oe!\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001\u0018i\u0016\u001cHOQ;tQfTu.\u001b8D_:$\u0017\u000e^5p]FB#\u0001\u0011\u001e\t\u000b\u0011\u0003A\u0011A\u0015\u0002/Q,7\u000f\u001e\"vg\"L(j\\5o\u0007>tG-\u001b;j_:\u0014\u0004FA\";\u0011\u00159\u0005\u0001\"\u0001*\u0003Y!Xm\u001d;XSRDw.\u001e;D_2,XN\\*uCR\u001c\bF\u0001$;\u0011\u0015Q\u0005\u0001\"\u0001*\u0003M!Xm\u001d;K_&tw+\u001b;i!J|'.Z2uQ\tI%\bC\u0003N\u0001\u0011\u0005\u0011&\u0001\nuKN$(j\\5o/&$\bNR5mi\u0016\u0014\bF\u0001';\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003e!Xm\u001d;J]:,'/\u00118e\u0019\u00164GoT;uKJTu.\u001b8)\u0005=S\u0004\"B*\u0001\t\u0003I\u0013A\u0007;fgRLeN\\3s\u0003:$'+[4ii>+H/\u001a:K_&t\u0007F\u0001*;\u0011\u00151\u0006\u0001\"\u0001*\u0003e!Xm\u001d;J]:,'/\u00118e\rVdGnT;uKJTu.\u001b8)\u0005US\u0004\"B-\u0001\t\u0003I\u0013\u0001\u0006;fgR\fE\u000e\u001c'fMR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002Yu!)A\f\u0001C\u0001S\u0005)B/Z:u\u00032d'+[4ii>+H/\u001a:K_&t\u0007FA.;\u0011\u0015y\u0006\u0001\"\u0001*\u0003Q!Xm\u001d;BY24U\u000f\u001c7PkR,'OS8j]\"\u0012aL\u000f\u0005\u0006E\u0002!\t!K\u0001%i\u0016\u001cH\u000fR3sSZ,g*\u001e7m\r&dG/\u001a:BMR,'OS8j]J+wN\u001d3fe\"\u0012\u0011M\u000f")
public abstract class JoinReorderTestBase
extends TableTestBase {
    private final TableTestUtil util = this.getTableTestUtil();

    public TableTestUtil util() {
        return this.util;
    }

    public abstract TableTestUtil getTableTestUtil();

    @Before
    public void setup() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()});
        this.util().addTableSource("T1", types, (String[])((Object[])new String[]{"a1", "b1", "c1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(1000000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T2", types, (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(10000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(5000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T3", types, (String[])((Object[])new String[]{"a3", "b3", "c3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(10L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(2L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T4", types, (String[])((Object[])new String[]{"a4", "b4", "c4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T5", types, (String[])((Object[])new String[]{"a5", "b5", "c5"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().getTableEnv().getConfig().getConfiguration().setBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, true);
    }

    @Test
    public void testStarJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a1 = a3 AND a1 = a4 AND a1 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testStarJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b1 = b3 AND b1 = b4 AND b1 = b5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testBushyJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a2 = a3 AND a1 = a4 AND a3 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testBushyJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b2 = b3 AND b1 = b4 AND b3 = b5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWithoutColumnStats() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE c1 = c2 AND c1 = c3 AND c2 = c4 AND c1 = c5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |WITH V1 AS (SELECT b1, a1, a2, c2 FROM T1 JOIN T2 ON a1 = a2),\n         |     V2 AS (SELECT a3, b1, a1, c2, c3 FROM V1 JOIN T3 ON a2 = a3),\n         |     V3 AS (SELECT a3, b1, a1, c2, c3, a4, b4 FROM T4 JOIN V2 ON a1 = a4)\n         |\n         |SELECT * FROM V3, T5 where a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |WITH V1 AS (SELECT * FROM T1 JOIN T2 ON a1 = a2 WHERE b1 * b2 > 10),\n         |     V2 AS (SELECT * FROM V1 JOIN T3 ON a2 = a3 WHERE b1 * b3 < 2000),\n         |     V3 AS (SELECT * FROM T4 JOIN V2 ON a3 = a4 WHERE b2 + b4 > 100)\n         |\n         |SELECT * FROM V3, T5 WHERE a4 = a5 AND b5 < 15\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInnerAndLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInnerAndRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInnerAndFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAllLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a2 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAllRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a2 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAllFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T1\n         |   FULL OUTER JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a1 = a3\n         |   FULL OUTER JOIN T4 ON a1 = a4\n         |   FULL OUTER JOIN T5 ON a4 = a5\n         "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDeriveNullFilterAfterJoinReorder() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG()});
        ColumnStats.Builder builderA = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(200000L)).setNullCount(Predef$.MODULE$.long2Long(50000L)).setAvgLen(Predef$.MODULE$.double2Double(4.0)).setMaxLen(Predef$.MODULE$.int2Integer(4));
        ColumnStats.Builder builderB = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(100000L)).setNullCount(Predef$.MODULE$.long2Long(0L)).setAvgLen(Predef$.MODULE$.double2Double(8.0)).setMaxLen(Predef$.MODULE$.int2Integer(8));
        this.util().addTableSource("T6", types, (String[])((Object[])new String[]{"a6", "b6"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a6"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b6"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T7", types, (String[])((Object[])new String[]{"a7", "b7"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a7"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b7"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T8", types, (String[])((Object[])new String[]{"a8", "b8"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a8"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b8"), (Object)builderB.build())}))))).build());
        this.util().getTableEnv().getConfig().getConfiguration().setLong(JoinDeriveNullFilterRule$.MODULE$.TABLE_OPTIMIZER_JOIN_NULL_FILTER_THRESHOLD(), 10000L);
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT * FROM T6\n         |   INNER JOIN T7 ON b6 = b7\n         |   INNER JOIN T8 ON a6 = a8\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().verifyExecPlan(sql);
    }
}

