/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001'\tyA+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!)\u0001\u0006\u0001C\u0001S\u0005)1/\u001a;vaR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0003kk:LG/\u0003\u00027g\t1!)\u001a4pe\u0016DQ\u0001\u000f\u0001\u0005\u0002%\n\u0011\u0003^3tiNKW\u000e\u001d7f!J|'.Z2uQ\t9$\b\u0005\u00023w%\u0011Ah\r\u0002\u0005)\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005\u0011&A\u000fuKN$8+[7qY\u0016\u0004&o\u001c6fGR<\u0016\u000e\u001e5Qe>\u001cG/[7fQ\ti$\bC\u0003B\u0001\u0011\u0005\u0011&\u0001\u000euKN$\bK]8kK\u000e$x+\u001b;i_V$\u0018J\u001c9viJ+g\r\u000b\u0002Au!)A\t\u0001C\u0001S\u0005\tB/Z:u\u001d\u0016\u001cH/\u001a3Qe>TWm\u0019;)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013a\u0007;fgRtUm\u001d;Qe>TWm\u0019;XSRDW*\u001a;bI\u0006$\u0018\r\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005qB/Z:u\u001d\u0016\u001cH/\u001a3Qe>TWm\u0019;GS\u0016dGmV5uQ&#V)\u0014\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\n\u0011\u0005^3tiR\u000b'\r\\3IS:$x+\u001b;i\t&4g-\u001a:f]R|\u0005\u000f^5p]ND#\u0001\u0014\u001e\t\u000bA\u0003A\u0011A\u0015\u00029Q,7\u000f\u001e+bE2,\u0007*\u001b8u/&$\bnU1nK>\u0003H/[8og\"\u0012qJ\u000f\u0005\u0006'\u0002!\t!K\u00010i\u0016\u001cH\u000fV1cY\u0016D\u0015N\u001c;XSRDG)[4fgR\u0014V-^:f\r>\u0014Hj\\4jG\u0006dG+\u00192mKN\u001b\u0017M\u001c\u0015\u0003%jBQA\u0016\u0001\u0005\u0002%\nQ\u0005^3ti\n+\u0018\u000e\u001c;J]\u001a+hn\u0019;j_:<\u0016\u000e\u001e5GS2$XM\u001d)vg\"$wn\u001e8)\u0005US\u0004")
public class TableSourceTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE ProjectableTable (\n         |  a int,\n         |  b bigint,\n         |  c varchar(32)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'true'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE NestedTable (\n        |  id int,\n        |  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag\n        |  boolean>>,\n        |  nested row<name string, `value` int>,\n        |  name string\n        |) WITH (\n        | 'connector' = 'values',\n        | 'nested-projection-supported' = 'true',\n        | 'bounded' = 'true'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |    nested2 row<num int, flag boolean>>,\n         |  metadata_1 int metadata,\n         |  metadata_2 string metadata\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'true',\n         |  'readable-metadata' =\n         |    'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String ddl4 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE NestedItemTable (\n         |  `id` INT,\n         |  `name` STRING,\n         |  `result` ROW<\n         |     `data_arr` ROW<`value` BIGINT> ARRAY,\n         |     `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n         |  `extra` STRING\n         |  ) WITH (\n         |    'connector' = 'values',\n         |    'nested-projection-supported' = 'true',\n         |    'bounded' = 'true'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin();
        this.util().tableEnv().executeSql(ddl4);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MyTable (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }

    @Test
    public void testSimpleProject() {
        this.util().verifyExecPlan("SELECT a, c FROM ProjectableTable");
    }

    @Test
    public void testSimpleProjectWithProctime() {
        this.util().verifyExecPlan("SELECT a, c, PROCTIME() FROM ProjectableTable");
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.util().verifyExecPlan("SELECT COUNT(1) FROM ProjectableTable");
    }

    @Test
    public void testNestedProject() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM NestedTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestProjectWithMetadata() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |       deepNested.nested1 AS nested1,\n        |       deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\n        |FROM T\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectFieldWithITEM() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |SELECT\n         |  `result`.`data_arr`[`id`].`value`,\n         |  `result`.`data_map`['item'].`value`\n         |FROM NestedItemTable\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin());
    }

    @Test
    public void testTableHintWithDifferentOptions() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, true);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '/tmp/test'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n        |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHintWithSameOptions() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, true);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '/tmp/test'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHintWithDigestReuseForLogicalTableScan() {
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, true);
        this.util().tableEnv().getConfig().getConfiguration().setBoolean(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), true);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TABLE MySink (\n         |  `a` INT,\n         |  `b` BIGINT,\n         |  `c` STRING\n         |) WITH (\n         |  'connector' = 'filesystem',\n         |  'format' = 'testcsv',\n         |  'path' = '/tmp/test'\n         |)\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='0') */\n        |union all\n        |select a,b,c from MyTable /*+ OPTIONS('source.num-element-to-skip'='1') */\n        |")).stripMargin());
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into MySink select a,b,c from MyTable\n        |  /*+ OPTIONS('source.num-element-to-skip'='2') */\n        |")).stripMargin());
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testBuiltInFunctionWithFilterPushdown() {
        this.util().verifyExecPlan("SELECT a FROM ProjectableTable WHERE IFNULL(a, 1) = 1");
    }
}

