/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001'\t)\u0002+\u0019:uSRLwN\\1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003\u0015)H/\u001b7!\u0011\u0015A\u0003\u0001\"\u0003*\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0007)\u0002\u0014\b\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\b\"B\u0019(\u0001\u0004\u0011\u0014\u0001\u00028b[\u0016\u0004\"a\r\u001c\u000f\u0005-\"\u0014BA\u001b-\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ub\u0003\"\u0002\u001e(\u0001\u0004Y\u0014!C:ik\u001a4G.\u001a\"z!\tYC(\u0003\u0002>Y\t9!i\\8mK\u0006t\u0007\"B \u0001\t\u0003\u0001\u0015A\u0003;fgR\u001cF/\u0019;jGR\t!\u0006\u000b\u0002?\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000f\u0012\u0013A\u0001V3ti\")\u0011\n\u0001C\u0001\u0001\u0006YA/Z:u\tft\u0017-\\5dQ\tA%\tC\u0003M\u0001\u0011\u0005\u0001)\u0001\u000buKN$H)\u001f8b[&\u001c7\u000b[;gM2,')\u001f\u0015\u0003\u0017\nCQa\u0014\u0001\u0005\u0002\u0001\u000b1\u0002^3tiB\u000b'\u000f^5bY\"\u0012aJ\u0011\u0005\u0006%\u0002!\t\u0001Q\u0001\u0010i\u0016\u001cHo\u0016:p]\u001e\u001cF/\u0019;jG\"\"\u0011K\u0011+V\u0003!)\u0007\u0010]3di\u0016$7%\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005eS\u0011aA1qS&\u00111\f\u0017\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0006;\u0002!\t\u0001Q\u0001\u0010i\u0016\u001cHo\u0016:p]\u001e4\u0015.\u001a7eg\"\"AL\u0011+V\u0011\u0015\u0001\u0007\u0001\"\u0001A\u0003Q!Xm\u001d;Ti\u0006$\u0018nY,ji\"4\u0016\r\\;fg\"\u0012qL\u0011")
public class PartitionableSinkTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    private BatchTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table ", " (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ", "\n         |  'format' = 'testcsv'\n         |)\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : ""})))).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongFields() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testStaticWithValues() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) VALUES (5)");
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3)}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
        this.createTable("sink", false);
    }
}

