/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.FirstLastValueAggFunctionWithOrderTestBase;
import org.apache.flink.table.planner.functions.aggfunctions.LastValueWithRetractAggFunction;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public final class LastValueWithRetractAggFunctionWithOrderTest {

    public static abstract class NumberLastValueWithRetractAggFunctionWithOrderTestBase<T>
    extends LastValueWithRetractAggFunctionWithOrderTestBase<T> {
        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null, this.getValue("3"), this.getValue("2"), this.getValue("-99")), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("5")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, 6L, 11L, 13L, 7L, 5L), Arrays.asList(8L, 6L, 9L, 5L), Arrays.asList(null, 6L, 4L, 3L));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("3"), null, this.getValue("10"));
        }
    }

    public static abstract class LastValueWithRetractAggFunctionWithOrderTestBase<T>
    extends FirstLastValueAggFunctionWithOrderTestBase<T, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<T>> {
        @Override
        protected Class<?> getAccClass() {
            return LastValueWithRetractAggFunction.LastValueWithRetractAccumulator.class;
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Object.class, Long.class);
        }
    }

    public static final class StringLastValueWithRetractAggFunctionWithOrderTest
    extends LastValueWithRetractAggFunctionWithOrderTestBase<StringData> {
        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz"), StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"abc")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, null, 3L, 1L, 5L, 10L, 15L, 11L), Arrays.asList(6L, 5L), Arrays.asList(8L, 6L), Arrays.asList(6L, 4L, 3L));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"def"), null, StringData.fromString((String)"a"), StringData.fromString((String)"x"));
        }

        @Override
        protected AggregateFunction<StringData, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<StringData>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    public static final class DecimalLastValueWithRetractAggFunctionWithOrderTest
    extends LastValueWithRetractAggFunctionWithOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 1L, 5L, null, 3L, 1L, 5L, 2L), Arrays.asList(6L, 5L, null, 8L, null), Arrays.asList(8L, 6L));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<DecimalData>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    public static final class BooleanLastValueWithRetractAggFunctionWithOrderTest
    extends LastValueWithRetractAggFunctionWithOrderTestBase<Boolean> {
        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(6L, 2L, 3L), Arrays.asList(1L, 2L, 3L), Arrays.asList(10L, 2L, 5L, 11L, 3L, 7L, 5L), Arrays.asList(6L, 9L, 5L), Arrays.asList(4L, 3L));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, true, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Boolean>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    public static final class DoubleLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Double> {
        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Double>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    public static final class FloatLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Float> {
        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Float>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    public static final class LongLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Long> {
        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Long>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    public static final class IntLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Integer> {
        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Integer>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    public static final class ShortLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Short> {
        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Short>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    public static final class ByteLastValueWithRetractAggFunctionWithOrderTest
    extends NumberLastValueWithRetractAggFunctionWithOrderTestBase<Byte> {
        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, LastValueWithRetractAggFunction.LastValueWithRetractAccumulator<Byte>> getAggregator() {
            return new LastValueWithRetractAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

