/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.FirstLastValueAggFunctionWithOrderTestBase;
import org.apache.flink.table.planner.functions.aggfunctions.FirstValueWithRetractAggFunction;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public final class FirstValueWithRetractAggFunctionWithOrderTest {

    public static abstract class NumberFirstValueWithRetractAggFunctionWithOrderTestBase<T>
    extends FirstValueWithRetractAggFunctionWithOrderTestBase<T> {
        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null, this.getValue("3"), this.getValue("2"), this.getValue("-99")), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("5")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, 6L, 11L, 3L, 7L, 5L), Arrays.asList(8L, 6L, 9L, 5L), Arrays.asList(null, 6L, 4L, 3L));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("3"), null, this.getValue("5"));
        }
    }

    public static abstract class FirstValueWithRetractAggFunctionWithOrderTestBase<T>
    extends FirstLastValueAggFunctionWithOrderTestBase<T, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<T>> {
        @Override
        protected Class<?> getAccClass() {
            return FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator.class;
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Object.class, Long.class);
        }
    }

    public static final class StringFirstValueWithRetractAggFunctionWithOrderTest
    extends FirstValueWithRetractAggFunctionWithOrderTestBase<StringData> {
        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, null, 3L, 1L, 5L), Arrays.asList(6L, 5L), Arrays.asList(8L, 6L), Arrays.asList(6L, 4L, 3L));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"def"), null, StringData.fromString((String)"a"), StringData.fromString((String)"e"));
        }

        @Override
        protected AggregateFunction<StringData, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<StringData>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    public static final class DecimalFirstValueWithRetractAggFunctionWithOrderTest
    extends FirstValueWithRetractAggFunctionWithOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 1L, 5L, null, 3L, 1L, 5L, 2L), Arrays.asList(6L, 5L, null, 8L, null), Arrays.asList(8L, 6L));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<DecimalData>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    public static final class BooleanFirstValueWithRetractAggFunctionWithOrderTest
    extends FirstValueWithRetractAggFunctionWithOrderTestBase<Boolean> {
        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(6L, 2L, 3L), Arrays.asList(1L, 2L, 3L), Arrays.asList(10L, 2L, 5L, 11L, 3L, 7L, 5L), Arrays.asList(6L, 9L, 5L), Arrays.asList(4L, 3L));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, false, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Boolean>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    public static final class DoubleFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Double> {
        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Double>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    public static final class FloatFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Float> {
        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Float>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    public static final class LongFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Long> {
        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Long>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    public static final class IntFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Integer> {
        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Integer>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    public static final class ShortFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Short> {
        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Short>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    public static final class ByteFirstValueWithRetractAggFunctionWithOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithOrderTestBase<Byte> {
        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Byte>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

