/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.Random;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.expressions.ScalarFunctionsTest$;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u0001\u0003\u0001=\u00111cU2bY\u0006\u0014h)\u001e8di&|gn\u001d+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\u0003\u0003\u0015)H/\u001b7t\u0013\t)\"CA\nTG\u0006d\u0017M\u001d+za\u0016\u001cH+Z:u\u0005\u0006\u001cX\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005YA/Z:u\u001fZ,'\u000f\\1z)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRD#aG\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!b\u0011!\u00026v]&$\u0018B\u0001\u0016(\u0005\u0011!Vm\u001d;\t\u000b1\u0002A\u0011A\u000f\u0002\u0019Q,7\u000f\u001e)pg&$\u0018n\u001c8)\u0005-*\u0003\"B\u0018\u0001\t\u0003i\u0012A\u0003;fgRdunY1uK\"\u0012a&\n\u0005\u0006e\u0001!\t!H\u0001\ti\u0016\u001cH\u000fT3gi\"\u0012\u0011'\n\u0005\u0006k\u0001!\t!H\u0001\ni\u0016\u001cHOU5hQRD#\u0001N\u0013\t\u000ba\u0002A\u0011A\u000f\u0002\u0013Q,7\u000f^!tG&L\u0007FA\u001c&\u0011\u0015Y\u0004\u0001\"\u0001\u001e\u0003%!Xm\u001d;J]N$(\u000f\u000b\u0002;K!)a\b\u0001C\u0001;\u0005iA/Z:u'V\u00147\u000f\u001e:j]\u001eD#!P\u0013\t\u000b\u0005\u0003A\u0011A\u000f\u0002\u0017Q,7\u000f\u001e*fa2\f7-\u001a\u0015\u0003\u0001\u0016BQ\u0001\u0012\u0001\u0005\u0002u\t\u0001\u0002^3tiR\u0013\u0018.\u001c\u0015\u0003\u0007\u0016BQa\u0012\u0001\u0005\u0002u\t\u0011\u0002^3ti2#&/[7)\u0005\u0019+\u0003\"\u0002&\u0001\t\u0003i\u0012!\u0003;fgR\u0014FK]5nQ\tIU\u0005C\u0003N\u0001\u0011\u0005Q$\u0001\buKN$8\t[1s\u0019\u0016tw\r\u001e5)\u00051+\u0003\"\u0002)\u0001\t\u0003i\u0012!\u0004;fgR,\u0006\u000f]3s\u0007\u0006\u001cX\r\u000b\u0002PK!)1\u000b\u0001C\u0001;\u0005iA/Z:u\u0019><XM]\"bg\u0016D#AU\u0013\t\u000bY\u0003A\u0011A\u000f\u0002\u0017Q,7\u000f^%oSR\u001c\u0015\r\u001d\u0015\u0003+\u0016BQ!\u0017\u0001\u0005\u0002u\t!\u0002^3ti\u000e{gnY1uQ\tAV\u0005C\u0003]\u0001\u0011\u0005Q$\u0001\u0005uKN$H*[6fQ\tYV\u0005C\u0003`\u0001\u0011\u0005Q$A\u0006uKN$hj\u001c;MS.,\u0007F\u00010&\u0011\u0015\u0011\u0007\u0001\"\u0001\u001e\u0003I!Xm\u001d;MS.,w+\u001b;i\u000bN\u001c\u0017\r]3)\u0005\u0005,\u0003\"B3\u0001\t\u0003i\u0012!\u0006;fgRtu\u000e\u001e'jW\u0016<\u0016\u000e\u001e5Fg\u000e\f\u0007/\u001a\u0015\u0003I\u0016BQ\u0001\u001b\u0001\u0005\u0002u\t1\u0002^3tiNKW.\u001b7be\"\u0012q-\n\u0005\u0006W\u0002!\t!H\u0001\u000fi\u0016\u001cHOT8u'&l\u0017\u000e\\1sQ\tQW\u0005C\u0003o\u0001\u0011\u0005Q$A\u000buKN$8+[7jY\u0006\u0014x+\u001b;i\u000bN\u001c\u0017\r]3)\u00055,\u0003\"B9\u0001\t\u0003i\u0012\u0001\u0007;fgRtu\u000e^*j[&d\u0017M],ji\",5oY1qK\"\u0012\u0001/\n\u0005\u0006i\u0002!\t!H\u0001\u0010i\u0016\u001cH/T;mi&\u001cuN\\2bi\"\u00121/\n\u0005\u0006o\u0002!\t!H\u0001\ri\u0016\u001cHoQ8oG\u0006$xk\u001d\u0015\u0003m\u0016BQA\u001f\u0001\u0005\u0002u\t\u0011\u0003^3tiJ+w-\u001a=q%\u0016\u0004H.Y2fQ\tIX\u0005C\u0003~\u0001\u0011\u0005Q$A\tuKN$(+Z4fqB,\u0005\u0010\u001e:bGRD#\u0001`\u0013\t\r\u0005\u0005\u0001\u0001\"\u0001\u001e\u00039!Xm\u001d;Ge>l')Y:fmQB#a`\u0013\t\r\u0005\u001d\u0001\u0001\"\u0001\u001e\u00031!Xm\u001d;U_\n\u000b7/\u001a\u001c5Q\r\t)!\n\u0005\u0007\u0003\u001b\u0001A\u0011A\u000f\u0002\u001bQ,7\u000f^*vEN#(/\u001b8hQ\r\tY!\n\u0005\u0007\u0003'\u0001A\u0011A\u000f\u0002\u0011Q,7\u000f\u001e'QC\u0012D3!!\u0005&\u0011\u0019\tI\u0002\u0001C\u0001;\u0005AA/Z:u%B\u000bG\rK\u0002\u0002\u0018\u0015Ba!a\b\u0001\t\u0003i\u0012\u0001\u0004;fgR\u0004\u0016M]:f+Jd\u0007fAA\u000fK!1\u0011Q\u0005\u0001\u0005\u0002u\t!\u0002^3tiJ+\u0007/Z1uQ\r\t\u0019#\n\u0005\u0007\u0003W\u0001A\u0011A\u000f\u0002\u0017Q,7\u000f\u001e*fm\u0016\u00148/\u001a\u0015\u0004\u0003S)\u0003BBA\u0019\u0001\u0011\u0005Q$\u0001\buKN$8\u000b\u001d7ji&sG-\u001a=)\u0007\u0005=R\u0005\u0003\u0004\u00028\u0001!\t!H\u0001\ri\u0016\u001cH\u000fS1tQ\u000e{G-\u001a\u0015\u0004\u0003k)\u0003BBA\u001f\u0001\u0011\u0005Q$A\u0004uKN$X\nR\u001b)\u0007\u0005mR\u0005\u0003\u0004\u0002D\u0001!\t!H\u0001\u000bi\u0016\u001cHOU3hKb\u0004\bfAA!K!1\u0011\u0011\n\u0001\u0005\u0002u\tq\u0001^3ti\"+\u0007\u0010K\u0002\u0002H\u0015Ba!a\u0014\u0001\t\u0003i\u0012a\u0002;fgR\u0014\u0015N\u001c\u0015\u0004\u0003\u001b*\u0003BBA+\u0001\u0011\u0005Q$\u0001\u0005uKN$X+V%EQ\r\t\u0019&\n\u0005\u0007\u00037\u0002A\u0011A\u000f\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0007\u0005eS\u0005\u0003\u0004\u0002b\u0001!\t!H\u0001\bi\u0016\u001cH/\u0012=qQ\r\ty&\n\u0005\u0007\u0003O\u0002A\u0011A\u000f\u0002\u0013Q,7\u000f\u001e'pOF\u0002\u0004fAA3K!1\u0011Q\u000e\u0001\u0005\u0002u\t\u0011\u0002^3tiB{w/\u001a:)\u0007\u0005-T\u0005\u0003\u0004\u0002t\u0001!\t!H\u0001\ti\u0016\u001cHoU9si\"\u001a\u0011\u0011O\u0013\t\r\u0005e\u0004\u0001\"\u0001\u001e\u0003!!Xm\u001d;D_ND\u0007fAA<K!1\u0011q\u0010\u0001\u0005\u0002u\ta\u0001^3ti2s\u0007fAA?K!1\u0011Q\u0011\u0001\u0005\u0002u\tq\u0001^3ti\u0006\u00137\u000fK\u0002\u0002\u0004\u0016Ba!a#\u0001\t\u0003i\u0012a\u0006;fgR\f%/\u001b;i[\u0016$\u0018n\u0019$m_>\u00148)Z5mQ\r\tI)\n\u0005\u0007\u0003#\u0003A\u0011A\u000f\u0002\u000fQ,7\u000f^*j]\"\u001a\u0011qR\u0013\t\r\u0005]\u0005\u0001\"\u0001\u001e\u0003\u001d!Xm\u001d;D_ND3!!&&\u0011\u0019\ti\n\u0001C\u0001;\u0005AA/Z:u'&t\u0007\u000eK\u0002\u0002\u001c\u0016Ba!a)\u0001\t\u0003i\u0012a\u0002;fgR$\u0016M\u001c\u0015\u0004\u0003C+\u0003BBAU\u0001\u0011\u0005Q$\u0001\u0005uKN$H+\u00198iQ\r\t9+\n\u0005\u0007\u0003_\u0003A\u0011A\u000f\u0002\u000fQ,7\u000f^\"pi\"\u001a\u0011QV\u0013\t\r\u0005U\u0006\u0001\"\u0001\u001e\u0003!!Xm\u001d;Bg&t\u0007fAAZK!1\u00111\u0018\u0001\u0005\u0002u\t\u0001\u0002^3ti\u0006\u001bwn\u001d\u0015\u0004\u0003s+\u0003BBAa\u0001\u0011\u0005Q$\u0001\u0005uKN$\u0018\t^1oQ\r\ty,\n\u0005\u0007\u0003\u000f\u0004A\u0011A\u000f\u0002\u0013Q,7\u000f^!uC:\u0014\u0004fAAcK!1\u0011Q\u001a\u0001\u0005\u0002u\t1\u0002^3ti\u0012+wM]3fg\"\u001a\u00111Z\u0013\t\r\u0005M\u0007\u0001\"\u0001\u001e\u0003-!Xm\u001d;SC\u0012L\u0017M\\:)\u0007\u0005EW\u0005\u0003\u0004\u0002Z\u0002!\t!H\u0001\ti\u0016\u001cHoU5h]\"\u001a\u0011q[\u0013\t\r\u0005}\u0007\u0001\"\u0001\u001e\u0003%!Xm\u001d;S_VtG\rK\u0002\u0002^\u0016Ba!!:\u0001\t\u0003i\u0012A\u0002;fgR\u0004\u0016\u000eK\u0002\u0002d\u0016Ba!a;\u0001\t\u0003i\u0012A\u0006;fgR\u0014\u0016M\u001c3B]\u0012\u0014\u0016M\u001c3J]R,w-\u001a:)\u0007\u0005%X\u0005\u0003\u0004\u0002r\u0002!\t!H\u0001\u0006i\u0016\u001cH/\u0012\u0015\u0004\u0003_,\u0003BBA|\u0001\u0011\u0005Q$A\u0004uKN$Hj\\4)\u0007\u0005UX\u0005\u0003\u0004\u0002~\u0002!\t!H\u0001\ti\u0016\u001cH\u000fT8he!\u001a\u00111`\u0013\t\r\t\r\u0001\u0001\"\u0001\u001e\u0003\u001d!Xm\u001d;DQJD3A!\u0001&\u0011\u0019\u0011I\u0001\u0001C\u0001;\u0005YA/Z:u\u000bb$(/Y2uQ\r\u00119!\n\u0005\u0007\u0005\u001f\u0001A\u0011A\u000f\u0002#Q,7\u000f\u001e+f[B|'/\u00197GY>|'\u000fK\u0002\u0003\u000e\u0015BaA!\u0006\u0001\t\u0003i\u0012\u0001\u0006;fgR\u001cUO\u001d:f]R$\u0016.\\3Q_&tG\u000fK\u0002\u0003\u0014\u0015BaAa\u0007\u0001\t\u0003i\u0012\u0001\u0004;fgR|e/\u001a:mCB\u001c\bf\u0001B\rK!1!\u0011\u0005\u0001\u0005\u0002u\t1\u0002^3tiF+\u0018M\u001d;fe\"\u001a!qD\u0013\t\r\t\u001d\u0002\u0001\"\u0001\u001e\u0003E!Xm\u001d;US6,7\u000f^1na\u0012KgM\u001a\u0015\u0004\u0005K)\u0003B\u0002B\u0017\u0001\u0011\u0005Q$\u0001\tuKN$H+[7fgR\fW\u000e]!eI\"\u001a!1F\u0013\t\r\tM\u0002\u0001\"\u0001\u001e\u0003=!Xm\u001d;U_RKW.Z:uC6\u0004\bf\u0001B\u0019K!1!\u0011\b\u0001\u0005\u0002u\t!\u0002^3tiR{G)\u0019;fQ\r\u00119$\n\u0005\u0007\u0005\u007f\u0001A\u0011A\u000f\u0002#Q,7\u000f\u001e%bg\"4UO\\2uS>t7\u000fK\u0002\u0003>\u0015BaA!\u0012\u0001\t\u0003i\u0012!\u0005;fgRL5\u000f\u0016:vK&\u001bh)\u00197tK\"\u001a!1I\u0013\t\r\t-\u0003\u0001\"\u0001\u001e\u0003m!Xm\u001d;TiJLgn\u001a$v]\u000e$\u0018n\u001c8t/&$\bNT;mY\"\u001a!\u0011J\u0013\t\r\tE\u0003\u0001\"\u0001\u001e\u00039!Xm\u001d;D_\u0012,w)\u001a8O!\u0016C3Aa\u0014&\u0011\u0019\u00119\u0006\u0001C\u0001;\u0005\u0011B/Z:u\u001dVdGNQ5h\t\u0016\u001c\u0017.\\1mQ\r\u0011)&\n\u0005\u0007\u0005;\u0002A\u0011A\u000f\u0002'Q,7\u000f^#oG>$W-\u00118e\t\u0016\u001cw\u000eZ3)\u0007\tmS\u0005\u0003\u0004\u0003d\u0001!\t!H\u0001\u0010i\u0016\u001cHo\u0015;sS:<Gk\\'ba\"\u001a!\u0011M\u0013\t\r\t%\u0004\u0001\"\u0001\u001e\u0003\u0019!Xm\u001d;JM\"\u001a!qM\u0013\t\r\t=\u0004\u0001\"\u0001\u001e\u00035!Xm\u001d;JM\u0012+7-[7bY\"\u001a!QN\u0013\t\r\tU\u0004\u0001\"\u0001\u001e\u00035!Xm\u001d;Jg\u0012+7-[7bY\"\u001a!1O\u0013\t\r\tm\u0004\u0001\"\u0001\u001e\u0003-!Xm\u001d;Jg\u0012Kw-\u001b;)\u0007\teT\u0005\u0003\u0004\u0003\u0002\u0002!\t!H\u0001\fi\u0016\u001cH/S:BYBD\u0017\rK\u0002\u0003\u0000\u0015BaAa\"\u0001\t\u0003i\u0012a\u0005;fgR\u0014\u0016m\u001e+za\u0016,\u0015/^1mSRL\bf\u0001BCK!1!Q\u0012\u0001\u0005\u0002u\t\u0011\u0006^3tiN#(/\u001b8h\rVt7\r^5p]\u0006sG-\u0012=qe\u0016\u001c8/[8o%\u0016\u001cX\u000f\u001c;UsB,\u0007f\u0001BFK\u0001")
public class ScalarFunctionsTest
extends ScalarTypesTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f0");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("f7");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("f33");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f8");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("f2");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f3");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f4");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("f32");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("f23");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("f24");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("f29");
    private static Symbol symbol$12 = Symbol$.MODULE$.apply("f30");
    private static Symbol symbol$13 = Symbol$.MODULE$.apply("f31");
    private static Symbol symbol$14 = Symbol$.MODULE$.apply("f28");
    private static Symbol symbol$15 = Symbol$.MODULE$.apply("f5");
    private static Symbol symbol$16 = Symbol$.MODULE$.apply("f6");
    private static Symbol symbol$17 = Symbol$.MODULE$.apply("f22");
    private static Symbol symbol$18 = Symbol$.MODULE$.apply("f9");
    private static Symbol symbol$19 = Symbol$.MODULE$.apply("f10");
    private static Symbol symbol$20 = Symbol$.MODULE$.apply("f11");
    private static Symbol symbol$21 = Symbol$.MODULE$.apply("f12");
    private static Symbol symbol$22 = Symbol$.MODULE$.apply("f13");
    private static Symbol symbol$23 = Symbol$.MODULE$.apply("f15");
    private static Symbol symbol$24 = Symbol$.MODULE$.apply("f25");
    private static Symbol symbol$25 = Symbol$.MODULE$.apply("f26");
    private static Symbol symbol$26 = Symbol$.MODULE$.apply("f27");
    private static Symbol symbol$27 = Symbol$.MODULE$.apply("f16");
    private static Symbol symbol$28 = Symbol$.MODULE$.apply("f18");
    private static Symbol symbol$29 = Symbol$.MODULE$.apply("f17");
    private static Symbol symbol$30 = Symbol$.MODULE$.apply("f19");
    private static Symbol symbol$31 = Symbol$.MODULE$.apply("f20");
    private static Symbol symbol$32 = Symbol$.MODULE$.apply("f44");
    private static Symbol symbol$33 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$34 = Symbol$.MODULE$.apply("f21");
    private static Symbol symbol$35 = Symbol$.MODULE$.apply("f41");
    private static Symbol symbol$36 = Symbol$.MODULE$.apply("f34");

    @Test
    public void testOverlay() {
        Seq cases = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"'xxxxxtest'.overlay('xxxx', 6)", (Object)"OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6)", (Object)"xxxxxxxxx"), new Tuple3((Object)"'xxxxxtest'.overlay('xxxx', 6, 2)", (Object)"OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6 FOR 2)", (Object)"xxxxxxxxxst"), new Tuple3((Object)"'123456789'.overlay('abc', 100, 2)", (Object)"OVERLAY('123456789' PLACING 'It' FROM -1 FOR 4)", (Object)"123456789"), new Tuple3((Object)"'123456789'.overlay('abc', -1, 2)", (Object)"OVERLAY('123456789' PLACING 'It' FROM -1 FOR 2)", (Object)"123456789"), new Tuple3((Object)"'123456789'.overlay('abc', 2, 100)", (Object)"OVERLAY('123456789' PLACING 'abc' FROM 2 FOR 100)", (Object)"1abc"), new Tuple3((Object)"'123456789'.overlay('abc', 2, -1)", (Object)"OVERLAY('123456789' PLACING 'abc' FROM 2 FOR -1)", (Object)"1abc"), new Tuple3((Object)"'123456789'.overlay('abc', 100, -1)", (Object)"OVERLAY('123456789' PLACING 'abc' FROM 100 FOR -1)", (Object)"123456789"), new Tuple3((Object)"f0.overlay('It', 1, 4)", (Object)"OVERLAY(f0 PLACING 'It' FROM 1 FOR 4)", (Object)"It is a test String."), new Tuple3((Object)"f0.overlay('It', -1, 4)", (Object)"OVERLAY(f0 PLACING 'It' FROM -1 FOR 4)", (Object)"This is a test String."), new Tuple3((Object)"f0.overlay('It', 100, 4)", (Object)"OVERLAY(f0 PLACING 'It' FROM 100 FOR 4)", (Object)"This is a test String."), new Tuple3((Object)"f0.overlay('It', -1, 2)", (Object)"OVERLAY(f0 PLACING 'It' FROM -1 FOR 2)", (Object)"This is a test String."), new Tuple3((Object)"f0.overlay('It', 100, 2)", (Object)"OVERLAY(f0 PLACING 'It' FROM 100 FOR 2)", (Object)"This is a test String."), new Tuple3((Object)"f0.overlay('IS', 6, 100)", (Object)"OVERLAY(f0 PLACING 'IS' FROM 6 FOR 100)", (Object)"This IS"), new Tuple3((Object)"f0.overlay('IS', 6, -1)", (Object)"OVERLAY(f0 PLACING 'IS' FROM 6 FOR -1)", (Object)"This IS"), new Tuple3((Object)"f40.overlay('It', 1, 4)", (Object)"OVERLAY(f40 PLACING 'It' FROM 1 FOR 2)", (Object)"null")}));
        cases.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;

            public final void apply(Tuple3<String, String, String> x) {
                this.$outer.testAllApis(ExpressionParser.parseExpression((String)((String)x._1())), (String)x._1(), (String)x._2(), (String)x._3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPosition() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").position((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxtest")), "'test'.position('xxxtest')", "POSITION('test' IN 'xxxtest')", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("testx").position((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("xxxtest")), "'testx'.position('xxxtest')", "POSITION('testx' IN 'xxxtest')", "0");
        this.testSqlApi("POSITION('aa' IN 'aaads')", "1");
        this.testSqlApi("position('aa' in 'aaads')", "1");
    }

    @Test
    public void testLocate() {
        this.testSqlApi("locate('test', 'xxxtest')", "4");
        this.testSqlApi("locate('testx', 'xxxtest')", "0");
        this.testSqlApi("locate('aa',  'aaads')", "1");
        this.testSqlApi("locate('aa', 'aaads', 2)", "2");
    }

    @Test
    public void testLeft() {
        this.testSqlApi("`LEFT`(f0, 2)", "Th");
        this.testSqlApi("`LEFT`(f0, 100)", "This is a test String.");
        this.testSqlApi("`LEFT`(f0, -2)", "");
        this.testSqlApi("`LEFT`(f0, 0)", "");
        this.testSqlApi("`LEFT`(f0, CAST(null as Integer))", "null");
        this.testSqlApi("`LEFT`(CAST(null as VARCHAR), -2)", "null");
        this.testSqlApi("`LEFT`(CAST(null as VARCHAR), 2)", "null");
    }

    @Test
    public void testRight() {
        this.testSqlApi("`right`(f0, 2)", "g.");
        this.testSqlApi("`right`(f0, 100)", "This is a test String.");
        this.testSqlApi("`right`(f0, -2)", "");
        this.testSqlApi("`right`(f0, 0)", "");
        this.testSqlApi("`right`(f0, CAST(null as Integer))", "null");
        this.testSqlApi("`right`(CAST(null as VARCHAR), -2)", "null");
        this.testSqlApi("`right`(CAST(null as VARCHAR), 2)", "null");
    }

    @Test
    public void testAscii() {
        this.testSqlApi("ascii('efg')", "101");
        this.testSqlApi("ascii('abcdef')", "97");
        this.testSqlApi("ascii('')", "0");
        this.testSqlApi("ascii(cast (null AS VARCHAR))", "null");
        this.testSqlApi("ascii('val_238') = ascii('val_239')", "true");
    }

    @Test
    public void testInstr() {
        this.testSqlApi("instr('Corporate Floor', 'or', 3, 2)", "14");
        this.testSqlApi("instr('Corporate Floor', 'or', -3, 2)", "2");
        this.testSqlApi("instr('Tech on the net', 'e')", "2");
        this.testSqlApi("instr('Tech on the net', 'e', 1, 2)", "11");
        this.testSqlApi("instr('Tech on the net', 'e', 1, 3)", "14");
        this.testSqlApi("instr('Tech on the net', 'e', -3, 2)", "2");
        this.testSqlApi("instr('myteststring', 'st')", "5");
        this.testSqlApi("instr(cast (null AS VARCHAR), 'e')", "null");
        this.testSqlApi("instr('e', cast (null AS VARCHAR))", "null");
        this.testSqlApi("instr('val_238', '_') = instr('val_239', '_')", "true");
        this.testSqlApi("instr('val_239', '_')", "4");
    }

    @Test
    public void testSubstring() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f0.substring(2)", "SUBSTRING(f0, 2)", "his is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(5)), "f0.substring(2, 5)", "SUBSTRING(f0, 2, 5)", "his i");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f0.substring(1, f7)", "SUBSTRING(f0, 1, f7)", "Thi");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).substring(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).cast(DataTypes.TINYINT()), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f0.substring(1.cast(BYTE), f7)", "SUBSTRING(f0, CAST(1 AS TINYINT), f7)", "Thi");
        this.testSqlApi("SUBSTRING(f0 FROM 2 FOR 1)", "h");
        this.testSqlApi("SUBSTRING(f0 FROM 2)", "his is a test String.");
        this.testSqlApi("SUBSTRING(f0 FROM -2)", "g.");
        this.testSqlApi("SUBSTRING(f0 FROM -2 FOR 1)", "g");
        this.testSqlApi("SUBSTRING(f0 FROM -2 FOR 0)", "");
    }

    @Test
    public void testReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(" "), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_")), "f0.replace(' ', '_')", "REPLACE(f0, ' ', '_')", "This_is_a_test_String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("i"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "f0.replace('i', '')", "REPLACE(f0, 'i', '')", "Ths s a test Strng.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("i"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "f33.replace('i', '')", "REPLACE(f33, 'i', '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).replace((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.STRING()), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "f0.replace(Null(STRING), '')", "REPLACE(f0, NULLIF('', ''), '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).replace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal(" "), (Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.STRING())), "f0.replace(' ', Null(STRING))", "REPLACE(f0, ' ', NULLIF('', ''))", "null");
    }

    @Test
    public void testTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).trim(), "f8.trim()", "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).trim(true, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(" ")), "trim(f8)", "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).trim(false, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(" ")), "f8.trim(TRAILING, ' ')", "TRIM(TRAILING FROM f8)", " This is a test String.");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).trim(true, true, org.apache.flink.table.api.package$.MODULE$.string2Literal(".")), "trim(BOTH, '.', f0)", "TRIM(BOTH '.' FROM f0)", "This is a test String");
        this.testSqlApi("trim(BOTH 'abc' FROM 'abcddcba')", "dd");
        this.testSqlApi("trim(BOTH 'abd' FROM 'abcddcba')", "cddc");
        this.testSqlApi("trim(BOTH '\u5f00\u5fc3' FROM '\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3')", "\u60c5");
        this.testSqlApi("trim(BOTH '\u5f00\u5fc3' FROM '\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3')", "\u60c5");
        this.testSqlApi("trim(LEADING  from '  example  ')", "example  ");
        this.testSqlApi("trim(TRAILING from '  example  ')", "  example");
        this.testSqlApi("trim(BOTH     from '  example  ')", "example");
        this.testSqlApi("trim(LEADING  'e' from 'example')", "xample");
        this.testSqlApi("trim(TRAILING 'e' from 'example')", "exampl");
        this.testSqlApi("trim(BOTH     'e' from 'example')", "xampl");
        this.testSqlApi("trim(BOTH     'xyz' from 'example')", "example");
    }

    @Test
    public void testLTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).ltrim(), "f8.ltrim()", "LTRIM(f8)", "This is a test String. ");
        this.testSqlApi("LTRIM(f8)", "This is a test String. ");
        this.testSqlApi("LTRIM(f0, 'This ')", "a test String.");
        this.testSqlApi("ltrim('abcddcba', 'abc')", "ddcba");
        this.testSqlApi("LTRIM('abcddcba', 'abd')", "cddcba");
        this.testSqlApi("ltrim('\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3', '\u5f00\u5fc3')", "\u60c5\u5f00\u5f00\u5fc3\u5fc3");
        this.testSqlApi("LTRIM('abcddcba', CAST(null as VARCHAR))", "null");
        this.testSqlApi("LTRIM(CAST(null as VARCHAR), 'abcddcba')", "null");
    }

    @Test
    public void testRTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).rtrim(), "f8.rtrim()", "rtrim(f8)", " This is a test String.");
        this.testSqlApi("rtrim(f8)", " This is a test String.");
        this.testSqlApi("rtrim(f0, 'String. ')", "This is a tes");
        this.testSqlApi("rtrim('abcddcba', 'abc')", "abcdd");
        this.testSqlApi("rtrim('abcddcba', 'abd')", "abcddc");
        this.testSqlApi("rtrim('\u5fc3\u60c5\u5f00\u5f00\u5fc3\u5fc3', '\u5f00\u5fc3')", "\u5fc3\u60c5");
        this.testSqlApi("rtrim('abcddcba', CAST(null as VARCHAR))", "null");
        this.testSqlApi("rtrim(CAST(null as VARCHAR), 'abcddcba')", "null");
    }

    @Test
    public void testCharLength() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).charLength(), "f0.charLength()", "CHAR_LENGTH(f0)", "22");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).charLength(), "charLength(f0)", "CHARACTER_LENGTH(f0)", "22");
    }

    @Test
    public void testUpperCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).upperCase(), "f0.upperCase()", "UPPER(f0)", "THIS IS A TEST STRING.");
    }

    @Test
    public void testLowerCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).lowerCase(), "f0.lowerCase()", "LOWER(f0)", "this is a test string.");
    }

    @Test
    public void testInitCap() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).initCap(), "f0.initCap()", "INITCAP(f0)", "This Is A Test String.");
        this.testSqlApi("INITCAP('ab')", "Ab");
        this.testSqlApi("INITCAP('a B')", "A B");
        this.testSqlApi("INITCAP('fLinK')", "Flink");
    }

    @Test
    public void testConcat() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).$plus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$1)), "f0 + f0", "f0||f0", "This is a test String.This is a test String.");
    }

    @Test
    public void testLike() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("Th_s%")), "f0.like('Th_s%')", "f0 LIKE 'Th_s%'", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%is a%")), "f0.like('%is a%')", "f0 LIKE '%is a%'", "true");
        this.testSqlApi("'abcxxxdef' LIKE 'abcx%'", "true");
        this.testSqlApi("'abcxxxdef' LIKE '%%def'", "true");
        this.testSqlApi("'abcxxxdef' LIKE 'abcxxxdef'", "true");
        this.testSqlApi("'abcxxxdef' LIKE '%xdef'", "true");
        this.testSqlApi("'abcxxxdef' LIKE 'abc%def%'", "true");
        this.testSqlApi("'abcxxxdef' LIKE '%abc%def'", "true");
        this.testSqlApi("'abcxxxdef' LIKE '%abc%def%'", "true");
        this.testSqlApi("'abcxxxdef' LIKE 'abc%def'", "true");
        this.testSqlApi("'abcxxxdef' LIKE 'abdxxxdef'", "false");
        this.testSqlApi("'abcxxxdef' LIKE '%xqef'", "false");
        this.testSqlApi("'abcxxxdef' LIKE 'abc%qef%'", "false");
        this.testSqlApi("'abcxxxdef' LIKE '%abc%qef'", "false");
        this.testSqlApi("'abcxxxdef' LIKE '%abc%qef%'", "false");
        this.testSqlApi("'abcxxxdef' LIKE 'abc%qef'", "false");
    }

    @Test
    public void testNotLike() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("Th_s%"))).unary_$bang(), "!f0.like('Th_s%')", "f0 NOT LIKE 'Th_s%'", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).like((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("%is a%"))).unary_$bang(), "!f0.like('%is a%')", "f0 NOT LIKE '%is a%'", "false");
    }

    @Test
    public void testLikeWithEscape() {
        this.testSqlApi("f23 LIKE '&%Th_s%' ESCAPE '&'", "true");
        this.testSqlApi("f23 LIKE '&%%is a%' ESCAPE '&'", "true");
        this.testSqlApi("f0 LIKE 'Th_s%' ESCAPE '&'", "true");
        this.testSqlApi("f0 LIKE '%is a%' ESCAPE '&'", "true");
    }

    @Test
    public void testNotLikeWithEscape() {
        this.testSqlApi("f23 NOT LIKE '&%Th_s%' ESCAPE '&'", "false");
        this.testSqlApi("f23 NOT LIKE '&%%is a%' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT LIKE 'Th_s%' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT LIKE '%is a%' ESCAPE '&'", "false");
    }

    @Test
    public void testSimilar() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_*")), "f0.similar('_*')", "f0 SIMILAR TO '_*'", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*")), "f0.similar('This (is)? a (test)+ Strin_*')", "f0 SIMILAR TO 'This (is)? a (test)+ Strin_*'", "true");
    }

    @Test
    public void testNotSimilar() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("_*"))).unary_$bang(), "!f0.similar('_*')", "f0 NOT SIMILAR TO '_*'", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).similar((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*"))).unary_$bang(), "!f0.similar('This (is)? a (test)+ Strin_*')", "f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*'", "false");
    }

    @Test
    public void testSimilarWithEscape() {
        this.testSqlApi("f24 SIMILAR TO '&*&__*' ESCAPE '&'", "true");
        this.testSqlApi("f0 SIMILAR TO '_*' ESCAPE '&'", "true");
        this.testSqlApi("f24 SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "true");
        this.testSqlApi("f0 SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "true");
    }

    @Test
    public void testNotSimilarWithEscape() {
        this.testSqlApi("f24 NOT SIMILAR TO '&*&__*' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT SIMILAR TO '_*' ESCAPE '&'", "false");
        this.testSqlApi("f24 NOT SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "false");
    }

    @Test
    public void testMultiConcat() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("xx"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)})), "concat('xx', f33)", "CONCAT('xx', f33)", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.package$.MODULE$.string2Literal("CC"), org.apache.flink.table.api.package$.MODULE$.string2Literal("---")})), "concat('AA','BB','CC','---')", "CONCAT('AA','BB','CC','---')", "AABBCC---");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat(org.apache.flink.table.api.package$.MODULE$.string2Literal("x~x"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("b~b"), org.apache.flink.table.api.package$.MODULE$.string2Literal("c~~~~c"), org.apache.flink.table.api.package$.MODULE$.string2Literal("---")})), "concat('x~x','b~b','c~~~~c','---')", "CONCAT('x~x','b~b','c~~~~c','---')", "x~xb~bc~~~~c---");
        this.testSqlApi("concat(f35)", "a");
        this.testSqlApi("concat(f35,f36)", "ab");
        this.testSqlApi("concat(f35,f36,f33)", "null");
    }

    @Test
    public void testConcatWs() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "concat_ws(f33, 'AA')", "CONCAT_WS(f33, 'AA')", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "concat_ws('~~~~','AA')", "concat_ws('~~~~','AA')", "AA");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("BB")})), "concat_ws('~','AA','BB')", "concat_ws('~','AA','BB')", "AA~BB");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.string2Literal("AA"), org.apache.flink.table.api.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.package$.MODULE$.string2Literal(""), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), org.apache.flink.table.api.package$.MODULE$.string2Literal("CC")})), "concat_ws('~',f33, 'AA','BB','',f33, 'CC')", "concat_ws('~',f33, 'AA','BB','',f33, 'CC')", "AA~BB~~CC");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.concat_ws(org.apache.flink.table.api.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.package$.MODULE$.string2Literal("Flink"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), org.apache.flink.table.api.package$.MODULE$.string2Literal("xx"), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)})), "concat_ws('~~~~','Flink', f33, 'xx', f33, f33)", "CONCAT_WS('~~~~','Flink', f33, 'xx', f33, f33)", "Flink~~~~xx");
        this.testSqlApi("concat_ws('||', f35, f36, f33)", "a||b");
    }

    @Test
    public void testRegexpReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("abc")), "'foobar'.regexpReplace('oo|ar', 'abc')", "regexp_replace('foobar', 'oo|ar', 'abc')", "fabcbabc");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foofar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("^f"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "'foofar'.regexpReplace('^f', '')", "regexp_replace('foofar', '^f', '')", "oofar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("^f*.*r$"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace('^f*.*r$', '')", "regexp_replace('foobar', '^f*.*r$', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foo1bar2").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\d"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "'foo1bar2'.regexpReplace('\\d', '')", "regexp_replace('foobar', '\\d', '')", "foobar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\w"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace('\\w', '')", "regexp_replace('foobar', '\\w', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("fooobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("$")), "'fooobar'.regexpReplace('oo', '$')", "regexp_replace('fooobar', 'oo', '$')", "f$obar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("\\")), "'foobar'.regexpReplace('oo', '\\')", "regexp_replace('foobar', 'oo', '\\')", "f\\bar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "f33.regexpReplace('oo|ar', '')", "REGEXP_REPLACE(f33, 'oo|ar', '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace(f33, '')", "REGEXP_REPLACE('foobar', f33, '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)), "'foobar'.regexpReplace('oo|ar', f33)", "REGEXP_REPLACE('foobar', 'oo|ar', f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.STRING())).regexpReplace((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("oo|ar"), (Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3)), "nullOf(STRING).regexpReplace('oo|ar', f33)", "REGEXP_REPLACE(CAST(NULL AS VARCHAR), 'oo|ar', f33)", "null");
    }

    @Test
    public void testRegexpExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 2)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 0)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 0)", "foothebar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 1)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 1)", "the");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo([\\w]+)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo([\\w]+)', 1)", "REGEXP_EXTRACT('foothebar', 'foo([\\w]+)', 1)", "thebar");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo([\\d]+)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo([\\d]+)', 1)", "REGEXP_EXTRACT('foothebar', 'foo([\\d]+)', 1)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)"), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f33.regexpExtract('foo(.*?)(bar)', 2)", "REGEXP_EXTRACT(f33, 'foo(.*?)(bar)', 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$3), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "'foothebar'.regexpExtract(f33, 2)", "REGEXP_EXTRACT('foothebar', f33, 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract((Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("foo(.*?)(bar)")), "'foothebar'.regexpExtract('foo(.*?)(bar)')", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)')", "foothebar");
    }

    @Test
    public void testFromBase64() {
        this.testSqlApi("FROM_BASE64('aGVsbG8gd29ybGQ=')", "hello world");
        this.testSqlApi("CONCAT(FROM_BASE64('5L2g5aW9'), ' flink')", "\u4f60\u597d flink");
        this.testSqlApi("FROM_BASE64(f33)", "null");
        this.testSqlApi("FROM_BASE64('5L2g5aW9')", "\u4f60\u597d");
        this.testSqlApi("FROM_BASE64(CAST(x'6147567362473867643239796247513D' AS VARBINARY))", "hello world");
        this.testSqlApi("FROM_BASE64(x'6147567362473867643239796247513D')", "hello world");
        this.testSqlApi("FROM_BASE64(f58)", "\u4f60\u597d");
    }

    @Test
    public void testToBase64() {
        this.testSqlApi("TO_BASE64(f0)", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==");
        this.testSqlApi("TO_BASE64(f8)", "IFRoaXMgaXMgYSB0ZXN0IFN0cmluZy4g");
        this.testSqlApi("TO_BASE64('')", "");
        this.testSqlApi("TO_BASE64(f33)", "null");
        this.testSqlApi("TO_BASE64('\u4f60\u597d')", "5L2g5aW9");
        this.testSqlApi("to_base64(f37)", "AQIDBA==");
        this.testSqlApi("to_base64(from_base64(f38))", "AQIDBA==");
    }

    @Test
    public void testSubString() {
        Predef$.MODULE$.refArrayOps((Object[])new String[]{"substring", "substr"}).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;

            public final void apply(String substr) {
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, 2, 3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "his");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, 2, 100)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "his is a test String.");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, 100, 10)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, 2, -1)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "null");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f40, 2, 3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "null");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(CAST(null AS VARCHAR), 2, 3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "null");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, 2, f14)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "null");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f0, f30, f7)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "Thi");
                this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(f39, 1, 2)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{substr})), "1\u4e16");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testLPad() {
        this.testSqlApi("lpad(f33,1,'??')", "null");
        this.testSqlApi("lpad(f35, 1, '??')", "a");
        this.testSqlApi("lpad(f35, 2, '??')", "?a");
        this.testSqlApi("lpad(f35, 5, '??')", "????a");
        this.testSqlApi("lpad(f35, CAST(null as INT), '??')", "null");
        this.testSqlApi("lpad(f35, 5, CAST(null as VARCHAR))", "null");
        this.testSqlApi("lpad(f40, 1, '??')", "null");
        this.testSqlApi("lpad('hi', 1, '??')", "h");
        this.testSqlApi("lpad('hi', 5, '??')", "???hi");
        this.testSqlApi("lpad(CAST(null as VARCHAR), 5, '??')", "null");
        this.testSqlApi("lpad('hi', CAST(null as INT), '??')", "null");
        this.testSqlApi("lpad('hi', 5, CAST(null as VARCHAR))", "null");
        this.testSqlApi("lpad('',1,'??')", "?");
        this.testSqlApi("lpad('',30,'??')", "??????????????????????????????");
        this.testSqlApi("lpad('111',-2,'??')", "null");
        this.testSqlApi("lpad('ab',1,'??')", "a");
        this.testSqlApi("lpad('\u23a8\u23a8',1,'??')", "\u23a8");
        this.testSqlApi("lpad('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',2,'??')", "\u00e4\u00e4");
        this.testSqlApi("lpad('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',10,'??')", "?\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4");
        this.testSqlApi("lpad('Hello', -1, 'x') IS NULL", "true");
        this.testSqlApi("lpad('Hello', -1, 'x') IS NOT NULL", "false");
        this.testSqlApi("lpad('ab', 5, '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").lpad((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(13), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("12345")), "'\u00e4\u00e4\u00e4'.lpad(13, '12345')", "lpad('\u00e4\u00e4\u00e4',13,'12345')", "1234512345\u00e4\u00e4\u00e4");
    }

    @Test
    public void testRPad() {
        this.testSqlApi("rpad(f33,1,'??')", "null");
        this.testSqlApi("rpad(f35, 1, '??')", "a");
        this.testSqlApi("rpad(f35, 2, '??')", "a?");
        this.testSqlApi("rpad(f35, 5, '??')", "a????");
        this.testSqlApi("rpad(f35, CAST(null as INT), '??')", "null");
        this.testSqlApi("rpad(f35, 5, CAST(null as VARCHAR))", "null");
        this.testSqlApi("rpad(f40, 1, '??')", "null");
        this.testSqlApi("rpad('hi', 1, '??')", "h");
        this.testSqlApi("rpad('hi', 5, '??')", "hi???");
        this.testSqlApi("rpad(CAST(null as VARCHAR), 5, '??')", "null");
        this.testSqlApi("rpad('hi', CAST(null as INT), '??')", "null");
        this.testSqlApi("rpad('hi', 5, CAST(null as VARCHAR))", "null");
        this.testSqlApi("rpad('',1,'??')", "?");
        this.testSqlApi("rpad('111',-2,'??')", "null");
        this.testSqlApi("rpad('ab',1,'??')", "a");
        this.testSqlApi("rpad('\u00fc\u00f6',1,'??')", "\u00fc");
        this.testSqlApi("rpad('abcd', 5, '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").rpad((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(13), (Object)org.apache.flink.table.api.package$.MODULE$.string2Literal("12345")), "'\u00e4\u00e4\u00e4'.rpad(13, '12345')", "rpad('\u00e4\u00e4\u00e4',13,'12345')", "\u00e4\u00e4\u00e41234512345");
    }

    @Test
    public void testParseUrl() {
        this.testUrl$1("http://userinfo@flink.apache.org/path?query=1#Ref", "flink.apache.org", "/path", "query=1", "Ref", "http", "/path?query=1", "userinfo@flink.apache.org", "userinfo", "1");
        this.testUrl$1("https://use%20r:pas%20s@example.com/dir%20/pa%20th.HTML?query=x%20y&q2=2#Ref%20two", "example.com", "/dir%20/pa%20th.HTML", "query=x%20y&q2=2", "Ref%20two", "https", "/dir%20/pa%20th.HTML?query=x%20y&q2=2", "use%20r:pas%20s@example.com", "use%20r:pas%20s", "x%20y");
        this.testUrl$1("http://user:pass@host", "host", "", "null", "null", "http", "", "user:pass@host", "user:pass", "null");
        this.testUrl$1("http://user:pass@host/", "host", "/", "null", "null", "http", "/", "user:pass@host", "user:pass", "null");
        this.testUrl$1("http://user:pass@host/?#", "host", "/", "", "", "http", "/?", "user:pass@host", "user:pass", "null");
        this.testUrl$1("http://user:pass@host/file;param?query;p2", "host", "/file;param", "query;p2", "null", "http", "/file;param?query;p2", "user:pass@host", "user:pass", "null");
        this.testUrl$1("invalid://user:pass@host/file;param?query;p2", "null", "null", "null", "null", "null", "null", "null", "null", "null");
    }

    @Test
    public void testRepeat() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f0.repeat(1)", "REPEAT(f0, 1)", "This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f0.repeat(2)", "REPEAT(f0, 2)", "This is a test String.This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(0)), "f0.repeat(0)", "REPEAT(f0, 0)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "f0.repeat(-1)", "REPEAT(f0, -1)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(2)), "f33.repeat(2)", "REPEAT(f33, 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("").repeat((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "''.repeat(1)", "REPEAT('', 2)", "");
    }

    @Test
    public void testReverse() {
        this.testSqlApi("reverse(f38)", "==ABDIQA");
        this.testSqlApi("reverse(f40)", "null");
        this.testSqlApi("reverse('hi')", "ih");
        this.testSqlApi("reverse('hhhi')", "ihhh");
        this.testSqlApi("reverse(CAST(null as VARCHAR))", "null");
    }

    @Test
    public void testSplitIndex() {
        this.testSqlApi("split_index(f38, 'I', 0)", "AQ");
        this.testSqlApi("split_index(f38, 'I', 2)", "null");
        this.testSqlApi("split_index(f38, 'I', -1)", "null");
        this.testSqlApi("split_index(f38, CAST(null as VARCHAR), 0)", "null");
        this.testSqlApi("split_index(f38, 'I', CAST(null as INT))", "null");
        this.testSqlApi("split_index(f38, 'I', -1)", "null");
        this.testSqlApi("split_index(f40, 'I', 0)", "null");
        this.testSqlApi("split_index(f38, 73, 0)", "AQ");
        this.testSqlApi("split_index(f38, 256, 0)", "null");
        this.testSqlApi("split_index(f38, 0, 0)", "null");
        this.testSqlApi("split_index('Test', 'e', 1)", "st");
        this.testSqlApi("split_index(CAST(null as VARCHAR), 'e', 1)", "null");
        this.testSqlApi("split_index('test', CAST(null as VARCHAR), 1)", "null");
        this.testSqlApi("split_index('test', 'e', -1)", "null");
    }

    @Test
    public void testHashCode() {
        this.testSqlApi("hash_code('abc')", "96354");
        this.testSqlApi("hash_code(f35)", "97");
        this.testSqlApi("hash_code(f40)", "null");
        this.testSqlApi("hash_code(CAST(null as VARCHAR))", "null");
    }

    @Test
    public void testMD5() {
        this.testSqlApi("md5('abc')", "900150983cd24fb0d6963f7d28e17f72");
        this.testSqlApi("md5('')", "d41d8cd98f00b204e9800998ecf8427e");
        this.testSqlApi("md5(f35)", "0cc175b9c0f1b6a831c399e269772661");
        this.testSqlApi("md5(f40)", "null");
        this.testSqlApi("md5(CAST(null as VARCHAR))", "null");
    }

    @Test
    public void testRegexp() {
        this.testSqlApi("regexp('100-200', '(\\d+)')", "true");
        this.testSqlApi("regexp('abc-def', '(\\d+)')", "false");
        this.testSqlApi("regexp(f35, 'a')", "true");
        this.testSqlApi("regexp(f40, '(\\d+)')", "null");
        this.testSqlApi("regexp(CAST(null as VARCHAR), '(\\d+)')", "null");
        this.testSqlApi("regexp('100-200', CAST(null as VARCHAR))", "null");
    }

    @Test
    public void testHex() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(100).hex(), "100.hex()", "HEX(100)", "64");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).hex(), "f2.hex()", "HEX(f2)", "2A");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TINYINT())).hex(), "hex(Null(BYTE))", "HEX(CAST(NULL AS TINYINT))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).hex(), "f3.hex()", "HEX(f3)", "2B");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).hex(), "f4.hex()", "HEX(f4)", "2C");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).hex(), "f7.hex()", "HEX(f7)", "3");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).hex(), "12.hex()", "HEX(12)", "C");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).hex(), "10.hex()", "HEX(10)", "A");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).hex(), "0.hex()", "HEX(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("\u00f6").hex(), "'\u00f6'.hex()", "HEX('\u00f6')", "C3B6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).hex(), "f32.hex()", "HEX(f32)", "FFFFFFFFFFFFFFFF");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$1).hex(), "f0.hex()", "HEX(f0)", "546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$4).hex(), "f8.hex()", "HEX(f8)", "20546869732069732061207465737420537472696E672E20");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$9).hex(), "f23.hex()", "HEX(f23)", "25546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$10).hex(), "f24.hex()", "HEX(f24)", "2A5F546869732069732061207465737420537472696E672E");
    }

    @Test
    public void testBin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TINYINT())).bin(), "bin(Null(BYTE))", "BIN((CAST(NULL AS TINYINT)))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).bin(), "f2.bin()", "BIN(f2)", "101010");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).bin(), "f3.bin()", "BIN(f3)", "101011");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).bin(), "f4.bin()", "BIN(f4)", "101100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).bin(), "f7.bin()", "BIN(f7)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(12).bin(), "12.bin()", "BIN(12)", "1100");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).bin(), "10.bin()", "BIN(10)", "1010");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).bin(), "0.bin()", "BIN(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$8).bin(), "f32.bin()", "BIN(f32)", "1111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testUUID() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).charLength(), "uuid().charLength", "CHARACTER_LENGTH(UUID())", "36");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(9), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "uuid().substring(9, 1)", "SUBSTRING(UUID(), 9, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(14), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "uuid().substring(14, 1)", "SUBSTRING(UUID(), 14, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(19), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "uuid().substring(19, 1)", "SUBSTRING(UUID(), 19, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.uuid()).substring((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(24), (Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "uuid().substring(24, 1)", "SUBSTRING(UUID(), 24, 1)", "-");
    }

    @Test
    public void testTruncate() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12)), "f29.truncate(f30)", "truncate(f29, f30)", "0.4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$13).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f31.truncate(f7)", "truncate(f31, f7)", "-0.123");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).truncate((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$8)), "f4.truncate(f32)", "truncate(f4, f32)", "40");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).cast(DataTypes.DOUBLE())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f28.cast(DOUBLE).truncate(1)", "truncate(cast(f28 as DOUBLE), 1)", "0.4");
        this.testSqlApi("truncate(cast(f31 as decimal(38, 18)), 2)", "-0.12");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).cast(DataTypes.FLOAT())).truncate(), "f5.cast(FLOAT).truncate()", "truncate(cast(f5 as float))", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(42).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-1)), "42.truncate(-1)", "truncate(42, -1)", "40");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(42).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(-3)), "42.truncate(-3)", "truncate(42, -3)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.INT())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f33.cast(INT).truncate(1)", "truncate(cast(null as integer), 1)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(43.21).truncate(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.INT())), "43.21.truncate(f33.cast(INT))", "truncate(43.21, cast(null as integer))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.DOUBLE())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f33.cast(DOUBLE).truncate(1)", "truncate(cast(null as double), 1)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.INT())).truncate((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "f33.cast(INT).truncate(1)", "truncate(cast(null as integer))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).cast(DataTypes.DOUBLE())).truncate(), "f33.cast(DOUBLE).truncate()", "truncate(cast(null as double))", "null");
    }

    @Test
    public void testExp() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).exp(), "f2.exp()", "EXP(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).exp(), "f3.exp()", "EXP(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).exp(), "f4.exp()", "EXP(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).exp(), "f5.exp()", "EXP(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).exp(), "f6.exp()", "EXP(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).exp(), "exp(f7)", "EXP(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).exp(), "exp(3)", "EXP(3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(3.0))).toString());
    }

    @Test
    public void testLog10() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).log10(), "f2.log10()", "LOG10(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).log10(), "f3.log10()", "LOG10(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).log10(), "f4.log10()", "LOG10(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).log10(), "f5.log10()", "LOG10(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).log10(), "f6.log10()", "LOG10(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10(4.6))).toString());
    }

    @Test
    public void testPower() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f2.power(f7)", "POWER(f2, f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)((byte)42), 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16)), "f3.power(f6)", "POWER(f3, f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)((short)43), 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f4.power(f5)", "POWER(f4, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)44, (double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f4.power(f5)", "POWER(f4, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)44, (double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f5.power(f5)", "power(f5, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 4.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16)), "f5.power(f6)", "power(f5, f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f5.power(f7)", "power(f5, f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$7)), "f5.power(f4)", "power(f5, f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$15)), "f22.cast(DOUBLE).power(f5)", "power(CAST(f22 AS DOUBLE), f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 4.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16)), "f22.cast(DOUBLE).power(f6)", "power(CAST(f22 AS DOUBLE), f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "f22.cast(DOUBLE).power(f7)", "power(CAST(f22 AS DOUBLE), f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())).power((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$7)), "f22.cast(DOUBLE).power(f4)", "power(CAST(f22 AS DOUBLE), f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).power(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())), "f6.power(f22.cast(DOUBLE))", "power(f6, f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.6, 2.0))).toString());
    }

    @Test
    public void testSqrt() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).sqrt(), "f6.sqrt", "SQRT(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).sqrt(), "f7.sqrt", "SQRT(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).sqrt(), "f4.sqrt", "SQRT(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cast(DataTypes.DOUBLE())).sqrt(), "f22.cast(DOUBLE).sqrt", "SQRT(CAST(f22 AS DOUBLE))", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(2.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).sqrt(), "f5.sqrt", "SQRT(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 0.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(25).sqrt(), "25.sqrt()", "SQRT(25)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralDoubleExpression(2.2).sqrt(), "2.2.sqrt()", "POWER(CAST(2.2 AS DOUBLE), CAST(0.5 AS DOUBLE))", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(2.2))).toString());
    }

    @Test
    public void testCosh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).cosh(), "0.cosh()", "COSH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).cosh(), "-1.cosh()", "COSH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).cosh(), "f4.cosh", "COSH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).cosh(), "f6.cosh", "COSH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).cosh(), "f7.cosh", "COSH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).cosh(), "f22.cosh", "COSH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(2.0))).toString());
    }

    @Test
    public void testLn() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).ln(), "f2.ln()", "LN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).ln(), "f3.ln()", "LN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).ln(), "f4.ln()", "LN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).ln(), "f5.ln()", "LN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).ln(), "f6.ln()", "LN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log(4.6))).toString());
    }

    @Test
    public void testAbs() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).abs(), "f2.abs()", "ABS(f2)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).abs(), "f3.abs()", "ABS(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).abs(), "f4.abs()", "ABS(f4)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).abs(), "f5.abs()", "ABS(f5)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).abs(), "f6.abs()", "ABS(f6)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$18).abs(), "f9.abs()", "ABS(f9)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$19).abs(), "f10.abs()", "ABS(f10)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$20).abs(), "f11.abs()", "ABS(f11)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$21).abs(), "f12.abs()", "ABS(f12)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$22).abs(), "f13.abs()", "ABS(f13)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).abs(), "f15.abs()", "ABS(f15)", "1231.1231231321321321111");
    }

    @Test
    public void testArithmeticFloorCeil() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).floor(), "f5.floor()", "FLOOR(f5)", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).ceil(), "f5.ceil()", "CEIL(f5)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).floor(), "f3.floor()", "FLOOR(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).ceil(), "f3.ceil()", "CEIL(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).floor(), "f15.floor()", "FLOOR(f15)", "-1232");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).ceil(), "f15.ceil()", "CEIL(f15)", "-1231");
    }

    @Test
    public void testSin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).sin(), "f2.sin()", "SIN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).sin(), "f3.sin()", "SIN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).sin(), "f4.sin()", "SIN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).sin(), "f5.sin()", "SIN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).sin(), "f6.sin()", "SIN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).sin(), "sin(f15)", "SIN(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin(-1231.1231231321322))).toString());
    }

    @Test
    public void testCos() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).cos(), "f2.cos()", "COS(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).cos(), "f3.cos()", "COS(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).cos(), "f4.cos()", "COS(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).cos(), "f5.cos()", "COS(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).cos(), "f6.cos()", "COS(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).cos(), "cos(f15)", "COS(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos(-1231.1231231321322))).toString());
    }

    @Test
    public void testSinh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).sinh(), "0.sinh()", "SINH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).sinh(), "-1.sinh()", "SINH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).sinh(), "f4.sinh", "SINH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).sinh(), "f6.sinh", "SINH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).sinh(), "f7.sinh", "SINH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).sinh(), "f22.sinh", "SINH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(2.0))).toString());
    }

    @Test
    public void testTan() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).tan(), "f2.tan()", "TAN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).tan(), "f3.tan()", "TAN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).tan(), "f4.tan()", "TAN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).tan(), "f5.tan()", "TAN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).tan(), "f6.tan()", "TAN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).tan(), "tan(f15)", "TAN(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan(-1231.1231231321322))).toString());
    }

    @Test
    public void testTanh() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).tanh(), "0.tanh()", "TANH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-1).tanh(), "-1.tanh()", "TANH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).tanh(), "f4.tanh", "TANH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).tanh(), "f6.tanh", "TANH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).tanh(), "f7.tanh", "TANH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$17).tanh(), "f22.tanh", "TANH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(2.0))).toString());
    }

    @Test
    public void testCot() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).cot(), "f2.cot()", "COT(f2)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((byte)42))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).cot(), "f3.cot()", "COT(f3)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((short)43))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).cot(), "f4.cot()", "COT(f4)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)44)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).cot(), "f5.cot()", "COT(f5)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((float)4.5))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).cot(), "f6.cot()", "COT(f6)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan(4.6)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).cot(), "cot(f15)", "COT(f15)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan(-1231.1231231321322)))).toString());
    }

    @Test
    public void testAsin() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$24).asin(), "f25.asin()", "ASIN(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$25).asin(), "f26.asin()", "ASIN(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$26).asin(), "f27.asin()", "ASIN(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).asin(), "f28.asin()", "ASIN(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).asin(), "f29.asin()", "ASIN(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$12).asin(), "f30.asin()", "ASIN(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$13).asin(), "f31.asin()", "ASIN(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(-0.12312313213213211))).toString());
    }

    @Test
    public void testAcos() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$24).acos(), "f25.acos()", "ACOS(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$25).acos(), "f26.acos()", "ACOS(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$26).acos(), "f27.acos()", "ACOS(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).acos(), "f28.acos()", "ACOS(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).acos(), "f29.acos()", "ACOS(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$12).acos(), "f30.acos()", "ACOS(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$13).acos(), "f31.acos()", "ACOS(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(-0.12312313213213211))).toString());
    }

    @Test
    public void testAtan() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$24).atan(), "f25.atan()", "ATAN(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$25).atan(), "f26.atan()", "ATAN(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$26).atan(), "f27.atan()", "ATAN(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$14).atan(), "f28.atan()", "ATAN(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).atan(), "f29.atan()", "ATAN(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$12).atan(), "f30.atan()", "ATAN(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$13).atan(), "f31.atan()", "ATAN(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(-0.12312313213213211))).toString());
    }

    @Test
    public void testAtan2() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$24), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$25)), "atan2(f25, f26)", "ATAN2(f25, f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((byte)0.42), (double)((byte)0)))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$25), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$24)), "atan2(f26, f25)", "ATAN2(f26, f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((short)0), (double)((short)0)))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$26), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$26)), "atan2(f27, f27)", "ATAN2(f27, f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)0, (double)0))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$14), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$14)), "atan2(f28, f28)", "ATAN2(f28, f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((float)0.45), (double)((float)0.45)))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$11)), "atan2(f29, f29)", "ATAN2(f29, f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(0.46, 0.46))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12)), "atan2(f30, f30)", "ATAN2(f30, f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(1.0, 1.0))).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.atan2(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$13), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$13)), "atan2(f31, f31)", "ATAN2(f31, f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(-0.12312313213213211, -0.12312313213213211))).toString());
    }

    @Test
    public void testDegrees() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).degrees(), "f2.degrees()", "DEGREES(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).degrees(), "f3.degrees()", "DEGREES(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).degrees(), "f4.degrees()", "DEGREES(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).degrees(), "f5.degrees()", "DEGREES(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).degrees(), "f6.degrees()", "DEGREES(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).degrees(), "degrees(f15)", "DEGREES(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees(-1231.1231231321322))).toString());
    }

    @Test
    public void testRadians() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$5).radians(), "f2.radians()", "RADIANS(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$6).radians(), "f3.radians()", "RADIANS(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).radians(), "f4.radians()", "RADIANS(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$15).radians(), "f5.radians()", "RADIANS(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).radians(), "f6.radians()", "RADIANS(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).radians(), "radians(f15)", "RADIANS(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians(-1231.1231231321322))).toString());
    }

    @Test
    public void testSign() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).sign(), "f4.sign()", "SIGN(f4)", ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).sign(), "f6.sign()", "SIGN(f6)", ((Object)BoxesRunTime.boxToDouble((double)1.0)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$23).sign(), "sign(f15)", "SIGN(f15)", "-1.0000000000000000000");
    }

    @Test
    public void testRound() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$11).round((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$12)), "f29.round(f30)", "ROUND(f29, f30)", ((Object)BoxesRunTime.boxToDouble((double)0.5)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).round((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$8)), "f4.round(f32)", "ROUND(f4, f32)", ((Object)BoxesRunTime.boxToInteger((int)40)).toString());
        this.testSqlApi("ROUND(125.315)", "125");
        this.testSqlApi("ROUND(-125.315, 2)", "-125.32");
        this.testSqlApi("ROUND(125.315, 0)", "125");
        this.testSqlApi("ROUND(1.4, 1)", "1.4");
    }

    @Test
    public void testPi() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.pi(), "pi()", "pi()", ((Object)BoxesRunTime.boxToDouble((double)Math.PI)).toString());
    }

    @Test
    public void testRandAndRandInteger() {
        Random random1 = new Random(1L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.int2Literal(1)), "rand(1)", "RAND(1)", ((Object)BoxesRunTime.boxToDouble((double)random1.nextDouble())).toString());
        Random random2 = new Random(3L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.rand(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2)), "rand(f7)", "RAND(f7)", ((Object)BoxesRunTime.boxToDouble((double)random2.nextDouble())).toString());
        Random random3 = new Random(1L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.randInteger(org.apache.flink.table.api.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.package$.MODULE$.int2Literal(10)), "randInteger(1, 10)", "RAND_INTEGER(1, 10)", ((Object)BoxesRunTime.boxToInteger((int)random3.nextInt(10))).toString());
        Random random4 = new Random(3L);
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.randInteger(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$2), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$7).cast(DataTypes.INT())), "randInteger(f7, f4.cast(INT))", "RAND_INTEGER(f7, CAST(f4 AS INT))", ((Object)BoxesRunTime.boxToInteger((int)random4.nextInt(44))).toString());
    }

    @Test
    public void testE() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.e(), "E()", "E()", ((Object)BoxesRunTime.boxToDouble((double)Math.E)).toString());
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.e(), "e()", "e()", ((Object)BoxesRunTime.boxToDouble((double)Math.E)).toString());
    }

    @Test
    public void testLog() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).log(), "f6.log", "LOG(f6)", "1.5260563034950492");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(100))).log((Object)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(10))), "(f6 - f6 + 100).log(f6 - f6 + 10)", "LOG(f6 - f6 + 10, f6 - f6 + 100)", "2.0");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))).log(), "(f6+20).log", "LOG(f6+20)", "3.202746442938317");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).log(), "10.log", "LOG(10)", "2.302585092994046");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(100).log((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(10)), "100.log(10)", "LOG(10, 100)", "2.0");
        this.testSqlApi("LOG(cast (null AS DOUBLE))", "null");
        this.testSqlApi("LOG(cast (null AS DOUBLE), 1)", "null");
        this.testSqlApi("LOG(1, cast (null AS DOUBLE))", "null");
        this.testSqlApi("LOG(cast (null AS DOUBLE), cast (null AS DOUBLE))", "null");
    }

    @Test
    public void testLog2() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).log2(), "f6.log2", "LOG2(f6)", "2.2016338611696504");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$16))).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(100))).log2(), "(f6 - f6 + 100).log2()", "LOG2(f6 - f6 + 100)", "6.643856189774725");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$16).$plus(org.apache.flink.table.api.package$.MODULE$.int2Literal(20))).log2(), "(f6+20).log2", "LOG2(f6+20)", "4.620586410451877");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).log2(), "10.log2", "LOG2(10)", "3.3219280948873626");
        this.testSqlApi("LOG2(cast (null AS DOUBLE))", "null");
    }

    @Test
    public void testChr() {
        this.testSqlApi("CHR(f4)", ",");
        this.testSqlApi("CHR(f43)", "");
        this.testSqlApi("CHR(f42)", ((Object)BoxesRunTime.boxToCharacter((char)'\u0000')).toString());
        this.testSqlApi("CHR(65)", "A");
        this.testSqlApi("CHR(CAST (-10 AS BIGINT))", "");
        this.testSqlApi("CHR(300)", ",");
        this.testSqlApi("CHR(97)", "a");
        this.testSqlApi("CHR(97 + 256)", "a");
        this.testSqlApi("CHR(-9)", "");
        this.testSqlApi("CHR(0)", ((Object)BoxesRunTime.boxToCharacter((char)'\u0000')).toString());
        this.testSqlApi("CHR(149)", ((Object)BoxesRunTime.boxToCharacter((char)((char)149))).toString());
        this.testSqlApi("CHR(cast (null AS BIGINT))", "null");
    }

    @Test
    public void testExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.YEAR), "f16.extract(YEAR)", "EXTRACT(YEAR FROM f16)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.QUARTER), "f16.extract(QUARTER)", "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.MONTH), "extract(f16, MONTH)", "EXTRACT(MONTH FROM f16)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.WEEK), "extract(f16, WEEK)", "EXTRACT(WEEK FROM f16)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.DAY), "f16.extract(DAY)", "EXTRACT(DAY FROM f16)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.YEAR), "f18.extract(YEAR)", "EXTRACT(YEAR FROM f18)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.QUARTER), "f18.extract(QUARTER)", "EXTRACT(QUARTER FROM f18)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).extract(TimeIntervalUnit.QUARTER), "f16.extract(QUARTER)", "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.MONTH), "f18.extract(MONTH)", "EXTRACT(MONTH FROM f18)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.WEEK), "f18.extract(WEEK)", "EXTRACT(WEEK FROM f18)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.DAY), "f18.extract(DAY)", "EXTRACT(DAY FROM f18)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.HOUR), "f18.extract(HOUR)", "EXTRACT(HOUR FROM f18)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).extract(TimeIntervalUnit.HOUR), "f17.extract(HOUR)", "EXTRACT(HOUR FROM f17)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.MINUTE), "f18.extract(MINUTE)", "EXTRACT(MINUTE FROM f18)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).extract(TimeIntervalUnit.MINUTE), "f17.extract(MINUTE)", "EXTRACT(MINUTE FROM f17)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).extract(TimeIntervalUnit.SECOND), "f18.extract(SECOND)", "EXTRACT(SECOND FROM f18)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).extract(TimeIntervalUnit.SECOND), "f17.extract(SECOND)", "EXTRACT(SECOND FROM f17)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$30).extract(TimeIntervalUnit.DAY), "f19.extract(DAY)", "EXTRACT(DAY FROM f19)", "16979");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$30).extract(TimeIntervalUnit.HOUR), "f19.extract(HOUR)", "EXTRACT(HOUR FROM f19)", "7");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$30).extract(TimeIntervalUnit.MINUTE), "f19.extract(MINUTE)", "EXTRACT(MINUTE FROM f19)", "23");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$30).extract(TimeIntervalUnit.SECOND), "f19.extract(SECOND)", "EXTRACT(SECOND FROM f19)", "33");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$31).extract(TimeIntervalUnit.MONTH), "f20.extract(MONTH)", "EXTRACT(MONTH FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$31).extract(TimeIntervalUnit.QUARTER), "f20.extract(QUARTER)", "EXTRACT(QUARTER FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$31).extract(TimeIntervalUnit.YEAR), "f20.extract(YEAR)", "EXTRACT(YEAR FROM f20)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f18)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f16)", "2");
        this.testSqlApi("EXTRACT(CENTURY FROM f18)", "20");
        this.testSqlApi("EXTRACT(CENTURY FROM f16)", "20");
        this.testSqlApi("EXTRACT(DOY FROM f18)", "315");
        this.testSqlApi("EXTRACT(DOY FROM f16)", "315");
        this.testSqlApi("EXTRACT(DOW FROM f18)", "1");
        this.testSqlApi("EXTRACT(DOW FROM f16)", "1");
        this.testSqlApi("EXTRACT(QUARTER FROM f18)", "4");
        this.testSqlApi("EXTRACT(QUARTER FROM f16)", "4");
        this.testSqlApi("EXTRACT(WEEK FROM f18)", "45");
        this.testSqlApi("EXTRACT(WEEK FROM f16)", "45");
        this.testSqlApi("YEAR(f18)", "1996");
        this.testSqlApi("YEAR(f16)", "1996");
        this.testSqlApi("QUARTER(f18)", "4");
        this.testSqlApi("QUARTER(f16)", "4");
        this.testSqlApi("MONTH(f18)", "11");
        this.testSqlApi("MONTH(f16)", "11");
        this.testSqlApi("WEEK(f18)", "45");
        this.testSqlApi("WEEK(f16)", "45");
        this.testSqlApi("DAYOFYEAR(f18)", "315");
        this.testSqlApi("DAYOFYEAR(f16)", "315");
        this.testSqlApi("DAYOFMONTH(f18)", "10");
        this.testSqlApi("DAYOFMONTH(f16)", "10");
        this.testSqlApi("DAYOFWEEK(f18)", "1");
        this.testSqlApi("DAYOFWEEK(f16)", "1");
        this.testSqlApi("HOUR(f17)", "6");
        this.testSqlApi("HOUR(f19)", "7");
        this.testSqlApi("MINUTE(f17)", "55");
        this.testSqlApi("MINUTE(f19)", "23");
        this.testSqlApi("SECOND(f17)", "44");
        this.testSqlApi("SECOND(f19)", "33");
    }

    @Test
    public void testTemporalFloor() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.YEAR), "f18.floor(YEAR)", "FLOOR(f18 TO YEAR)", "1996-01-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.MONTH), "f18.floor(MONTH)", "FLOOR(f18 TO MONTH)", "1996-11-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.DAY), "f18.floor(DAY)", "FLOOR(f18 TO DAY)", "1996-11-10 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.HOUR), "f18.floor(HOUR)", "FLOOR(f18 TO HOUR)", "1996-11-10 06:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.MINUTE), "f18.floor(MINUTE)", "FLOOR(f18 TO MINUTE)", "1996-11-10 06:55:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).floor(TimeIntervalUnit.SECOND), "f18.floor(SECOND)", "FLOOR(f18 TO SECOND)", "1996-11-10 06:55:44.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).floor(TimeIntervalUnit.HOUR), "f17.floor(HOUR)", "FLOOR(f17 TO HOUR)", "06:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).floor(TimeIntervalUnit.MINUTE), "f17.floor(MINUTE)", "FLOOR(f17 TO MINUTE)", "06:55:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).floor(TimeIntervalUnit.SECOND), "f17.floor(SECOND)", "FLOOR(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).floor(TimeIntervalUnit.YEAR), "f16.floor(YEAR)", "FLOOR(f16 TO YEAR)", "1996-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).floor(TimeIntervalUnit.MONTH), "f16.floor(MONTH)", "FLOOR(f16 TO MONTH)", "1996-11-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.YEAR), "f18.ceil(YEAR)", "CEIL(f18 TO YEAR)", "1997-01-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.MONTH), "f18.ceil(MONTH)", "CEIL(f18 TO MONTH)", "1996-12-01 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.DAY), "f18.ceil(DAY)", "CEIL(f18 TO DAY)", "1996-11-11 00:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.HOUR), "f18.ceil(HOUR)", "CEIL(f18 TO HOUR)", "1996-11-10 07:00:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.MINUTE), "f18.ceil(MINUTE)", "CEIL(f18 TO MINUTE)", "1996-11-10 06:56:00.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$28).ceil(TimeIntervalUnit.SECOND), "f18.ceil(SECOND)", "CEIL(f18 TO SECOND)", "1996-11-10 06:55:45.000");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).ceil(TimeIntervalUnit.HOUR), "f17.ceil(HOUR)", "CEIL(f17 TO HOUR)", "07:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).ceil(TimeIntervalUnit.MINUTE), "f17.ceil(MINUTE)", "CEIL(f17 TO MINUTE)", "06:56:00");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$29).ceil(TimeIntervalUnit.SECOND), "f17.ceil(SECOND)", "CEIL(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).ceil(TimeIntervalUnit.YEAR), "f16.ceil(YEAR)", "CEIL(f16 TO YEAR)", "1997-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$27).ceil(TimeIntervalUnit.MONTH), "f16.ceil(MONTH)", "CEIL(f16 TO MONTH)", "1996-12-01");
    }

    @Test
    public void testCurrentTimePoint() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentDate()).cast(DataTypes.STRING())).charLength(), "currentDate().cast(STRING).charLength()", "CHAR_LENGTH(CAST(CURRENT_DATE AS VARCHAR))", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTime()).cast(DataTypes.STRING())).charLength(), "localTime().cast(STRING).charLength()", "CHAR_LENGTH(CAST(LOCALTIME AS VARCHAR))", "8");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentTime()).cast(DataTypes.STRING())).charLength(), "currentTime().cast(STRING).charLength()", "CHAR_LENGTH(CAST(CURRENT_TIME AS VARCHAR))", "8");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTimestamp()).cast(DataTypes.STRING())).charLength(), "localTimestamp().cast(STRING).charLength()", "CHAR_LENGTH(CAST(LOCALTIMESTAMP AS VARCHAR))", "23");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.currentTimestamp()).cast(DataTypes.STRING())).charLength(), "currentTimestamp().cast(STRING).charLength()", "CHAR_LENGTH(CAST(CURRENT_TIMESTAMP AS VARCHAR))", "23");
        this.testSqlApi("CHAR_LENGTH(CAST(NOW() AS VARCHAR))", "23");
        this.testSqlApi("CHAR_LENGTH(CAST(CURRENT_ROW_TIMESTAMP() AS VARCHAR))", "23");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.localTimestamp()).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.localTimestamp()), "localTimestamp() === localTimestamp()", "LOCALTIMESTAMP = LOCALTIMESTAMP", "true");
    }

    @Test
    public void testOverlaps() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2:55:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).hour(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("3:30:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(2).hours()), "temporalOverlaps('2:55:00'.toTime, 1.hour, '3:30:00'.toTime, 2.hours)", "(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:30:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:29:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:31:00").toTime()), "temporalOverlaps(toTime('9:00:00'), '9:30:00'.toTime, '9:29:00'.toTime, '9:31:00'.toTime)", "(TIME '9:00:00', TIME '9:30:00') OVERLAPS (TIME '9:29:00', TIME '9:31:00')", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("10:00:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("10:15:00").toTime(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).hours()), "temporalOverlaps('9:00:00'.toTime, '10:00:00'.toTime, '10:15:00'.toTime, 3.hours)", "(TIME '9:00:00', TIME '10:00:00') OVERLAPS (TIME '10:15:00', INTERVAL '3' HOUR)", "false");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10").toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).days(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-19").toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(10).days()), "temporalOverlaps(toDate('2011-03-10'), 10.days, '2011-03-19'.toDate, 10.days)", "(DATE '2011-03-10', INTERVAL '10' DAY) OVERLAPS (DATE '2011-03-19', INTERVAL '10' DAY)", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:01").toTimestamp()), "temporalOverlaps(toTimestamp('2011-03-10 05:02:02'), 0.milli, '2011-03-10 05:02:02'.toTimestamp, '2011-03-10 05:02:01'.toTimestamp)", "(TIMESTAMP '2011-03-10 05:02:02', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 05:02:02', TIMESTAMP '2011-03-10 05:02:01')", "true");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.temporalOverlaps((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.001").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp()), "temporalOverlaps('2011-03-10 02:02:02.001'.toTimestamp, 0.milli, '2011-03-10 02:02:02.002'.toTimestamp, '2011-03-10 02:02:02.002'.toTimestamp)", "(TIMESTAMP '2011-03-10 02:02:02.001', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 02:02:02.002', TIMESTAMP '2011-03-10 02:02:02.002')", "false");
    }

    @Test
    public void testQuarter() {
        this.testSqlApi("QUARTER(DATE '1997-01-27')", "1");
        this.testSqlApi("QUARTER(DATE '1997-04-27')", "2");
        this.testSqlApi("QUARTER(DATE '1997-12-31')", "4");
    }

    @Test
    public void testTimestampDiff() {
        Map dataMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"DAY", (Object)TimePointUnit.DAY, (Object)"SQL_TSI_DAY")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"1"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"3"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"3")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"HOUR", (Object)TimePointUnit.HOUR, (Object)"SQL_TSI_HOUR")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-04 12:12:11", (Object)"25"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"35"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"85"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-12", (Object)"-72")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MINUTE", (Object)TimePointUnit.MINUTE, (Object)"SQL_TSI_MINUTE")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 12:10:11", (Object)"59"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"2111"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"5100"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"4320")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"SECOND", (Object)TimePointUnit.SECOND, (Object)"SQL_TSI_SECOND")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"61"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"126671"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"306000"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"259200")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"WEEK", (Object)TimePointUnit.WEEK, (Object)"SQL_TSI_WEEK")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-05-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"8"), new Tuple3((Object)"2016-04-15", (Object)"2016-07-16 11:11:11", (Object)"13"), new Tuple3((Object)"2016-04-15 11:00:00", (Object)"2016-09-19", (Object)"22"), new Tuple3((Object)"2016-08-15", (Object)"2016-06-18", (Object)"-8")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MONTH", (Object)TimePointUnit.MONTH, (Object)"SQL_TSI_MONTH")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"24"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"23"), new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"21")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"QUARTER", (Object)TimePointUnit.QUARTER, (Object)"SQL_TSI_QUARTER")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-01-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"8"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"7"), new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"7")})))}));
        dataMap.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple3<String, TimePointUnit, String>, Seq<Tuple3<String, String, String>>> check$ifrefutable$2) {
                Tuple2<Tuple3<String, TimePointUnit, String>, Seq<Tuple3<String, String, String>>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;

            public final void apply(Tuple2<Tuple3<String, TimePointUnit, String>, Seq<Tuple3<String, String, String>>> x$3) {
                Tuple2<Tuple3<String, TimePointUnit, String>, Seq<Tuple3<String, String, String>>> tuple2 = x$3;
                if (tuple2 != null) {
                    Tuple3 unitParts = (Tuple3)tuple2._1();
                    Seq dataParts = (Seq)tuple2._2();
                    ((TraversableLike)dataParts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Tuple3<String, String, String>, Object> check$ifrefutable$3) {
                            Tuple2<Tuple3<String, String, String>, Object> tuple2 = check$ifrefutable$3;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, unitParts){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testTimestampDiff$2 $outer;
                        private final Tuple3 unitParts$1;

                        public final void apply(Tuple2<Tuple3<String, String, String>, Object> x$2) {
                            Tuple2<Tuple3<String, String, String>, Object> tuple2 = x$2;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                int index;
                                Tuple3 data = (Tuple3)tuple2._1();
                                int n = index = tuple2._2$mcI$sp();
                                switch (n) {
                                    default: {
                                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                                    }
                                    case 3: {
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)this.unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestampDiff(", ", '", "'.toDate, '", "'.toDate)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", DATE '", "', DATE '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), (String)data._3());
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", DATE '", "', DATE '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._3(), data._1(), data._2()})), (String)data._3());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break;
                                    }
                                    case 2: {
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)this.unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestampDiff(", ", '", "'.toTimestamp, '", "'.toDate)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", TIMESTAMP '", "', DATE '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), (String)data._3());
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", TIMESTAMP '", "', DATE '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._3(), data._1(), data._2()})), (String)data._3());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break;
                                    }
                                    case 1: {
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)this.unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestampDiff(", ", '", "'.toDate, '", "'.toTimestamp)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", DATE '", "', TIMESTAMP '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), (String)data._3());
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", DATE '", "', TIMESTAMP '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._3(), data._1(), data._2()})), (String)data._3());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break;
                                    }
                                    case 0: {
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff((TimePointUnit)this.unitParts$1._2(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestampDiff(", ", '", "'.toTimestamp, '", "'.toTimestamp)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", TIMESTAMP '", "', TIMESTAMP '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._1(), data._1(), data._2()})), (String)data._3());
                                        this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPDIFF(", ", TIMESTAMP '", "', TIMESTAMP '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unitParts$1._3(), data._1(), data._2()})), (String)data._3());
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.unitParts$1 = unitParts$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ScalarFunctionsTest org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff(TimePointUnit.DAY, org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3)), (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()), "timestampDiff(DAY, Null(SQL_TIMESTAMP), '2016-02-24 12:42:25'.toTimestamp)", "TIMESTAMPDIFF(DAY, CAST(NULL AS TIMESTAMP), TIMESTAMP '2016-02-24 12:42:25')", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.timestampDiff(TimePointUnit.DAY, (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp(), org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))), "timestampDiff(DAY, '2016-02-24 12:42:25'.toTimestamp,  Null(SQL_TIMESTAMP))", "TIMESTAMPDIFF(DAY, TIMESTAMP '2016-02-24 12:42:25',  CAST(NULL AS TIMESTAMP))", "null");
    }

    @Test
    public void testTimestampAdd() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-61), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1000), (Object)"2017-11-29 22:58:58.998")}));
        Seq YEAR = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-11-29 22:58:58.998", "2020-11-29 22:58:58.998", "2016-11-29 22:58:58.998", "1956-11-29 22:58:58.998", "1017-11-29 22:58:58.998"}));
        Seq QUARTER = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-02-28 22:58:58.998", "2018-08-29 22:58:58.998", "2017-08-29 22:58:58.998", "2002-08-29 22:58:58.998", "1767-11-29 22:58:58.998"}));
        Seq MONTH = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-12-29 22:58:58.998", "2018-02-28 22:58:58.998", "2017-10-29 22:58:58.998", "2012-10-29 22:58:58.998", "1934-07-29 22:58:58.998"}));
        Seq WEEK = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-12-06 22:58:58.998", "2017-12-20 22:58:58.998", "2017-11-22 22:58:58.998", "2016-09-28 22:58:58.998", "1998-09-30 22:58:58.998"}));
        Seq DAY = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-30 22:58:58.998", "2017-12-02 22:58:58.998", "2017-11-28 22:58:58.998", "2017-09-29 22:58:58.998", "2015-03-05 22:58:58.998"}));
        Seq HOUR = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 23:58:58.998", "2017-11-30 01:58:58.998", "2017-11-29 21:58:58.998", "2017-11-27 09:58:58.998", "2017-10-19 06:58:58.998"}));
        Seq MINUTE = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 22:59:58.998", "2017-11-29 23:01:58.998", "2017-11-29 22:57:58.998", "2017-11-29 21:57:58.998", "2017-11-29 06:18:58.998"}));
        Seq SECOND = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 22:58:59.998", "2017-11-29 22:59:01.998", "2017-11-29 22:58:57.998", "2017-11-29 22:57:57.998", "2017-11-29 22:42:18.998"}));
        Map intervalMapResults = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SECOND"), (Object)SECOND), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_SECOND"), (Object)SECOND)}));
        intervalMapResults.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Seq<String>> check$ifrefutable$4) {
                Tuple2<String, Seq<String>> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, data){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;
            public final Seq data$1;

            public final void apply(Tuple2<String, Seq<String>> x$5) {
                Tuple2<String, Seq<String>> tuple2 = x$5;
                if (tuple2 != null) {
                    String interval = (String)tuple2._1();
                    Seq result = (Seq)tuple2._2();
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, interval, result){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testTimestampAdd$2 $outer;
                        private final String interval$1;
                        private final Seq result$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            Tuple2 tuple2 = (Tuple2)this.$outer.data$1.apply(i);
                            if (tuple2 != null) {
                                Tuple2 tuple22;
                                int offset = tuple2._1$mcI$sp();
                                String ts = (String)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)offset), (Object)ts);
                                int offset2 = tuple23._1$mcI$sp();
                                String ts2 = (String)tuple23._2();
                                Tuple2 timeInterval = this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$intervalCount$1(this.interval$1, offset2);
                                this.$outer.org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer().testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)timeInterval._1()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression(ts2).toTimestamp()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " + '", "'.toTimestamp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeInterval._2(), ts2})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMPADD(", ", ", ", TIMESTAMP '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.interval$1, BoxesRunTime.boxToInteger((int)offset2), ts2})), (String)this.result$1.apply(i));
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.interval$1 = interval$1;
                            this.result$1 = result$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ScalarFunctionsTest org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.data$1 = data$1;
            }
        });
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()).$plus(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE()))), "'2016-02-24 12:42:25'.toTimestamp + Null(INTERVAL_MILLIS)", "TIMESTAMPADD(HOUR, CAST(NULL AS INTEGER), TIMESTAMP '2016-02-24 12:42:25')", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-200).hours()), "Null(SQL_TIMESTAMP) + -200.hours", "TIMESTAMPADD(HOUR, -200, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "'2016-06-15'.toDate + 1.day", "TIMESTAMPADD(DAY, 1, DATE '2016-06-15')", "2016-06-16");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.TIMESTAMP((int)3))).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).months()), "Null(SQL_TIMESTAMP) + 3.months", "TIMESTAMPADD(MONTH, 3, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()).$plus(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.INTERVAL_MILLIS())), "'2016-02-24 12:42:25'.toTimestamp + nullOf(INTERVAL_MILLIS)", "TIMESTAMPADD(HOUR, CAST(NULL AS INTEGER), TIMESTAMP '2016-02-24 12:42:25')", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(-200).hours()), "nullOf(SQL_TIMESTAMP) + -200.hours", "TIMESTAMPADD(HOUR, -200, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(3).months()), "nullOf(SQL_TIMESTAMP) + 3.months", "TIMESTAMPADD(MONTH, 3, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-06-15'.toDate + 1.month", "timestampadd(MONTH, 1, date '2016-06-15')", "2016-07-15");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "'2016-06-15'.toDate + 1.day", "timestampadd(DAY, 1, date '2016-06-15')", "2016-06-16");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).hour()), "'2016-06-15'.toTimestamp - 1.hour", "2016-06-14 23:00:00.000");
        this.testSqlApi("timestampadd(HOUR, -1, date '2016-06-15')", "2016-06-14 23:00:00.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).minute()), "'2016-06-15'.toTimestamp + 1.minute", "2016-06-15 00:01:00.000");
        this.testSqlApi("timestampadd(MINUTE, 1, date '2016-06-15')", "2016-06-15 00:01:00.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "'2016-06-15'.toTimestamp - 1.second", "2016-06-14 23:59:59.000");
        this.testSqlApi("timestampadd(SQL_TSI_SECOND, -1, date '2016-06-15')", "2016-06-14 23:59:59.000000");
        this.testTableApi(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "'2016-06-15'.toTimestamp + 1.second", "2016-06-15 00:00:01.000");
        this.testSqlApi("timestampadd(SECOND, 1, date '2016-06-15')", "2016-06-15 00:00:01.000000");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).second()), "nullOf(SQL_TIMESTAMP) + 1.second", "timestampadd(SECOND, 1, cast(null as date))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.nullOf(Types.SQL_TIMESTAMP())).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).day()), "nullOf(SQL_TIMESTAMP) + 1.day", "timestampadd(DAY, 1, cast(null as date))", "null");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-05-31").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-05-31'.toDate + 1.month", "timestampadd(MONTH, 1, date '2016-05-31')", "2016-06-30");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-01-31").toDate()).$plus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(5).month()), "'2016-01-31'.toDate + 5.month", "timestampadd(MONTH, 5, date '2016-01-31')", "2016-06-30");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-03-31").toDate()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-03-31'.toDate - 1.month", "timestampadd(MONTH, -1, date '2016-03-31')", "2016-02-29");
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("2016-03-31").toDate()).$minus((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(1).week()), "'2016-03-31'.toDate - 1.week", "timestampadd(WEEK, -1, date '2016-03-31')", "2016-03-24");
        this.testSqlApi("TIMESTAMPADD(SECOND, 1, time '23:59:59')", "00:00:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, 1, time '00:00:00')", "00:01:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, 1, time '23:59:59')", "00:00:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, 1, time '23:59:59')", "00:59:59");
        this.testSqlApi("TIMESTAMPADD(DAY, 15, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(WEEK, 3, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MONTH, 6, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(QUARTER, 1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(YEAR, 10, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(SECOND, -1, time '00:00:00')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MINUTE, -1, time '00:00:00')", "23:59:00");
        this.testSqlApi("TIMESTAMPADD(MINUTE, -1, time '00:00:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(HOUR, -1, time '00:00:00')", "23:00:00");
        this.testSqlApi("TIMESTAMPADD(DAY, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(WEEK, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(MONTH, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(QUARTER, -1, time '23:59:59')", "23:59:59");
        this.testSqlApi("TIMESTAMPADD(YEAR, -1, time '23:59:59')", "23:59:59");
    }

    @Test
    public void testToTimestamp() {
        this.testSqlApi("to_timestamp('abc')", "null");
        this.testSqlApi("to_timestamp('2017-09-15 00:00:00')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp('20170915000000', 'yyyyMMddHHmmss')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp('2017-09-15', 'yyyy-MM-dd')", "2017-09-15 00:00:00.000");
        this.testSqlApi("to_timestamp(cast(null as varchar))", "null");
    }

    @Test
    public void testToDate() {
        this.testSqlApi("to_date('2017-09-15 00:00:00')", "2017-09-15");
    }

    @Test
    public void testHashFunctions() {
        String expectedMd5 = "098f6bcd4621d373cade4e832627b4f6";
        String expectedSha1 = "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3";
        String expectedSha224 = "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809";
        String expectedSha256 = "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08";
        String expectedSha384 = "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9";
        String expectedSha512 = "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff";
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").md5(), "md5('test')", "MD5('test')", expectedMd5);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha1(), "sha1('test')", "SHA1('test')", expectedSha1);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha224(), "sha224('test')", "SHA224('test')", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(224)), "sha2('test', 224)", "SHA2('test', 224)", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha256(), "sha256('test')", "SHA256('test')", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(256)), "sha2('test', 256)", "SHA2('test', 256)", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha384(), "sha384('test')", "SHA384('test')", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(384)), "sha2('test', 384)", "SHA2('test', 384)", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha512(), "sha512('test')", "SHA512('test')", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(512)), "sha2('test', 512)", "SHA2('test', 512)", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).md5(), "md5(f33)", "MD5(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha1(), "sha1(f33)", "SHA1(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha224(), "sha224(f33)", "SHA2(f33, 224)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha2((Object)org.apache.flink.table.api.package$.MODULE$.int2Literal(224)), "sha2(f33, 224)", "SHA2(f33, 224)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha256(), "sha256(f33)", "SHA2(f33, 256)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha384(), "sha384(f33)", "SHA2(f33, 384)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$3).sha512(), "sha512(f33)", "SHA2(f33, 512)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.nullOf(DataTypes.INT())), "sha2('test', Null(INT))", "SHA2('test', CAST(NULL AS INT))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("test").sha2((Object)org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$32)), "sha2('test', f44)", "SHA2('test', f44)", expectedSha256);
        this.testSqlApi("MD5(cast('test' as varbinary))", expectedMd5);
        this.testSqlApi("SHA1(cast('test' as varbinary))", expectedSha1);
        this.testSqlApi("SHA224(cast('test' as varbinary))", expectedSha224);
        this.testSqlApi("SHA2(cast('test' as varbinary), 224)", expectedSha224);
        this.testSqlApi("SHA256(cast('test' as varbinary))", expectedSha256);
        this.testSqlApi("SHA2(cast('test' as varbinary), 256)", expectedSha256);
        this.testSqlApi("SHA384(cast('test' as varbinary))", expectedSha384);
        this.testSqlApi("SHA2(cast('test' as varbinary), 384)", expectedSha384);
        this.testSqlApi("SHA512(cast('test' as varbinary))", expectedSha512);
        this.testSqlApi("SHA2(cast('test' as varbinary), 512)", expectedSha512);
        this.testSqlApi("MD5(cast(null as varbinary))", "null");
        this.testSqlApi("SHA1(cast(null as varbinary))", "null");
        this.testSqlApi("SHA224(cast(null as varbinary))", "null");
        this.testSqlApi("SHA2(cast(null as varbinary), 224)", "null");
        this.testSqlApi("SHA256(cast(null as varbinary))", "null");
        this.testSqlApi("SHA2(cast(null as varbinary), 256)", "null");
        this.testSqlApi("SHA384(cast(null as varbinary))", "null");
        this.testSqlApi("SHA2(cast(null as varbinary), 384)", "null");
        this.testSqlApi("SHA512(cast(null as varbinary))", "null");
        this.testSqlApi("SHA2(cast(null as varbinary), 512)", "null");
    }

    @Test
    public void testIsTrueIsFalse() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).isTrue(), "f1.isTrue", "f1 IS TRUE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$34).isTrue(), "f21.isTrue", "f21 IS TRUE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralBooleanExpression(false).isFalse(), "false.isFalse", "FALSE IS FALSE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$34).isFalse(), "f21.isFalse", "f21 IS FALSE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$33).isNotTrue(), "f1.isNotTrue", "f1 IS NOT TRUE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$34).isNotTrue(), "f21.isNotTrue", "f21 IS NOT TRUE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.LiteralBooleanExpression(false).isNotFalse(), "false.isNotFalse", "FALSE IS NOT FALSE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$34).isNotFalse(), "f21.isNotFalse", "f21 IS NOT FALSE", "true");
    }

    @Test
    public void testStringFunctionsWithNull() {
        List functions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"%s.subString(2)", (Object)"SUBSTRING(%s, 2)"), new Tuple2((Object)"%s.trim()", (Object)"TRIM(%s)"), new Tuple2((Object)"%s.like('%%link')", (Object)"%s LIKE '%%link'"), new Tuple2((Object)"%s.charLength()", (Object)"CHAR_LENGTH(%s)"), new Tuple2((Object)"%s.lowerCase()", (Object)"LOWER(%s)"), new Tuple2((Object)"%s.upperCase()", (Object)"UPPER(%s)"), new Tuple2((Object)"%s.initCap()", (Object)"INITCAP(%s)"), new Tuple2((Object)"%s.position('aa')", (Object)"POSITION('aa' IN %s)"), new Tuple2((Object)"%s.overlay('aa', 2)", (Object)"OVERLAY(%s PLACING 'aa' FROM 2 FOR 2)")}));
        String field = "f40";
        functions.foreach((Function1)new Serializable(this, field){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;
            private final String field$1;

            public final void apply(Tuple2<String, String> x) {
                String tableApiString = new StringOps(Predef$.MODULE$.augmentString((String)x._1())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1}));
                String sqlApiString = new StringOps(Predef$.MODULE$.augmentString((String)x._2())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1}));
                this.$outer.testAllApis(ExpressionParser.parseExpression((String)tableApiString), tableApiString, sqlApiString, "null");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.field$1 = field$1;
            }
        });
    }

    @Test
    public void testCodeGenNPE() {
        Seq fields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f0", "f40", "''"}));
        fields.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;

            public final void apply(String x) {
                String tableApiString = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n          |%s.subString(1, -1)\n          |.upperCase()\n        ")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x}));
                String sqlApiString = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("UPPER(%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUBSTRING(%s, 1, -1)"})))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x}));
                this.$outer.testAllApis(ExpressionParser.parseExpression((String)tableApiString), tableApiString, sqlApiString, "null");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testNullBigDecimal() {
        this.testAllApis((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$35).sign(), "f41.sign()", "SIGN(f41)", "null");
    }

    @Test
    public void testEncodeAndDecode() {
        this.testSqlApi("decode(encode('aabbef', 'UTF-16LE'), 'UTF-16LE')", "aabbef");
        this.testSqlApi("decode(encode('aabbef', 'utf-8'), 'utf-8')", "aabbef");
        this.testSqlApi("decode(encode('', 'utf-8'), 'utf-8')", "");
        this.testSqlApi("encode(cast (null AS VARCHAR), 'utf-8')", "null");
        this.testSqlApi("encode(cast (null AS VARCHAR), cast (null AS VARCHAR))", "null");
        this.testSqlApi("encode('aabbef', cast (null AS VARCHAR))", "null");
        this.testSqlApi("decode(cast (null AS BINARY), 'utf-8')", "null");
        this.testSqlApi("decode(cast (null AS BINARY), cast (null AS VARCHAR))", "null");
        this.testSqlApi("decode(encode('aabbef', 'utf-8'), cast (null AS VARCHAR))", "null");
        this.testSqlApi("decode(encode('\u4e2d\u56fd', 'UTF-16LE'), 'UTF-16LE')", "\u4e2d\u56fd");
        this.testSqlApi("decode(encode('val_238', 'US-ASCII'), 'US-ASCII') = decode(encode('val_238', 'utf-8'), 'utf-8')", "true");
    }

    @Test
    public void testStringToMap() {
        this.testSqlApi("STR_TO_MAP('k1=v1,k2=v2')", "{k1=v1, k2=v2}");
        this.testSqlApi("STR_TO_MAP('k1:v1;k2: v2', ';', ':')", "{k1=v1, k2= v2}");
        this.testSqlApi("STR_TO_MAP('')", "{}");
        this.testSqlApi("STR_TO_MAP('k1=v1,k2=v2')['k1']", "v1");
        this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';', ':')['k2']", "v2");
        this.testSqlApi("STR_TO_MAP('k1=v1,k2=v2')['k3']", "null");
        this.testSqlApi("STR_TO_MAP(f46)", "{test1=1, test2=2, test3=3}");
        this.testSqlApi("STR_TO_MAP(f47)", "null");
    }

    @Test
    public void testIf() {
        this.testSqlApi("IF(f7 > 5, f14, f4)", "44");
        this.testSqlApi("IF(f7 < 5, cast(null as int), f4)", "null");
        this.testSqlApi("IF(1 = 1, f6, cast(f0 as double))", "4.6");
        this.testSqlApi("IF(f7 > 5, f0, f8)", " This is a test String. ");
        this.testSqlApi("IF(f7 < 5, f2, f9)", "42");
        this.testSqlApi("IF(f7 < 5, f14, f7)", "-3");
        this.testSqlApi("IF(f7 < 5, f3, f10)", "43");
        this.testSqlApi("IF(f7 < 5, f4, f11)", "44");
        this.testSqlApi("IF(f7 < 5, f6, f13)", "4.6");
        this.testSqlApi("IF(f7 < 5, f1, f48)", "true");
        this.testSqlApi("IF(f7 < 5, f15, f49)", "-1231.1231231321321321111");
        this.testSqlApi("IF(f7 < 5, f53, f54)", "hello world");
        this.testSqlApi("IF(f7 < 5, f16, f50)", "1996-11-10");
        this.testSqlApi("IF(f7 < 5, f17, f51)", "06:55:44");
    }

    @Test
    public void testIfDecimal() {
        this.testAllApis(org.apache.flink.table.api.package$.MODULE$.ifThenElse(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression(symbol$2).$less(org.apache.flink.table.api.package$.MODULE$.int2Literal(5)), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$13), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression(symbol$36)), "ifThenElse(f7 < 5, f31, f34)", "IF(f7 < 5, f31, f34)", "-0.1231231321321321111");
    }

    @Test
    public void testIsDecimal() {
        this.testSqlApi("IS_DECIMAL('1')", "true");
        this.testSqlApi("IS_DECIMAL('123')", "true");
        this.testSqlApi("IS_DECIMAL('2')", "true");
        this.testSqlApi("IS_DECIMAL('11.4445')", "true");
        this.testSqlApi("IS_DECIMAL('3')", "true");
        this.testSqlApi("IS_DECIMAL('abc')", "false");
        this.testSqlApi("IS_DECIMAL(f33)", "false");
    }

    @Test
    public void testIsDigit() {
        this.testSqlApi("IS_DIGIT('1')", "true");
        this.testSqlApi("IS_DIGIT('123')", "true");
        this.testSqlApi("IS_DIGIT('2')", "true");
        this.testSqlApi("IS_DIGIT('11.4445')", "false");
        this.testSqlApi("IS_DIGIT('3')", "true");
        this.testSqlApi("IS_DIGIT('abc')", "false");
        this.testSqlApi("IS_DIGIT(f33)", "false");
    }

    @Test
    public void testIsAlpha() {
        this.testSqlApi("IS_ALPHA('1')", "false");
        this.testSqlApi("IS_ALPHA('123')", "false");
        this.testSqlApi("IS_ALPHA('2')", "false");
        this.testSqlApi("IS_ALPHA('11.4445')", "false");
        this.testSqlApi("IS_ALPHA('3')", "false");
        this.testSqlApi("IS_ALPHA('abc')", "true");
        this.testSqlApi("IS_ALPHA(f33)", "false");
    }

    @Test
    public void testRawTypeEquality() {
        this.testSqlApi("f55=f56", "false");
        this.testSqlApi("f55=f57", "true");
    }

    @Test
    public void testStringFunctionAndExpressionResultType() {
        String str1 = "CAST('Hello' AS VARCHAR(5))";
        String str2 = "CAST('Hi' AS VARCHAR(2))";
        String str3 = "CAST('hello world' AS VARCHAR(11))";
        String str4 = "CAST(' hello ' AS VARCHAR(7))";
        String url = "CAST('http://user:pass@host' AS VARCHAR(50))";
        String base64 = "CAST('aGVsbG8gd29ybGQ=' AS VARCHAR(20))";
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SUBSTR(", ", 2, 3), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "ell");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SUBSTRING(", ", 2, 3), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "ell");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(LEFT(", ", 3), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "Hel");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(RIGHT(", ", 3), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "llo");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(REGEXP_EXTRACT(", ", 'H(.+?)l(.+?)$', 2), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "lo");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(REGEXP_REPLACE(", ", 'e.l', 'EXL'), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "HEXLo");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(UPPER(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "HELLO");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(LOWER(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "hello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(INITCAP(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str3, str2})), "Hello World");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(OVERLAY(", " PLACING ", " FROM 2 FOR 3), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str3, str2})), "Hhello worldo");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(LPAD(", ", 7, ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str3, str2})), "heHello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(RPAD(", ", 7, ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str3, str2})), "Hellohe");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(REPEAT(", ", 2), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "HelloHello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(REVERSE(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "olleH");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(REPLACE(", ", ' ', '_'), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str3, str2})), "hello_world");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SPLIT_INDEX(", ", ' ', 1), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str3, str2})), "world");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(MD5(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "8b1a9953c4611296a827abf8c47804d7");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA1(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "f7ff9e8b7bb2e09b70935a5d785e0cc5d9d0abf0");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA224(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "4149da18aa8bfc2b1e382c6c26556d01a92c261b6436dad5e3be3fcc");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA256(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "185f8db32271fe25f561a6fc938b2e264306ec304eda518007d1764826381969");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA384(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "3519fe5ad2c596efe3e276a6f351b8fc0b03db861782490d45f7598ebd0ab5fd5520ed102f38c4a5ec834e98668035fc");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA512(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "3615f80c9d293ed7402687f94b22d58e529b8cc7916f8fac7fddf7fbd5af4cf777d3d795a7a00a16bf7e7f3fb9561ee9baae480da9fe7a18769e71886b03f315");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SHA2(", ", 256), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "185f8db32271fe25f561a6fc938b2e264306ec304eda518007d1764826381969");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(PARSE_URL(", ", 'HOST'), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, str2})), "host");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(FROM_BASE64(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base64, str2})), "hello world");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(TO_BASE64(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str3, str2})), "aGVsbG8gd29ybGQ=");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CHR(65), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "A");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(BIN(10), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "1010");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CONCAT(", ", ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2, str2})), "HelloHi");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CONCAT_WS('~', ", ", ", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2, str2})), "Hello~Hi");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(TRIM(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str4, str2})), "hello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(LTRIM(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str4, str2})), "hello ");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(RTRIM(", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str4, str2})), " hello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(", " || ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2, str2})), "HelloHi");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(SUBSTRING(UUID(), 9, 1), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "-");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(DECODE(ENCODE(", ", 'utf-8'), 'utf-8'), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str1, str2})), "Hello");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(DATE '2021-04-06' AS VARCHAR(10)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "2021-04-06");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(TIME '11:05:30' AS VARCHAR(8)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "11:05:30");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(TIMESTAMP '2021-04-06 11:05:30' AS VARCHAR(19)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "2021-04-06 11:05:30");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(INTERVAL '2' YEAR AS VARCHAR(20)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "+2-00");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(INTERVAL '2' DAY AS VARCHAR(20)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "+2 00:00:00.000");
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IFNULL(CAST(f53 AS VARCHAR(100)), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})), "hello world");
    }

    private final void testUrl$1(String url, String host, String path, String query, String ref, String protocol, String file, String authority, String userInfo, String qv) {
        Map parts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOST"), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PATH"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUERY"), (Object)query), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REF"), (Object)ref), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROTOCOL"), (Object)protocol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FILE"), (Object)file), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AUTHORITY"), (Object)authority), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USERINFO"), (Object)userInfo)}));
        parts.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, url){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalarFunctionsTest $outer;
            private final String url$1;

            public final void apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.$outer.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse_url('", "', '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1, n})), v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.url$1 = url$1;
            }
        });
        this.testSqlApi(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse_url('", "', 'QUERY', 'query')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), qv);
    }

    public final Tuple2 org$apache$flink$table$planner$expressions$ScalarFunctionsTest$$intervalCount$1(String interval, int count) {
        String string;
        block18: {
            Tuple2 tuple2;
            block3: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            string = interval;
                                                                            if (!"YEAR".equals(string)) break block2;
                                                                            tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".years"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                                            break block3;
                                                                        }
                                                                        if (!"SQL_TSI_YEAR".equals(string)) break block4;
                                                                        tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".years"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                                        break block3;
                                                                    }
                                                                    if (!"QUARTER".equals(string)) break block5;
                                                                    tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".quarters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                                    break block3;
                                                                }
                                                                if (!"SQL_TSI_QUARTER".equals(string)) break block6;
                                                                tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".quarters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                                break block3;
                                                            }
                                                            if (!"MONTH".equals(string)) break block7;
                                                            tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".months"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                            break block3;
                                                        }
                                                        if (!"SQL_TSI_MONTH".equals(string)) break block8;
                                                        tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".months"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                        break block3;
                                                    }
                                                    if (!"WEEK".equals(string)) break block9;
                                                    tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".weeks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                    break block3;
                                                }
                                                if (!"SQL_TSI_WEEK".equals(string)) break block10;
                                                tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".weeks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                                break block3;
                                            }
                                            if (!"DAY".equals(string)) break block11;
                                            tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".days"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                            break block3;
                                        }
                                        if (!"SQL_TSI_DAY".equals(string)) break block12;
                                        tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".days"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                        break block3;
                                    }
                                    if (!"HOUR".equals(string)) break block13;
                                    tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hours"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                    break block3;
                                }
                                if (!"SQL_TSI_HOUR".equals(string)) break block14;
                                tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".hours"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                                break block3;
                            }
                            if (!"MINUTE".equals(string)) break block15;
                            tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".minutes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                            break block3;
                        }
                        if (!"SQL_TSI_MINUTE".equals(string)) break block16;
                        tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".minutes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                        break block3;
                    }
                    if (!"SECOND".equals(string)) break block17;
                    tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
                    break block3;
                }
                if (!"SQL_TSI_SECOND".equals(string)) break block18;
                tuple2 = new Tuple2(org.apache.flink.table.api.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
            }
            return tuple2;
        }
        throw new MatchError((Object)string);
    }
}

